/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.botp.track.wblogicunit;

import java.math.BigDecimal;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.service.botp.track.WriteBackContext;
import kd.bos.service.botp.track.bizentity.WSRow;
import kd.bos.service.botp.track.getvaluemode.FieldValueTypeConvert;
import kd.bos.service.botp.track.helper.WRuleItemCompiler;
import kd.bos.service.botp.track.wblogicunit.IWriteBack;

class WriteBackAdd
implements IWriteBack {
    private Class<?> fldValType;
    private FieldValueTypeConvert valueTypeConvert;

    WriteBackAdd() {
    }

    @Override
    public void setFieldValueType(Class<?> fldValType) {
        this.fldValType = fldValType;
    }

    @Override
    public void setFieldValueTypeConvert(FieldValueTypeConvert valueTypeConvert) {
        this.valueTypeConvert = valueTypeConvert;
    }

    @Override
    public void doWriteBack(RowDataModel rowDataModel, String srcFldKey, BigDecimal val, Object cval, int scale) {
        Object srcVale = rowDataModel.getValue(srcFldKey);
        if (srcVale == null) {
            srcVale = BigDecimal.ZERO;
        }
        BigDecimal oldValue = new BigDecimal(String.valueOf(srcVale));
        BigDecimal newValue = oldValue.add(val);
        newValue = newValue.setScale(scale, 4);
        Object fldValue = this.valueTypeConvert.convert((Object)newValue, this.fldValType);
        rowDataModel.setValue(srcFldKey, fldValue);
    }

    @Override
    public void doWriteBack(WriteBackContext writebackContext, WRuleItemCompiler ruleItemCompiler, RowDataModel rowDataModel, WSRow wsRow, int scale) {
        String srcFldKey = ruleItemCompiler.getItem().getSourceCommitFieldKey();
        BigDecimal val = wsRow.getVal();
        Object srcVale = rowDataModel.getValue(srcFldKey);
        if (srcVale == null) {
            srcVale = BigDecimal.ZERO;
        }
        BigDecimal oldValue = new BigDecimal(String.valueOf(srcVale));
        BigDecimal newValue = oldValue.add(val);
        newValue = newValue.setScale(scale, 4);
        Object fldValue = this.valueTypeConvert.convert((Object)newValue, this.fldValType);
        rowDataModel.setValue(srcFldKey, fldValue);
        writebackContext.getTrackerResult().getTrackerLog().addWriteValue(writebackContext, wsRow, srcFldKey, oldValue, "+", val, fldValue);
    }
}

