/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.service.operation.bizrule.PushAndSaveExecuter;
import kd.bos.util.botp.CustomParamsUtil;

public class PushAndSave
extends EntityOperateService {
    private String getOperationName() {
        LocaleString name = LocaleString.fromMap((Map)((Map)this.operateMetaMap.get("name")));
        return name.toString();
    }

    private String getOperationType() {
        return (String)this.operateMetaMap.get("type");
    }

    private String getTargetEntityNumber() {
        Map opParameter = (Map)this.operateMetaMap.get("parameter");
        return (String)opParameter.get("targetbill");
    }

    private String getConvertRuleId() {
        Map opParameter = (Map)this.operateMetaMap.get("parameter");
        String ruleId = (String)opParameter.get("ruleid");
        if (StringUtils.equals((CharSequence)ruleId, (CharSequence)"@all")) {
            ruleId = "";
        }
        return ruleId;
    }

    private String getTargetOperation() {
        Map opParameter = (Map)this.operateMetaMap.get("parameter");
        String targetOperation = (String)opParameter.get("targetoperation");
        return targetOperation;
    }

    private boolean isCheckNewRight() {
        Boolean checkRight;
        Map params = (Map)this.operateMetaMap.get("parameter");
        if (params != null && (checkRight = (Boolean)params.get("checkNewRight")) != null) {
            return checkRight;
        }
        return false;
    }

    private boolean isCheckSubmitRight() {
        Boolean checkRight;
        Map params = (Map)this.operateMetaMap.get("parameter");
        if (params != null && (checkRight = (Boolean)params.get("checkSubmitRight")) != null) {
            return checkRight;
        }
        return false;
    }

    private boolean isCheckAuditRight() {
        Boolean checkRight;
        Map params = (Map)this.operateMetaMap.get("parameter");
        if (params != null && (checkRight = (Boolean)params.get("checkAuditRight")) != null) {
            return checkRight;
        }
        return false;
    }

    private boolean isBatchPush() {
        Boolean batchPush;
        Map params = (Map)this.operateMetaMap.get("parameter");
        if (params != null && (batchPush = (Boolean)params.get("batchPush")) != null) {
            return batchPush;
        }
        return false;
    }

    protected void callOperationTransaction(DynamicObject[] objs) throws Exception {
        if (objs != null && objs.length > 0) {
            PushAndSaveExecuter executer = new PushAndSaveExecuter();
            executer.setSourceBill(this.billEntityType.getName());
            executer.setTargetBill(this.getTargetEntityNumber());
            executer.setRuleId(this.getConvertRuleId());
            executer.setCheckNewRight(this.isCheckNewRight());
            executer.setCheckSubmitRight(this.isCheckSubmitRight());
            executer.setCheckAuditRight(this.isCheckAuditRight());
            executer.setOpKey(this.operationKey);
            executer.setOpName(this.getOperationName());
            executer.setOpType(this.getOperationType());
            executer.setTargetOperation(this.getTargetOperation());
            executer.setOption(this.getOption());
            executer.setOperationResult(this.getOperationResult());
            executer.setThrowExecptin(true);
            executer.setOneByOne(!this.isBatchPush());
            executer.setMergeResult(true);
            executer.setOperateLog(this.getOperateLog());
            if (this.checkRule(executer)) {
                executer.execute(objs);
                ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
                for (DynamicObject obj : objs) {
                    Object pkValue = obj.getPkValue();
                    if (executer.getPushFailBillIds().contains(pkValue)) continue;
                    this.getOperationResult().getSuccessPkIds().add(pkValue);
                    this.getOperationResult().setSuccess(true);
                    successObjs.add(obj);
                }
                if (this.getOperationResult().getSuccessPkIds().isEmpty()) {
                    this.getOperationResult().setSuccess(false);
                }
                this.setSuccessDataEntities(successObjs);
            } else {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setLevel(ErrorLevel.Info);
                operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s-\u81ea\u52a8\u4e0b\u63a8\u5931\u8d25: \u65e0\u5339\u914d\u89c4\u5219", (String)"AutoPushOpAction_1", (String)"bos-mservice-botp", (Object[])new Object[0]), this.getOperationName()));
                List allErrorInfo = this.getOperationResult().getAllErrorInfo();
                if (allErrorInfo != null) {
                    allErrorInfo.add(operateErrorInfo);
                }
            }
        }
    }

    protected void executeOperate(DynamicObject[] objs) {
    }

    private boolean checkRule(PushAndSaveExecuter executer) {
        boolean checkRuleParam = CustomParamsUtil.getBooleanCusParams((String)"BOS_BOTP_CHECKRULE_MATCH");
        if (!checkRuleParam) {
            return true;
        }
        String ruleId = executer.getRuleId();
        if (StringUtils.isBlank((CharSequence)ruleId) || StringUtils.equals((CharSequence)ruleId, (CharSequence)"@all")) {
            return true;
        }
        String sourceBill = executer.getSourceBill();
        String targetBill = executer.getTargetBill();
        ConvertRuleElement ruleElement = ConvertRuleCache.loadRule((String)ruleId);
        if (ruleElement == null) {
            return false;
        }
        String ruleSourceBill = ruleElement.getSourceEntityNumber();
        String ruleTargetBill = ruleElement.getTargetEntityNumber();
        return StringUtils.equals((CharSequence)sourceBill, (CharSequence)ruleSourceBill) && StringUtils.equals((CharSequence)targetBill, (CharSequence)ruleTargetBill);
    }
}

