/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.bizrule;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.bizrule.PushAndSaveExecuter;
import kd.bos.util.botp.CustomParamsUtil;

public class AutoPushOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(AutoPushOpAction.class);
    private Map<String, Object> params;

    private Map<String, Object> getParams() {
        if (this.params == null) {
            if (StringUtils.isBlank((CharSequence)this.getBizRule().getParameter())) {
                return null;
            }
            this.params = (Map)SerializationUtils.fromJsonString((String)this.getBizRule().getParameter(), Map.class);
        }
        return this.params;
    }

    private String getOperationKey() {
        if (this.operateMeta == null) {
            return null;
        }
        return (String)this.operateMeta.get("key");
    }

    private String getOperationName() {
        String operationName = null;
        if (this.operateMeta == null || !this.operateMeta.containsKey("name")) {
            return operationName;
        }
        Map opName = (Map)this.operateMeta.get("name");
        if (opName.containsKey(ResManager.getLanguage())) {
            operationName = (String)opName.get(ResManager.getLanguage());
        } else {
            Object zh_cn = opName.get("zh_CN");
            if (zh_cn != null) {
                operationName = (String)zh_cn;
            }
        }
        return operationName;
    }

    private String getOperationType() {
        if (this.operateMeta == null) {
            return null;
        }
        return (String)this.operateMeta.get("type");
    }

    private String getOpBizRuleName() {
        if (this.getBizRule().getName() != null) {
            return this.getBizRule().getName().toString();
        }
        return this.getBizRule().getRuleType();
    }

    private String getTargetEntityNumber() {
        Map<String, Object> params = this.getParams();
        if (params != null) {
            return params.get("targetBill").toString();
        }
        return null;
    }

    private String getConvertRuleId() {
        Map<String, Object> params = this.getParams();
        String ruleId = null;
        if (params != null) {
            ruleId = params.get("ruleId").toString();
        }
        if (StringUtils.equals(ruleId, (CharSequence)"@all")) {
            ruleId = "";
        }
        return ruleId;
    }

    private String getTargetOperation() {
        Map<String, Object> params = this.getParams();
        if (params != null) {
            return params.get("afterOperation").toString();
        }
        return null;
    }

    private boolean isCheckNewRight() {
        Boolean checkRight;
        Map<String, Object> params = this.getParams();
        if (params != null && (checkRight = (Boolean)params.get("checkNewRight")) != null) {
            return checkRight;
        }
        return false;
    }

    private boolean isCheckSubmitRight() {
        Boolean checkRight;
        Map<String, Object> params = this.getParams();
        if (params != null && (checkRight = (Boolean)params.get("checkSubmitRight")) != null) {
            return checkRight;
        }
        return false;
    }

    private boolean isCheckAuditRight() {
        Boolean checkRight;
        Map<String, Object> params = this.getParams();
        if (params != null && (checkRight = (Boolean)params.get("checkAuditRight")) != null) {
            return checkRight;
        }
        return false;
    }

    private boolean isBatchPush() {
        Boolean batchPush;
        Map<String, Object> params = this.getParams();
        if (params != null && (batchPush = (Boolean)params.get("batchPush")) != null) {
            return batchPush;
        }
        return false;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (this.isPushAndSaveOp() && this.isSameTargetBill()) {
            log.info("current op is pushandsave, cann't execute autopush bizerule again");
            return;
        }
        if (e.getDataEntities() != null && e.getDataEntities().length > 0) {
            PushAndSaveExecuter executer = new PushAndSaveExecuter();
            executer.setSourceBill(this.billEntityType.getName());
            executer.setTargetBill(this.getTargetEntityNumber());
            executer.setRuleId(this.getConvertRuleId());
            executer.setCheckNewRight(this.isCheckNewRight());
            executer.setCheckSubmitRight(this.isCheckSubmitRight());
            executer.setCheckAuditRight(this.isCheckAuditRight());
            executer.setOpKey(this.getOperationKey());
            executer.setOpName(this.getOperationName());
            executer.setOpType(this.getOperationType());
            executer.setOpBizRuleKey(this.getBizRule().getKey());
            executer.setOpBizRuleName(this.getOpBizRuleName());
            executer.setTargetOperation(this.getTargetOperation());
            executer.setOption(this.getOption());
            if (this.getOperationContext() != null) {
                executer.setOperateLog(this.getOperationContext().getOperateLog());
            }
            OperationResult pushAndSaveResult = new OperationResult();
            executer.setOperationResult(pushAndSaveResult);
            executer.setMergeResult(true);
            executer.setThrowExecptin(true);
            executer.setOneByOne(!this.isBatchPush());
            if (this.checkRule(executer)) {
                executer.execute(e.getDataEntities());
            } else {
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s-\u81ea\u52a8\u4e0b\u63a8\u5931\u8d25: \u65e0\u5339\u914d\u89c4\u5219", (String)"AutoPushOpAction_1", (String)"bos-mservice-botp", (Object[])new Object[0]), this.getOperationName()));
                List allErrorInfo = pushAndSaveResult.getAllErrorInfo();
                if (allErrorInfo != null) {
                    allErrorInfo.add(operateErrorInfo);
                }
            }
            for (OperateErrorInfo errorInfo : pushAndSaveResult.getAllErrorInfo()) {
                errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u4e0b\u63a8\u62a5\u544a - %s", (String)"AutoPushOpAction_0", (String)"bos-mservice-botp", (Object[])new Object[0]), errorInfo.getMessage()));
                errorInfo.setLevel(ErrorLevel.Info);
                this.getOperationResult().getAllErrorInfo().add(errorInfo);
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
    }

    private boolean isPushAndSaveOp() {
        if (this.operateMeta == null) {
            return false;
        }
        if (!this.operateMeta.containsKey("type")) {
            return false;
        }
        String opType = (String)this.operateMeta.get("type");
        return StringUtils.equals((CharSequence)opType, (CharSequence)"pushandsave");
    }

    private boolean isSameTargetBill() {
        if (this.operateMeta == null) {
            return false;
        }
        if (!this.operateMeta.containsKey("parameter")) {
            return false;
        }
        Map opParameter = (Map)this.operateMeta.get("parameter");
        if (opParameter == null) {
            return false;
        }
        String targetBill1 = (String)opParameter.get("targetbill");
        String targetBill2 = this.getTargetEntityNumber();
        return StringUtils.equals((CharSequence)targetBill1, (CharSequence)targetBill2);
    }

    private boolean checkRule(PushAndSaveExecuter executer) {
        boolean checkRuleParam = CustomParamsUtil.getBooleanCusParams((String)"BOS_BOTP_CHECKRULE_MATCH");
        if (!checkRuleParam) {
            return true;
        }
        String ruleId = executer.getRuleId();
        if (StringUtils.isBlank((CharSequence)ruleId) || StringUtils.equals((CharSequence)ruleId, (CharSequence)"@all")) {
            return true;
        }
        String sourceBill = executer.getSourceBill();
        String targetBill = executer.getTargetBill();
        ConvertRuleElement ruleElement = ConvertRuleCache.loadRule((String)ruleId);
        if (ruleElement == null) {
            return false;
        }
        String ruleSourceBill = ruleElement.getSourceEntityNumber();
        String ruleTargetBill = ruleElement.getTargetEntityNumber();
        return StringUtils.equals((CharSequence)sourceBill, (CharSequence)ruleSourceBill) && StringUtils.equals((CharSequence)targetBill, (CharSequence)ruleTargetBill);
    }
}

