/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.bizrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;

class OpResultGroup {
    private OperationResult opResult;
    private Map<Object, List<OperateErrorInfo>> billErrors = new HashMap<Object, List<OperateErrorInfo>>(1);

    public OpResultGroup(OperationResult opResult) {
        this.opResult = opResult;
        if (opResult != null) {
            for (IOperateInfo info : opResult.getAllErrorOrValidateInfo()) {
                Object billId;
                if (!(info instanceof OperateErrorInfo) || (billId = ((OperateErrorInfo)info).getPkValue()) == null) continue;
                if (!this.billErrors.containsKey(billId)) {
                    this.billErrors.put(billId, new ArrayList(1));
                }
                this.billErrors.get(billId).add((OperateErrorInfo)info);
            }
        }
    }

    public boolean isBillSuccess(Object billId) {
        if (this.opResult == null) {
            return false;
        }
        if (this.opResult.getSuccessPkIds().isEmpty()) {
            return false;
        }
        return this.opResult.getSuccessPkIds().contains(billId);
    }

    public List<OperateErrorInfo> getBillError(Object billId) {
        if (this.billErrors.containsKey(billId)) {
            return this.billErrors.get(billId);
        }
        return new ArrayList<OperateErrorInfo>(0);
    }
}

