/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.operation.bizrule;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.AttachmentInfoPackage;
import kd.bos.entity.botp.runtime.AttachmentItemInfo;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.OpInfo;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.OperateLog;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.exception.KDBizException;
import kd.bos.param.ParameterReader;
import kd.bos.service.botp.convert.ConvertEngine;
import kd.bos.service.operation.bizrule.OpResultGroup;
import kd.bos.service.operation.bizrule.PushAndSaveLog;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class PushAndSaveExecuter {
    private static final String OP_TYPE_PUSH = "push";
    private static final String OP_TYPE_SAVE = "save";
    private static final String OP_TYPE_SUBMIT = "submit";
    private static final String OP_TYPE_AUDIT = "audit";
    private static final String ERRORCODE_AUTOPUSH = "autopush_error";
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private static final String OP_NAME_MAX_PUSH_ROWS = "bos_max_push_rows";
    private static final String MAX_PUSH_ROWS = "200000";
    private static final String OPTION_BOTP_STRICTVALIDATION = "option_botp_strictvalidation";
    private boolean writeLog;
    boolean throwExecptin;
    boolean mergeResult;
    boolean oneByOne;
    String sourceBill;
    String targetBill;
    String ruleId;
    String targetOperation;
    @Deprecated
    private boolean hasRight;
    private boolean checkNewRight;
    private boolean checkSubmitRight;
    private boolean checkAuditRight;
    private String opKey;
    private String opName;
    private String opType;
    private String opBizRuleKey;
    private String opBizRuleName;
    IDataEntityProperty srcBillProp = null;
    BillEntityType targetMainType;
    Operations targetOperations;
    Map<String, Object> submitOp;
    Map<String, Object> auditOp;
    IRefrencedataProvider refLoader;
    OperateOption option;
    OperationResult operationResult;
    private OperateLog operateLog;
    private PushAndSaveLog pushLog;
    private Set<Object> pushFailBillIds = new HashSet<Object>();
    private Map<Object, String> srcBillNos = new HashMap<Object, String>(1);
    private Set<String> srcBillIdsDataMutex = new HashSet<String>(0);

    @Deprecated
    public boolean isWriteLog() {
        return this.writeLog;
    }

    public void setWriteLog(boolean writeLog) {
        this.writeLog = writeLog;
    }

    public boolean isThrowExecptin() {
        return this.throwExecptin;
    }

    public void setThrowExecptin(boolean throwExecptin) {
        this.throwExecptin = throwExecptin;
    }

    public boolean isMergeResult() {
        return this.mergeResult;
    }

    public void setMergeResult(boolean mergeResult) {
        this.mergeResult = mergeResult;
    }

    public boolean isOneByOne() {
        return this.oneByOne;
    }

    public void setOneByOne(boolean oneByOne) {
        this.oneByOne = oneByOne;
    }

    public String getSourceBill() {
        return this.sourceBill;
    }

    public void setSourceBill(String sourceBill) {
        this.sourceBill = sourceBill;
    }

    public String getTargetBill() {
        return this.targetBill;
    }

    public void setTargetBill(String targetBill) {
        this.targetBill = targetBill;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getOpKey() {
        return this.opKey;
    }

    public void setOpKey(String opKey) {
        this.opKey = opKey;
    }

    public String getOpName() {
        return this.opName;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public String getOpType() {
        return this.opType;
    }

    public void setOpType(String opType) {
        this.opType = opType;
    }

    public String getOpBizRuleKey() {
        return this.opBizRuleKey;
    }

    public void setOpBizRuleKey(String opBizRuleKey) {
        this.opBizRuleKey = opBizRuleKey;
    }

    public String getOpBizRuleName() {
        return this.opBizRuleName;
    }

    public void setOpBizRuleName(String opBizRuleName) {
        this.opBizRuleName = opBizRuleName;
    }

    public String getFullName() {
        if (StringUtils.isBlank((CharSequence)this.opBizRuleName)) {
            return this.opName;
        }
        if (StringUtils.isBlank((CharSequence)this.opName)) {
            return this.opBizRuleName;
        }
        return this.opName + "-" + this.opBizRuleName;
    }

    public String getSimpleName() {
        if (StringUtils.isNotBlank((CharSequence)this.opBizRuleName)) {
            return this.opBizRuleName;
        }
        return this.opName;
    }

    public String getTargetOperation() {
        return this.targetOperation;
    }

    public void setTargetOperation(String targetOperation) {
        this.targetOperation = targetOperation;
    }

    @Deprecated
    public boolean isHasRight() {
        return this.hasRight;
    }

    @Deprecated
    public void setHasRight(boolean hasRight) {
        this.hasRight = hasRight;
    }

    @SimplePropertyAttribute(name="CheckNewRight")
    public boolean isCheckNewRight() {
        return this.checkNewRight;
    }

    public void setCheckNewRight(boolean checkNewRight) {
        this.checkNewRight = checkNewRight;
    }

    @SimplePropertyAttribute(name="CheckSubmitRight")
    public boolean isCheckSubmitRight() {
        return this.checkSubmitRight;
    }

    public void setCheckSubmitRight(boolean checkSubmitRight) {
        this.checkSubmitRight = checkSubmitRight;
    }

    @SimplePropertyAttribute(name="CheckAuditRight")
    public boolean isCheckAuditRight() {
        return this.checkAuditRight;
    }

    public void setCheckAuditRight(boolean checkAuditRight) {
        this.checkAuditRight = checkAuditRight;
    }

    public BillEntityType getTargetMainType() {
        if (this.targetMainType != null) {
            return this.targetMainType;
        }
        this.targetMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.getTargetBill());
        return this.targetMainType;
    }

    public Operations getTargetOperations() {
        if (this.targetOperations == null) {
            this.targetOperations = EntityMetadataCache.getDataEntityOperations((String)this.getTargetBill());
        }
        return this.targetOperations;
    }

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(OperationResult operationResult) {
        this.operationResult = operationResult;
    }

    public OperateLog getOperateLog() {
        if (this.operateLog == null) {
            DynamicObject billParamObj;
            boolean opExecuteLog = false;
            if (StringUtils.isNotBlank((CharSequence)this.getSourceBill()) && (billParamObj = ParameterReader.getBillParameter((String)this.getSourceBill())) != null && billParamObj.getDataEntityType().getProperties().containsKey((Object)"opexecutelog")) {
                opExecuteLog = billParamObj.getBoolean("opexecutelog");
            }
            this.operateLog = OperateLog.get((boolean)opExecuteLog);
        }
        return this.operateLog;
    }

    public void setOperateLog(OperateLog operateLog) {
        this.operateLog = operateLog;
    }

    private PushAndSaveLog getPushLog() {
        if (this.pushLog == null) {
            this.pushLog = new PushAndSaveLog(this, this.getOperateLog());
        }
        return this.pushLog;
    }

    public Set<Object> getPushFailBillIds() {
        return this.pushFailBillIds;
    }

    private boolean isSubmit(String afterOperation) {
        return StringUtils.equalsIgnoreCase((CharSequence)afterOperation, (CharSequence)OP_TYPE_SUBMIT) || StringUtils.equalsIgnoreCase((CharSequence)afterOperation, (CharSequence)OP_TYPE_AUDIT);
    }

    private boolean isAudit(String afterOperation) {
        return StringUtils.equalsIgnoreCase((CharSequence)afterOperation, (CharSequence)OP_TYPE_AUDIT);
    }

    private boolean isShowFailRowInfo() {
        if (this.getOption() == null) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getOption().getVariableValue("WF", ""), (CharSequence)"TRUE")) {
            return false;
        }
        return Boolean.parseBoolean(this.getOption().getVariableValue("pushandsave_showfailrow", String.valueOf(false)));
    }

    private Map<String, Object> getSubmitOpMeta() {
        if (this.submitOp != null) {
            return this.submitOp;
        }
        Operations ops = this.getTargetOperations();
        String opKey = OP_TYPE_SUBMIT;
        if (StringUtils.isNotBlank((CharSequence)ops.getSubmit())) {
            opKey = ops.getSubmit();
        }
        this.submitOp = this.getTargetOpMeta(opKey);
        return this.submitOp;
    }

    private Map<String, Object> getAuditOpMeta() {
        if (this.auditOp != null) {
            return this.auditOp;
        }
        Operations ops = this.getTargetOperations();
        String opKey = OP_TYPE_AUDIT;
        if (StringUtils.isNotBlank((CharSequence)ops.getAudit())) {
            opKey = ops.getAudit();
        }
        this.auditOp = this.getTargetOpMeta(opKey);
        return this.auditOp;
    }

    private Map<String, Object> getTargetOpMeta(String opKey) {
        return EntityMetadataCache.getDataEntityOperate((String)this.getTargetBill(), (String)opKey);
    }

    private IDataEntityProperty getSrcBillNoProp(DynamicObject srcObj) {
        IDataEntityType dt;
        if (this.srcBillProp == null && (dt = srcObj.getDataEntityType()) instanceof BillEntityType) {
            String billNoKey = ((BillEntityType)dt).getBillNo();
            if (dt.getProperties().containsKey((Object)billNoKey)) {
                this.srcBillProp = (IDataEntityProperty)dt.getProperties().get((Object)billNoKey);
            }
        }
        return this.srcBillProp;
    }

    private void setSrcBillNo(DynamicObject srcObj) {
        IDataEntityProperty billNoProp = this.getSrcBillNoProp(srcObj);
        if (billNoProp != null) {
            Object pkValue = srcObj.getPkValue();
            String billNo = (String)billNoProp.getValue((Object)srcObj);
            if (pkValue != null) {
                this.srcBillNos.put(pkValue, billNo);
            }
        }
    }

    private String getSrcBillNo(Object srcId) {
        return this.srcBillNos.get(srcId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DynamicObject[] objs) {
        this.getPushLog().execute_begin(objs);
        for (DynamicObject obj : objs) {
            this.setSrcBillNo(obj);
        }
        try {
            PushArgs pushArgs = this.buildPushArgs();
            if (this.isOneByOne()) {
                for (DynamicObject obj : objs) {
                    this.doExecute(new DynamicObject[]{obj}, pushArgs);
                }
            } else {
                this.doExecute(objs, pushArgs);
            }
        }
        finally {
            this.releasePushMutex();
        }
        this.getPushLog().execute_end(objs);
    }

    private void doExecute(DynamicObject[] objs, PushArgs pushArgs) {
        this.getPushLog().doExecute_begin(objs, pushArgs);
        ConvertOperationResult pushResult = this.doPush(objs, pushArgs);
        if (pushResult.getCachePageIds().isEmpty()) {
            this.getPushLog().doExecute_end("PushAndSaveExecuter.doExecute(), push result is empty, exit do execute.");
            return;
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)this.getTargetBill());
        List targetBillObjList = pushResult.loadTargetDataObjects(this.buildRefLoader(), targetMainType, true);
        DynamicObject[] targetBillObjs = targetBillObjList.toArray(new DynamicObject[targetBillObjList.size()]);
        this.autoSetPrimaryKey(targetBillObjs);
        Map<Object, Set<Object>> targetToSrcIdsMap = this.findSourceBillIds(targetBillObjs);
        OperationResult saveResult = this.doSave(targetBillObjs);
        this.parseSaveFailBills(objs, pushResult, saveResult, targetToSrcIdsMap);
        this.releasePushMutex();
        if (saveResult == null || saveResult.getSuccessPkIds().isEmpty()) {
            this.getPushLog().doExecute_end("PushAndSaveExecuter.doExecute(), save is failed, exit do execute.");
            return;
        }
        this.persistAttachmentPanelInfos(targetMainType, saveResult.getSuccessPkIds(), pushResult);
        if (this.isSubmit(this.targetOperation)) {
            OperationResult auditResult;
            OperationResult submitResult = this.doSubmit(saveResult, targetToSrcIdsMap);
            if (submitResult == null || !submitResult.isSuccess()) {
                this.getPushLog().doExecute_end("PushAndSaveExecuter.doExecute(), submit is failed, exit do execute.");
                return;
            }
            if (this.isAudit(this.targetOperation) && ((auditResult = this.doAudit(submitResult, targetToSrcIdsMap)) == null || !auditResult.isSuccess())) {
                this.getPushLog().doExecute_end("PushAndSaveExecuter.doExecute(), audit is failed, exit do execute.");
                return;
            }
        }
        this.getPushLog().doExecute_end(null);
    }

    private void persistAttachmentPanelInfos(MainEntityType targetEntityType, List<Object> successPkIds, ConvertOperationResult pushResult) {
        Map sourceAttachmentPanelInfos = pushResult.getBillAttachmentPanelInfos();
        HashSet<Object> successPkset = new HashSet<Object>(successPkIds);
        for (Map.Entry billAttachmentIndex : sourceAttachmentPanelInfos.entrySet()) {
            Object targetPk = billAttachmentIndex.getKey();
            Map billAttachmentItemInfoList = (Map)billAttachmentIndex.getValue();
            if (!successPkset.contains(targetPk)) {
                sourceAttachmentPanelInfos.remove(targetPk);
                continue;
            }
            if (billAttachmentItemInfoList == null || billAttachmentItemInfoList.isEmpty()) continue;
            this.persistAttachments(targetEntityType, targetPk, billAttachmentItemInfoList);
        }
    }

    private void persistAttachments(MainEntityType targetEntityType, Object targetPk, Map<String, List<AttachmentItemInfo>> billAttachItemInfos) {
        AttachmentInfoPackage pkg = new AttachmentInfoPackage();
        pkg.setAppId(targetEntityType.getAppId());
        pkg.setFormId(targetEntityType.getName());
        pkg.setPkId(targetPk);
        pkg.setAttachmentInfo(billAttachItemInfos);
        pkg.persist();
    }

    private ConvertOperationResult doPush(DynamicObject[] objs, PushArgs pushArgs) {
        ConvertOperationResult pushAgainResult;
        this.getPushLog().push_begin(objs, pushArgs);
        ArrayList<ListSelectedRow> rows = new ArrayList<ListSelectedRow>(objs.length);
        for (DynamicObject obj : objs) {
            ListSelectedRow row = new ListSelectedRow(obj.getPkValue(), Boolean.TRUE);
            row.setBillNo(this.getSrcBillNo(obj.getPkValue()));
            rows.add(row);
        }
        pushArgs.setSelectedRows(rows);
        ConvertEngine convertEngine = new ConvertEngine();
        ConvertOperationResult pushResult = convertEngine.push(pushArgs);
        this.srcBillIdsDataMutex.addAll(pushResult.getDataMutexSrcBillIds());
        this.mergePushFailMessages(pushResult);
        if (pushResult.getCachePageIds().isEmpty() && objs.length > this.getPushFailBillIds().size() && (pushAgainResult = this.doPushAgain(objs, pushArgs)) != null) {
            this.srcBillIdsDataMutex.addAll(pushAgainResult.getDataMutexSrcBillIds());
            this.mergePushFailMessages(pushAgainResult);
            pushResult = pushAgainResult;
        }
        if (pushResult.getCachePageIds().isEmpty()) {
            this.addPushFailMessage(objs, pushResult);
        }
        this.getPushLog().push_end(objs, pushResult);
        return pushResult;
    }

    private ConvertOperationResult doPushAgain(DynamicObject[] objs, PushArgs pushArgs) {
        ArrayList<ListSelectedRow> rows = new ArrayList<ListSelectedRow>();
        for (DynamicObject obj : objs) {
            Object pkValue = obj.getPkValue();
            if (this.getPushFailBillIds().contains(pkValue)) continue;
            ListSelectedRow row = new ListSelectedRow(pkValue, Boolean.TRUE);
            rows.add(row);
        }
        pushArgs.setSelectedRows(rows);
        if (rows.isEmpty()) {
            return null;
        }
        ConvertEngine convertEngine = new ConvertEngine();
        return convertEngine.push(pushArgs);
    }

    private OperationResult doSave(DynamicObject[] targetBillObjs) {
        String saveOpKey = this.getTargetOperations().getSave();
        if (StringUtils.isBlank((CharSequence)saveOpKey)) {
            OperationResult saveResult = new OperationResult();
            saveResult.setBillCount(targetBillObjs.length);
            saveResult.setSuccess(false);
            saveResult.setMessage(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u4fdd\u5b58\u64cd\u4f5c\uff0c\u65e0\u6cd5\u4fdd\u5b58", (String)"PushAndSaveExecuter_0", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
            this.getOperateLog().important("PushAndSaveExecuter.doSave(), target bill has no save operation, exit save");
            return saveResult;
        }
        this.getPushLog().executeOperate_begin(saveOpKey, targetBillObjs);
        OperateOption saveOption = this.getOption().copy();
        saveOption.setVariableValue("strictvalidation", String.valueOf(this.getBotpStrictValidation()));
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.removeVariable("WF");
        saveOption.setVariableValue("ishasright", String.valueOf(true));
        saveOption.setVariableValue("botptag_of_datasource", String.valueOf(true));
        OperationResult saveResult = this.doOperation(saveOpKey, targetBillObjs, saveOption);
        this.getPushLog().executeOperate_end(saveOpKey, targetBillObjs, saveResult);
        return saveResult;
    }

    private OperationResult doSubmit(OperationResult saveResult, Map<Object, Set<Object>> targetToSrcIdsMap) {
        Map<String, Object> submitOp = this.getSubmitOpMeta();
        if (submitOp == null) {
            if (this.isMergeResult()) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setTitle(this.getSimpleName());
                errorInfo.setLevel(ErrorLevel.Warning);
                errorInfo.setErrorCode(ERRORCODE_AUTOPUSH);
                errorInfo.setErrorCustInfos(this.buildErrorCustInfos(OP_TYPE_SUBMIT, "no submit op", null, null));
                errorInfo.setMessage(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u4fdd\u5b58\u6210\u529f\uff0c\u672a\u7ed1\u5b9a\u63d0\u4ea4\u64cd\u4f5c\uff0c\u672a\u63d0\u4ea4", (String)"PushAndSaveExecuter_2", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                this.getOperationResult().addErrorInfo(errorInfo);
            }
            this.getOperateLog().important("PushAndSaveExecuter.doSubmit(), target bill has no submit operation, exit submit");
            return null;
        }
        String submitOpKey = (String)submitOp.get("key");
        Object[] targetBillIds = saveResult.getSuccessPkIds().toArray();
        OperateOption submitOption = this.getOption().copy();
        submitOption.setVariableValue("strictvalidation", String.valueOf(this.getBotpStrictValidation()));
        submitOption.removeVariable("WF");
        submitOption.setVariableValue("ishasright", String.valueOf(!this.isCheckSubmitRight()));
        this.getPushLog().executeOperate_begin(submitOpKey, targetBillIds);
        OperationResult submitResult = this.doOperation(submitOpKey, this.targetBill, targetBillIds, submitOption);
        this.getPushLog().executeOperate_end(submitOpKey, targetBillIds, submitResult);
        if (this.isMergeResult() && (submitResult == null || submitResult.getSuccessPkIds().size() < saveResult.getSuccessPkIds().size())) {
            this.parseOpFailBills(OP_TYPE_SUBMIT, saveResult.getSuccessPkIds(), submitResult, targetToSrcIdsMap);
        }
        return submitResult;
    }

    private OperationResult doAudit(OperationResult submitResult, Map<Object, Set<Object>> targetToSrcIdsMap) {
        Map<String, Object> auditOp = this.getAuditOpMeta();
        if (auditOp == null) {
            if (this.isMergeResult()) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setTitle(this.getSimpleName());
                errorInfo.setLevel(ErrorLevel.Warning);
                errorInfo.setErrorCode(ERRORCODE_AUTOPUSH);
                errorInfo.setErrorCustInfos(this.buildErrorCustInfos(OP_TYPE_AUDIT, "no audit op", null, null));
                errorInfo.setMessage(ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u63d0\u4ea4\u6210\u529f\uff0c\u672a\u7ed1\u5b9a\u5ba1\u6838\u64cd\u4f5c\uff0c\u672a\u5ba1\u6838", (String)"PushAndSaveExecuter_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]));
                this.getOperationResult().addErrorInfo(errorInfo);
            }
            this.getOperateLog().important("PushAndSaveExecuter.doAudit(), target bill has no audit operation, exit audit");
            return null;
        }
        String auditOpKey = (String)auditOp.get("key");
        Object[] targetBillIds = submitResult.getSuccessPkIds().toArray();
        OperateOption auditOption = this.getOption().copy();
        auditOption.setVariableValue("strictvalidation", String.valueOf(this.getBotpStrictValidation()));
        auditOption.setVariableValue("WF", String.valueOf(false));
        auditOption.setVariableValue("ishasright", String.valueOf(!this.isCheckAuditRight()));
        this.getPushLog().executeOperate_begin(auditOpKey, targetBillIds);
        OperationResult auditResult = this.doOperation(auditOpKey, this.targetBill, submitResult.getSuccessPkIds().toArray(), auditOption);
        this.getPushLog().executeOperate_end(auditOpKey, targetBillIds, auditResult);
        if (this.isMergeResult() && (auditResult == null || auditResult.getSuccessPkIds().size() < submitResult.getSuccessPkIds().size())) {
            this.parseOpFailBills(OP_TYPE_AUDIT, submitResult.getSuccessPkIds(), auditResult, targetToSrcIdsMap);
        }
        return auditResult;
    }

    private OperationResult doOperation(String operationKey, DynamicObject[] objs, OperateOption option) {
        if (objs == null || objs.length == 0) {
            return null;
        }
        return OperationServiceHelper.executeOperate((String)operationKey, (String)objs[0].getDataEntityType().getName(), (DynamicObject[])objs, (OperateOption)option);
    }

    private OperationResult doOperation(String operationKey, String entityNumber, Object[] pkValues, OperateOption option) {
        return OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])pkValues, (OperateOption)option);
    }

    private void releasePushMutex() {
        if (this.srcBillIdsDataMutex.isEmpty()) {
            return;
        }
        HashSet<String> srcBillIds = new HashSet<String>(this.srcBillIdsDataMutex);
        ConvertServiceHelper.releasePushMutex((String)this.getSourceBill(), srcBillIds);
        this.srcBillIdsDataMutex.clear();
    }

    private void parseSaveFailBills(DynamicObject[] srcObjs, ConvertOperationResult pushResult, OperationResult saveResult, Map<Object, Set<Object>> targetToSrcIdsMap) {
        block8: {
            String opName;
            String saveFailMessage;
            OpResultGroup opResultGroup;
            block7: {
                opResultGroup = new OpResultGroup(saveResult);
                saveFailMessage = null;
                saveFailMessage = saveResult == null ? ResManager.loadKDString((String)"\u4e0b\u63a8\u6210\u529f\uff0c\u4f46\u4fdd\u5b58\u5931\u8d25", (String)"PushAndSaveExecuter_8", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u6279\u91cf\u4fdd\u5b58\u88ab\u4e2d\u6b62\uff0c\u8bf7\u6309\u63d0\u793a\u4fee\u590d\u9519\u8bef\u6570\u636e\u540e\u518d\u8bd5\uff1a%s", (String)"PushAndSaveExecuter_14", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), saveResult.getMessage());
                opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"PushAndSaveExecuter_20", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
                if (saveResult != null && !saveResult.getSuccessPkIds().isEmpty()) break block7;
                for (int i = 0; i < srcObjs.length; ++i) {
                    List<Object> errorInfos;
                    DynamicObject srcObj = srcObjs[i];
                    Object srcId = srcObj.getPkValue();
                    if (!this.getPushFailBillIds().add(srcId)) continue;
                    Set<Object> targetIds = this.findTargetBillIds(srcId, targetToSrcIdsMap);
                    List<Object> list = errorInfos = targetIds.isEmpty() ? new ArrayList(0) : opResultGroup.getBillError(targetIds.iterator().next());
                    if (!errorInfos.isEmpty()) {
                        this.addOpFailMessage(srcId, null, OP_TYPE_SAVE, opName, ErrorLevel.FatalError, ((OperateErrorInfo)errorInfos.get(0)).getMessage());
                        continue;
                    }
                    if (saveResult != null && saveResult.getBillCount() == 1) {
                        this.addOpFailMessage(srcId, null, OP_TYPE_SAVE, opName, ErrorLevel.FatalError, saveResult.getMessage());
                        continue;
                    }
                    this.addOpFailMessage(srcId, null, OP_TYPE_SAVE, opName, ErrorLevel.FatalError, saveFailMessage);
                }
                break block8;
            }
            if (pushResult.getCachePageIds().size() <= saveResult.getSuccessPkIds().size()) break block8;
            HashSet successIds = new HashSet(saveResult.getSuccessPkIds());
            for (int i = 0; i < srcObjs.length; ++i) {
                DynamicObject srcObj = srcObjs[i];
                Object srcId = srcObj.getPkValue();
                Set<Object> targetIds = this.findTargetBillIds(srcId, targetToSrcIdsMap);
                for (Object targetId : targetIds) {
                    if (successIds.contains(targetId) || !this.getPushFailBillIds().add(srcId)) continue;
                    List<OperateErrorInfo> errorInfos = opResultGroup.getBillError(targetId);
                    if (!errorInfos.isEmpty()) {
                        this.addOpFailMessage(srcId, targetId, OP_TYPE_SAVE, opName, ErrorLevel.FatalError, errorInfos.get(0).getMessage());
                        continue;
                    }
                    if (saveResult.getBillCount() == 1) {
                        this.addOpFailMessage(srcId, targetId, OP_TYPE_SAVE, opName, ErrorLevel.FatalError, saveResult.getMessage());
                        continue;
                    }
                    this.addOpFailMessage(srcId, targetId, OP_TYPE_SAVE, opName, ErrorLevel.FatalError, saveFailMessage);
                }
            }
        }
    }

    private void parseOpFailBills(String opType, List<Object> opBillIds, OperationResult opResult, Map<Object, Set<Object>> targetToSrcIdsMap) {
        OpResultGroup opResultGroup = new OpResultGroup(opResult);
        String opFailMessage = "";
        String opName = "";
        if (StringUtils.equals((CharSequence)opType, (CharSequence)OP_TYPE_SUBMIT)) {
            opFailMessage = ResManager.loadKDString((String)"\u6279\u91cf\u63d0\u4ea4\u51fa\u9519\u88ab\u4e2d\u6b62\uff1a", (String)"PushAndSaveExecuter_16", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            opName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"PushAndSaveExecuter_18", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
        } else if (StringUtils.equals((CharSequence)opType, (CharSequence)OP_TYPE_AUDIT)) {
            opFailMessage = ResManager.loadKDString((String)"\u6279\u91cf\u5ba1\u6838\u51fa\u9519\u88ab\u4e2d\u6b62\uff1a", (String)"PushAndSaveExecuter_17", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            opName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"PushAndSaveExecuter_19", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
        }
        if (opResult != null) {
            opFailMessage = opFailMessage + opResult.getMessage();
        }
        HashSet successIds = null;
        successIds = opResult != null && opResult.getSuccessPkIds() != null ? new HashSet(opResult.getSuccessPkIds()) : new HashSet(0);
        for (Object targetId : opBillIds) {
            Set<Object> srcIds;
            if (successIds.contains(targetId) || (srcIds = targetToSrcIdsMap.get(targetId)) == null) continue;
            for (Object srcId : srcIds) {
                List<OperateErrorInfo> errorInfos = opResultGroup.getBillError(targetId);
                if (!errorInfos.isEmpty()) {
                    this.addOpFailMessage(srcId, targetId, opType, opName, ErrorLevel.Info, errorInfos.get(0).getMessage());
                    continue;
                }
                if (opResult != null && opBillIds.size() == 1) {
                    this.addOpFailMessage(srcId, targetId, opType, opName, ErrorLevel.Info, opResult.getMessage());
                    continue;
                }
                this.addOpFailMessage(srcId, targetId, opType, opName, ErrorLevel.Info, opFailMessage);
            }
        }
    }

    private void addOpFailMessage(Object srcPKValue, Object targetPKValue, String opType, String opName, ErrorLevel errorLevel, String failMessage) {
        OperateErrorInfo errInfo = new OperateErrorInfo();
        String srcBillNo = this.getSrcBillNo(srcPKValue);
        String msg = MessageFormat.format(ResManager.loadKDString((String)"\u5355\u636e({0}):\u4e0b\u63a8\u6210\u529f\uff0c\u4f46{1}\u5931\u8d25: {2}", (String)"PushAndSaveExecuter_15", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), StringUtils.isBlank((CharSequence)srcBillNo) ? srcPKValue : srcBillNo, opName, failMessage);
        errInfo.setMessage(msg);
        errInfo.setLevel(errorLevel);
        errInfo.setPkValue(srcPKValue);
        errInfo.setErrorCode(ERRORCODE_AUTOPUSH);
        errInfo.setErrorCustInfos(this.buildErrorCustInfos(opType, "op failed", srcPKValue, targetPKValue));
        this.getOperationResult().getAllErrorInfo().add(errInfo);
        if (this.getOperateLog().isWriteLog()) {
            this.getOperateLog().info(String.format("target bill %s failed, source bill id :=%s, bill no : %s", opName, srcPKValue, srcBillNo));
        }
    }

    private PushArgs buildPushArgs() {
        if (StringUtils.isBlank((CharSequence)this.targetBill)) {
            String msg = String.format(ResManager.loadKDString((String)"%1$s\u5931\u8d25\uff0c\u8bf7\u5230\u5355\u636e\u8bbe\u8ba1\u5668\u4e2d\uff0c\u8bbe\u7f6e\u201c%2$s\u201d\u7684\u76ee\u6807\u5355\u53c2\u6570", (String)"PushAndSaveExecuter_12", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.getSimpleName(), this.getFullName());
            this.getOperateLog().info(msg);
            if (this.isThrowExecptin()) {
                throw new KDBizException(msg);
            }
            return null;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(this.sourceBill);
        pushArgs.setTargetEntityNumber(this.targetBill);
        pushArgs.setRuleId(this.ruleId);
        pushArgs.setHasRight(!this.isCheckNewRight());
        pushArgs.setBuildConvReport(true);
        if (this.getOption() != null) {
            pushArgs.getCustomParams().putAll(this.getOption().getVariables());
        }
        pushArgs.setOpInfo(this.getOpInfo());
        if (!pushArgs.getCustomParams().containsKey(OP_NAME_MAX_PUSH_ROWS)) {
            pushArgs.addCustomParam(OP_NAME_MAX_PUSH_ROWS, MAX_PUSH_ROWS);
        }
        pushArgs.addCustomParam("botp_requiredatamutex", String.valueOf(Boolean.TRUE));
        if (StringUtils.isNotBlank((CharSequence)this.getOpBizRuleKey())) {
            pushArgs.addCustomParam("botp_isstrict", String.valueOf(Boolean.FALSE));
        }
        if (this.getOption().containsVariable("isStrict")) {
            pushArgs.addCustomParam("botp_isstrict", this.getOption().getVariableValue("isStrict", String.valueOf(Boolean.FALSE)));
        }
        return pushArgs;
    }

    private OpInfo getOpInfo() {
        OpInfo opInfo = new OpInfo();
        opInfo.setOpKey(this.getOpKey());
        opInfo.setOpName(new LocaleString(this.getOpName()));
        opInfo.setOpType(this.getOpType());
        return opInfo;
    }

    private void autoSetPrimaryKey(DynamicObject[] targetBillObjs) {
        ISimpleProperty pkProp = this.getTargetMainType().getPrimaryKey();
        for (DynamicObject billObj : targetBillObjs) {
            Object pkValue = billObj.getPkValue();
            if (!((IValidatorHanlder)pkProp).getValueComparator().compareValue(pkValue)) continue;
            if (pkProp instanceof LongProp) {
                pkValue = DBServiceHelper.genGlobalLongId();
            } else if (pkProp instanceof VarcharProp) {
                pkValue = DBServiceHelper.genStringId();
            }
            pkProp.setValue((Object)billObj, pkValue);
        }
    }

    private Map<Object, Set<Object>> findSourceBillIds(DynamicObject[] targetBillObjs) {
        ExtendedDataEntity[] headObjs;
        ExtendedDataEntitySet dataEntitySet = new ExtendedDataEntitySet();
        dataEntitySet.Parse(targetBillObjs, (MainEntityType)this.getTargetMainType());
        HashMap<Integer, Object> targetIds = new HashMap<Integer, Object>(targetBillObjs.length);
        for (ExtendedDataEntity headObj : headObjs = dataEntitySet.FindByEntityKey(this.getTargetBill())) {
            Object billId = headObj.getBillPkId();
            targetIds.put(headObj.getDataEntityIndex(), billId);
        }
        HashMap<Object, Set<Object>> targetToSrcIdsMap = new HashMap<Object, Set<Object>>(targetBillObjs.length);
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)this.getTargetBill());
        for (LinkSetItemElement itemElement : linkSet.getItems()) {
            ExtendedDataEntity[] linkRows = dataEntitySet.FindByEntityKey(itemElement.getLinkEntityKey());
            if (linkRows == null) continue;
            for (ExtendedDataEntity linkRow : linkRows) {
                Object targetBillId = targetIds.get(linkRow.getDataEntityIndex());
                Object srcBillId = linkRow.getValue(itemElement.getLinkEntityKey() + "_sbillid");
                if (targetBillId == null || srcBillId == null) continue;
                if (!targetToSrcIdsMap.containsKey(targetBillId)) {
                    targetToSrcIdsMap.put(targetBillId, new HashSet(1));
                }
                ((Set)targetToSrcIdsMap.get(targetBillId)).add(srcBillId);
            }
        }
        return targetToSrcIdsMap;
    }

    private Set<Object> findTargetBillIds(Object srcBillId, Map<Object, Set<Object>> targetToSrcIdsMap) {
        HashSet<Object> targetBillIds = new HashSet<Object>(1);
        for (Map.Entry<Object, Set<Object>> targetBill : targetToSrcIdsMap.entrySet()) {
            Set<Object> srcIds = targetBill.getValue();
            if (!srcIds.contains(srcBillId)) continue;
            targetBillIds.add(targetBill.getKey());
        }
        return targetBillIds;
    }

    private void mergePushFailMessages(ConvertOperationResult pushResult) {
        ArrayList<OperateErrorInfo> details = new ArrayList<OperateErrorInfo>();
        block0: for (SourceBillReport billReport : pushResult.getBillReports()) {
            if (billReport.isFullSuccess()) continue;
            if (!billReport.isSuccess()) {
                OperateErrorInfo errInfo = new OperateErrorInfo();
                String msg = String.format(ResManager.loadKDString((String)"%s\u5931\u8d25", (String)"PushAndSaveExecuter_13", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.getFullName()) + ": " + billReport.toString();
                errInfo.setMessage(msg);
                errInfo.setLevel(ErrorLevel.Info);
                errInfo.setPkValue(billReport.getBillId());
                errInfo.setErrorCode(ERRORCODE_AUTOPUSH);
                errInfo.setErrorCustInfos(this.buildErrorCustInfos(OP_TYPE_PUSH, "push fail", billReport.getBillId(), null));
                details.add(errInfo);
                this.getPushFailBillIds().add(billReport.getBillId());
                if (!this.getOperateLog().isWriteLog()) continue;
                this.getOperateLog().info(String.format("push failed, billid:=%s; message:=%s", billReport.getBillId(), billReport.toString()));
                continue;
            }
            if (!this.isShowFailRowInfo()) continue;
            OperateErrorInfo summaryInfo = new OperateErrorInfo();
            summaryInfo.setMessage(billReport.getRowInfo() + ": " + billReport.buildSummary());
            summaryInfo.setLevel(ErrorLevel.FatalError);
            summaryInfo.setErrorCode(ERRORCODE_AUTOPUSH);
            summaryInfo.setErrorCustInfos(this.buildErrorCustInfos(OP_TYPE_PUSH, "any rows push fail", billReport.getBillId(), null));
            details.add(summaryInfo);
            int errRowCount = 0;
            for (SourceRowReport rowReport : billReport.getLinkEntityRowReports()) {
                OperateErrorInfo rowInfo = new OperateErrorInfo();
                rowInfo.setMessage(rowReport.getRowInfo(billReport) + ": " + rowReport.getFailMessage());
                rowInfo.setLevel(ErrorLevel.FatalError);
                rowInfo.setErrorCode(ERRORCODE_AUTOPUSH);
                rowInfo.setErrorCustInfos(this.buildErrorCustInfos(OP_TYPE_PUSH, "row push fail", billReport.getBillId(), null));
                details.add(rowInfo);
                if (++errRowCount < 5) continue;
                continue block0;
            }
        }
        if (this.isMergeResult()) {
            OperationResult allResult = this.getOperationResult();
            if (!details.isEmpty()) {
                for (OperateErrorInfo errInfo : details) {
                    allResult.addErrorInfo(errInfo);
                }
            }
        }
    }

    private void addPushFailMessage(DynamicObject[] srcObjs, ConvertOperationResult pushResult) {
        ArrayList<OperateErrorInfo> details = new ArrayList<OperateErrorInfo>();
        DynamicProperty billNoProp = null;
        BillEntityType srcSubMainType = (BillEntityType)srcObjs[0].getDataEntityType();
        if (StringUtils.isNotBlank((CharSequence)srcSubMainType.getBillNo()) && srcSubMainType.getProperties().containsKey((Object)srcSubMainType.getBillNo())) {
            billNoProp = srcSubMainType.getProperty(srcSubMainType.getBillNo());
        }
        if (pushResult.getCachePageIds().isEmpty()) {
            for (DynamicObject srcObj : srcObjs) {
                Object srcBillId = srcObj.getPkValue();
                if (this.getPushFailBillIds().contains(srcBillId)) continue;
                OperateErrorInfo errInfo = new OperateErrorInfo();
                errInfo.setTitle(this.getFullName());
                errInfo.setLevel(ErrorLevel.FatalError);
                errInfo.setPkValue(srcBillId);
                errInfo.setErrorCode(ERRORCODE_AUTOPUSH);
                errInfo.setErrorCustInfos(this.buildErrorCustInfos(OP_TYPE_PUSH, "others push fail", srcBillId, null));
                if (billNoProp != null) {
                    errInfo.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e(%1$s): \u6574\u6279\u4e0b\u63a8\u5931\u8d25\uff0c\u672c\u5355\u88ab\u653e\u5f03: %2$s", (String)"PushAndSaveExecuter_9", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), srcObj.getString((IDataEntityProperty)billNoProp), pushResult.getMessage()));
                } else {
                    errInfo.setMessage(String.format(ResManager.loadKDString((String)"\u6574\u6279\u4e0b\u63a8\u5931\u8d25\uff0c\u672c\u5355\u88ab\u653e\u5f03: %s", (String)"PushAndSaveExecuter_10", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), pushResult.getMessage()));
                }
                details.add(errInfo);
                this.getPushFailBillIds().add(srcBillId);
            }
        }
        if (this.isMergeResult()) {
            OperationResult allResult = this.getOperationResult();
            if (!details.isEmpty()) {
                for (OperateErrorInfo errInfo : details) {
                    allResult.addErrorInfo(errInfo);
                }
            }
        }
    }

    private Map<String, String> buildErrorCustInfos(String targetOpType, String tag, Object sourcePKValue, Object targetPkValue) {
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("sourceentitynumber", this.getSourceBill());
        map.put("sourceopkey", this.getOpKey());
        map.put("sourceopbizrule", this.getOpBizRuleKey());
        map.put("sourcepkvalue", sourcePKValue == null ? null : sourcePKValue.toString());
        map.put("targetentitynumber", this.getTargetBill());
        map.put("ruleid", this.getRuleId());
        map.put("targetoptype", targetOpType);
        map.put("targetpkvalue", targetPkValue == null ? null : targetPkValue.toString());
        map.put("tag", tag);
        return map;
    }

    private IRefrencedataProvider buildRefLoader() {
        if (this.refLoader != null) {
            return this.refLoader;
        }
        this.refLoader = new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        };
        return this.refLoader;
    }

    private boolean getBotpStrictValidation() {
        String botpStrictValidation = this.getOption().getVariableValue(OPTION_BOTP_STRICTVALIDATION, String.valueOf(true));
        return Boolean.parseBoolean(botpStrictValidation);
    }
}

