/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.botp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.service.botp.metadata.IConvertRuleMetaDaoPlugin;

public class ConvertRuleMetaDaoPlugin
implements IMetadataDaoPlugIn,
IConvertRuleMetaDaoPlugin {
    private static IDataEntityType designMetaType;

    private static synchronized IDataEntityType getDesignMetaType() {
        if (designMetaType == null) {
            designMetaType = OrmUtils.getDataEntityType(DesignConvertRuleMeta.class);
        }
        return designMetaType;
    }

    public HashSet<String> loadDisableExtend(HashSet<String> extObjectIds) {
        HashSet<String> disableIds = new HashSet<String>();
        if (extObjectIds.size() == 0) {
            return disableIds;
        }
        String ids = StringUtils.join((Object[])extObjectIds.toArray(), (String)"','");
        String sql = String.format("SELECT FId FROM %s_S WHERE FEnabled <> '1' and FId IN ('%s') ", ConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias(), ids);
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    list.add(id);
                }
                return list;
            }
        };
        List list = (List)DB.query((DBRoute)DBRoute.meta, (String)sql, null, (ResultSetHandler)action);
        disableIds.addAll(list);
        return disableIds;
    }

    public void save(AbstractMetadata[] metadatas) {
        super.save(metadatas);
        for (AbstractMetadata metadata : metadatas) {
            this.saveStatus((ConvertRuleMetadata)metadata);
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ConvertRule", new DistributeCacheHAPolicy(true, true));
        HashSet<String> removeRuleIds = new HashSet<String>(16);
        for (AbstractMetadata metadata : metadatas) {
            if (!(metadata instanceof ConvertRuleMetadata)) continue;
            ConvertRuleMetadata ruleMetadata = (ConvertRuleMetadata)metadata;
            removeRuleIds.add(ruleMetadata.getId());
            if (!ruleMetadata.getDevType().equals("2")) continue;
            removeRuleIds.add(ruleMetadata.getMasterId());
        }
        if (!CollectionUtils.isEmpty(removeRuleIds)) {
            cache.remove(removeRuleIds.toArray(new String[0]));
        }
    }

    public void afterReadMeta(AbstractMetadata meta) {
        this.loadStatus((ConvertRuleMetadata)meta);
    }

    private void saveStatus(ConvertRuleMetadata meta) {
        String sqlExists = String.format("select FID from %s_S where FId = ? ", ConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
        Object[] paramsExists = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId())};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        boolean exists = (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sqlExists, (Object[])paramsExists, (ResultSetHandler)action);
        String sql = null;
        Object[] params = null;
        if (exists) {
            sql = String.format("update %s_S set FEnabled = ? where FId = ? ", ConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
            params = new SqlParameter[]{new SqlParameter(":FEnabled", 1, (Object)(meta.getRuleElement().isEnabled() ? "1" : "0")), new SqlParameter(":FId", 12, (Object)meta.getId())};
        } else {
            sql = String.format("insert into %s_S (FID, FEnabled) values (?, ?)", ConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
            params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId()), new SqlParameter(":FEnabled", 1, (Object)(meta.getRuleElement().isEnabled() ? "1" : "0"))};
        }
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
    }

    private boolean loadStatus(final ConvertRuleMetadata meta) {
        String sql = String.format("select FEnabled, FIsDefault from %s_S where FId = ? ", ConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId())};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    String enable = rs.getString(1);
                    String isDefault = rs.getString(2);
                    meta.getRuleElement().setEnabled(StringUtils.equals((CharSequence)enable, (CharSequence)"1"));
                    meta.getRuleElement().setDefRule(StringUtils.equals((CharSequence)isDefault, (CharSequence)"1"));
                    return true;
                }
                meta.getRuleElement().setEnabled(true);
                meta.getRuleElement().setDefRule(false);
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }
}

