/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.botp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleElementDcBinder;
import kd.bos.id.ID;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ConvertRuleVer {
    private static final String CONVERT_RULE_VER_FORMID = "botp_convertrulever";

    public static long getLatestVerId(String id) {
        try (DataSet ds = ORM.create().queryDataSet("ConvertRuleVer#getLatestVerId", CONVERT_RULE_VER_FORMID, "id", new QFilter[]{new QFilter("latest", "=", (Object)"1"), new QFilter("convertrule", "=", (Object)id)});){
            if (ds.hasNext()) {
                Row row = ds.next();
                long l = row.getLong("id");
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    public static Map<String, Long> saveAsVer(List<ConvertRuleMetadata> ruleMetadatas) {
        HashMap<String, Long> ruleVerIds = new HashMap<String, Long>(ruleMetadatas.size());
        if (ruleMetadatas.isEmpty()) {
            return ruleVerIds;
        }
        HashSet<String> ruleIds = new HashSet<String>(ruleMetadatas.size());
        for (ConvertRuleMetadata ruleMeta : ruleMetadatas) {
            ruleIds.add(ruleMeta.getId());
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)CONVERT_RULE_VER_FORMID);
        MainEntityType subEntityType = (MainEntityType)mainEntityType.getSubEntityType(Arrays.asList("id", "latest"));
        Map latestVerMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)subEntityType, (QFilter[])new QFilter[]{new QFilter("convertrule", "in", ruleIds), new QFilter("latest", "=", (Object)"1")});
        if (latestVerMap != null && !latestVerMap.isEmpty()) {
            DynamicObject[] oldLatestArr;
            for (DynamicObject oldLatest : oldLatestArr = latestVerMap.values().toArray(new DynamicObject[0])) {
                oldLatest.set("latest", (Object)"0");
            }
            SaveServiceHelper.update((DynamicObject[])oldLatestArr);
        }
        DcJsonSerializer convertRuleSerializer = ConvertRuleVer.getConvertRuleSerializer();
        ArrayList<DynamicObject> convertRuleVers = new ArrayList<DynamicObject>(ruleMetadatas.size());
        for (ConvertRuleMetadata ruleMeta : ruleMetadatas) {
            DynamicObject ruleVer = new DynamicObject((DynamicObjectType)mainEntityType);
            mainEntityType.getPrimaryKey().setValueFast((Object)ruleVer, (Object)ID.genLongId());
            ruleVer.set("number", ruleVer.getPkValue());
            ruleVer.set("name", (Object)ruleMeta.getName());
            ruleVer.set("latest", (Object)"1");
            ruleVer.set("convertrule", (Object)ruleMeta.getId());
            ruleVer.set("data", (Object)convertRuleSerializer.serializeToString((Object)ruleMeta, null));
            convertRuleVers.add(ruleVer);
            ruleVerIds.put(ruleMeta.getId(), (Long)ruleVer.getPkValue());
        }
        SaveServiceHelper.save((DynamicObject[])convertRuleVers.toArray(new DynamicObject[0]));
        return ruleVerIds;
    }

    private static DcJsonSerializer getConvertRuleSerializer() {
        ConvertRuleElementDcBinder binder = new ConvertRuleElementDcBinder();
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)binder);
        serializer.setIsLocaleValueFull(true);
        return serializer;
    }
}

