/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.botp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.metadata.botp.RuleDeleteChecker;
import kd.bos.metadata.botp.RuleEnableChecker;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleReader;
import kd.bos.metadata.botp.WriteBackRuleTemplate;
import kd.bos.metadata.botp.WriteBackRuleWriter;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;

public class WriteBackRuleOpPlug
extends AbstractOperationServicePlugIn {
    private static final String BOS_BOTP_FORMPLUGIN = "bos-botp-formplugin";
    private static final String KEY_DEVTYPE = "devtype";
    private static final String KEY_MASTERID = "masterid";
    private static final String ENABLE_STR = "enable";
    private static final String DISABLE_STR = "disable";
    private static final String DELETE_STR = "delete";
    private static final String BOS_BOTP_METADATA = "bos-botp-metadata";
    private Map<String, WriteBackRuleMetadata> opWriteBackRuleMetadataMap;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(KEY_DEVTYPE);
        e.getFieldKeys().add(KEY_MASTERID);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        String opType = (String)this.operateMeta.get("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)ENABLE_STR, (CharSequence)opType)) {
            e.addValidator((AbstractValidator)new RuleEnableChecker());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)DELETE_STR, (CharSequence)opType)) {
            e.addValidator((AbstractValidator)new RuleDeleteChecker());
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        HashSet<String> ruleIds = new HashSet<String>(e.getDataEntities().length);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            String ruleId = (String)dataEntity.getPkValue();
            String devType = dataEntity.getString(KEY_DEVTYPE);
            DynamicObject masterObj = dataEntity.getDynamicObject(KEY_MASTERID);
            ruleIds.add(ruleId);
            if (!StringUtils.isNotBlank((CharSequence)devType) || !devType.equals("2") || masterObj == null) continue;
            ruleIds.add((String)masterObj.getPkValue());
        }
        String opType = (String)this.operateMeta.get("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)DELETE_STR, (CharSequence)opType) || StringUtils.equalsIgnoreCase((CharSequence)ENABLE_STR, (CharSequence)opType) || StringUtils.equalsIgnoreCase((CharSequence)DISABLE_STR, (CharSequence)opType)) {
            WriteBackRuleReader writeBackRuleReader = new WriteBackRuleReader();
            List<WriteBackRuleMetadata> deleteWriteBackRuleMetadataList = writeBackRuleReader.loadMetas(new ArrayList<String>(ruleIds), false, true);
            this.opWriteBackRuleMetadataMap = deleteWriteBackRuleMetadataList.stream().collect(Collectors.toMap(WriteBackRuleMetadata::getId, item -> item));
        }
        WriteBackRuleWriter.clearCache(ruleIds.toArray(new String[ruleIds.size()]));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<String> ruleIds = new ArrayList<String>(10);
        for (DynamicObject obj : e.getDataEntities()) {
            ruleIds.add((String)obj.getPkValue());
        }
        String opType = (String)this.operateMeta.get("type");
        if (StringUtils.equalsIgnoreCase((CharSequence)ENABLE_STR, (CharSequence)opType)) {
            this.updateCustStatus(ruleIds, "1");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)DISABLE_STR, (CharSequence)opType)) {
            this.updateCustStatus(ruleIds, "2");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)DELETE_STR, (CharSequence)opType)) {
            this.deleteCustStatus(ruleIds);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String opType = (String)this.operateMeta.get("type");
        short metaLogType = 0;
        StringBuilder remarkBuilder = new StringBuilder(ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219", (String)"WriteBackRuleOpPlug_2", (String)BOS_BOTP_METADATA, (Object[])new Object[0]));
        if (StringUtils.equalsIgnoreCase((CharSequence)DELETE_STR, (CharSequence)opType)) {
            metaLogType = MetaLogType.BotpDelete.getValue();
            remarkBuilder.append(ResManager.loadKDString((String)"_\u5220\u9664", (String)"WriteBackRuleOpPlug_3", (String)BOS_BOTP_METADATA, (Object[])new Object[0]));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)DISABLE_STR, (CharSequence)opType)) {
            metaLogType = MetaLogType.BotpSave.getValue();
            remarkBuilder.append(ResManager.loadKDString((String)"_\u7981\u7528", (String)"WriteBackRuleOpPlug_4", (String)BOS_BOTP_METADATA, (Object[])new Object[0]));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ENABLE_STR, (CharSequence)opType)) {
            metaLogType = MetaLogType.BotpSave.getValue();
            remarkBuilder.append(ResManager.loadKDString((String)"_\u542f\u7528", (String)"WriteBackRuleOpPlug_5", (String)BOS_BOTP_METADATA, (Object[])new Object[0]));
        }
        if (metaLogType != 0) {
            for (DynamicObject obj : e.getDataEntities()) {
                WriteBackRuleMetadata writeBackRuleMetadata = this.opWriteBackRuleMetadataMap.get((String)obj.getPkValue());
                if (writeBackRuleMetadata == null) continue;
                this.writeOpLog(writeBackRuleMetadata, metaLogType, remarkBuilder.toString());
            }
        }
    }

    private void updateCustStatus(List<String> ruleIds, String status) {
        SqlParameter[] sqlParams;
        if (ruleIds.isEmpty()) {
            return;
        }
        String sqlExists = "select FID from t_botp_WriteBackRule_S where FId in (%s) ";
        ArrayList<String> list = new ArrayList<String>(10);
        Object[] params = new SqlParameter[ruleIds.size()];
        for (int i = 0; i < ruleIds.size(); ++i) {
            list.add("?");
            params[i] = new SqlParameter(":FId" + String.valueOf(i), 12, (Object)ruleIds.get(i));
        }
        sqlExists = String.format(sqlExists, StringUtils.join((Object[])list.toArray(), (String)","));
        ResultSetHandler<Set<String>> action = new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws Exception {
                HashSet<String> idSet = new HashSet<String>(16);
                while (rs.next()) {
                    idSet.add(rs.getString(1));
                }
                return idSet;
            }
        };
        Set existsRuleIds = (Set)DB.query((DBRoute)DBRoute.meta, (String)sqlExists, (Object[])params, (ResultSetHandler)action);
        ArrayList<String> insertRuleIds = new ArrayList<String>();
        for (String ruleId : ruleIds) {
            if (existsRuleIds.contains(ruleId)) continue;
            insertRuleIds.add(ruleId);
        }
        if (!insertRuleIds.isEmpty()) {
            String strInsertSQL = "INSERT INTO t_botp_WriteBackRule_S (FID, FCustStatus) VALUES (?, ?) ";
            ArrayList<SqlParameter[]> insertParams = new ArrayList<SqlParameter[]>(10);
            for (String ruleId : insertRuleIds) {
                sqlParams = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)ruleId), new SqlParameter(":FCustStatus", 1, (Object)status)};
                insertParams.add(sqlParams);
            }
            DB.executeBatch((DBRoute)DBRoute.meta, (String)strInsertSQL, insertParams);
        }
        if (!existsRuleIds.isEmpty()) {
            String strUpdateSQL = "Update t_botp_WriteBackRule_S SET FCustStatus = ? WHERE FID = ? ";
            ArrayList<SqlParameter[]> updateParams = new ArrayList<SqlParameter[]>(10);
            for (String ruleId : existsRuleIds) {
                sqlParams = new SqlParameter[]{new SqlParameter(":FCustStatus", 1, (Object)status), new SqlParameter(":FId", 12, (Object)ruleId)};
                updateParams.add(sqlParams);
            }
            DB.executeBatch((DBRoute)DBRoute.meta, (String)strUpdateSQL, updateParams);
        }
    }

    private void deleteCustStatus(List<String> ruleIds) {
        if (ruleIds.isEmpty()) {
            return;
        }
        String sql = "DELETE FROM T_BOTP_WriteBackRule_S WHERE FID IN (%s)";
        ArrayList<String> list = new ArrayList<String>(10);
        Object[] params = new SqlParameter[ruleIds.size()];
        for (int i = 0; i < ruleIds.size(); ++i) {
            list.add("?");
            params[i] = new SqlParameter(":FId" + String.valueOf(i), 12, (Object)ruleIds.get(i));
        }
        sql = String.format(sql, StringUtils.join((Object[])list.toArray(), (String)","));
        DB.execute((DBRoute)DBRoute.meta, (String)sql, (Object[])params);
    }

    private void writeOpLog(WriteBackRuleMetadata rule, int metaLogType, String remark) {
        WriteBackRuleTemplate template = new WriteBackRuleTemplate();
        long logId = DB.genGlobalLongId();
        String metaId = rule.getId();
        String metaNumber = rule.getRuleElement().getSourceEntityNumber() + "-" + rule.getRuleElement().getTargetEntityNumber();
        MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        logService.addBotpMetaLog(metaId, metaNumber, template.buildDiffXml(rule, null, false), metaLogType, logId, rule.getBizappId(), remark);
    }
}

