/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.botp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.botp.WriteBackRuleElementDcBinder;
import kd.bos.entity.botp.WriteBackRuleElementSerializer;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleTemplate;
import kd.bos.metadata.botp.WriteBackRuleVer;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.lang.LangItemBuilder;
import kd.bos.metadata.lang.LangWriter;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class WriteBackRuleReader {
    private static final Log log = LogFactory.getLog(WriteBackRuleReader.class);
    private String appGroup = AppGroupUtils.getCurrentAppGroup();

    private String getAppGroup() {
        return this.appGroup;
    }

    public WriteBackRuleMetadata loadMeta(String id, boolean runtime) {
        return this.loadMeta(id, runtime, false);
    }

    public WriteBackRuleMetadata loadMeta(String id, boolean runtime, boolean isBaseMeta) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class);
        AbstractMetadata meta = this.readRuleMetadata(id, designerMetaType, runtime, isBaseMeta);
        return (WriteBackRuleMetadata)meta;
    }

    public List<WriteBackRuleMetadata> loadMetas(List<String> ids, boolean runtime, boolean isBaseMeta) {
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<WriteBackRuleMetadata>();
        }
        ArrayList<WriteBackRuleMetadata> metas = new ArrayList<WriteBackRuleMetadata>(ids.size());
        for (String id : ids) {
            metas.add(this.loadMeta(id, runtime, isBaseMeta));
        }
        return metas;
    }

    public List<WriteBackRuleElement> loadRules(String targetEntityNumber) {
        IDataEntityType designerMetaType = OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class);
        List<String> ruleIds = this.loadRuleIds(targetEntityNumber, true);
        ArrayList<WriteBackRuleElement> rules = new ArrayList<WriteBackRuleElement>(10);
        for (String ruleId : ruleIds) {
            WriteBackRuleMetadata metadata = (WriteBackRuleMetadata)this.readRuleMetadata(ruleId, designerMetaType, true, false);
            if (metadata == null) continue;
            rules.add(metadata.getRuleElement());
        }
        return rules;
    }

    public WriteBackRuleElement loadRuleVer(long verId) {
        IDataEntityType dType = OrmUtils.getDataEntityType(WriteBackRuleVer.class);
        WriteBackRuleVer ver = (WriteBackRuleVer)BusinessDataReader.read((Object)verId, (IDataEntityType)this.getGrayDeataEntityType(dType), (Boolean)false);
        if (ver == null && this.isGrayGroup()) {
            ver = (WriteBackRuleVer)BusinessDataReader.read((Object)verId, (IDataEntityType)dType, (Boolean)false);
        }
        String json = null;
        if (ver != null) {
            json = ver.getData();
        }
        WriteBackRuleElement ruleElement = WriteBackRuleElementSerializer.deserializeFromString((String)json, null);
        this.fillLocaleProp2RuleVer(ruleElement);
        return ruleElement;
    }

    private void fillLocaleProp2RuleVer(WriteBackRuleElement ruleElement) {
        try {
            String ruleId = ruleElement.getId();
            WriteBackRuleMetadata metadata = this.loadMeta(ruleId, true);
            WriteBackRuleElement rule = metadata.getRuleElement();
            if (ruleElement.getOriVersion() != rule.getOriVersion()) {
                return;
            }
            WriteBackRuleElementDcBinder binder = new WriteBackRuleElementDcBinder();
            LangItemBuilder builder = new LangItemBuilder((DcBinder)binder);
            builder.builderResouces((Object)rule, null);
            List datas = builder.getLocaleItemValues();
            HashSet localeIds = new HashSet(16);
            ArrayList items = new ArrayList(10);
            for (Map localeMap : datas) {
                HashMap v = new HashMap(16);
                for (Map.Entry data : localeMap.entrySet()) {
                    localeIds.addAll(((ILocaleValue)data.getValue()).keySet());
                    Map map = (Map)data.getValue();
                    v.put(data.getKey(), map);
                }
                items.add(v);
            }
            LangWriter writer = new LangWriter((DcBinder)binder, (Object)ruleElement, items);
            writer.setLoaceValue(new ArrayList(localeIds));
        }
        catch (Exception e) {
            log.error(String.format("Failed to populate writebackrulever multilingual attributes ,ruleId: %s ,errmsg = %s ", ruleElement.getId(), e.getMessage()));
        }
    }

    public List<String> loadRuleIds(String targetEntityNumber, boolean runtime) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId ");
        sBuilder.append("FROM ").append(this.getGrayTableName("T_BOTP_WriteBackRule"));
        sBuilder.append(" WHERE FTargetEntityNumber = ? ");
        if (runtime) {
            sBuilder.append("and FType <> '2'");
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":FTargetEntityNumber", 12, (Object)targetEntityNumber)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    ids.add(id);
                }
                return ids;
            }
        };
        List ruleIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (ruleIds.isEmpty() && this.isGrayGroup()) {
            sBuilder = new StringBuilder();
            sBuilder.append("SELECT FId ");
            sBuilder.append("FROM ").append("T_BOTP_WriteBackRule");
            sBuilder.append(" WHERE FTargetEntityNumber = ? ");
            if (runtime) {
                sBuilder.append("and FType <> '2'");
            }
            ruleIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        }
        return ruleIds;
    }

    public boolean hadExtRules(String ruleId) {
        IDataEntityType dType = OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class);
        DesignWriteBackRuleMeta designMeta = (DesignWriteBackRuleMeta)BusinessDataReader.read((Object)ruleId, (IDataEntityType)this.getGrayDeataEntityType(dType), (Boolean)false);
        if (designMeta == null && this.isGrayGroup()) {
            designMeta = (DesignWriteBackRuleMeta)BusinessDataReader.read((Object)ruleId, (IDataEntityType)dType, (Boolean)false);
        }
        String devType = null;
        if (designMeta != null) {
            devType = designMeta.getDevType();
        }
        if ("2".equals(devType)) {
            return true;
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FId ");
        sBuilder.append("FROM ").append(this.getGrayTableName("T_BOTP_WriteBackRule"));
        sBuilder.append(" WHERE FMasterId = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FMasterId", 12, (Object)ruleId)};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    ids.add(id);
                }
                return ids;
            }
        };
        List extRuleIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (extRuleIds.isEmpty() && this.isGrayGroup()) {
            sBuilder = new StringBuilder();
            sBuilder.append("SELECT FId ");
            sBuilder.append("FROM ").append("T_BOTP_WriteBackRule");
            sBuilder.append(" WHERE FMasterId = ? ");
            extRuleIds = (List)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        }
        return extRuleIds.size() > 0;
    }

    public String buildXml(String ruleId, boolean runtime, boolean onlyLocaleValue) {
        WriteBackRuleMetadata writeBackRuleMetadata = this.loadMeta(ruleId, runtime);
        String xmlData = "";
        if (writeBackRuleMetadata != null) {
            WriteBackRuleTemplate template = new WriteBackRuleTemplate();
            xmlData = template.buildDiffXml(writeBackRuleMetadata, null, onlyLocaleValue);
        }
        return xmlData;
    }

    private AbstractMetadata readRuleMetadata(String id, IDataEntityType designerMetaType, boolean runtime, boolean isBaseMeta) {
        MetadataReader reader = this.createMetaReader();
        AbstractMetadata meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        if (meta == null && AppGroupUtils.isGrayGroup()) {
            reader = new MetadataReader();
            meta = reader.readMeta(id, designerMetaType, runtime, isBaseMeta);
        }
        return meta;
    }

    private MetadataReader createMetaReader() {
        MetadataReader reader = new MetadataReader();
        reader.setAppGroup(this.appGroup);
        return reader;
    }

    private IDataEntityType getGrayDeataEntityType(IDataEntityType designerMetaType) {
        IDataEntityType det;
        if (!this.isGrayGroup()) {
            return designerMetaType;
        }
        try {
            det = (IDataEntityType)designerMetaType.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
        det.setAlias(String.format("%s_%s", det.getAlias(), this.appGroup));
        return det;
    }

    private boolean isGrayGroup() {
        return StringUtils.isNotBlank((CharSequence)this.appGroup) && !"defaultGroup".equals(this.appGroup);
    }

    private String getGrayTableName(String tabName) {
        if (StringUtils.isBlank((CharSequence)this.appGroup) || "defaultGroup".equals(this.appGroup)) {
            return tabName;
        }
        return String.format("%s_%s", tabName, this.appGroup);
    }
}

