/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.ConvertRuleElementDcBinder;
import kd.bos.entity.botp.WriteBackRuleCache;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.botp.WriteBackRuleElementSerializer;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.ConvertRuleReader;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleReader;

class BOTPMetadataReader {
    BOTPMetadataReader() {
    }

    public static String loadConvertRule(String ruleId) {
        ConvertRuleReader reader = new ConvertRuleReader();
        ConvertRuleMetadata metadata = reader.loadMeta(ruleId, true);
        if (metadata == null) {
            return null;
        }
        ConvertRuleElement rule = metadata.getRuleElement();
        ConvertRuleElementDcBinder binder = new ConvertRuleElementDcBinder();
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)binder);
        serializer.setIsLocaleValueFull(true);
        String ruleString = serializer.serializeToString((Object)rule, null);
        return ruleString;
    }

    public static List<String> loadConvertRules(String sourceEntityNumber, String targetEntityNumber) {
        ConvertRuleReader reader = new ConvertRuleReader();
        List<String> ruleIds = reader.loadRuleIds(sourceEntityNumber, targetEntityNumber, true);
        ArrayList<String> ruleStrings = new ArrayList<String>(10);
        for (String ruleId : ruleIds) {
            String ruleString = BOTPMetadataReader.loadConvertRule(ruleId);
            ruleStrings.add(ruleString);
        }
        return ruleStrings;
    }

    public static List<String> loadConvertRuleIds(String sourceEntityNumber, String targetEntityNumber) {
        ConvertRuleReader reader = new ConvertRuleReader();
        return reader.loadRuleIds(sourceEntityNumber, targetEntityNumber, true);
    }

    public static String loadWriteBackRule(String ruleId) {
        WriteBackRuleReader reader = new WriteBackRuleReader();
        WriteBackRuleMetadata metadata = reader.loadMeta(ruleId, true);
        WriteBackRuleElement rule = metadata.getRuleElement();
        String ruleString = WriteBackRuleElementSerializer.serializeToString((WriteBackRuleElement)rule, null);
        return ruleString;
    }

    public static List<String> loadWriteBackRuleIds(String targetEntityNumber) {
        WriteBackRuleReader reader = new WriteBackRuleReader();
        return reader.loadRuleIds(targetEntityNumber, true);
    }

    public static List<String> loadWriteBackRules(String targetEntityNumber) {
        WriteBackRuleReader reader = new WriteBackRuleReader();
        List<String> ruleIds = reader.loadRuleIds(targetEntityNumber, true);
        ArrayList<String> ruleStrings = new ArrayList<String>(10);
        for (String ruleId : ruleIds) {
            String ruleString = BOTPMetadataReader.loadWriteBackRule(ruleId);
            ruleStrings.add(ruleString);
        }
        return ruleStrings;
    }

    public static String loadWriteBackRuleVersion(long verId) {
        WriteBackRuleReader reader = new WriteBackRuleReader();
        WriteBackRuleElement rule = reader.loadRuleVer(verId);
        String ruleString = WriteBackRuleElementSerializer.serializeToString((WriteBackRuleElement)rule, null);
        return ruleString;
    }

    public static void clearAllConvertRuleCache() {
        ConvertRuleCache.clearAllConvertRuleCache();
    }

    public static void clearAllWriteBackRuleCache() {
        WriteBackRuleCache.clearAllRuleCache();
    }
}

