/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.openapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.service.metadata.MultiLangMetadataFileService;

public class BotpMetaLFilePlugin
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(MultiLangMetadataFileService.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        String id = params.get("id").toString();
        int type = 0;
        if (params.get("type") != null) {
            type = Integer.parseInt(params.get("type").toString());
        }
        List tlangs = (List)params.get("tlangs");
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("id", id);
            map.put("ver", Long.valueOf(System.currentTimeMillis()).toString());
            List list = new ArrayList();
            switch (type) {
                case 0: {
                    list = MetadataDao.getConvertRuleDeployFile((String)id);
                    break;
                }
                case 1: {
                    list = MetadataDao.getWriteBackRuleDeployFile((String)id);
                    break;
                }
            }
            HashMap<String, String> files = new HashMap<String, String>(16);
            for (DeployFile file : list) {
                String[] name = file.getFileName().split("\\.");
                if (name.length == 2) continue;
                String localeId = name[1];
                if (tlangs.isEmpty() || !tlangs.contains(localeId)) continue;
                files.put(file.getFileName(), file.getFileContent());
            }
            map.put("files", files);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u591a\u8bed\u8a00\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u591a\u8bed\u8a00\u6587\u4ef6\u5931\u8d25: %s", (String)"BotpMetaLFilePlugin_0", (String)"bos-botp-metadata", (Object[])new Object[0]), e.getMessage()));
        }
        return ApiResult.success(map);
    }
}

