/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata.openapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.botp.ConvertRuleMetadata;
import kd.bos.metadata.botp.ConvertRuleReader;
import kd.bos.metadata.botp.ConvertRuleWriter;
import kd.bos.metadata.botp.WriteBackRuleMetadata;
import kd.bos.metadata.botp.WriteBackRuleReader;
import kd.bos.metadata.botp.WriteBackRuleWriter;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.lang.LangWriter;
import kd.bos.service.metadata.MultiLangMetadataUpdate;
import kd.bos.service.metadata.util.GzipUtils;

public class BotpMetaLWriterPlugin
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(MultiLangMetadataUpdate.class);
    private MetadataSerializer serializer;
    private List<String> tlangs;
    private String slang = "zh_CN";

    private AbstractMetadata convertTo(AbstractMetadata meta, List<Map<String, Map<String, Object>>> localeItemMap) {
        String modelType = meta.getModelType();
        this.serializer = new MetadataSerializer(modelType);
        this.restoreLang(meta, localeItemMap);
        return meta;
    }

    public ApiResult doCustomService(Map<String, Object> localeDataMap) {
        try {
            int type = 0;
            if (localeDataMap.get("type") != null) {
                type = Integer.parseInt(String.valueOf(localeDataMap.get("type")));
            }
            String id = String.valueOf(localeDataMap.get("id"));
            this.tlangs = (List)localeDataMap.get("tlangs");
            if (this.tlangs == null || this.tlangs.isEmpty()) {
                this.tlangs = new ArrayList<String>();
                this.tlangs.add("en_US");
            }
            Boolean isEncrypt = Boolean.valueOf(String.valueOf(localeDataMap.get("isEncrypt")));
            Map list = null;
            list = isEncrypt != false ? (Map)SerializationUtils.fromJsonString((String)GzipUtils.uncompress((String)localeDataMap.get("localeData").toString(), (String)"utf-8"), Map.class) : (Map)localeDataMap.get("localeData");
            this.updateLocaleMeta(id, type, list);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25: " + e.getMessage());
            return ApiResult.fail((String)String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u5931\u8d25%s", (String)"BotpMetaLWriterPlugin_0", (String)"bos-botp-metadata", (Object[])new Object[0]), e.getMessage()));
        }
        return ApiResult.success((Object)ResManager.loadKDString((String)"\u66f4\u65b0\u591a\u8bed\u8a00\u8bcd\u6761\u6210\u529f", (String)"BotpMetaLWriterPlugin_1", (String)"bos-botp-metadata", (Object[])new Object[0]));
    }

    private void updateLocaleMeta(String id, int type, Map<String, Map<String, Object>> localeItemMap) {
        switch (type) {
            case 0: {
                this.updateLocaleConvertRuleMeta(id, localeItemMap);
                break;
            }
            case 1: {
                this.updateLocaleWriteBackMeta(id, localeItemMap);
            }
        }
    }

    private void restoreLang(AbstractMetadata metadata, List<Map<String, Map<String, Object>>> localeItems) {
        LangWriter writer = new LangWriter(this.serializer.getBinder(), (Object)metadata, localeItems);
        writer.setLoaceValue(this.tlangs);
        for (String tlang : this.tlangs) {
            writer.setNullLoaceValue(tlang, this.slang);
        }
    }

    public void updateLocaleConvertRuleMeta(String id, Map<String, Map<String, Object>> itemdatas) {
        ConvertRuleReader reader = new ConvertRuleReader();
        ConvertRuleMetadata meta = reader.loadMeta(id, false);
        ArrayList<Map<String, Map<String, Object>>> items = new ArrayList<Map<String, Map<String, Object>>>();
        this.buildLocaleItem(itemdatas, items);
        this.convertTo(meta, items);
        ConvertRuleWriter.save(meta);
    }

    public void updateLocaleWriteBackMeta(String id, Map<String, Map<String, Object>> itemdatas) {
        WriteBackRuleReader reader = new WriteBackRuleReader();
        WriteBackRuleMetadata meta = reader.loadMeta(id, false);
        ArrayList<Map<String, Map<String, Object>>> items = new ArrayList<Map<String, Map<String, Object>>>();
        this.buildLocaleItem(itemdatas, items);
        this.convertTo(meta, items);
        WriteBackRuleWriter.save(meta);
    }

    private void buildLocaleItem(Map<String, Map<String, Object>> itemdatas, List<Map<String, Map<String, Object>>> items) {
        for (Map.Entry<String, Map<String, Object>> item : itemdatas.entrySet()) {
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
            map.put(item.getKey(), item.getValue());
            items.add(map);
        }
    }
}

