/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.ctbotp.CtBizAppTreeBuilder;
import kd.bos.entity.EntryType;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.dto.CtBotpEntityDto;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;

public class CtConvertEntityList
extends AbstractFormPlugin
implements TreeNodeClickListener,
RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static Log log = LogFactory.getLog(CtConvertEntityList.class);
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String KEY_OK = "btnok";
    private static final String KEY_FID = "fid";
    private static final String KEY_FNUMBER = "fnumber";
    private static final String KEY_FNAME = "fname";
    private static final String KEY_FBIZAPPNAME = "fbizappname";
    private static final String KEY_FBIZAPPID = "fbizappid";
    private static final String KEY_FBIZCLOUDNAME = "fbizcloudname";
    private static final String KEY_FBIZCLOUDNUMBER = "fbizcloudnumber";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_SEARCH_PATH = "searchpath";
    private static final String CACHEID_CONVERT_ENTITYS = "entitys";
    private static final String CACHEID_TREE_NODES = "nodes";
    private static final String CACHEID_CURR_NODE = "currnode";
    private List<CtBotpEntityDto> allEntityDto;

    public void initialize() {
        super.initialize();
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"tbar_main"});
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH_PATH);
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{KEY_OK});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equalsIgnoreCase(KEY_OK)) {
            this.returnData();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(CACHEID_CONVERT_ENTITYS);
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        this.getModel().putContextVariable("MODEL_BOSENTRYSERVERFILTERSORT", (Object)true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String tenant = (String)this.getView().getFormShowParameter().getCustomParam("tenant");
        String accountId = (String)this.getView().getFormShowParameter().getCustomParam("accountId");
        String result = CtBotpApiUtils.get((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETENTITYOBJECT, null);
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        List entityDtos = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(openApiResult.get("data")), CtBotpEntityDto.class);
        this.putPathCache(entityDtos);
        this.doSearchByNodeId(entityDtos, "");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String tenant = (String)this.getView().getFormShowParameter().getCustomParam("tenant");
        String accountId = (String)this.getView().getFormShowParameter().getCustomParam("accountId");
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("tenant", tenant);
        param.put("accountId", accountId);
        String result = CtBotpApiUtils.get((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETTREENODE, param);
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        CtBizAppTreeBuilder ctBizAppTreeBuilder = (CtBizAppTreeBuilder)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), CtBizAppTreeBuilder.class);
        String json = SerializationUtils.toJsonString((Object)ctBizAppTreeBuilder);
        this.getPageCache().put(CACHEID_TREE_NODES, json);
        TreeView tView = (TreeView)this.getControl(KEY_TREEVIEW);
        tView.addNode(ctBizAppTreeBuilder.getRootNode());
        tView.focusNode(ctBizAppTreeBuilder.getRootNode());
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId;
        String newNodeId = (String)e.getNodeId();
        if (newNodeId.equals(currNodeId = this.getPageCache().get(CACHEID_CURR_NODE))) {
            return;
        }
        List<CtBotpEntityDto> allEntitys = this.getPathCache();
        this.doSearchByNodeId(allEntitys, newNodeId);
        this.getPageCache().put(CACHEID_CURR_NODE, newNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
    }

    public List<String> getSearchList(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_PATH, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                return this.doSearchList(searchText);
            }
            return null;
        }
        return null;
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_PATH, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearchByBill(searchText);
        }
    }

    private CtBotpEntityDto getSelectEntity() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY);
        if (rowCount == 0) {
            return null;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        String billNumber = (String)this.getModel().getValue(KEY_FNUMBER, rowIndex);
        List<CtBotpEntityDto> allPaths = this.getPathCache();
        CtBotpEntityDto myDto = null;
        for (CtBotpEntityDto dto : allPaths) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)billNumber, (CharSequence)dto.getNumber())) continue;
            myDto = dto;
            break;
        }
        return myDto;
    }

    private List<String> doSearchList(String searchText) {
        HashSet<String> searchList = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return new ArrayList<String>();
        }
        List<CtBotpEntityDto> allEntityDto = this.getPathCache();
        for (CtBotpEntityDto dto : allEntityDto) {
            if (StringUtils.isNotBlank((CharSequence)dto.getNumber()) && dto.getNumber().indexOf(searchText) == 0) {
                searchList.add(dto.getNumber());
            } else if (StringUtils.isNotBlank((CharSequence)dto.getName()) && dto.getName().indexOf(searchText) == 0) {
                searchList.add(dto.getName());
            }
            if (searchList.size() < 10) continue;
            break;
        }
        return new ArrayList<String>(searchList);
    }

    private void doSearchByBill(String searchText) {
        List<CtBotpEntityDto> allEntityDto = this.getPathCache();
        ArrayList<CtBotpEntityDto> entityDtos = new ArrayList<CtBotpEntityDto>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            entityDtos.addAll(allEntityDto);
        } else {
            for (CtBotpEntityDto dto : allEntityDto) {
                if (!this.checkPathSourceAndTarget(dto, searchText)) continue;
                entityDtos.add(dto);
            }
        }
        this.refreshEntryGrid(entityDtos);
    }

    private boolean checkPathSourceAndTarget(CtBotpEntityDto dto, String searchText) {
        return StringUtils.isNotBlank((CharSequence)dto.getNumber()) && dto.getNumber().indexOf(searchText) >= 0 || StringUtils.isNotBlank((CharSequence)dto.getName()) && dto.getName().indexOf(searchText) >= 0;
    }

    private void doSearchByNodeId(List<CtBotpEntityDto> allEntityDto, String nodedId) {
        ArrayList<CtBotpEntityDto> entityDtos = new ArrayList<CtBotpEntityDto>();
        if (StringUtils.isBlank((CharSequence)nodedId)) {
            entityDtos.addAll(allEntityDto);
        } else {
            String rootNodeJson = this.getPageCache().get(CACHEID_TREE_NODES);
            CtBizAppTreeBuilder bizAppTreeBuilder = (CtBizAppTreeBuilder)SerializationUtils.fromJsonString((String)rootNodeJson, CtBizAppTreeBuilder.class);
            TreeNode rootNode = bizAppTreeBuilder.getRootNode();
            if (rootNode.getId().equals(nodedId)) {
                entityDtos.addAll(allEntityDto);
            } else {
                TreeNode cloudNode = null;
                for (TreeNode node : rootNode.getChildren()) {
                    if (!node.getId().equals(nodedId)) continue;
                    cloudNode = node;
                    break;
                }
                HashSet<String> bizAppIds = new HashSet<String>();
                if (cloudNode != null) {
                    if (cloudNode.getChildren() != null) {
                        for (TreeNode bizAppNode : cloudNode.getChildren()) {
                            bizAppIds.add(bizAppNode.getId());
                            bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(bizAppNode.getId()));
                        }
                    }
                } else {
                    bizAppIds.add(nodedId);
                    bizAppIds.addAll((Collection)bizAppTreeBuilder.getAppExtIds().get(nodedId));
                }
                for (CtBotpEntityDto dto : allEntityDto) {
                    if (!bizAppIds.contains(dto.getBizAppId())) continue;
                    entityDtos.add(dto);
                }
            }
        }
        this.refreshEntryGrid(entityDtos);
    }

    private void refreshEntryGrid(List<CtBotpEntityDto> entityDtos) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_ENTITY);
        int seq = 1;
        for (CtBotpEntityDto dto : entityDtos) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("seq", (Object)seq);
            row.set(KEY_FID, (Object)dto.getId());
            row.set(KEY_FNUMBER, (Object)dto.getNumber());
            row.set(KEY_FNAME, (Object)dto.getName());
            row.set(KEY_FBIZAPPID, (Object)dto.getBizAppId());
            row.set(KEY_FBIZAPPNAME, (Object)dto.getBizAppIdName());
            row.set(KEY_FBIZCLOUDNAME, (Object)dto.getBizcloudName());
            row.set(KEY_FBIZCLOUDNUMBER, (Object)dto.getBizcloudNumber());
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private boolean existBill(List<CtBotpEntityDto> allEntityDto, String number) {
        for (CtBotpEntityDto dto : allEntityDto) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)dto.getNumber(), (CharSequence)number)) continue;
            return true;
        }
        return false;
    }

    private void putPathCache(List<CtBotpEntityDto> entityDtos) {
        String entitysJsonString = SerializationUtils.toJsonString(entityDtos);
        this.getPageCache().put(CACHEID_CONVERT_ENTITYS, entitysJsonString);
        this.allEntityDto = entityDtos;
    }

    private List<CtBotpEntityDto> getPathCache() {
        if (this.allEntityDto != null) {
            return this.allEntityDto;
        }
        String pathsJsonString = this.getPageCache().get(CACHEID_CONVERT_ENTITYS);
        this.allEntityDto = StringUtils.isBlank((CharSequence)pathsJsonString) ? new ArrayList<CtBotpEntityDto>() : SerializationUtils.fromJsonStringToList((String)pathsJsonString, CtBotpEntityDto.class);
        return this.allEntityDto;
    }

    private void returnData() {
        CtBotpEntityDto returnData = this.getSelectEntity();
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }
}

