/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.util.CtGetMainEntityTypeUtil;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtConvertPath;
import kd.bos.entity.ctbotp.dto.CtBotpEntityDto;
import kd.bos.entity.ctbotp.dto.MainEntityTypeDto;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;

public class CtConvertPathEdit
extends AbstractTreeListPlugin
implements RowClickEventListener,
SearchEnterListener,
HyperLinkClickListener {
    private static Log log = LogFactory.getLog(CtConvertPathEdit.class);
    private static final String KEY_NEW = "new";
    private static final String KEY_MODIFY = "modify";
    private static final String KEY_DELETE = "delete";
    private static final String KEY_FSOURCE_BIZAPPNAME = "fsbizappname";
    private static final String KEY_FSOURCE_ENTITY_NUMBER = "fsourceentitynumber";
    private static final String KEY_FSOURCE_ENTITY_NAME = "fsourceentityname";
    private static final String KEY_FTARGET_BIZAPPNAME = "ftbizappname";
    private static final String KEY_FTARGET_ENTITY_NUMBER = "ftargetentitynumber";
    private static final String KEY_FTARGET_ENTITY_NAME = "ftargetentityname";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_SEARCH_PATH = "searchpath";
    private static final String FORMID_NEW_CONVERT_PATH = "ct_botp_newconvertpath";
    private static final String FORMID_CONVERT_RULE = "ct_botp_convertrule";
    private static final String CACHEID_CONVERT_PATHS = "paths";
    private static final String BOS_CTBOTP_PLUGIN = "bos-ctbotp-formplugin";
    private List<CtConvertPath> allPaths;

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main"});
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        grid.addHyperClickListener((HyperLinkClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCH_PATH);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(CACHEID_CONVERT_PATHS);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List paths = CtConvertMetaServiceHelper.loadAllConvertPaths();
        this.putPathCache(paths);
        this.doSearchByNodeId(paths);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getOperationResult() == null || !e.getOperationResult().isSuccess()) {
            return;
        }
        String opKey = e.getOperateKey();
        if (opKey.equalsIgnoreCase(KEY_NEW)) {
            this.doNew();
        } else if (opKey.equalsIgnoreCase(KEY_MODIFY)) {
            this.doModify();
        } else if (opKey.equalsIgnoreCase(KEY_DELETE)) {
            this.doBeforeDelete();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equalsIgnoreCase(KEY_NEW)) {
            this.afterShowNewForm(closedCallBackEvent);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)KEY_DELETE, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.doDelete();
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        Map<String, String> sourceMap = this.getSourceInfo(rowIndex);
        Map<String, String> targetMap = this.getTargetInfo(rowIndex);
        this.showRuleForm(sourceMap, targetMap);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        Map<String, String> sourceMap = this.getSourceInfo(rowIndex);
        Map<String, String> targetMap = this.getTargetInfo(rowIndex);
        this.showRuleForm(sourceMap, targetMap);
    }

    public List<String> getSearchList(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_PATH, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                return this.doSearchList(searchText);
            }
            return null;
        }
        return null;
    }

    public void search(SearchEnterEvent e) {
        Search search = (Search)e.getSource();
        if (StringUtils.equals((CharSequence)KEY_SEARCH_PATH, (CharSequence)search.getKey())) {
            String searchText = e.getText();
            this.doSearchByBill(searchText);
        }
    }

    private void doNew() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_NEW_CONVERT_PATH);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_NEW);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void doModify() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        int[] rows = grid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u3002", (String)"CtConvertPathEdit_6", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY);
        if (rowCount == 0) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        Map<String, String> sourceMap = this.getSourceInfo(rowIndex);
        Map<String, String> targetMap = this.getTargetInfo(rowIndex);
        this.showRuleForm(sourceMap, targetMap);
    }

    private void doBeforeDelete() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        int[] rows = grid.getSelectRows();
        if (rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u3002", (String)"CtConvertPathEdit_6", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        CtConvertPath myPath = this.getSelectPath();
        if (myPath != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(KEY_DELETE, (IFormPlugin)this);
            String strDeleteConfirmTip = String.format(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u5220\u9664[%1$s]->[%2$s]\u4e4b\u95f4\u7684\u8f6c\u6362\u89c4\u5219\u5417\uff1f", (String)"CtConvertPathEdit_0", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), myPath.getSourceEntityNumber(), myPath.getTargetEntityNumber());
            this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBacks);
            return;
        }
    }

    private void doDelete() {
        CtConvertPath myPath = this.getSelectPath();
        if (myPath != null) {
            Map delResult;
            MainEntityTypeDto targetDto;
            boolean existSourceEntity = false;
            boolean existTargetEntity = false;
            MainEntityTypeDto sourceDto = CtGetMainEntityTypeUtil.getMainEntityType(myPath.getSourceTenant(), myPath.getSourceAccountId(), myPath.getSourceEntityNumber(), this.getPageCache());
            if (sourceDto != null) {
                existSourceEntity = true;
            }
            if ((targetDto = CtGetMainEntityTypeUtil.getMainEntityType(myPath.getTargetTenant(), myPath.getTargetAccountId(), myPath.getTargetEntityNumber(), this.getPageCache())) != null) {
                existTargetEntity = true;
            }
            if ((delResult = CtConvertMetaServiceHelper.delete((CtConvertPath)myPath, (boolean)existSourceEntity, (boolean)existTargetEntity)) == null || !delResult.containsKey("success")) {
                return;
            }
            boolean success = (Boolean)delResult.get("success");
            String message = (String)delResult.get("message");
            if (!success) {
                this.getView().showTipNotification(message);
            } else {
                this.writeDeleteLog(myPath.getSourceEntityNumber(), myPath.getTargetEntityNumber());
                int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
                this.getModel().deleteEntryRow(KEY_ENTRY_ENTITY, rowIndex);
                List<CtConvertPath> allPaths = this.getPathCache();
                allPaths.remove(myPath);
                this.putPathCache(allPaths);
                this.getView().showSuccessNotification(message);
            }
        }
    }

    private CtConvertPath getSelectPath() {
        int rowCount = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY);
        if (rowCount == 0) {
            return null;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY_ENTITY);
        String sourceBill = (String)this.getModel().getValue(KEY_FSOURCE_ENTITY_NUMBER, rowIndex);
        String targetBill = (String)this.getModel().getValue(KEY_FTARGET_ENTITY_NUMBER, rowIndex);
        List<CtConvertPath> allPaths = this.getPathCache();
        CtConvertPath myPath = null;
        for (CtConvertPath path : allPaths) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)sourceBill, (CharSequence)path.getSourceEntityNumber()) || !StringUtils.equalsIgnoreCase((CharSequence)targetBill, (CharSequence)path.getTargetEntityNumber())) continue;
            myPath = path;
            break;
        }
        return myPath;
    }

    private List<String> doSearchList(String searchText) {
        HashSet<String> searchList = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return new ArrayList<String>();
        }
        List<CtConvertPath> allPaths = this.getPathCache();
        for (CtConvertPath path : allPaths) {
            if (StringUtils.isNotBlank((CharSequence)path.getSourceEntityName()) && path.getSourceEntityName().indexOf(searchText) == 0) {
                searchList.add(path.getSourceEntityName());
            } else if (StringUtils.isNotBlank((CharSequence)path.getSourceEntityNumber()) && path.getSourceEntityNumber().indexOf(searchText) == 0) {
                searchList.add(path.getSourceEntityNumber());
            } else if (StringUtils.isNotBlank((CharSequence)path.getTargetEntityName()) && path.getTargetEntityName().indexOf(searchText) == 0) {
                searchList.add(path.getTargetEntityName());
            } else if (StringUtils.isNotBlank((CharSequence)path.getTargetEntityNumber()) && path.getTargetEntityNumber().indexOf(searchText) == 0) {
                searchList.add(path.getTargetEntityNumber());
            }
            if (searchList.size() < 10) continue;
            break;
        }
        return new ArrayList<String>(searchList);
    }

    private void doSearchByBill(String searchText) {
        List<CtConvertPath> allPaths = this.getPathCache();
        ArrayList<CtConvertPath> myPaths = new ArrayList<CtConvertPath>();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            myPaths.addAll(allPaths);
        } else {
            for (CtConvertPath path : allPaths) {
                if (!this.checkPathSourceAndTarget(path, searchText)) continue;
                myPaths.add(path);
            }
        }
        this.refreshEntryGrid(myPaths);
    }

    private boolean checkPathSourceAndTarget(CtConvertPath path, String searchText) {
        return StringUtils.isNotBlank((CharSequence)path.getSourceEntityNumber()) && path.getSourceEntityNumber().indexOf(searchText) >= 0 || StringUtils.isNotBlank((CharSequence)path.getSourceEntityName()) && path.getSourceEntityName().indexOf(searchText) >= 0 || StringUtils.isNotBlank((CharSequence)path.getTargetEntityNumber()) && path.getTargetEntityNumber().indexOf(searchText) >= 0 || StringUtils.isNotBlank((CharSequence)path.getTargetEntityName()) && path.getTargetEntityName().indexOf(searchText) >= 0;
    }

    private void doSearchByNodeId(List<CtConvertPath> allPaths) {
        this.refreshEntryGrid(allPaths);
    }

    private void refreshEntryGrid(List<CtConvertPath> paths) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(KEY_ENTRY_ENTITY);
        rows.clear();
        EntryType entryType = (EntryType)this.getModel().getDataEntityType().getAllEntities().get(KEY_ENTRY_ENTITY);
        int seq = 1;
        for (CtConvertPath path : paths) {
            DynamicObject row = new DynamicObject((DynamicObjectType)entryType);
            row.set("seq", (Object)seq);
            row.set(KEY_FSOURCE_BIZAPPNAME, (Object)path.getSourceBizAppName());
            row.set(KEY_FSOURCE_ENTITY_NUMBER, (Object)path.getSourceEntityNumber());
            row.set(KEY_FSOURCE_ENTITY_NAME, (Object)path.getSourceEntityName());
            row.set(KEY_FTARGET_BIZAPPNAME, (Object)path.getTargetBizAppName());
            row.set(KEY_FTARGET_ENTITY_NUMBER, (Object)path.getTargetEntityNumber());
            row.set(KEY_FTARGET_ENTITY_NAME, (Object)path.getTargetEntityName());
            rows.add((Object)row);
            ++seq;
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }

    private void afterShowNewForm(ClosedCallBackEvent closedCallBackEvent) {
        Map params = (Map)closedCallBackEvent.getReturnData();
        if (params == null) {
            return;
        }
        CtBotpEntityDto sourceBillDto = (CtBotpEntityDto)params.get("SourceBillDto");
        DynamicObject tenantPath = (DynamicObject)params.get("TenantPath");
        String tenantPathNumber = "";
        if (tenantPath != null) {
            tenantPathNumber = tenantPath.getString("number");
            this.getPageCache().put("tenantPathNumber", tenantPathNumber);
        }
        CtBotpEntityDto targetBillDto = (CtBotpEntityDto)params.get("TargetBillDto");
        if (StringUtils.isBlank((Object)sourceBillDto) || StringUtils.isBlank((Object)targetBillDto)) {
            return;
        }
        String sourceAppName = sourceBillDto.getBizAppIdName();
        String sourceBill = sourceBillDto.getNumber();
        String sourceBillName = sourceBillDto.getName();
        String targetAppName = targetBillDto.getBizAppIdName();
        String targetBill = targetBillDto.getNumber();
        String targetBillName = targetBillDto.getName();
        List<CtConvertPath> allPaths = this.getPathCache();
        if (!this.existPath(allPaths, sourceBillDto, targetBillDto)) {
            CtConvertPath newPath = new CtConvertPath();
            newPath.setSourceEntityNumber(sourceBill);
            newPath.setSourceEntityName(sourceBillName);
            newPath.setSourceBizAppName(sourceAppName);
            newPath.setTargetEntityNumber(targetBill);
            newPath.setTargetEntityName(targetBillName);
            newPath.setTargetBizAppName(targetAppName);
            newPath.setBizAppId(targetBillDto.getBizAppId());
            newPath.setTargetBizAppId(targetBillDto.getBizAppId());
            newPath.setSourceBizAppId(sourceBillDto.getBizAppId());
            allPaths.add(newPath);
            this.putPathCache(allPaths);
            this.getModel().createNewEntryRow(KEY_ENTRY_ENTITY);
            int rowIndex = this.getModel().getEntryRowCount(KEY_ENTRY_ENTITY) - 1;
            this.getModel().setValue(KEY_FSOURCE_BIZAPPNAME, (Object)sourceAppName, rowIndex);
            this.getModel().setValue(KEY_FSOURCE_ENTITY_NUMBER, (Object)sourceBill, rowIndex);
            this.getModel().setValue(KEY_FSOURCE_ENTITY_NAME, (Object)sourceBillName, rowIndex);
            this.getModel().setValue(KEY_FTARGET_BIZAPPNAME, (Object)targetAppName, rowIndex);
            this.getModel().setValue(KEY_FTARGET_ENTITY_NUMBER, (Object)targetBill, rowIndex);
            this.getModel().setValue(KEY_FTARGET_ENTITY_NAME, (Object)targetBillName, rowIndex);
            this.getView().updateView(KEY_ENTRY_ENTITY);
        }
        this.showRuleForm(this.getSourceInfo(sourceBillDto), this.getTargetInfo(targetBillDto));
    }

    private void showRuleForm(Map<String, String> sourceMap, Map<String, String> targetMap) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_CONVERT_RULE);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("sourceInfo", sourceMap);
        showParameter.setCustomParam("targetInfo", targetMap);
        String tenantPathNumber = this.getPageCache().get("tenantPathNumber");
        if (StringUtils.isNotBlank((CharSequence)tenantPathNumber)) {
            showParameter.setCustomParam("tenantPathNumber", (Object)tenantPathNumber);
        }
        showParameter.getCustomParams().put("checkRightAppId", this.getView().getFormShowParameter().getAppId());
        this.getView().showForm(showParameter);
    }

    private boolean existPath(List<CtConvertPath> allPaths, CtBotpEntityDto sourceBill, CtBotpEntityDto targetBill) {
        for (CtConvertPath path : allPaths) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)path.getSourceEntityNumber(), (CharSequence)sourceBill.getNumber()) || !StringUtils.equalsIgnoreCase((CharSequence)path.getTargetEntityNumber(), (CharSequence)targetBill.getNumber())) continue;
            return true;
        }
        return false;
    }

    private void putPathCache(List<CtConvertPath> paths) {
        String pathsJsonString = SerializationUtils.toJsonString(paths);
        this.getPageCache().put(CACHEID_CONVERT_PATHS, pathsJsonString);
        this.allPaths = paths;
    }

    private List<CtConvertPath> getPathCache() {
        if (this.allPaths != null) {
            return this.allPaths;
        }
        String pathsJsonString = this.getPageCache().get(CACHEID_CONVERT_PATHS);
        this.allPaths = StringUtils.isBlank((CharSequence)pathsJsonString) ? new ArrayList<CtConvertPath>() : SerializationUtils.fromJsonStringToList((String)pathsJsonString, CtConvertPath.class);
        return this.allPaths;
    }

    private void writeDeleteLog(String srcEntityNumber, String targetEntityNumber) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        MainEntityType srcMainType = null;
        MainEntityType targetMainType = null;
        try {
            srcMainType = EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
            targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntityNumber);
        }
        catch (Throwable exp) {
            log.error("\u8bfb\u53d6\u5143\u6570\u636e\u5931\u8d25,err:" + exp.getMessage());
        }
        String appNumber = srcMainType == null ? "" : srcMainType.getBizAppNumber();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                if (null != appInfo) {
                    appId = appInfo.getId();
                }
            }
            catch (KDException e) {
                log.error((Throwable)e);
            }
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID("botp_crlist");
        logInfo.setOrgID(Long.valueOf(0L));
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(ResManager.loadKDString((String)"\u5220\u9664", (String)"CtConvertPathEdit_2", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        String msg = String.format(ResManager.loadKDString((String)"\u5220\u9664\u8f6c\u6362\u8def\u7ebf\uff1a%1$s(%2$s) \u5230 %3$s(%4$s)", (String)"CtConvertPathEdit_3", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), srcMainType == null ? "" : srcMainType.getDisplayName().toString(), srcEntityNumber, targetMainType == null ? "" : targetMainType.getDisplayName().toString(), targetEntityNumber);
        logInfo.setOpDescription(msg);
        logService.addLog(logInfo);
    }

    private Map<String, String> getSourceInfo(int rowIndex) {
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put("SourceAppName", (String)this.getModel().getValue(KEY_FSOURCE_BIZAPPNAME, rowIndex));
        map.put("SourceBill", (String)this.getModel().getValue(KEY_FSOURCE_ENTITY_NUMBER, rowIndex));
        map.put("SourceBillName", (String)this.getModel().getValue(KEY_FSOURCE_ENTITY_NAME, rowIndex));
        return map;
    }

    private Map<String, String> getTargetInfo(int rowIndex) {
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("TargetAppName", (String)this.getModel().getValue(KEY_FTARGET_BIZAPPNAME, rowIndex));
        map.put("TargetBill", (String)this.getModel().getValue(KEY_FTARGET_ENTITY_NUMBER, rowIndex));
        map.put("TargetBillName", (String)this.getModel().getValue(KEY_FTARGET_ENTITY_NAME, rowIndex));
        return map;
    }

    private Map<String, String> getSourceInfo(CtBotpEntityDto sourceBillDto) {
        HashMap<String, String> map = new HashMap<String, String>(7);
        map.put("SourceAppId", sourceBillDto.getBizAppId());
        map.put("SourceAppName", sourceBillDto.getBizAppIdName());
        map.put("SourceBill", sourceBillDto.getNumber());
        map.put("SourceBillName", sourceBillDto.getName());
        return map;
    }

    private Map<String, String> getTargetInfo(CtBotpEntityDto targetBillDto) {
        HashMap<String, String> map = new HashMap<String, String>(7);
        map.put("TargetAppId", targetBillDto.getBizAppId());
        map.put("TargetAppName", targetBillDto.getBizAppIdName());
        map.put("TargetBill", targetBillDto.getNumber());
        map.put("TargetBillName", targetBillDto.getName());
        return map;
    }
}

