/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.designer.ctbotp.CtConvertRuleRightChecker;
import kd.bos.designer.ctbotp.CtFieldEventHandler;
import kd.bos.designer.ctbotp.CtGetRuleHelper;
import kd.bos.designer.ctbotp.CtLockRuleHelper;
import kd.bos.designer.ctbotp.CtRuleCacheHelper;
import kd.bos.designer.ctbotp.CtSetRuleHelper;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.CtLinkSetElement;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CheckPoint;
import kd.bos.entity.botp.CheckResult;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.CtConvertRuleElementDcBinder;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.ctbotp.CtFieldMapPolicy;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.dto.DeleteRuleDto;
import kd.bos.entity.ctbotp.dto.MainEntityTypeDto;
import kd.bos.entity.ctbotp.plugin.CtConvertRuleSetPlugInProxy;
import kd.bos.entity.ctbotp.syncdata.SyncRuleResult;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.ctbotp.CtConvertRuleMetadata;
import kd.bos.metadata.ctbotp.CtConvertRuleTemplate;
import kd.bos.metadata.ctbotp.CtRuleTreeNode;
import kd.bos.metadata.ctbotp.DesignCtConvertRuleMeta;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.service.ctbotp.utils.CtTenantPathUtils;
import kd.bos.service.metadata.MetadataLogService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.MapUtils;

public class CtConvertRuleEdit
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeClickListener,
HyperLinkClickListener {
    private static final String BOS_CTBOTP_PLUGIN = "bos-ctbotp-formplugin";
    private static final String CT_BOTP_CONVERTRULE_SYNCLOG = "ct_botp_rule_synclog";
    private static Log log = LogFactory.getLog(CtConvertRuleEdit.class);
    private CtRuleTreeNode rootRuleNode;
    private CtRuleTreeNode currRuleNode;
    private CtConvertRuleMetadata ruleMetadata;
    private CtGetRuleHelper getRuleHelper;
    private CtSetRuleHelper setRuleHelper;
    private CtLockRuleHelper lockRuleHelper;
    private CtFieldEventHandler eventHandler;
    private CtConvertRuleSetPlugInProxy ruleSetPlugInProxy;
    private Map<String, CtConvertRuleMetadata> beforeModifyRuleMap = new HashMap<String, CtConvertRuleMetadata>(16);

    private CtRuleTreeNode getRootRuleNode() {
        if (this.rootRuleNode == null) {
            this.rootRuleNode = CtRuleCacheHelper.getRootRuleNode(this);
        }
        return this.rootRuleNode;
    }

    private CtRuleTreeNode getCurrRuleNode() {
        String ruleId;
        if (this.currRuleNode == null && StringUtils.isNotBlank((CharSequence)(ruleId = (String)this.getModel().getValue("fid")))) {
            CtRuleTreeNode rootRuleNode = this.getRootRuleNode();
            this.currRuleNode = rootRuleNode.searchRule(ruleId);
        }
        return this.currRuleNode;
    }

    private CtConvertRuleMetadata getCacheRuleMetadata() {
        if (this.ruleMetadata == null) {
            CtRuleTreeNode currRuleNode = this.getCurrRuleNode();
            this.ruleMetadata = currRuleNode == null ? new CtConvertRuleMetadata() : currRuleNode.deserialize(this.getRootRuleNode());
        }
        return this.ruleMetadata;
    }

    private CtGetRuleHelper getGetRuleHelper() {
        if (this.getRuleHelper == null) {
            this.getRuleHelper = new CtGetRuleHelper(this.getView(), this);
        }
        return this.getRuleHelper;
    }

    private CtSetRuleHelper getSetRuleHelper() {
        if (this.setRuleHelper == null) {
            this.setRuleHelper = new CtSetRuleHelper(this.getView(), this);
        }
        return this.setRuleHelper;
    }

    private CtLockRuleHelper getLockRuleHelper() {
        if (this.lockRuleHelper == null) {
            this.lockRuleHelper = new CtLockRuleHelper(this.getView(), this);
        }
        return this.lockRuleHelper;
    }

    private CtFieldEventHandler getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = new CtFieldEventHandler(this.getView(), this);
        }
        return this.eventHandler;
    }

    public CtConvertRuleSetPlugInProxy getRuleSetPlugInProxy() {
        String tgtEntityNumber;
        if (this.ruleSetPlugInProxy != null) {
            return this.ruleSetPlugInProxy;
        }
        BillEntityType srcMainType = null;
        BillEntityType tgtMainType = null;
        ArrayList plugins = new ArrayList();
        String srcEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.getView());
        if (StringUtils.isNotBlank((CharSequence)srcEntityNumber)) {
            srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcEntityNumber);
            CtLinkSetElement srcLinkSet = CtConvertMetaServiceHelper.loadCtLinkSet((String)srcEntityNumber);
            if (srcLinkSet != null && srcLinkSet.getConvRulePlugIns() != null) {
                plugins.addAll(srcLinkSet.getConvRulePlugIns());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(tgtEntityNumber = CtRuleCacheHelper.getTargetEntityNumber(this.getView())))) {
            tgtMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)tgtEntityNumber);
            CtLinkSetElement tgtLinkSet = CtConvertMetaServiceHelper.loadCtLinkSet((String)tgtEntityNumber);
            if (tgtLinkSet != null && tgtLinkSet.getConvRulePlugIns() != null) {
                plugins.addAll(tgtLinkSet.getConvRulePlugIns());
            }
        }
        this.ruleSetPlugInProxy = new CtConvertRuleSetPlugInProxy(plugins);
        this.ruleSetPlugInProxy.setContext(srcMainType, tgtMainType);
        return this.ruleSetPlugInProxy;
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"tbar_main", "tbar_treeview", "tbar_billtypemap", "tbar_fieldmap", "tbar_bizrule", "tbar_plugin"});
        CtFieldEventHandler fieldEventHandler = this.getEventHandler();
        fieldEventHandler.addClickListeners();
        fieldEventHandler.addHyperLinkClickListener();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid grid = (EntryGrid)this.getView().getControl("mirrorlinkpolicy");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map sourceMap = (Map)this.getView().getFormShowParameter().getCustomParam("sourceInfo");
        Map targetMap = (Map)this.getView().getFormShowParameter().getCustomParam("targetInfo");
        String tenantPathNumber = (String)this.getView().getFormShowParameter().getCustomParam("tenantPathNumber");
        if (StringUtils.isNotBlank((CharSequence)tenantPathNumber)) {
            this.getPageCache().put("tenantPathNumber", tenantPathNumber);
        }
        Object ruleId = this.getView().getFormShowParameter().getCustomParam("ruleId");
        this.getModel().setValue("fsbizappname", sourceMap.get("SourceAppName"));
        this.getModel().setValue("fsourcebill", sourceMap.get("SourceBill"));
        this.getModel().setValue("fsourceentityname", sourceMap.get("SourceBillName"));
        this.getModel().setValue("ftbizappname", targetMap.get("TargetAppName"));
        this.getModel().setValue("ftargetbill", targetMap.get("TargetBill"));
        this.getModel().setValue("ftargetentityname", targetMap.get("TargetBillName"));
        List<CtConvertRuleMetadata> ruleMetadatas = this.loadMetas((String)sourceMap.get("SourceBill"), (String)targetMap.get("TargetBill"), true);
        CtRuleTreeNode rootRuleNode = CtRuleTreeNode.BuildRuleTree(ruleMetadatas);
        CtRuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        TreeNode rootNode = rootRuleNode.buildTreeNodes();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        for (TreeNode childNode : rootNode.getChildren()) {
            tView.addNode(childNode);
        }
        CtRuleTreeNode firstRuleNode = null;
        if (ruleId != null && StringUtils.isNotBlank((CharSequence)ruleId.toString())) {
            firstRuleNode = rootRuleNode.searchRule(ruleId.toString());
            if (firstRuleNode == null) {
                firstRuleNode = (CtRuleTreeNode)rootRuleNode.getChildren().entrySet().iterator().next().getValue();
            }
        } else {
            firstRuleNode = (CtRuleTreeNode)rootRuleNode.getChildren().entrySet().iterator().next().getValue();
        }
        CtConvertRuleMetadata ruleMetadata = firstRuleNode.deserialize(rootRuleNode);
        this.currRuleNode = firstRuleNode;
        this.ruleMetadata = ruleMetadata;
        CtConvertRuleMetadata metadata = this.getCacheRuleMetadata();
        this.setTenantInfo(tenantPathNumber, metadata.getRuleElement());
        this.setCtrlPropsValue();
        this.setRule();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setFocusRule();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        CtFieldEventHandler fieldEventHandler = this.getEventHandler();
        fieldEventHandler.Click(source.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String barItemKey = evt.getItemKey();
        if (barItemKey.equalsIgnoreCase("btnsave")) {
            this.doModify();
            this.doSaveAll();
        } else if (barItemKey.equalsIgnoreCase("btnnewrule")) {
            this.doModify();
            this.doNew();
        } else if (barItemKey.equalsIgnoreCase("tbncopy")) {
            CtConvertRuleMetadata currRuleMeta = this.doModify();
            if (currRuleMeta != null) {
                this.doCopy(currRuleMeta);
            }
        } else if (barItemKey.equalsIgnoreCase("btnext")) {
            CtConvertRuleMetadata currRuleMeta = this.doModify();
            if (currRuleMeta != null) {
                this.doExt(currRuleMeta);
            }
        } else if (barItemKey.equalsIgnoreCase("btninherit")) {
            CtConvertRuleMetadata currRuleMeta = this.doModify();
            if (currRuleMeta != null) {
                this.doInherit(currRuleMeta);
            }
        } else if (barItemKey.equalsIgnoreCase("btndelete")) {
            this.doDelete();
        } else if (barItemKey.equalsIgnoreCase("btnxml")) {
            CtConvertRuleMetadata currRuleMeta = this.doModify();
            if (currRuleMeta != null) {
                this.doShowXML();
            }
        } else if (barItemKey.equalsIgnoreCase("btnautomatchfield")) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7a0d\u7b49", (String)"CtConvertRuleEdit_17", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0])));
            CtSetRuleHelper setRuleHelper = this.getSetRuleHelper();
            boolean mirrorsync = (Boolean)this.getModel().getValue("fmirrorsync");
            try {
                setRuleHelper.autoMatchFields(mirrorsync);
            }
            finally {
                this.getView().hideLoading();
            }
        } else if (barItemKey.equalsIgnoreCase("btnsyncconvertrule")) {
            if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715a0df000000ac")) {
                this.getView().showTipNotification(this.getMultiLNoOperationPermission());
                return;
            }
            CtRuleTreeNode rootRuleNode = CtRuleCacheHelper.getRootRuleNode(this);
            this.syncConvertRule(CtRuleCacheHelper.getSourceTenant(this.getView()), CtRuleCacheHelper.getSourceDataCenter(this.getView()), CtRuleCacheHelper.getTargetTenant(this.getView()), CtRuleCacheHelper.getTargetDataCenter(this.getView()), rootRuleNode);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"CtConvertRuleEdit_13", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        } else {
            CtFieldEventHandler eventHandler = this.getEventHandler();
            eventHandler.itemClick(evt);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currRuleId = (String)this.getModel().getValue("fid");
        String nextRuleId = (String)e.getNodeId();
        if (StringUtils.isBlank((CharSequence)nextRuleId)) {
            nextRuleId = "0";
        }
        if (nextRuleId.equals("0") || nextRuleId.equals(currRuleId)) {
            return;
        }
        CtConvertRuleMetadata currRuleMeta = this.doModify();
        if (currRuleMeta != null) {
            CtConvertRuleMetadata nextRuleMeta;
            this.ruleMetadata = nextRuleMeta = CtRuleCacheHelper.getRule(this, nextRuleId);
            CtConvertRuleElement rule = nextRuleMeta.getRuleElement();
            this.getGetRuleHelper().clearManEntityTypeCache(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), false);
            this.getGetRuleHelper().clearManEntityTypeCache(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), true);
            this.setRule();
            this.setFocusRule();
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        CtFieldEventHandler eventHandler = this.getEventHandler();
        eventHandler.hyperLinkClick(e);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equalsIgnoreCase("botp_convertrulexml")) {
            this.doReceiveXML(closedCallBackEvent);
        } else {
            CtFieldEventHandler clickHandler = this.getEventHandler();
            clickHandler.closedCallBack(closedCallBackEvent.getActionId(), closedCallBackEvent.getReturnData());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        CtFieldEventHandler fieldEventHandler = this.getEventHandler();
        fieldEventHandler.propertyChanged(e);
    }

    private void doNew() {
        CtRuleTreeNode ruleTreeNode;
        CtConvertRuleMetadata newRuleMeta;
        if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "47156aff000000ac")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        String tenantPathNumber = this.getPageCache().get("tenantPathNumber");
        this.ruleMetadata = newRuleMeta = this.createBlankRule(tenantPathNumber);
        this.currRuleNode = ruleTreeNode = CtRuleCacheHelper.addRule(this, newRuleMeta);
        this.getModel().beginInit();
        CtConvertRuleElement rule = newRuleMeta.getRuleElement();
        this.getGetRuleHelper().clearManEntityTypeCache(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), false);
        this.getGetRuleHelper().clearManEntityTypeCache(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), true);
        this.setRule();
        this.getModel().endInit();
        this.getView().updateView();
        TreeNode treeNode = ruleTreeNode.buildTreeNode();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addNode(treeNode);
        this.setFocusRule();
    }

    private void doCopy(CtConvertRuleMetadata currRuleMeta) {
        CtRuleTreeNode ruleTreeNode;
        if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4730fc9f000020ae")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        currRuleMeta.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        currRuleMeta.getName().setLocaleValue_zh_CN(String.format(ResManager.loadKDString((String)"%s_\u590d\u5236", (String)"CtConvertRuleEdit_72", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), currRuleMeta.getName().getLocaleValue_zh_CN()));
        currRuleMeta.setMasterId("");
        currRuleMeta.setParentId("");
        currRuleMeta.setInheritPath("");
        currRuleMeta.setDevType("0");
        currRuleMeta.getRuleElement().setEnabled(false);
        currRuleMeta.setCreateDate(TimeServiceHelper.now());
        this.currRuleNode = ruleTreeNode = CtRuleCacheHelper.addRule(this, currRuleMeta);
        this.ruleMetadata = currRuleMeta;
        this.getModel().setValue("fid", (Object)currRuleMeta.getId());
        this.getModel().setValue("fname", (Object)currRuleMeta.getName().toString());
        this.getModel().setValue("fenabled", (Object)currRuleMeta.getRuleElement().isEnabled());
        TreeNode treeNode = ruleTreeNode.buildTreeNode();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addNode(treeNode);
        this.setFocusRule();
    }

    private void doInherit(CtConvertRuleMetadata currRuleMeta) {
        CtRuleTreeNode ruleTreeNode;
        if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "47156aff000000ac")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        String parentId = currRuleMeta.getId();
        CtConvertRuleMetadata parentRuleMeta = currRuleMeta;
        if (StringUtils.isNotBlank((CharSequence)currRuleMeta.getMasterId())) {
            parentId = currRuleMeta.getMasterId();
            parentRuleMeta = CtRuleCacheHelper.getRule(this, parentId);
        }
        if (parentRuleMeta == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u539f\u751f\u89c4\u5219\u3002", (String)"CtConvertRuleEdit_75", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        currRuleMeta.setParentId(parentId);
        currRuleMeta.setMasterId("");
        String inheritPath = parentRuleMeta.getInheritPath();
        inheritPath = StringUtils.isBlank((CharSequence)inheritPath) ? parentId : inheritPath + "," + parentId;
        currRuleMeta.setInheritPath(inheritPath);
        currRuleMeta.setDevType("1");
        currRuleMeta.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        currRuleMeta.getName().setLocaleValue_zh_CN(String.format(ResManager.loadKDString((String)"%s_\u7ee7\u627f", (String)"CtConvertRuleEdit_78", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), currRuleMeta.getName().getLocaleValue_zh_CN()));
        currRuleMeta.getRuleElement().setEnabled(false);
        currRuleMeta.setCreateDate(TimeServiceHelper.now());
        this.currRuleNode = ruleTreeNode = CtRuleCacheHelper.addRule(this, currRuleMeta);
        this.ruleMetadata = currRuleMeta;
        this.getModel().setValue("fid", (Object)currRuleMeta.getId());
        this.getModel().setValue("fname", (Object)currRuleMeta.getName().toString());
        this.getModel().setValue("fenabled", (Object)currRuleMeta.getRuleElement().isEnabled());
        TreeNode treeNode = ruleTreeNode.buildTreeNode();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addNode(treeNode);
        this.setFocusRule();
    }

    private void doExt(CtConvertRuleMetadata currRuleMeta) {
        CtRuleTreeNode ruleTreeNode;
        String inheritPath;
        if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715a0df000000ac")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        CtRuleTreeNode currRuleNode = this.getCurrRuleNode();
        int extCount = 0;
        for (CtRuleTreeNode childNode : currRuleNode.getChildren().values()) {
            if (childNode.isDeleted() || !"2".equals(childNode.getDevType())) continue;
            ++extCount;
        }
        if (extCount > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u7684\u89c4\u5219\uff0c\u5df2\u7ecf\u5b58\u5728\u4e86\u6269\u5c55\uff0c\u4e0d\u5141\u8bb8\u6269\u5c55\u591a\u6b21\u3002", (String)"CtConvertRuleEdit_66", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        currRuleMeta.setParentId(currRuleMeta.getId());
        if (StringUtils.isBlank((CharSequence)currRuleMeta.getMasterId())) {
            currRuleMeta.setMasterId(currRuleMeta.getId());
        }
        inheritPath = StringUtils.isBlank((CharSequence)(inheritPath = currRuleMeta.getInheritPath())) ? currRuleMeta.getId() : inheritPath + "," + currRuleMeta.getId();
        currRuleMeta.setInheritPath(inheritPath);
        currRuleMeta.setDevType("2");
        currRuleMeta.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        currRuleMeta.getName().setLocaleValue_zh_CN(String.format(ResManager.loadKDString((String)"%s_\u6269\u5c55", (String)"CtConvertRuleEdit_79", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), currRuleMeta.getName().getLocaleValue_zh_CN()));
        currRuleMeta.setCreateDate(TimeServiceHelper.now());
        this.currRuleNode = ruleTreeNode = CtRuleCacheHelper.addRule(this, currRuleMeta);
        this.ruleMetadata = currRuleMeta;
        this.getModel().setValue("fid", (Object)currRuleMeta.getId());
        this.getModel().setValue("fname", (Object)currRuleMeta.getName().toString());
        TreeNode treeNode = ruleTreeNode.buildTreeNode();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.addNode(treeNode);
        this.setFocusRule();
    }

    private CtConvertRuleMetadata doModify() {
        String currRuleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isBlank((CharSequence)currRuleId)) {
            return null;
        }
        CtRuleTreeNode rootRuleNode = CtRuleCacheHelper.getRootRuleNode(this);
        CtRuleTreeNode currRuleNode = rootRuleNode.searchRule(currRuleId);
        if (currRuleNode == null) {
            return null;
        }
        CtConvertRuleMetadata ruleMetadata = currRuleNode.deserialize(rootRuleNode);
        currRuleNode.setEnabled(((Boolean)this.getModel().getValue("fenabled")).booleanValue());
        currRuleNode.setChanged(true);
        if (!currRuleNode.isCanModify()) {
            CtRuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        } else {
            ruleMetadata = this.getRule(ruleMetadata);
            currRuleNode.setName(ruleMetadata.getName().toString());
            String currentIsv = ISVService.getISVInfo().getId();
            CtConvertRuleMetadata parentRuleMeta = CtRuleCacheHelper.getRule(this, ruleMetadata.getParentId());
            CtRuleTreeNode newNode = CtRuleTreeNode.buildRuleNode((CtConvertRuleMetadata)parentRuleMeta, (CtConvertRuleMetadata)ruleMetadata, (String)currentIsv);
            currRuleNode.setDesignJson(newNode.getDesignJson());
            CtRuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        }
        return ruleMetadata;
    }

    private void doDelete() {
        CtRuleTreeNode nextRuleNode;
        String currRuleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isBlank((CharSequence)currRuleId)) {
            return;
        }
        CtRuleTreeNode rootRuleNode = CtRuleCacheHelper.getRootRuleNode(this);
        CtRuleTreeNode currRuleNode = rootRuleNode.searchRule(currRuleId);
        if (currRuleNode == null) {
            return;
        }
        if (!currRuleNode.isNewed()) {
            if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715e1f1000000ac")) {
                this.getView().showTipNotification(this.getMultiLNoOperationPermission());
                return;
            }
            boolean isEnable = (Boolean)this.getModel().getValue("fenabled");
            if (isEnable) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u7684\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CtConvertRuleEdit_60", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
                return;
            }
        }
        if (!currRuleNode.isCanModify()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6240\u9009\u7684\u662f\u9884\u7f6e\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u88ab\u5220\u9664\u3002", (String)"CtConvertRuleEdit_3", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        tView.deleteNode(currRuleId);
        this.currRuleNode = nextRuleNode = CtRuleCacheHelper.deleteRule(this, currRuleId);
        this.getModel().beginInit();
        CtConvertRuleMetadata nextRuleMeta = null;
        nextRuleMeta = nextRuleNode == null ? new CtConvertRuleMetadata() : nextRuleNode.deserialize(rootRuleNode);
        this.ruleMetadata = nextRuleMeta;
        CtConvertRuleElement rule = nextRuleMeta.getRuleElement();
        this.getGetRuleHelper().clearManEntityTypeCache(rule.getSourceTenant(), rule.getSourceDataCenter(), rule.getSourceEntityNumber(), false);
        this.getGetRuleHelper().clearManEntityTypeCache(rule.getTargetTenant(), rule.getTargetDataCenter(), rule.getTargetEntityNumber(), true);
        this.setRule();
        this.getModel().endInit();
        this.getView().updateView();
        this.setFocusRule();
    }

    private void doShowXML() {
        String currRuleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isBlank((CharSequence)currRuleId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u770bXML\u7684\u8f6c\u6362\u89c4\u5219\u3002", (String)"CtConvertRuleEdit_4", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        CtRuleTreeNode rootRuleNode = CtRuleCacheHelper.getRootRuleNode(this);
        CtRuleTreeNode currNode = rootRuleNode.searchRule(currRuleId);
        if (currNode == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5728\u89c4\u5219\u6811\u4e0a\uff0c\u6ca1\u6709\u627e\u5230\u5f53\u524d\u89c4\u5219\u3002", (String)"CtConvertRuleEdit_5", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        CtRuleTreeNode parentNode = rootRuleNode.searchRule(currNode.getParentId());
        String xml = "";
        if (parentNode == null) {
            CtConvertRuleTemplate template = new CtConvertRuleTemplate();
            CtConvertRuleMetadata currRule = currNode.deserialize(rootRuleNode);
            xml = template.buildDiffXml(currRule, null, false);
        } else {
            CtConvertRuleMetadata currRule = currNode.deserialize(rootRuleNode);
            CtConvertRuleMetadata parentRule = parentNode.deserialize(rootRuleNode);
            CtConvertRuleTemplate template = new CtConvertRuleTemplate();
            xml = template.buildDiffXml(currRule, parentRule, false);
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_convertrulexml");
        showParameter.setCustomParam("xml", (Object)xml);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (!currNode.isCanModify()) {
            showParameter.setCustomParam("lock", (Object)"true");
        } else {
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "botp_convertrulexml");
            showParameter.setCloseCallBack(callBack);
        }
        this.getView().showForm(showParameter);
    }

    private void doReceiveXML(ClosedCallBackEvent closedCallBackEvent) {
        String xml = (String)closedCallBackEvent.getReturnData();
        if (StringUtils.isBlank((CharSequence)xml)) {
            return;
        }
        CtRuleTreeNode rootRuleNode = CtRuleCacheHelper.getRootRuleNode(this);
        String currRuleId = (String)this.getModel().getValue("fid");
        CtRuleTreeNode currNode = rootRuleNode.searchRule(currRuleId);
        String designJson = currNode.getDesignJson();
        DesignCtConvertRuleMeta designMeta = (DesignCtConvertRuleMeta)SerializationUtils.fromJsonString((String)designJson, DesignCtConvertRuleMeta.class);
        CtRuleTreeNode parentNode = rootRuleNode.searchRule(currNode.getParentId());
        CtConvertRuleTemplate template = new CtConvertRuleTemplate();
        CtConvertRuleMetadata xmlRule = null;
        CtConvertRuleMetadata parentRule = null;
        if (parentNode == null) {
            xmlRule = template.getMetadata(xml, null);
        } else {
            parentRule = parentNode.deserialize(rootRuleNode);
            xmlRule = template.getMetadata(xml, parentRule);
            parentRule = parentNode.deserialize(rootRuleNode);
        }
        xmlRule.convertFromDesignMeta((DesignMeta)designMeta);
        String diffXml = template.buildDiffXml(xmlRule, parentRule, false);
        designMeta.setDataXml(diffXml);
        designJson = SerializationUtils.toJsonString((Object)designMeta);
        currNode.setDesignJson(designJson);
        currNode.setChanged(true);
        CtRuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        this.getModel().beginInit();
        CtSetRuleHelper helper = new CtSetRuleHelper(this.getView(), this);
        helper.setRule(xmlRule.getRuleElement());
        this.getModel().endInit();
        this.getModel().setValue("isv_tag", (Object)xmlRule.getIsv());
        this.getView().updateView();
    }

    private void doSaveAll() {
        if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715a0df000000ac")) {
            this.getView().showTipNotification(this.getMultiLNoOperationPermission());
            return;
        }
        String sourceBill = CtRuleCacheHelper.getSourceEntityNumber(this.getView());
        String sourceTenant = CtRuleCacheHelper.getSourceTenant(this.getView());
        String sourceDataCenter = CtRuleCacheHelper.getSourceDataCenter(this.getView());
        String targetBill = CtRuleCacheHelper.getTargetEntityNumber(this.getView());
        String targetTenant = CtRuleCacheHelper.getTargetTenant(this.getView());
        String targetDataCenter = CtRuleCacheHelper.getTargetDataCenter(this.getView());
        if (StringUtils.isBlank((CharSequence)sourceBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u6ca1\u6709\u786e\u5b9a\u6e90\u5355\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"CtConvertRuleEdit_8", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)targetBill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u5219\u6ca1\u6709\u786e\u5b9a\u76ee\u6807\u5355\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"CtConvertRuleEdit_9", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return;
        }
        CtRuleTreeNode rootRuleNode = CtRuleCacheHelper.getRootRuleNode(this);
        List ruleNodes = rootRuleNode.mergeAllChildren();
        ArrayList<CtConvertRuleMetadata> addList = new ArrayList<CtConvertRuleMetadata>();
        ArrayList<CtConvertRuleMetadata> modifyList = new ArrayList<CtConvertRuleMetadata>();
        ArrayList<CtConvertRuleMetadata> delList = new ArrayList<CtConvertRuleMetadata>();
        ArrayList<String> delRuleIds = new ArrayList<String>();
        for (CtRuleTreeNode ruleNode : ruleNodes) {
            CtConvertRuleMetadata ruleMetadata = ruleNode.deserialize(rootRuleNode);
            ruleMetadata.getRuleElement().setEnabled(ruleNode.isEnabled());
            if (ruleNode.isDeleted()) {
                if (ruleNode.isNewed()) continue;
                delRuleIds.add(ruleNode.getId());
                delList.add(ruleMetadata);
                continue;
            }
            if (ruleNode.isNewed()) {
                addList.add(ruleMetadata);
            } else if (ruleNode.isChanged()) {
                modifyList.add(ruleMetadata);
                if (ruleNode.isCanModify()) {
                    ruleMetadata.setModifierId(String.valueOf(RequestContext.get().getCurrUserId()));
                    ruleMetadata.setModifyDate(TimeServiceHelper.now());
                }
            }
            if (StringUtils.equals((CharSequence)ruleNode.getDevType(), (CharSequence)"2")) continue;
        }
        ArrayList<CtConvertRuleMetadata> allSaveList = new ArrayList<CtConvertRuleMetadata>();
        allSaveList.addAll(modifyList);
        allSaveList.addAll(addList);
        CheckResult checkResult = new CheckResult();
        if (!this.checkRule(allSaveList)) {
            return;
        }
        for (CtConvertRuleMetadata convertRuleMetadata : modifyList) {
            String tenantPath = convertRuleMetadata.getRuleElement().getTenantPath();
            this.beforeModifyRuleMap.put(convertRuleMetadata.getId(), CtConvertMetaServiceHelper.loadMeta((String)convertRuleMetadata.getId(), (boolean)false));
            convertRuleMetadata.getRuleElement().setTenantPath(tenantPath);
        }
        for (CtConvertRuleMetadata ruleMetadata : modifyList) {
            CtConvertMetaServiceHelper.save((CtConvertRuleMetadata)ruleMetadata);
        }
        if (!modifyList.isEmpty()) {
            this.writeSaveLog(modifyList, true);
        }
        for (CtConvertRuleMetadata ruleMetadata : addList) {
            CtConvertMetaServiceHelper.save((CtConvertRuleMetadata)ruleMetadata);
        }
        if (!addList.isEmpty()) {
            this.writeSaveLog(addList, false);
        }
        if (delRuleIds.size() > 0) {
            boolean flag;
            boolean flag2;
            int i;
            CtConvertMetaServiceHelper.delete((String[])delRuleIds.toArray(new String[delRuleIds.size()]));
            for (i = 0; i < 10 && !(flag2 = this.deleteConvertRules(sourceTenant, sourceDataCenter, delRuleIds)); ++i) {
            }
            for (i = 0; i < 10 && !(flag = this.deleteConvertRules(targetTenant, targetDataCenter, delRuleIds)); ++i) {
            }
            this.writeDeleteLog(delList);
        }
        List<CtConvertRuleMetadata> ruleMetas = this.loadMetas(sourceBill, targetBill, false);
        rootRuleNode = CtRuleTreeNode.BuildRuleTree(ruleMetas);
        CtRuleCacheHelper.putRootRuleNode(this, rootRuleNode);
        TreeNode rootTreeNode = rootRuleNode.buildTreeNodes();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        for (TreeNode childTreeNode : rootTreeNode.getChildren()) {
            tView.updateNode(childTreeNode);
        }
        this.syncConvertRule(sourceTenant, sourceDataCenter, targetTenant, targetDataCenter, rootRuleNode);
        String ruleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            TreeNode currNode = new TreeNode();
            currNode.setId(ruleId);
            tView.focusNode(currNode);
        }
        this.getGetRuleHelper().clearManEntityTypeCache(sourceTenant, sourceDataCenter, sourceBill, false);
        this.getGetRuleHelper().clearManEntityTypeCache(targetTenant, targetDataCenter, targetBill, true);
        this.setRule();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CtConvertRuleEdit_10", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
    }

    private boolean checkRule(List<CtConvertRuleMetadata> allSaveList) {
        for (CtConvertRuleMetadata ruleMetadata : allSaveList) {
            boolean checkRusult;
            if (!ruleMetadata.getRuleElement().isEnabled()) continue;
            CtConvertRuleElement ruleElement = ruleMetadata.getRuleElement();
            CtFieldMapPolicy ctFieldMapPolicy = ruleElement.getCtFieldMapPolicy();
            List ctFieldMapItems = ctFieldMapPolicy.getCtFieldMapItems();
            HashMap<String, Boolean> hasEntryFieldForSubEntry = new HashMap<String, Boolean>();
            for (CtFieldMapItem ctFieldMapItem : ctFieldMapItems) {
                String entryEntityKey;
                if (ctFieldMapItem == null || !ctFieldMapItem.isValid()) continue;
                String targetEntityKeys = ctFieldMapItem.getTargetEntityKeys();
                String[] entityArr = targetEntityKeys.split("\\|");
                if (entityArr.length == 2) {
                    hasEntryFieldForSubEntry.put(targetEntityKeys, true);
                    continue;
                }
                if (entityArr.length != 3 || hasEntryFieldForSubEntry.containsKey(entryEntityKey = targetEntityKeys.substring(0, targetEntityKeys.lastIndexOf("|")))) continue;
                hasEntryFieldForSubEntry.put(entryEntityKey, false);
            }
            if (!MapUtils.isNotEmpty(hasEntryFieldForSubEntry) || (checkRusult = hasEntryFieldForSubEntry.values().stream().allMatch(hasEntryField -> hasEntryField))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u53ea\u914d\u7f6e\u5b50\u5355\u636e\u4f53\u5b57\u6bb5\u6620\u5c04\uff0c\u8bf7\u914d\u7f6e\u6539\u5b50\u5355\u636e\u4f53\u7684\u4e0a\u7ea7\u5355\u636e\u4f53\u5b57\u6bb5\u6620\u5c04\u3002", (String)"CtConvertRuleEdit_83", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean doCheck(MainEntityTypeDto srcMainTypeDto, MainEntityTypeDto tgtMainTypeDto, List<CtConvertRuleMetadata> ruleMetadatas, CheckResult checkResult) {
        CheckPoint checkPoint = new CheckPoint(null, "");
        for (CtConvertRuleMetadata ruleMetadata : ruleMetadatas) {
            if (!ruleMetadata.getRuleElement().isEnabled()) continue;
            ruleMetadata.getRuleElement().check(srcMainTypeDto, tgtMainTypeDto, checkPoint, checkResult);
            this.check(ruleMetadata.getRuleElement(), checkPoint, checkResult);
        }
        return checkResult.isPass();
    }

    private void doShowCheckResult(CheckResult checkResult) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_rulecheckreport");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u89c4\u5219\u542f\u7528\u68c0\u67e5\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"CtConvertRuleEdit_11", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        String json = SerializationUtils.toJsonString((Object)checkResult);
        showParameter.setCustomParam("checkresult", (Object)json);
        this.getView().showForm(showParameter);
    }

    private List<CtConvertRuleMetadata> loadMetas(String sourceBill, String targetBill, boolean autoCreateNew) {
        List ruleMetas = CtConvertMetaServiceHelper.loadMetas((String)sourceBill, (String)targetBill);
        if (ruleMetas.isEmpty() && autoCreateNew) {
            String tenantPathNumber = this.getPageCache().get("tenantPathNumber");
            CtConvertRuleMetadata newRuleMeta = this.createBlankRule(tenantPathNumber);
            String currentIsv = ISVService.getISVInfo().getId();
            newRuleMeta.setIsv(currentIsv);
            if (StringUtils.isNotBlank((CharSequence)sourceBill) && StringUtils.isNotBlank((CharSequence)targetBill)) {
                CtConvertMetaServiceHelper.save((CtConvertRuleMetadata)newRuleMeta);
            }
            ruleMetas.add(newRuleMeta);
        }
        return ruleMetas;
    }

    private CtConvertRuleMetadata createBlankRule(String tenantPathNumber) {
        Map sourceMap = (Map)this.getView().getFormShowParameter().getCustomParam("sourceInfo");
        Map targetMap = (Map)this.getView().getFormShowParameter().getCustomParam("targetInfo");
        CtConvertRuleTemplate template = new CtConvertRuleTemplate();
        CtConvertRuleMetadata newRuleMeta = template.CreateBlankRule();
        newRuleMeta.getRuleElement().setTenantPath(tenantPathNumber);
        newRuleMeta.getRuleElement().setSourceEntityNumber((String)sourceMap.get("SourceBill"));
        newRuleMeta.getRuleElement().setSourceTenant((String)sourceMap.get("SourceTenant"));
        newRuleMeta.getRuleElement().setSourceDataCenter((String)sourceMap.get("SourceDataCenter"));
        newRuleMeta.getRuleElement().setsBizAppId((String)sourceMap.get("SourceAppId"));
        newRuleMeta.getRuleElement().setsBizAppName(new LocaleString((String)sourceMap.get("SourceAppName")));
        newRuleMeta.getRuleElement().setSourceEntityName(new LocaleString((String)sourceMap.get("SourceBillName")));
        newRuleMeta.getRuleElement().setSourceAccountNumber((String)sourceMap.get("SourceAccountNumber"));
        newRuleMeta.getRuleElement().setTargetEntityNumber((String)targetMap.get("TargetBill"));
        newRuleMeta.getRuleElement().setTargetTenant((String)targetMap.get("TargetTenant"));
        newRuleMeta.getRuleElement().setTargetDataCenter((String)targetMap.get("TargetDataCenter"));
        newRuleMeta.getRuleElement().settBizAppId((String)targetMap.get("TargetAppId"));
        newRuleMeta.getRuleElement().settBizAppName(new LocaleString((String)targetMap.get("TargetAppName")));
        newRuleMeta.getRuleElement().setTargetEntityName(new LocaleString((String)targetMap.get("TargetBillName")));
        newRuleMeta.getRuleElement().setTargetAccountNumber((String)targetMap.get("TargetAccountNumber"));
        this.setTenantInfo(tenantPathNumber, newRuleMeta.getRuleElement());
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)targetMap.get("TargetBill")))) {
            newRuleMeta.getRuleElement().getCtLinkEntityPolicy().setTargetEntryKey((String)targetMap.get("TargetBill"));
            newRuleMeta.getRuleElement().getCtLinkEntityPolicy().setTargetEntityKeys("billhead");
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)sourceMap.get("SourceBill")))) {
            newRuleMeta.getRuleElement().getCtLinkEntityPolicy().setSourceEntryKey((String)sourceMap.get("SourceBill"));
            newRuleMeta.getRuleElement().getCtLinkEntityPolicy().setSourceEntityKeys("billhead");
        }
        return newRuleMeta;
    }

    private CtConvertRuleMetadata getRule(CtConvertRuleMetadata ruleMetadata) {
        CtConvertRuleElement rule = ruleMetadata.getRuleElement();
        CtGetRuleHelper helper = this.getGetRuleHelper();
        rule = helper.getRule(rule);
        return ruleMetadata;
    }

    private void setRule() {
        CtConvertRuleMetadata ruleMetadata = this.getCacheRuleMetadata();
        CtConvertRuleElement ruleElement = ruleMetadata.getRuleElement();
        if (StringUtils.isBlank((CharSequence)ruleElement.getTenantPath())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a:%s\u7684\u89c4\u5219\u672a\u7ed1\u5b9a\u79df\u6237\u8def\u7ebf\u3002", (String)"CtConvertRuleEdit_59", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), ruleElement.getId()));
        }
        this.getPageCache().put("tenantPathNumber", ruleElement.getTenantPath());
        DynamicObject tenantPath = CtTenantPathUtils.getTenantPath((String)ruleElement.getTenantPath());
        if (tenantPath == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u6237\u8def\u7ebf\u7f16\u7801:%s\u4e0d\u5b58\u5728\u3002", (String)"CtConvertRuleEdit_84", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), ruleElement.getTenantPath()));
        }
        this.getModel().setValue("tenantpath", tenantPath.getPkValue());
        DynamicObject sourceTenant = (DynamicObject)tenantPath.get("sourcetenant");
        this.getModel().setValue("fsourcetenant", (Object)sourceTenant.getString("tenantid"));
        this.getModel().setValue("fsourceaccountnumber", (Object)sourceTenant.getString("accountnumber"));
        ruleElement.setSourceTenant(sourceTenant.getString("tenantid"));
        ruleElement.setSourceDataCenter(sourceTenant.getString("accountid"));
        ruleElement.setSourceAccountNumber(sourceTenant.getString("accountnumber"));
        DynamicObject targetTenant = (DynamicObject)tenantPath.get("targettenant");
        this.getModel().setValue("ftargettenant", (Object)targetTenant.getString("tenantid"));
        this.getModel().setValue("ftargetaccountnumber", (Object)targetTenant.getString("accountnumber"));
        ruleElement.setTargetTenant(targetTenant.getString("tenantid"));
        ruleElement.setTargetDataCenter(targetTenant.getString("accountid"));
        ruleElement.setTargetAccountNumber(targetTenant.getString("accountnumber"));
        this.getModel().setValue("isv_tag", (Object)ruleMetadata.getIsv());
        CtSetRuleHelper setRuleHelper = this.getSetRuleHelper();
        if (ruleElement.getId() != null) {
            setRuleHelper.setRule(ruleElement);
        }
    }

    private void setFocusRule() {
        CtRuleTreeNode currRuleNode = this.getCurrRuleNode();
        CtConvertRuleMetadata ruleMetadata = this.getCacheRuleMetadata();
        TreeView tView = (TreeView)this.getView().getControl("tv_rules");
        String ruleId = (String)this.getModel().getValue("fid");
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            TreeNode currNode = new TreeNode();
            currNode.setId(ruleId);
            tView.focusNode(currNode);
        }
        CtLockRuleHelper lockRuleHelper = this.getLockRuleHelper();
        if (currRuleNode == null) {
            lockRuleHelper.lockRule(true);
            lockRuleHelper.setLabelIsvVisiable(false);
        } else {
            lockRuleHelper.lockRule(!currRuleNode.isCanModify());
            lockRuleHelper.setLabelIsvVisiable(!currRuleNode.isCanModify());
        }
    }

    private void setTenantInfo(String tenantPathNumber, CtConvertRuleElement ruleElement) {
        DynamicObject tenantPath;
        if (StringUtils.isBlank((CharSequence)tenantPathNumber)) {
            tenantPathNumber = ruleElement.getTenantPath();
        }
        if (StringUtils.isNotBlank((CharSequence)tenantPathNumber)) {
            tenantPath = CtTenantPathUtils.getTenantPath((String)tenantPathNumber);
            if (tenantPath == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79df\u6237\u8def\u7ebf\u7f16\u7801:%s\u4e0d\u5b58\u5728\u3002", (String)"CtConvertRuleEdit_84", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), tenantPathNumber));
            }
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u4e3a:%s\u7684\u89c4\u5219\u672a\u7ed1\u5b9a\u79df\u6237\u8def\u7ebf\u3002", (String)"CtConvertRuleEdit_59", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), ruleElement.getId()));
        }
        DynamicObject sourceTenant = (DynamicObject)tenantPath.get("sourcetenant");
        String sourceTenantCode = sourceTenant.getString("tenantid");
        String sourceAccountId = sourceTenant.getString("accountid");
        String sourceAccountNumber = sourceTenant.getString("accountnumber");
        ruleElement.setSourceTenant(sourceTenantCode);
        ruleElement.setSourceDataCenter(sourceAccountId);
        ruleElement.setSourceAccountNumber(sourceAccountNumber);
        this.getModel().setValue("fsourcetenant", (Object)sourceTenantCode);
        this.getModel().setValue("fsourceaccountnumber", (Object)sourceAccountNumber);
        this.getPageCache().put("SourceTenant", sourceTenantCode);
        this.getPageCache().put("SourceDataCenter", sourceAccountId);
        DynamicObject targetTenant = (DynamicObject)tenantPath.get("targettenant");
        String targetTenantCode = targetTenant.getString("tenantid");
        String targetAccountId = targetTenant.getString("accountid");
        String targetAccountNumber = sourceTenant.getString("accountnumber");
        ruleElement.setTargetTenant(targetTenantCode);
        ruleElement.setTargetDataCenter(targetAccountId);
        ruleElement.setTargetAccountNumber(targetAccountNumber);
        this.getModel().setValue("ftargettenant", (Object)targetTenantCode);
        this.getModel().setValue("ftargetaccountnumber", (Object)targetAccountNumber);
        this.getPageCache().put("TargetTenant", targetTenantCode);
        this.getPageCache().put("TargetDataCenter", targetAccountId);
    }

    private void setCtrlPropsValue() {
        if (StringUtils.isBlank((CharSequence)CtRuleCacheHelper.getSourceEntityNumber(this.getView())) || StringUtils.isBlank((CharSequence)CtRuleCacheHelper.getTargetEntityNumber(this.getView()))) {
            return;
        }
        CtSetRuleHelper helper = this.getSetRuleHelper();
        CtConvertRuleMetadata ruleMetadata = this.getCacheRuleMetadata();
        CtConvertRuleElement ruleElement = ruleMetadata.getRuleElement();
        helper.fillLinkEntityCombo(ruleElement);
    }

    private void writeSaveLog(List<CtConvertRuleMetadata> rules, boolean isNeedInit) {
        String opName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"CtConvertRuleEdit_64", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]);
        this.writeLog(rules, opName);
        StringBuilder remarkBuilder = new StringBuilder(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219", (String)"CtConvertRuleEdit_70", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        if (isNeedInit) {
            remarkBuilder.append(ResManager.loadKDString((String)"_\u4fee\u6539", (String)"CtConvertRuleEdit_71", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        }
        this.writeMetadataLog(rules, MetaLogType.BotpSave.getValue(), isNeedInit, remarkBuilder.toString());
    }

    private void writeDeleteLog(List<CtConvertRuleMetadata> rules) {
        String opName = ResManager.loadKDString((String)"\u5220\u9664", (String)"CtConvertRuleEdit_62", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]);
        this.writeLog(rules, opName);
    }

    private void writeLog(List<CtConvertRuleMetadata> rules, String opName) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(10);
        CtGetRuleHelper getRuleHelper = this.getGetRuleHelper();
        MainEntityTypeDto srcMainTypeDto = getRuleHelper.getMainEntityTypeFromCache(rules.get(0).getRuleElement().getSourceTenant(), rules.get(0).getRuleElement().getSourceDataCenter(), rules.get(0).getRuleElement().getSourceEntityNumber(), false);
        MainEntityTypeDto targetMainTypeDto = getRuleHelper.getMainEntityTypeFromCache(rules.get(0).getRuleElement().getTargetTenant(), rules.get(0).getRuleElement().getTargetDataCenter(), rules.get(0).getRuleElement().getTargetEntityNumber(), true);
        for (CtConvertRuleMetadata ruleMetadata : rules) {
            AppLogInfo logInfo = new AppLogInfo();
            logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
            String appNumber = srcMainTypeDto == null ? "" : srcMainTypeDto.getBizAppNumber();
            String appId = " ";
            if (StringUtils.isNotEmpty((CharSequence)appNumber)) {
                try {
                    AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                    if (null != appInfo) {
                        appId = appInfo.getId();
                    }
                }
                catch (KDException e) {
                    log.error((Throwable)e);
                }
            }
            logInfo.setBizAppID(appId);
            logInfo.setBizObjID("botp_crlist");
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
            logInfo.setOpTime(TimeServiceHelper.now());
            logInfo.setClientType(RequestContext.get().getClient());
            logInfo.setClientIP(RequestContext.get().getLoginIP());
            logInfo.setOpName(opName);
            String msg = String.format(ResManager.loadKDString((String)"%1$s -> %2$s\uff1a%3$s(%4$s)\uff0c%5$s\u6210\u529f", (String)"CtConvertRuleEdit_80", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), srcMainTypeDto == null ? "" : srcMainTypeDto.getDisplayName(), targetMainTypeDto == null ? "" : targetMainTypeDto.getDisplayName(), ruleMetadata.getRuleElement().getName().toString(), ruleMetadata.getId(), opName);
            logInfo.setOpDescription(msg);
            appLogInfoList.add(logInfo);
        }
        logService.addBatchLog(appLogInfoList);
    }

    private void writeMetadataLog(List<CtConvertRuleMetadata> rules, int metaLogType, boolean isNeedInit, String remark) {
        MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        long[] globalLongIds = new long[]{};
        if (!rules.isEmpty()) {
            globalLongIds = DB.genGlobalLongIds((int)rules.size());
        }
        for (int i = 0; i < rules.size(); ++i) {
            CtConvertRuleMetadata rule = rules.get(i);
            long logId = globalLongIds[i];
            String metaId = rule.getId();
            String metaNumber = rule.getRuleElement().getSourceEntityNumber() + "-" + rule.getRuleElement().getTargetEntityNumber();
            if (isNeedInit && CollectionUtils.isEmpty((Collection)logService.queryMetaIds(Stream.of(metaId).collect(Collectors.toList())))) {
                CtConvertRuleTemplate template = new CtConvertRuleTemplate();
                String sourceXmlData = template.buildDiffXml(this.beforeModifyRuleMap.get(rule.getId()), null, false);
                long initLogId = DB.genGlobalLongId();
                logService.addBotpMetaLog(metaId, metaNumber, sourceXmlData, (int)MetaLogType.BotpInit.getValue(), initLogId, rule.getBizappId(), remark);
            }
            String remarkDesc = remark;
            if (!isNeedInit) {
                String remarkSuffix = ResManager.loadKDString((String)"_\u65b0\u589e", (String)"CtConvertRuleEdit_67", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]);
                if ("1".equals(rule.getDevType())) {
                    remarkSuffix = ResManager.loadKDString((String)"_\u7ee7\u627f", (String)"CtConvertRuleEdit_61", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]);
                } else if ("2".equals(rule.getDevType())) {
                    remarkSuffix = ResManager.loadKDString((String)"_\u6269\u5c55", (String)"CtConvertRuleEdit_69", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]);
                }
                remarkDesc = remark + remarkSuffix;
            }
            logService.addBotpMetaLog(metaId, metaNumber, this.getRuleXml(rule.getId()), metaLogType, logId, rule.getBizappId(), remarkDesc);
        }
    }

    private String getRuleXml(String ruleId) {
        CtRuleTreeNode rootRuleNode = CtRuleCacheHelper.getRootRuleNode(this);
        CtRuleTreeNode currNode = rootRuleNode.searchRule(ruleId);
        String xml = "";
        if (currNode != null) {
            CtConvertRuleTemplate template = new CtConvertRuleTemplate();
            CtConvertRuleMetadata currRule = currNode.deserialize(rootRuleNode);
            xml = template.buildDiffXml(currRule, null, false);
        }
        return xml;
    }

    private String getMultiLNoOperationPermission() {
        return ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650!", (String)"CtConvertRuleEdit_74", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]);
    }

    public void check(CtConvertRuleElement rule, CheckPoint parentPoint, CheckResult checkResult) {
        CheckPoint checkPoint = new CheckPoint(parentPoint, ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04", (String)"CtFieldMapPolicy_0", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        for (CtFieldMapItem item : rule.getCtFieldMapPolicy().getCtFieldMapItems()) {
            this.itemCheck(rule, item, checkPoint, checkResult);
        }
    }

    public void itemCheck(CtConvertRuleElement rule, CtFieldMapItem item, CheckPoint parentPoint, CheckResult checkResult) {
        if (StringUtils.isBlank((CharSequence)item.getTargetFieldKey())) {
            return;
        }
    }

    private void addErrorMessage(CheckPoint checkPoint, CheckResult checkResult, String errMessage) {
        checkResult.addErrorMessage(checkPoint, errMessage);
    }

    private void syncConvertRule(String sourceTenant, String sourceAccountId, String targetTenant, String targetAccountId, CtRuleTreeNode rootRuleNode) {
        Set<Long> verIds = this.addSyncRuleRecord(rootRuleNode);
        SyncRuleResult result = this.syncTargetConvertRule(targetTenant, targetAccountId, rootRuleNode, verIds);
        if (result.isSuccess()) {
            this.syncSourceConvertRule(sourceTenant, sourceAccountId, rootRuleNode, verIds);
        }
    }

    private void syncSourceConvertRule(String sourceTenant, String sourceAccountId, CtRuleTreeNode ctRuleTreeNode, Set<Long> verIds) {
        try {
            String result = CtBotpApiUtils.post((String)sourceTenant, (String)sourceAccountId, (CtApiUrlEnum)CtApiUrlEnum.SYNCRULE, (String)SerializationUtils.toJsonString((Object)ctRuleTreeNode));
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            String json = SerializationUtils.toJsonString(openApiResult.get("data"));
            SyncRuleResult syncResult = (SyncRuleResult)SerializationUtils.fromJsonString((String)json, SyncRuleResult.class);
            if (syncResult.isSuccess()) {
                Set list = syncResult.getVerIds();
                verIds.removeAll(list);
                this.updateSyncLogStatus(list, "S", "sourcestatus");
            }
            if (verIds.size() > 0) {
                this.updateSyncLogStatus(verIds, "F", "sourcestatus");
            }
        }
        catch (Exception e) {
            if (verIds.size() > 0) {
                this.updateSyncLogStatus(verIds, "F", "sourcestatus");
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u4e0a\u6e38\u8f6c\u6362\u89c4\u5219\u5931\u8d25\u3002", (String)"CtConvertRuleEdit_14", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        }
    }

    private SyncRuleResult syncTargetConvertRule(String targetTenant, String targetAccountId, CtRuleTreeNode ctRuleTreeNode, Set<Long> verIds) {
        SyncRuleResult syncResult;
        try {
            String result = CtBotpApiUtils.post((String)targetTenant, (String)targetAccountId, (CtApiUrlEnum)CtApiUrlEnum.SYNCRULE, (String)SerializationUtils.toJsonString((Object)ctRuleTreeNode));
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            String json = SerializationUtils.toJsonString(openApiResult.get("data"));
            syncResult = (SyncRuleResult)SerializationUtils.fromJsonString((String)json, SyncRuleResult.class);
            if (syncResult.isSuccess()) {
                Set list = syncResult.getVerIds();
                verIds.removeAll(list);
                this.updateSyncLogStatus(list, "S", "targetstatus");
            }
            if (verIds.size() > 0) {
                this.updateSyncLogStatus(verIds, "F", "targetstatus");
            }
        }
        catch (Exception e) {
            if (verIds.size() > 0) {
                this.updateSyncLogStatus(verIds, "F", "targetstatus");
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u540c\u6b65\u4e0b\u6e38\u7cfb\u7edf\u8f6c\u6362\u89c4\u5219\u5931\u8d25\u3002", (String)"CtConvertRuleEdit_18", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        }
        return syncResult;
    }

    private boolean deleteConvertRules(String tenant, String accountId, List<String> ruleIds) {
        boolean flag = false;
        try {
            DeleteRuleDto deleteRuleDto = new DeleteRuleDto();
            deleteRuleDto.setDelRuleIds(ruleIds);
            String result = CtBotpApiUtils.post((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.DELETERULES, (String)SerializationUtils.toJsonString((Object)deleteRuleDto));
            if (StringUtils.isNotBlank((CharSequence)result)) {
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                if (!Boolean.parseBoolean(openApiResult.get("status").toString()) || !openApiResult.get("errorCode").equals("0")) {
                    log.info(result);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u79df\u6237%s\u7cfb\u7edf\u8f6c\u6362\u89c4\u5219\u5931\u8d25\u3002", (String)"CtConvertRuleEdit_58", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), tenant + ":" + accountId));
                }
            } else {
                log.error("result is blank");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u79df\u6237%s\u7cfb\u7edf\u8f6c\u6362\u89c4\u5219\u5931\u8d25\u3002", (String)"CtConvertRuleEdit_58", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), tenant + ":" + accountId));
            }
            log.info("success deleted ruleids:" + SerializationUtils.toJsonString(ruleIds));
            flag = true;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u79df\u6237%s\u7cfb\u7edf\u8f6c\u6362\u89c4\u5219\u5931\u8d25\u3002", (String)"CtConvertRuleEdit_58", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), tenant + ":" + accountId));
        }
        return flag;
    }

    private Set<Long> addSyncRuleRecord(CtRuleTreeNode rootRuleNode) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)CT_BOTP_CONVERTRULE_SYNCLOG);
        MainEntityType subEntityType = (MainEntityType)mainEntityType.getSubEntityType(Arrays.asList("id", "updatetime", "modifier"));
        List ruleNodes = rootRuleNode.mergeAllChildren();
        HashSet<Long> set = new HashSet<Long>(ruleNodes.size());
        DcJsonSerializer convertRuleSerializer = CtConvertRuleEdit.getCtConvertRuleSerializer();
        HashMap<Long, DynamicObject> convertRuleSyncLogs = new HashMap<Long, DynamicObject>(ruleNodes.size());
        for (CtRuleTreeNode ruleNode : ruleNodes) {
            CtConvertRuleMetadata ruleMeta = ruleNode.deserialize(rootRuleNode);
            DynamicObject syncLog = new DynamicObject((DynamicObjectType)mainEntityType);
            if (ruleMeta.getDevType().equals("2")) {
                mainEntityType.getPrimaryKey().setValueFast((Object)syncLog, (Object)ruleMeta.getRuleElement().getExtVerId());
            } else {
                mainEntityType.getPrimaryKey().setValueFast((Object)syncLog, (Object)ruleMeta.getRuleElement().getCurrentVerId());
            }
            syncLog.set("sourcetenant", (Object)ruleMeta.getRuleElement().getSourceTenant());
            syncLog.set("sourcedatacenter", (Object)ruleMeta.getRuleElement().getSourceDataCenter());
            syncLog.set("sourcenumber", (Object)ruleMeta.getRuleElement().getSourceEntityNumber());
            syncLog.set("targettenant", (Object)ruleMeta.getRuleElement().getTargetTenant());
            syncLog.set("targetdatacenter", (Object)ruleMeta.getRuleElement().getTargetDataCenter());
            syncLog.set("targetnumber", (Object)ruleMeta.getRuleElement().getTargetEntityNumber());
            syncLog.set("sourcestatus", (Object)Character.valueOf('A'));
            syncLog.set("targetstatus", (Object)Character.valueOf('A'));
            syncLog.set("ruleid", (Object)ruleMeta.getRuleElement().getId());
            syncLog.set("synccontent_tag", (Object)convertRuleSerializer.serializeToString((Object)ruleMeta, null));
            syncLog.set("createtime", (Object)new Date());
            syncLog.set("creater", (Object)RequestContext.get().getCurrUserId());
            convertRuleSyncLogs.put((Long)syncLog.getPkValue(), syncLog);
        }
        set.addAll(convertRuleSyncLogs.keySet());
        Map existMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)subEntityType, (QFilter[])new QFilter[]{new QFilter("id", "in", convertRuleSyncLogs.keySet())});
        if (existMap != null && !existMap.isEmpty()) {
            DynamicObject[] oldExists;
            for (DynamicObject oldExist : oldExists = existMap.values().toArray(new DynamicObject[0])) {
                oldExist.set("updatetime", (Object)new Date());
                oldExist.set("modifier", (Object)RequestContext.get().getCurrUserId());
                convertRuleSyncLogs.remove((Long)oldExist.getPkValue());
            }
            SaveServiceHelper.update((DynamicObject[])oldExists);
        }
        SaveServiceHelper.save((DynamicObject[])convertRuleSyncLogs.values().toArray(new DynamicObject[0]));
        return set;
    }

    private void updateSyncLogStatus(Set<Long> ids, String status, String statusField) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)CT_BOTP_CONVERTRULE_SYNCLOG);
        MainEntityType subEntityType = (MainEntityType)mainEntityType.getSubEntityType(Arrays.asList("id", statusField, "updatetime", "modifier"));
        Map existMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)subEntityType, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (existMap != null && !existMap.isEmpty()) {
            DynamicObject[] oldExists;
            for (DynamicObject oldExist : oldExists = existMap.values().toArray(new DynamicObject[0])) {
                if (oldExist.getString(statusField).equals("S")) continue;
                oldExist.set("updatetime", (Object)new Date());
                oldExist.set(statusField, (Object)status);
                oldExist.set("modifier", (Object)RequestContext.get().getCurrUserId());
            }
            SaveServiceHelper.update((DynamicObject[])oldExists);
        }
    }

    private static DcJsonSerializer getCtConvertRuleSerializer() {
        CtConvertRuleElementDcBinder binder = new CtConvertRuleElementDcBinder();
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)binder);
        serializer.setIsLocaleValueFull(true);
        return serializer;
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("mirrorlinkpolicy");
        for (DynamicObject row : rows) {
            row.set("mirrorlinkentity", (Object)false);
        }
        this.getView().updateView();
    }
}

