/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.designer.ctbotp.CtConvertRuleRightChecker;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.apiparam.CtMainEntityTypeReq;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.dto.MainEntityTypeDto;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.ctbotp.CtConvertRuleMetaDaoPlugin;
import kd.bos.metadata.ctbotp.CtConvertRuleMetadata;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.service.ctbotp.utils.CtTenantPathUtils;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;

public class CtConvertRuleListPlugin
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(CtConvertRuleListPlugin.class);
    private static final String FORMID_CONVERT_RULE = "ct_botp_convertrule";
    private static final String UPDATE_INFO = "updateinfo";
    private static final String TENANT_MODIFY = "tenantmodify";
    private static final String FORMID_TENANT_MODIFY = "ct_botp_tenant_modify";
    private static final String KEY_MODIFY = "modify";
    private static final String KEY_ENABLED = "enabled";
    private static final String LISTHYPERLINK_SELECT_FIELDS = "id,sourcetenant,sourceaccountnumber,sourcedatacenter,sourceentitynumber,sourceentityname,sbizappname,targettenant,targetaccountnumber,targetdatacenter,targetentitynumber, targetentityname, tbizappname, tenantpath";
    private static final String BOS_CTBOTP_FORMPLUGIN = "bos-ctbotp-formplugin";
    private static final String KEY_TENANT_PATH = "tenantpath";
    private static final String KEY_SOURCE_TENANT = "sourcetenant";
    private static final String KEY_SOURCE_DATACENTER = "sourcedatacenter";
    private static final String KEY_SOURCE_ACCOUNTNUMBER = "sourceaccountnumber";
    private static final String KEY_TARGET_TENANT = "targettenant";
    private static final String KEY_TARGET_DATACENTER = "targetdatacenter";
    private static final String KEY_TARGET_ACCOUNTNUMBER = "targetaccountnumber";
    private static final String KEY_TENANTID = "tenantid";
    private static final String KEY_ACCOUNTID = "accountid";
    private static final String KEY_ACCOUNTNUMBER = "accountnumber";

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection datas = e.getPageData();
        if (datas == null) {
            return;
        }
        HashMap<String, DynamicObject> tenantPathMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject data : datas) {
            if (!StringUtils.equals((CharSequence)"0", (CharSequence)data.getString(KEY_ENABLED))) {
                data.set(KEY_ENABLED, (Object)"1");
            }
            String tenantPathNumber = data.getString(KEY_TENANT_PATH);
            DynamicObject tenantPath = null;
            if (StringUtils.isBlank((CharSequence)tenantPathNumber)) continue;
            if (tenantPathMap.get(tenantPathNumber) == null) {
                tenantPath = CtTenantPathUtils.getTenantPath((String)data.getString(KEY_TENANT_PATH));
                tenantPathMap.put(tenantPathNumber, tenantPath);
            } else {
                tenantPath = (DynamicObject)tenantPathMap.get(tenantPathNumber);
            }
            if (tenantPath == null) continue;
            DynamicObject sourceTenant = (DynamicObject)tenantPath.get(KEY_SOURCE_TENANT);
            data.set(KEY_SOURCE_TENANT, (Object)sourceTenant.getString(KEY_TENANTID));
            data.set(KEY_SOURCE_DATACENTER, (Object)sourceTenant.getString(KEY_ACCOUNTID));
            data.set(KEY_SOURCE_ACCOUNTNUMBER, (Object)sourceTenant.getString(KEY_ACCOUNTNUMBER));
            DynamicObject targetTenant = (DynamicObject)tenantPath.get(KEY_TARGET_TENANT);
            data.set(KEY_TARGET_TENANT, (Object)targetTenant.getString(KEY_TENANTID));
            data.set(KEY_TARGET_DATACENTER, (Object)targetTenant.getString(KEY_ACCOUNTID));
            data.set(KEY_TARGET_ACCOUNTNUMBER, (Object)targetTenant.getString(KEY_ACCOUNTNUMBER));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String barItemKey = evt.getItemKey();
        if (barItemKey.equalsIgnoreCase(UPDATE_INFO)) {
            if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715a0df000000ac")) {
                return;
            }
            if (this.getSelectedRows().size() != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"CtConvertRuleListPlugin_2", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            this.updateInfo(this.getSelectedRows().get(0).getPrimaryKeyValue());
        } else if (barItemKey.equalsIgnoreCase(TENANT_MODIFY)) {
            if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715a0df000000ac")) {
                return;
            }
            if (this.getSelectedRows().size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u3002", (String)"CtConvertRuleListPlugin_7", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(FORMID_TENANT_MODIFY);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_MODIFY);
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        HashMap returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(KEY_MODIFY) && (returnData = (HashMap)closedCallBackEvent.getReturnData()) != null) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            this.tenantModify(selectedRows, (DynamicObject)returnData.get("TenantPath"));
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        if (args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow row = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow();
            Object pkValue = row.getPrimaryKeyValue();
            QFilter[] filters = new QFilter[]{new QFilter(billList.getEntityType().getPrimaryKey().getName(), "=", pkValue)};
            DynamicObject dynamicObject = ORM.create().queryOne(billList.getEntityType().getName(), LISTHYPERLINK_SELECT_FIELDS, filters);
            String tenantPathNumber = dynamicObject.getString(KEY_TENANT_PATH);
            this.showRuleForm(this.getSourceInfo(dynamicObject), this.getTargetInfo(dynamicObject), pkValue, tenantPathNumber);
        }
    }

    private void showRuleForm(Map<String, String> sourceMap, Map<String, String> targetMap, Object ruleId, String tenantPathNumber) {
        if (StringUtils.isBlank((CharSequence)sourceMap.get("SourceBill"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6e90\u5355\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"CtConvertRuleListPlugin_0", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)targetMap.get("TargetBill"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"CtConvertRuleListPlugin_1", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_CONVERT_RULE);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("sourceInfo", sourceMap);
        showParameter.setCustomParam("targetInfo", targetMap);
        showParameter.setCustomParam("tenantPathNumber", (Object)tenantPathNumber);
        showParameter.setCustomParam("ruleId", ruleId);
        showParameter.getCustomParams().put("checkRightAppId", this.getView().getFormShowParameter().getAppId());
        this.getView().showForm(showParameter);
    }

    private Map<String, String> getSourceInfo(DynamicObject dynamicObject) {
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put("SourceBill", dynamicObject.getString("sourceentitynumber"));
        map.put("SourceBillName", dynamicObject.getString("sourceentityname"));
        map.put("SourceAppName", dynamicObject.getString("sbizappname"));
        return map;
    }

    private Map<String, String> getTargetInfo(DynamicObject dynamicObject) {
        HashMap<String, String> map = new HashMap<String, String>(6);
        map.put("TargetBill", dynamicObject.getString("targetentitynumber"));
        map.put("TargetBillName", dynamicObject.getString("targetentityname"));
        map.put("TargetAppName", dynamicObject.getString("tbizappname"));
        return map;
    }

    private void updateInfo(Object pkValue) {
        boolean flag = true;
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", pkValue)};
        DynamicObject dynamicObject = ORM.create().queryOne("ct_botp_crlist", LISTHYPERLINK_SELECT_FIELDS, filters);
        String sourcetenant = dynamicObject.getString(KEY_SOURCE_TENANT);
        String sourcedatacenter = dynamicObject.getString(KEY_SOURCE_DATACENTER);
        String sourceentitynumber = dynamicObject.getString("sourceentitynumber");
        String targettenant = dynamicObject.getString(KEY_TARGET_TENANT);
        String targetdatacenter = dynamicObject.getString(KEY_TARGET_DATACENTER);
        String targetentitynumber = dynamicObject.getString("targetentitynumber");
        List list = CtConvertMetaServiceHelper.loadMetas((String)sourcetenant, (String)sourcedatacenter, (String)sourceentitynumber, (String)targettenant, (String)targetdatacenter, (String)targetentitynumber);
        MainEntityTypeDto sourceDto = this.getMainEntityType(sourcetenant, sourcedatacenter, sourceentitynumber);
        MainEntityTypeDto targetDto = this.getMainEntityType(targettenant, targetdatacenter, targetentitynumber);
        for (CtConvertRuleMetadata metadata : list) {
            CtConvertRuleElement ruleElement = metadata.getRuleElement();
            if (sourceDto != null) {
                ruleElement.setSourceEntityName(new LocaleString(sourceDto.getDisplayName()));
            } else {
                flag = false;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u89c4\u5219[%1$s]\u66f4\u65b0\u6e90\u5355\u4fe1\u606f\u5931\u8d25\u3002", (String)"CtConvertRuleListPlugin_3", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]), ruleElement.getId()));
            }
            if (targetDto != null) {
                ruleElement.setTargetEntityName(new LocaleString(targetDto.getDisplayName()));
            } else {
                flag = false;
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u89c4\u5219[%1$s]\u66f4\u65b0\u76ee\u6807\u5355\u4fe1\u606f\u5931\u8d25\u3002", (String)"CtConvertRuleListPlugin_4", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]), ruleElement.getId()));
            }
            if (!flag) continue;
            CtConvertMetaServiceHelper.save((CtConvertRuleMetadata)metadata);
        }
        if (flag) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u5355\u636e\u4fe1\u606f\u6210\u529f\u3002", (String)"CtConvertRuleListPlugin_5", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            this.refreshView();
        }
    }

    private void tenantModify(ListSelectedRowCollection selectedRows, DynamicObject tenantPath) {
        if (tenantPath == null || selectedRows.size() == 0) {
            return;
        }
        Object[] pkValves = selectedRows.getPrimaryKeyValues();
        String[] ids = Arrays.asList(pkValves).toArray(new String[0]);
        List list = CtConvertMetaServiceHelper.batchLoadMeta((String[])ids, (boolean)false);
        String tenantPathNumber = tenantPath.getString("number");
        for (CtConvertRuleMetadata metadata : list) {
            CtConvertRuleElement ruleElement = metadata.getRuleElement();
            ruleElement.setTenantPath(tenantPathNumber);
            CtConvertMetaServiceHelper.save((CtConvertRuleMetadata)metadata);
            this.updateTenantInfo(metadata);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u79df\u6237\u4fe1\u606f\u6210\u529f\u3002", (String)"CtConvertRuleListPlugin_6", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
        this.refreshView();
    }

    private void refreshView() {
        ListView listView = (ListView)this.getView();
        listView.refresh();
    }

    public MainEntityTypeDto getMainEntityType(String tenant, String accountId, String entityNumber) {
        Map openApiResult;
        String localeId = RequestContext.get().getLang().toString();
        CtMainEntityTypeReq mainEntityTypeReq = new CtMainEntityTypeReq(entityNumber, Boolean.valueOf(false), Boolean.valueOf(false), localeId);
        String result = CtBotpApiUtils.post((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETMAINENTITYINFO, (String)SerializationUtils.toJsonString((Object)mainEntityTypeReq));
        if (StringUtils.isNotBlank((CharSequence)result) && Boolean.parseBoolean((openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class)).get("status").toString()) && openApiResult.get("errorCode").equals("0")) {
            this.getPageCache().put(entityNumber, SerializationUtils.toJsonString(openApiResult.get("data")));
            return (MainEntityTypeDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), MainEntityTypeDto.class);
        }
        return null;
    }

    private void updateTenantInfo(CtConvertRuleMetadata metadata) {
        CtConvertRuleMetaDaoPlugin.saveTenantInfo((CtConvertRuleMetadata)metadata);
    }

    private void updateInheritTenantInfo(CtConvertRuleMetadata meta) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FID ");
        sBuilder.append("FROM T_CTBOTP_ConvertRule ");
        sBuilder.append("WHERE FParentId = ? and FType = ? and FTenantPath = ' ' ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FParentId", 12, (Object)meta.getId()), new SqlParameter(":FType", 1, (Object)"2")};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FID");
                    ids.add(id);
                }
                return ids;
            }
        };
        List ruleIds = (List)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (ruleIds.isEmpty()) {
            return;
        }
        for (String ruleId : ruleIds) {
            meta.setId(ruleId);
            this.updateTenantInfo(meta);
        }
    }
}

