/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.ctbotp.CtGetRuleHelper;
import kd.bos.designer.ctbotp.CtPlugPolicyHelper;
import kd.bos.designer.ctbotp.CtRuleCacheHelper;
import kd.bos.designer.ctbotp.CtSelectBasedataValue;
import kd.bos.designer.ctbotp.CtSetRuleHelper;
import kd.bos.designer.property.ComboItemsEditPlugin;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.ctbotp.CtCRCondition;
import kd.bos.entity.ctbotp.CtCRValByConditions;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.CtFieldConvertType;
import kd.bos.entity.ctbotp.CtGroupByMode;
import kd.bos.entity.ctbotp.apiparam.TreeNodeParam;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.dto.MainEntityTypeDto;
import kd.bos.entity.ctbotp.dto.TargetFieldPropInfo;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.ctbotp.CtConvertRuleMetadata;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;

public class CtFieldEventHandler {
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private IFormView view;
    private AbstractFormPlugin plugin;
    private CtGetRuleHelper getRuleHelper;

    public CtFieldEventHandler(IFormView view, AbstractFormPlugin plugin) {
        this.view = view;
        this.plugin = plugin;
        this.getRuleHelper = new CtGetRuleHelper(view, plugin);
    }

    private IFormView getView() {
        return this.view;
    }

    private IDataModel getModel() {
        return this.view.getModel();
    }

    public void addClickListeners() {
        this.plugin.addClickListeners(new String[]{"frunconditiondesc"});
        this.plugin.addClickListeners(new String[]{"filterexprdesc"});
        this.plugin.addClickListeners(new String[]{"fsourcefieldname", "ffieldformuladesc"});
        this.plugin.addClickListeners(new String[]{"g_billadd", "g_billdel", "g_entryadd", "g_entrydel", "g_subentryadd", "g_subentrydel"});
    }

    public void addHyperLinkClickListener() {
        EntryGrid fieldMapGrid = (EntryGrid)this.getView().getControl("fieldmappolicy");
        fieldMapGrid.addHyperClickListener((HyperLinkClickListener)this.plugin);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        CtSetRuleHelper setRuleHelper = new CtSetRuleHelper(this.getView(), this.plugin);
        if ("ftargetentrykey".equalsIgnoreCase(key)) {
            MainEntityTypeDto targetMainTypeDto = this.getRuleHelper.getMainEntityTypeFromCache(CtRuleCacheHelper.getTargetTenant(this.view), CtRuleCacheHelper.getTargetDataCenter(this.view), CtRuleCacheHelper.getTargetEntityNumber(this.view), true);
            String targetEntryKey = (String)this.getModel().getValue("ftargetentrykey");
            String tgtEntityKeys = "";
            List comboItems = targetMainTypeDto.getComboItems();
            for (ComboItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(targetEntryKey)) continue;
                tgtEntityKeys = comboItem.getId();
            }
            this.getModel().setValue("ftargetlkentitykeys", (Object)tgtEntityKeys);
            setRuleHelper.changeTgtLinkEntity(CtRuleCacheHelper.getTargetTenant(this.getView()), CtRuleCacheHelper.getTargetDataCenter(this.getView()), CtRuleCacheHelper.getTargetEntityNumber(this.getView()), targetEntryKey, false);
            this.getModel().setValue("ftargetsubentrykey", (Object)"");
        } else if ("fsourceentrykey".equalsIgnoreCase(key)) {
            MainEntityTypeDto srcMainTypeDto = this.getRuleHelper.getMainEntityTypeFromCache(CtRuleCacheHelper.getSourceTenant(this.view), CtRuleCacheHelper.getSourceDataCenter(this.view), CtRuleCacheHelper.getSourceEntityNumber(this.view), false);
            String sourceEntryKey = (String)this.getModel().getValue("fsourceentrykey");
            String srcEntityKeys = "";
            List comboItems = srcMainTypeDto.getComboItems();
            for (ComboItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(sourceEntryKey)) continue;
                srcEntityKeys = comboItem.getId();
            }
            this.getModel().setValue("fsourcelkentitykeys", (Object)srcEntityKeys);
            setRuleHelper.changeSrcLinkEntity(CtRuleCacheHelper.getSourceTenant(this.getView()), CtRuleCacheHelper.getSourceDataCenter(this.getView()), CtRuleCacheHelper.getSourceEntityNumber(this.getView()), sourceEntryKey, false);
            this.getModel().setValue("fsourcesubentrykey", (Object)"");
            this.plugin.getPageCache().remove("SourceBillTreeNode");
        } else if ("fconverttype".equalsIgnoreCase(key)) {
            for (ChangeData changeData : e.getChangeSet()) {
                this.convertTypeChanged(changeData.getRowIndex());
            }
        } else if (StringUtils.isNotBlank((CharSequence)key) && key.startsWith("g_")) {
            this.groupByChanged(key);
        } else if ("frunconditiondesc".equalsIgnoreCase(key)) {
            this.doClearFieldValue("fruncondition", e.getChangeSet());
        } else if ("fsourcefieldname".equals(key)) {
            this.doClearFieldValue("fsourcefield", e.getChangeSet());
        } else if ("ffieldformuladesc".equals(key)) {
            this.doClearFieldValue("ffieldformula", e.getChangeSet());
        } else if ("synctype".equals(key)) {
            String ruleId = (String)this.getModel().getValue("fid");
            if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                CtConvertRuleMetadata rule = CtRuleCacheHelper.getRule(this.plugin, ruleId);
                CtConvertRuleElement convertRuleElement = rule.getRuleElement();
                convertRuleElement.setSyncType(String.valueOf(e.getChangeSet()[0].getNewValue()));
                setRuleHelper.setFieldMapPolicy(rule.getRuleElement());
            }
        } else if ("fmirrorsync".equals(key)) {
            String ruleId = (String)this.getModel().getValue("fid");
            if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                CtConvertRuleMetadata rule = CtRuleCacheHelper.getRule(this.plugin, ruleId);
                CtConvertRuleElement convertRuleElement = rule.getRuleElement();
                convertRuleElement.setMirrorSync(((Boolean)e.getChangeSet()[0].getNewValue()).booleanValue());
                setRuleHelper.setBaseInfo(convertRuleElement);
                this.getRuleHelper.clearManEntityTypeCache(convertRuleElement.getSourceTenant(), convertRuleElement.getSourceDataCenter(), convertRuleElement.getSourceEntityNumber(), false);
                this.getRuleHelper.clearManEntityTypeCache(convertRuleElement.getTargetTenant(), convertRuleElement.getTargetDataCenter(), convertRuleElement.getTargetEntityNumber(), true);
                this.getRuleHelper.getMainEntityType(convertRuleElement.getSourceTenant(), convertRuleElement.getSourceDataCenter(), convertRuleElement.getSourceEntityNumber(), false, convertRuleElement);
                this.getRuleHelper.getMainEntityType(convertRuleElement.getTargetTenant(), convertRuleElement.getTargetDataCenter(), convertRuleElement.getTargetEntityNumber(), true, convertRuleElement);
                setRuleHelper.setLinkEntryPolicy(convertRuleElement, true);
                setRuleHelper.setFieldMapPolicy(convertRuleElement);
            }
        } else if ("filterexprdesc".equalsIgnoreCase(key)) {
            this.doClearFieldValue("advfilterjson", e.getChangeSet());
            this.doClearFieldValue("advfilterdesc", e.getChangeSet());
        }
    }

    public void Click(String sourceFldKey) {
        if ("frunconditiondesc".equals(sourceFldKey)) {
            String conditionJson = (String)this.getModel().getValue("fruncondition");
            String srcEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.view);
            HashSet<String> selectEntitys = new HashSet<String>();
            selectEntitys.add(CtRuleCacheHelper.getSourceEntityNumber(this.view));
            String fldNodes = this.getSourceBillTreeNode(SerializationUtils.toJsonString(selectEntitys));
            this.showConditionForm(conditionJson, srcEntityNumber, true, fldNodes, sourceFldKey);
        } else if ("fsourcefieldname".equals(sourceFldKey)) {
            this.doClickSourceField();
        } else if ("ffieldformuladesc".equals(sourceFldKey)) {
            this.doClickFieldFormula();
        } else if (StringUtils.isNotBlank((CharSequence)sourceFldKey) && sourceFldKey.startsWith("g_")) {
            this.groupByClick(sourceFldKey);
        } else if ("filterexprdesc".equals(sourceFldKey)) {
            int row = this.getModel().getEntryCurrentRowIndex("adv_filter");
            String srcEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.view);
            String runConditionJson = (String)this.getModel().getValue("advfilterjson", row);
            String sourceLinkEntry = (String)this.getModel().getValue("fsourceentrykey");
            boolean onlyHeadFields = sourceLinkEntry.equals(srcEntityNumber);
            this.showFilterAdvConditionForm(runConditionJson, srcEntityNumber, onlyHeadFields, "", sourceFldKey);
        }
    }

    public void itemClick(ItemClickEvent e) {
        String itemKey = e.getItemKey();
        if (itemKey.equalsIgnoreCase("btnaddplug")) {
            CtPlugPolicyHelper.showAddPlugForm(this.view, this.plugin);
        } else if (itemKey.equalsIgnoreCase("btnaddjsplug")) {
            CtPlugPolicyHelper.showAddJSPlugForm(this.view, this.plugin);
        } else if (itemKey.equalsIgnoreCase("btnmodifyplug")) {
            CtPlugPolicyHelper.showModifyPlugForm(this.view, this.plugin);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldKey = e.getFieldName();
        int row = e.getRowIndex();
        if ("fclearsourcefield".equalsIgnoreCase(fieldKey)) {
            CtSetRuleHelper setRuleHelper = new CtSetRuleHelper(this.view, this.plugin);
            setRuleHelper.clearSourceField(row);
        }
    }

    public void closedCallBack(String sourceFldKey, Object returnData) {
        if ("frunconditiondesc".equals(sourceFldKey)) {
            String json = (String)returnData;
            this.receiveCondition(json, "", "fruncondition", "frunconditiondesc");
        } else if ("fsourcefieldname".equals(sourceFldKey)) {
            String srcEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.view);
            this.receiveSelectField(srcEntityNumber, (String)returnData, "fieldmappolicy", "fsourcefield", "fsourcefieldname");
        } else if ("ffieldformuladesc".equals(sourceFldKey)) {
            if (returnData instanceof ListSelectedRowCollection) {
                this.doReceiceFieldConstant((ListSelectedRowCollection)returnData);
            } else {
                this.doReceiveFieldFormula((String)returnData);
            }
        } else if (StringUtils.isNotBlank((CharSequence)sourceFldKey) && sourceFldKey.startsWith("groupby_")) {
            this.groupAddRow(sourceFldKey, returnData);
        } else if ("btnaddplug".equalsIgnoreCase(sourceFldKey)) {
            CtPlugPolicyHelper.receiveNewPlug(this.view, this.plugin, returnData);
        } else if ("btnaddjsplug".equalsIgnoreCase(sourceFldKey)) {
            CtPlugPolicyHelper.receiveNewJSPlug(this.view, this.plugin, returnData);
        } else if ("btnmodifyplug".equalsIgnoreCase(sourceFldKey)) {
            CtPlugPolicyHelper.receiveModifyPlug(this.view, this.plugin, returnData);
        } else if ("filterexprdesc".equalsIgnoreCase(sourceFldKey)) {
            String json = (String)returnData;
            this.receiveFilterCondition(json, "adv_filter", "advfilterjson", "filterexprdesc");
        }
    }

    private void doClearFieldValue(String key, ChangeData[] changeDatas) {
        for (ChangeData changeData : changeDatas) {
            if (!StringUtils.isBlank((Object)changeData.getNewValue())) continue;
            this.getModel().setValue(key, null, changeData.getRowIndex());
        }
    }

    private void doClickSourceField() {
        TreeNode treeNode;
        String tgtEntityNumber = CtRuleCacheHelper.getTargetEntityNumber(this.view);
        String srcEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.view);
        String srcTenant = CtRuleCacheHelper.getSourceTenant(this.view);
        String srcAccountId = CtRuleCacheHelper.getSourceDataCenter(this.view);
        String tgtTenant = CtRuleCacheHelper.getTargetTenant(this.view);
        String tgtAccountId = CtRuleCacheHelper.getTargetDataCenter(this.view);
        String entityKey = "fieldmappolicy";
        String targetFieldKey = "ftargetfield";
        String convertTypeFieldKey = "fconverttype";
        String sourceCtlKey = "fsourcefieldname";
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        String convertType = (String)this.getModel().getValue(convertTypeFieldKey, row);
        if (CtFieldConvertType.SourceField.getValue() != Integer.parseInt(convertType)) {
            return;
        }
        String targetFieldValue = (String)this.getModel().getValue(targetFieldKey, row);
        TreeNodeParam param = new TreeNodeParam();
        param.setSourceEntityNumber(srcEntityNumber);
        param.setTargetEntityNumber(tgtEntityNumber);
        param.setTargetFieldValue(targetFieldValue);
        TargetFieldPropInfo targetProperty = this.findProperty(tgtTenant, tgtAccountId, tgtEntityNumber, targetFieldValue);
        if (targetProperty != null) {
            param.setTargetProperty(targetProperty.getTargetProperty());
            param.setEntityNumbers(targetProperty.getEntityNumbers());
        }
        if ((treeNode = this.getSourceTreeNode(srcTenant, srcAccountId, param)) == null) {
            return;
        }
        this.showSelectFieldForm(treeNode, sourceCtlKey);
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveSelectField(String srcEntityNumber, String returnPropName, String entityKey, String sourceCtrlKey, String descFldKey) {
        if (StringUtils.isBlank((CharSequence)returnPropName)) {
            return;
        }
        String fieldCaption = this.getRuleHelper.getFieldCaption(CtRuleCacheHelper.getSourceTenant(this.view), CtRuleCacheHelper.getSourceDataCenter(this.view), srcEntityNumber, returnPropName);
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName);
            this.getModel().setValue(descFldKey, (Object)fieldCaption);
        } else {
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            this.getModel().setValue(sourceCtrlKey, (Object)returnPropName, row);
            this.getModel().setValue(descFldKey, (Object)fieldCaption, row);
        }
    }

    private void doClickFieldFormula() {
        String tgtEntityNumber = CtRuleCacheHelper.getTargetEntityNumber(this.view);
        String tgtTenant = CtRuleCacheHelper.getTargetTenant(this.view);
        String tgtaccountId = CtRuleCacheHelper.getTargetDataCenter(this.view);
        String srcEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.view);
        String srcTenant = CtRuleCacheHelper.getSourceTenant(this.view);
        String srcAccountId = CtRuleCacheHelper.getSourceDataCenter(this.view);
        String entityKey = "fieldmappolicy";
        String targetFld = "ftargetfield";
        String convertTypeFld = "fconverttype";
        String formulaFld = "ffieldformula";
        String formulaDescFld = "ffieldformuladesc";
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        String targetPropName = (String)this.getModel().getValue(targetFld, row);
        TargetFieldPropInfo targetPropInfo = this.findProperty(tgtTenant, tgtaccountId, tgtEntityNumber, targetPropName);
        if (targetPropInfo == null) {
            return;
        }
        IDataEntityProperty targetProperty = null;
        Class<?> type = null;
        try {
            type = Class.forName(targetPropInfo.getTargetProperty());
            targetProperty = (IDataEntityProperty)type.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.isPropertySupportFieldFormula(type)) {
            return;
        }
        String billNodeJson = this.getSourceBillTreeNode("");
        String convertType = (String)this.getModel().getValue(convertTypeFld, row);
        if (CtFieldConvertType.Formula.getValue() == Integer.parseInt(convertType)) {
            String formula = (String)this.getModel().getValue(formulaFld, row);
            if (StringUtils.isBlank((CharSequence)formula)) {
                CRFormula crFormula = new CRFormula();
                formula = SerializationUtils.toJsonString((Object)crFormula);
            }
            this.showFormulaForm(formula, srcEntityNumber, billNodeJson, formulaDescFld);
        } else if (CtFieldConvertType.ByCondition.getValue() == Integer.parseInt(convertType)) {
            String formula = (String)this.getModel().getValue(formulaFld, row);
            if (StringUtils.isBlank((CharSequence)formula)) {
                CtCRValByConditions valByConditions = new CtCRValByConditions();
                formula = SerializationUtils.toJsonString((Object)valByConditions);
            }
            this.showValByConditionForm(srcEntityNumber, formula, billNodeJson, formulaDescFld, targetProperty);
        } else if (CtFieldConvertType.CONSTANT.getValue() == Integer.parseInt(convertType)) {
            if (targetProperty instanceof ItemClassProp) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, formulaDescFld);
                DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("fieldmappolicy");
                CRFormula crFormula = null;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    if (!StringUtils.equals((CharSequence)((ItemClassProp)targetProperty).getTypePropName(), (CharSequence)dynamicObject.get("ftargetfield").toString()) || StringUtils.isEmpty((CharSequence)((String)dynamicObject.get("ffieldformula")))) continue;
                    crFormula = (CRFormula)SerializationUtils.fromJsonString((String)((String)dynamicObject.get("ffieldformula")), CRFormula.class);
                }
                if (crFormula != null) {
                    CtSelectBasedataValue.get().showF7List(crFormula.getExpression(), this.getView(), closeCallBack);
                } else {
                    CtSelectBasedataValue.get().showF7List((BasedataProp)targetProperty, this.getView(), closeCallBack);
                }
            } else if (targetProperty instanceof BasedataProp) {
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, formulaDescFld);
                CtSelectBasedataValue.get().showF7List((BasedataProp)targetProperty, this.getView(), closeCallBack);
            } else if (targetProperty instanceof ComboProp) {
                this.showComboForm((ComboProp)targetProperty, formulaDescFld);
            }
        }
    }

    private boolean isPropertySupportFieldFormula(Class targetProperty) {
        return targetProperty != AttachmentProp.class;
    }

    private void doReceiceFieldConstant(ListSelectedRowCollection returnData) {
        if (StringUtils.isBlank((Object)returnData) || returnData.size() == 0) {
            return;
        }
        CRFormula formula = new CRFormula();
        formula.setExprTran(returnData.get(0).getName());
        formula.setExpression(returnData.get(0).getPrimaryKeyValue().toString());
        String json = SerializationUtils.toJsonString((Object)formula);
        String entityKey = "fieldmappolicy";
        String formulaFld = "ffieldformula";
        String formulaDescFld = "ffieldformuladesc";
        if (StringUtils.isBlank((CharSequence)entityKey)) {
            this.getModel().setValue(formulaFld, (Object)json);
            this.getModel().setValue(formulaDescFld, (Object)formula.getExprTran());
        } else {
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            this.getModel().setValue(formulaFld, (Object)json, row);
            this.getModel().setValue(formulaDescFld, (Object)formula.getExprTran(), row);
        }
    }

    private void doReceiveFieldFormula(String returnData) {
        if (StringUtils.isBlank((CharSequence)returnData)) {
            return;
        }
        String entityKey = "fieldmappolicy";
        String convertTypeFld = "fconverttype";
        String formulaFld = "ffieldformula";
        String formulaDescFld = "ffieldformuladesc";
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        String convertType = (String)this.getModel().getValue(convertTypeFld, row);
        if (CtFieldConvertType.Formula.getValue() == Integer.parseInt(convertType) || CtFieldConvertType.CONSTANT.getValue() == Integer.parseInt(convertType)) {
            this.receiveFormula(returnData, entityKey, formulaFld, formulaDescFld);
        } else {
            this.receiveValByCondition(returnData, entityKey, formulaFld, formulaDescFld);
        }
    }

    private void showComboForm(ComboProp comboProp, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_comboitemsselect");
        showParameter.getCustomParams().put("comboProp", this.getComboItems(comboProp));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private Object getComboItems(ComboProp comboProp) {
        List items = comboProp.getComboItems();
        ComboToJsonSerializer comboJson = new ComboToJsonSerializer();
        comboJson.setItems(items);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(ComboItemsEditPlugin.ComboJsonSerializer.class));
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, dts));
        Map mapCombo = serializer.serializeToMap((Object)comboJson, null);
        return mapCombo.containsKey("Items") ? mapCombo.get("Items") : items;
    }

    private void showFormulaForm(String formulaJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = CtRuleCacheHelper.getFuncsXML(this.plugin);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveFormula(String formulaJson, String entryEntityKey, String formulaFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)formulaJson)) {
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(formulaFldKey, (Object)formulaJson);
                this.getModel().setValue(descFldKey, (Object)formula.getExprDesc());
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(formulaFldKey, (Object)formulaJson, row);
                this.getModel().setValue(descFldKey, (Object)formula.getExprDesc(), row);
            }
        }
    }

    private void showValByConditionForm(String srcEntityNumber, String json, String fieldNodes, String sourceCtrlKey, IDataEntityProperty targetProperty) {
        FormShowParameter showParameter = new FormShowParameter();
        String tenantCode = CtRuleCacheHelper.getSourceTenant(this.view);
        String accountId = CtRuleCacheHelper.getSourceDataCenter(this.view);
        showParameter.setFormId("ct_botp_valbycondition");
        showParameter.getCustomParams().put("crvalbyconditions", json);
        showParameter.getCustomParams().put("entitynumber", srcEntityNumber);
        showParameter.getCustomParams().put("SourceTenant", tenantCode);
        showParameter.getCustomParams().put("SourceDataCenter", accountId);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        if (targetProperty instanceof BasedataProp) {
            showParameter.getCustomParams().put("baseentityid", ((BasedataProp)targetProperty).getBaseEntityId());
        }
        String funcsXML = CtRuleCacheHelper.getFuncsXML(this.plugin);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveValByCondition(String json, String entryEntityKey, String formulaFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            CtCRValByConditions valByConditions = (CtCRValByConditions)SerializationUtils.fromJsonString((String)json, CtCRValByConditions.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(formulaFldKey, (Object)json);
                this.getModel().setValue(descFldKey, (Object)valByConditions.getDescription());
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(formulaFldKey, (Object)json, row);
                this.getModel().setValue(descFldKey, (Object)valByConditions.getDescription(), row);
            }
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        String tenantCode = CtRuleCacheHelper.getSourceTenant(this.view);
        String accountId = CtRuleCacheHelper.getSourceDataCenter(this.view);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ct_botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("SourceTenant", tenantCode);
        showParameter.getCustomParams().put("SourceDataCenter", accountId);
        String funcsXML = CtRuleCacheHelper.getFuncsXML(this.plugin);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showFilterAdvConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        String tenantCode = CtRuleCacheHelper.getSourceTenant(this.view);
        String accountId = CtRuleCacheHelper.getSourceDataCenter(this.view);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ct_botp_filteradv");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("SourceTenant", tenantCode);
        showParameter.getCustomParams().put("SourceDataCenter", accountId);
        String funcsXML = CtRuleCacheHelper.getFuncsXML(this.plugin);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CtCRCondition condition = (CtCRCondition)SerializationUtils.fromJsonString((String)conditionJson, CtCRCondition.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(conditionFldKey, (Object)conditionJson);
                this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
                this.getModel().setValue(descFldKey, (Object)condition.getExprDesc(), row);
            }
        }
    }

    private void convertTypeChanged(int row) {
        String convertType = (String)this.getModel().getValue("fconverttype", row);
        if (StringUtils.isBlank((CharSequence)convertType)) {
            return;
        }
        if (CtFieldConvertType.SourceField.getValue() == Integer.parseInt(convertType)) {
            this.getModel().setValue("ffieldformula", (Object)"", row);
            this.getModel().setValue("ffieldformuladesc", (Object)"", row);
        } else {
            this.getModel().setValue("fsourcefield", (Object)"", row);
            this.getModel().setValue("fsourcefieldname", (Object)"", row);
            this.getModel().setValue("ffieldformula", (Object)"", row);
            this.getModel().setValue("ffieldformuladesc", (Object)"", row);
        }
    }

    public void groupByChanged(String key) {
        if ("g_billcombo".equalsIgnoreCase(key)) {
            String value = (String)this.getModel().getValue(key);
            this.setEnable(String.valueOf(CtGroupByMode.GroupByField.getValue()).equals(value), "g_billentry", "g_billadd", "g_billdel");
        } else if ("g_entrycombo".equalsIgnoreCase(key)) {
            String value = (String)this.getModel().getValue(key);
            this.setEnable(String.valueOf(CtGroupByMode.GroupByField.getValue()).equals(value), "g_entry", "g_entryadd", "g_entrydel");
        } else if ("g_subentrycombo".equalsIgnoreCase(key)) {
            String value = (String)this.getModel().getValue(key);
            this.setEnable(String.valueOf(CtGroupByMode.GroupByField.getValue()).equals(value), "g_subentry", "g_subentryadd", "g_subentrydel");
        }
    }

    public void setEnable(Boolean value, String ... ctlKeys) {
        HashMap<String, Object> enableMap = new HashMap<String, Object>();
        enableMap.put("policy", "");
        enableMap.put("enable", value);
        enableMap.put("keys", ctlKeys);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("setEnable", enableMap);
    }

    public void groupByClick(String sourceFldKey) {
        switch (sourceFldKey) {
            case "g_billadd": 
            case "g_entryadd": 
            case "g_subentryadd": {
                HashSet<String> selectEntitys = this.getRuleHelper.getSourceLinkEntitys();
                String billNodeJson = this.getSourceBillTreeNode(SerializationUtils.toJsonString(selectEntitys));
                TreeNode srcBillNode = (TreeNode)SerializationUtils.fromJsonString((String)billNodeJson, TreeNode.class);
                String gEntryKey = "";
                if ("g_billadd".equals(sourceFldKey)) {
                    gEntryKey = "g_billentry";
                } else if ("g_entryadd".equals(sourceFldKey)) {
                    gEntryKey = "g_entry";
                } else if ("g_subentryadd".equals(sourceFldKey)) {
                    gEntryKey = "g_subentry";
                }
                this.showSelectFieldForm(srcBillNode, "groupby_" + gEntryKey);
                break;
            }
            case "g_billdel": 
            case "g_entrydel": 
            case "g_subentrydel": {
                String key = this.groupByDelToEntry(sourceFldKey);
                EntryGrid grid = (EntryGrid)this.getView().getControl(key);
                int[] selectRows = grid.getEntryState().getSelectedRows();
                if (selectRows == null || selectRows.length <= 0) break;
                this.getModel().deleteEntryRows(key, selectRows);
                break;
            }
        }
    }

    public String groupByDelToEntry(String delKey) {
        String entryKey = "";
        if ("g_billdel".equalsIgnoreCase(delKey)) {
            entryKey = "g_billentry";
        }
        if ("g_entrydel".equalsIgnoreCase(delKey)) {
            entryKey = "g_entry";
        }
        if ("g_subentrydel".equalsIgnoreCase(delKey)) {
            entryKey = "g_subentry";
        }
        return entryKey;
    }

    public void groupAddRow(String g_entryKey, Object returnData) {
        String entryKey = g_entryKey.substring(8);
        String fieldKey = "";
        String fieldName = "";
        if ("g_billentry".equals(entryKey)) {
            fieldKey = "g_billentrykey";
            fieldName = "g_billentryname";
        } else if ("g_entry".equals(entryKey)) {
            fieldKey = "g_entrykey";
            fieldName = "g_entryname";
        } else if ("g_subentry".equals(entryKey)) {
            fieldKey = "g_subentrykey";
            fieldName = "g_subentryname";
        }
        if (!StringUtils.isBlank((Object)returnData)) {
            String srcEntityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.view);
            String fieldCaption = this.getRuleHelper.getFieldCaption(CtRuleCacheHelper.getSourceTenant(this.view), CtRuleCacheHelper.getSourceDataCenter(this.view), srcEntityNumber, (String)returnData);
            int row = this.getModel().createNewEntryRow(entryKey);
            this.getModel().setValue(fieldKey, returnData, row);
            this.getModel().setValue(fieldName, (Object)fieldCaption, row);
        }
    }

    private TreeNode getSourceTreeNode(String tenant, String accountId, TreeNodeParam treeNodeParam) {
        String result = CtBotpApiUtils.post((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETSOURCETREENODE, (String)SerializationUtils.toJsonString((Object)treeNodeParam));
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        String json = SerializationUtils.toJsonString(openApiResult.get("data"));
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        return treeNode;
    }

    private String getSourceBillTreeNode(String selectEntitys) {
        String entityNumber = CtRuleCacheHelper.getSourceEntityNumber(this.view);
        String tenant = CtRuleCacheHelper.getSourceTenant(this.view);
        String accountId = CtRuleCacheHelper.getSourceDataCenter(this.view);
        String billNodeJson = "";
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("entityNumber", entityNumber);
        param.put("selectEntitys", selectEntitys);
        String result = CtBotpApiUtils.get((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.GETBILLTREENODE, param);
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        if (Boolean.parseBoolean(openApiResult.get("status").toString())) {
            billNodeJson = CtRuleCacheHelper.putSourceBillTreeNode(this.plugin, SerializationUtils.toJsonString(openApiResult.get("data")));
        }
        return billNodeJson;
    }

    private TargetFieldPropInfo findProperty(String tenant, String accountId, String targetNumber, String targetField) {
        String data;
        TargetFieldPropInfo info = null;
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("targetNumber", targetNumber);
        param.put("targetField", targetField);
        String result = CtBotpApiUtils.get((String)tenant, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.FINDPROPERTY, param);
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        if (Boolean.parseBoolean(openApiResult.get("status").toString()) && (data = openApiResult.get("data").toString()) != null && StringUtils.isNotBlank((CharSequence)data)) {
            info = (TargetFieldPropInfo)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), TargetFieldPropInfo.class);
        }
        return info;
    }

    private void receiveFilterCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CtCRCondition condition = (CtCRCondition)SerializationUtils.fromJsonString((String)conditionJson, CtCRCondition.class);
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(conditionFldKey, (Object)conditionJson);
                this.getModel().setValue(descFldKey, (Object)condition.getExprDesc());
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
                this.getModel().setValue(descFldKey, (Object)condition.getExprTran(), row);
                this.getModel().setValue("ft_id", (Object)condition.getId(), row);
                this.getModel().setValue("advfilterdesc", (Object)condition.getDescription(), row);
            }
        }
    }

    public static class ComboToJsonSerializer {
        private List<ValueMapItem> items = new ArrayList<ValueMapItem>();

        @CollectionPropertyAttribute(collectionItemPropertyType=ValueMapItem.class)
        public List<ValueMapItem> getItems() {
            return this.items;
        }

        public void setItems(List<ValueMapItem> items) {
            this.items = items;
        }
    }
}

