/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEdit;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.ctbotp.CtCRCondition;
import kd.bos.entity.ctbotp.apiparam.GetSimpleBaseDataParam;
import kd.bos.entity.ctbotp.apiparam.TenantF7Param;
import kd.bos.entity.ctbotp.apiparam.TranFormulaReq;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.dto.SimpleBaseDataDto;
import kd.bos.entity.ctbotp.dto.TenantF7Dto;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.FilterGridF7ClickEvent;
import kd.bos.form.control.events.FilterGridF7ClickListener;
import kd.bos.form.control.events.FilterGridF7CloseCallBackEvent;
import kd.bos.form.control.events.FilterGridF7CloseCallBackListener;
import kd.bos.lang.Lang;
import kd.bos.list.CtsyListShowParameter;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.SelectedRowCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;

public class CtFilterConditionEdit
extends FormulaEdit
implements FilterGridF7ClickListener,
FilterGridF7CloseCallBackListener {
    private List<Map<String, Object>> postData = null;

    public void initialize() {
        super.initialize();
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        filterGrid.addFilterGridF7ClickEvents((FilterGridF7ClickListener)this);
        filterGrid.addFilterGridF7CloseCallBackListeners((FilterGridF7CloseCallBackListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String onlyHeadField = (String)this.getView().getFormShowParameter().getCustomParam("onlyheadfield");
        String tenantCode = (String)this.getView().getFormShowParameter().getCustomParam("SourceTenant");
        String accountId = (String)this.getView().getFormShowParameter().getCustomParam("SourceDataCenter");
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("entityNumber", entityNumber);
            param.put("onlyHeadField", onlyHeadField);
            String result = CtBotpApiUtils.get((String)tenantCode, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.BUILDFILTERCOLUMNS, param);
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            List cols = SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString(openApiResult.get("data")), Map.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
            filterGrid.setFilterColumns(cols);
            if (this.currentTenant(tenantCode, accountId)) {
                filterGrid.setEntityNumber(entityNumber);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        if (StringUtils.isNotBlank((CharSequence)conditonJson)) {
            CtCRCondition conditionObj = (CtCRCondition)SerializationUtils.fromJsonString((String)conditonJson, CtCRCondition.class);
            FilterCondition filterCondition = conditionObj.getFilterCondition();
            if (filterCondition != null) {
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
                filterGrid.SetValue(filterCondition);
            }
            if (conditionObj.getDescription() == null) {
                this.getModel().setValue("filterdesc", null);
            } else {
                this.getModel().setValue("filterdesc", (Object)conditionObj.getDescription().getLocaleValue());
            }
        }
    }

    public void filterGridF7Click(FilterGridF7ClickEvent evt) {
        String accountId;
        String tenantCode = (String)this.getView().getFormShowParameter().getCustomParam("SourceTenant");
        if (!this.currentTenant(tenantCode, accountId = (String)this.getView().getFormShowParameter().getCustomParam("SourceDataCenter"))) {
            evt.setCancel(true);
            if (evt.getF7ClickArgs() != null) {
                String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
                TenantF7Param param = new TenantF7Param();
                param.setEntityId(evt.getF7ClickArgs().getEntityId());
                param.setEntityNumber(entityNumber);
                param.setFieldName(evt.getFieldName());
                param.setCompareTypeId(evt.getF7ClickArgs().getCompareTypeId());
                param.setRowIndex(Integer.valueOf(evt.getF7ClickArgs().getRowIndex()));
                param.setPostData(this.loadPostDataCache());
                String result = CtBotpApiUtils.post((String)tenantCode, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.BUILDF7PRAM, (String)SerializationUtils.toJsonString((Object)param));
                Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                String json = SerializationUtils.toJsonString(openApiResult.get("data"));
                TenantF7Dto tenantF7Dto = (TenantF7Dto)SerializationUtils.fromJsonString((String)json, TenantF7Dto.class);
                CtsyListShowParameter para = new CtsyListShowParameter(tenantCode, accountId, evt.getF7ClickArgs().getEntityId());
                para.setMultiSelect(true);
                String filternumbers = "";
                if (kd.bos.util.StringUtils.isNotEmpty((String)filternumbers)) {
                    QFilter f1 = new QFilter("billno", "in", (Object)filternumbers.split(","));
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                    qFilters.add(f1);
                    ListFilterParameter listFilterParameter = new ListFilterParameter(qFilters, null);
                    para.setListFilterParameter(listFilterParameter);
                }
                para.setUseOrgId(0L);
                List qFilters = SerializationUtils.fromJsonStringToList((String)tenantF7Dto.getqFilters(), QFilter.class);
                para.getListFilterParameter().setQFilters(qFilters);
                para.setMultiSelect(tenantF7Dto.getMultiSelect().booleanValue());
                if (StringUtils.isBlank((CharSequence)tenantF7Dto.getOrgFuncID())) {
                    para.setCustomParam("islockfunc", (Object)false);
                } else {
                    para.setCustomParam("islockfunc", (Object)true);
                    para.setCustomParam("orgFuncId", (Object)tenantF7Dto.getOrgFuncID());
                }
                if (!tenantF7Dto.getFilterValues().isEmpty()) {
                    if (tenantF7Dto.getSelectedId().booleanValue()) {
                        para.setSelectedRows(tenantF7Dto.getFilterValues().toArray(new Object[0]));
                    } else {
                        para.setSelectedRowCondition(new SelectedRowCondition(tenantF7Dto.getFilterValues(), tenantF7Dto.getRefPropKey()));
                    }
                }
                para.setF7ClickByFilter(true);
                CloseCallBack closeCallBack = new CloseCallBack();
                closeCallBack.setControlKey("ffiltergrid");
                closeCallBack.setActionId(tenantF7Dto.getRefEntityId() + "$" + evt.getF7ClickArgs().getClientType() + "$" + evt.getF7ClickArgs().getRowIndex() + "$" + tenantF7Dto.getRefPropKey() + "$" + evt.getFieldName() + "$" + entityNumber + "$" + para.getCloseCallBackActionIdSuffix());
                para.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)para);
            }
        }
    }

    protected CRFormula deserialize(String json) {
        CtCRCondition conditionObj = null;
        conditionObj = StringUtils.isBlank((CharSequence)json) ? new CtCRCondition() : (CtCRCondition)SerializationUtils.fromJsonString((String)json, CtCRCondition.class);
        return conditionObj;
    }

    protected void setFormulaObj(CRFormula formulaObj) {
        super.setFormulaObj(formulaObj);
    }

    protected void getFormulaObj(CRFormula formulaObj) {
        super.getFormulaObj(formulaObj);
        CtCRCondition ftCondition = (CtCRCondition)formulaObj;
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        ftCondition.setFilterCondition(filterGridState.getFilterCondition());
        OrmLocaleValue desc = (OrmLocaleValue)this.getView().getModel().getValue("filterdesc");
        ftCondition.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc.getLocaleValue());
    }

    protected String tranFormula(CRFormula formulaObj) {
        String tranExpr = super.tranFormula(formulaObj);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String tenantCode = (String)this.getView().getFormShowParameter().getCustomParam("SourceTenant");
        String accountId = (String)this.getView().getFormShowParameter().getCustomParam("SourceDataCenter");
        TranFormulaReq tranFormulaReq = new TranFormulaReq();
        tranFormulaReq.setEntityNumber(entityNumber);
        tranFormulaReq.setConditionStr(SerializationUtils.toJsonString((Object)((CtCRCondition)formulaObj)));
        tranFormulaReq.setTranExpr(tranExpr);
        String result = CtBotpApiUtils.post((String)tenantCode, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.TRANFORMULA, (String)SerializationUtils.toJsonString((Object)tranFormulaReq));
        Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
        tranExpr = (String)openApiResult.get("data");
        return tranExpr;
    }

    private List<Map<String, Object>> loadPostDataCache() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (this.postData == null && pageCache.get(this.getPostDataKey()) != null) {
            this.postData = SerializationUtils.fromJsonStringToList((String)pageCache.get(this.getPostDataKey()), Map.class);
        }
        if (this.postData == null) {
            this.postData = new ArrayList<Map<String, Object>>();
        }
        return this.postData;
    }

    private String getPostDataKey() {
        return "ffiltergrid_pd";
    }

    public void filterGridF7CloseCallBack(FilterGridF7CloseCallBackEvent evt) {
        String accountId;
        String tenantCode = (String)this.getView().getFormShowParameter().getCustomParam("SourceTenant");
        if (!this.currentTenant(tenantCode, accountId = (String)this.getView().getFormShowParameter().getCustomParam("SourceDataCenter"))) {
            evt.setCancel(true);
            GetSimpleBaseDataParam param = new GetSimpleBaseDataParam();
            param.setSelectedRows(SerializationUtils.toJsonString((Object)evt.getRows()));
            param.setActionIds(evt.getActionIds());
            String result = CtBotpApiUtils.post((String)tenantCode, (String)accountId, (CtApiUrlEnum)CtApiUrlEnum.BUILDSIMPLEBASEDATA, (String)SerializationUtils.toJsonString((Object)param));
            Map openApiResult = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            String json = SerializationUtils.toJsonString(openApiResult.get("data"));
            SimpleBaseDataDto simpleBaseDataDto = (SimpleBaseDataDto)SerializationUtils.fromJsonString((String)json, SimpleBaseDataDto.class);
            evt.setValues(simpleBaseDataDto.getValues());
        }
    }

    private boolean currentTenant(String tenant, String accountId) {
        return tenant.equals(RequestContext.get().getTenantCode()) && accountId.equals(RequestContext.get().getAccountId());
    }
}

