/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.PropertyEditHelper;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.EntityMetadataUtil;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.extensible.ExtLockTypeEnum;
import kd.bos.metadata.extensible.ExtensibleDao;

public class CtLinkSetEdit
extends AbstractFormPlugin {
    private static final String KEY_TRACKER_TABLE = "cttrackertable";
    private static final String KEY_WBSNAP_TABLE = "ctwbsnaptable";
    private static final String KEY_PLUGIN = "ctplugin";
    private static final String KEY_CONVRULE_PLUGIN = "ctconvruleplugin";
    private static final String KEY_ENTITYLK = "ctentryentity_lk";
    private static final String KEY_PARENT_ENTITYID = "ctparententityid";
    private static final String KEY_LINK_ENTITY_KEY = "ctlinkentitykey";
    private static final String KEY_TABLENAME = "cttablename";
    private static final String KEY_CTRLFIELD = "ctctrlfield";
    private static final String KEY_CTRLFIELD_DESC = "ctctrlfielddesc";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_CANCEL = "btncancel";
    private static final String LINKSETKEY_TRACKER_TABLE = "CtTrackerTable";
    private static final String LINKSETKEY_WBSNAP_TABLE = "CtWbSnapTable";
    private static final String LINKSETKEY_PLUGINS = "CtPlugIns";
    private static final String LINKSETKEY_CONVRULE_PLUGINS = "CtConvRulePlugIns";
    private static final String LINKSETKEY_ITEMS = "Items";
    private static final String LINKSETKEY_LINK_ENTITYKEY = "CtLinkEntityKey";
    private static final String LINKSETKEY_PARENT_ENTITYID = "CtParentEntityId";
    private static final String LINKSETKEY_TABLENAME = "CtTableName";
    private static final String LINKSETKEY_CTRLFLDIDS = "CtCtrlFldIds";
    private static final String VALUE = "value";
    private EntityMetadata entityMeta;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL, KEY_PLUGIN, KEY_CONVRULE_PLUGIN, KEY_CTRLFIELD_DESC});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.lockOkButton();
        this.fillTrackTable();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object v = showParameter.getCustomParam(VALUE);
        if (v instanceof Map) {
            Map linkSet = (Map)showParameter.getCustomParam(VALUE);
            this.setLinkSet(linkSet);
        }
    }

    private void lockOkButton() {
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("itemId");
        if (entityId == null) {
            return;
        }
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        if (entityMetadata == null) {
            return;
        }
        ExtLockTypeEnum lockType = ExtensibleDao.getExtLockType((AbstractMetadata)entityMetadata, (String)"Field", (String)entityMetadata.getModelType(), (String)entityMetadata.getRootEntity().getPkId(), (String)"LinkSet");
        if (ExtLockTypeEnum.speciallock.equals((Object)lockType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_BTN_OK});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillEntityCombo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(KEY_PARENT_ENTITYID)) {
            this.changeParentEntity();
        }
        if (e.getProperty().getName().equalsIgnoreCase(KEY_CTRLFIELD_DESC) && StringUtils.isBlank((Object)e.getChangeSet()[0].getNewValue())) {
            this.getModel().setValue(KEY_CTRLFIELD, (Object)"");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrlSource = (Control)evt.getSource();
        if (ctrlSource.getKey().equalsIgnoreCase(KEY_BTN_OK)) {
            Map<String, Object> returnData = this.getListSet();
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else if (ctrlSource.getKey().equalsIgnoreCase(KEY_PLUGIN)) {
            this.showPlugForm(KEY_PLUGIN);
        } else if (ctrlSource.getKey().equalsIgnoreCase(KEY_CONVRULE_PLUGIN)) {
            this.showPlugForm(KEY_CONVRULE_PLUGIN);
        } else if (ctrlSource.getKey().equalsIgnoreCase(KEY_CTRLFIELD_DESC)) {
            this.showCtrlFieldList();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equalsIgnoreCase(KEY_CTRLFIELD_DESC)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTITYLK);
            this.setCtrlFields((String)e.getReturnData(), rowIndex);
        } else if (e.getActionId().equalsIgnoreCase(KEY_PLUGIN)) {
            if (e.getReturnData() == null) {
                return;
            }
            Map para = (Map)e.getReturnData();
            List plugins = (List)para.get(VALUE);
            this.setPlugs(KEY_PLUGIN, plugins);
        } else if (e.getActionId().equalsIgnoreCase(KEY_CONVRULE_PLUGIN)) {
            if (e.getReturnData() == null) {
                return;
            }
            Map para = (Map)e.getReturnData();
            List plugins = (List)para.get(VALUE);
            this.setPlugs(KEY_CONVRULE_PLUGIN, plugins);
        }
    }

    private EntityMetadata getEntityMetadata() {
        if (this.entityMeta != null) {
            return this.entityMeta;
        }
        List<Map<String, Object>> entityItems = this.getEntityItems();
        if (entityItems.size() > 0) {
            this.entityMeta = EntityMetadataUtil.getEntityMetadata(entityItems);
        }
        return this.entityMeta;
    }

    private List<Map<String, Object>> getEntityItems() {
        List context = (List)this.getView().getFormShowParameter().getCustomParams().get("context");
        if (context == null || context.size() == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        return (List)context.get(0);
    }

    private Entity<?, ?> getParentEntity(String parentEntityId) {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        Entity parentEntity = null;
        for (EntityItem entityItem : entityMetadata.getItems()) {
            if (entityItem instanceof MainEntity) {
                if (!parentEntityId.equalsIgnoreCase("billhead")) continue;
                parentEntity = (Entity)entityItem;
                break;
            }
            if (!(entityItem instanceof Entity) || !entityItem.getId().equalsIgnoreCase(parentEntityId)) continue;
            parentEntity = (Entity)entityItem;
            break;
        }
        return parentEntity;
    }

    private void changeParentEntity() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTITYLK);
        String parentEntityId = (String)this.getModel().getValue(KEY_PARENT_ENTITYID, rowIndex);
        if (StringUtils.isBlank((CharSequence)parentEntityId)) {
            return;
        }
        Entity<?, ?> parentEntity = this.getParentEntity(parentEntityId);
        if (parentEntity == null) {
            return;
        }
        String parentEntityKey = parentEntity instanceof MainEntity ? "billhead" : parentEntity.getKey();
        String parentTableName = parentEntity.getTableName();
        if (StringUtils.isNotBlank((CharSequence)parentEntityKey)) {
            this.getModel().setValue(KEY_LINK_ENTITY_KEY, (Object)(parentEntityKey + "_ctlk"), rowIndex);
        }
        if (StringUtils.isNotBlank((CharSequence)parentTableName)) {
            this.getModel().setValue(KEY_TABLENAME, (Object)(parentTableName + "_ctlk"), rowIndex);
        }
        this.getModel().setValue(KEY_CTRLFIELD, (Object)"", rowIndex);
        this.getModel().setValue(KEY_CTRLFIELD_DESC, (Object)"", rowIndex);
    }

    private void setLinkSet(Map<String, Object> linkSet) {
        String trackerTable = (String)linkSet.get(LINKSETKEY_TRACKER_TABLE);
        String wbsnapTable = (String)linkSet.get(LINKSETKEY_WBSNAP_TABLE);
        if (StringUtils.isNotBlank((CharSequence)trackerTable)) {
            this.getModel().setValue(KEY_TRACKER_TABLE, (Object)trackerTable);
        }
        if (StringUtils.isNotBlank((CharSequence)wbsnapTable)) {
            this.getModel().setValue(KEY_WBSNAP_TABLE, (Object)wbsnapTable);
        }
        List plugins = (List)linkSet.get(LINKSETKEY_PLUGINS);
        this.setPlugs(KEY_PLUGIN, plugins);
        List items = (List)linkSet.get(LINKSETKEY_ITEMS);
        if (items != null && items.size() > 0) {
            int rowCount = this.getModel().getEntryRowCount(KEY_ENTITYLK);
            if (rowCount < items.size()) {
                this.getModel().batchCreateNewEntryRow(KEY_ENTITYLK, items.size() - rowCount);
            }
            for (int i = 0; i < items.size(); ++i) {
                this.getModel().setEntryCurrentRowIndex(KEY_ENTITYLK, i);
                Map item = (Map)items.get(i);
                this.getModel().setValue(KEY_PARENT_ENTITYID, item.get(LINKSETKEY_PARENT_ENTITYID), i);
                this.getModel().setValue(KEY_LINK_ENTITY_KEY, item.get(LINKSETKEY_LINK_ENTITYKEY), i);
                this.getModel().setValue(KEY_TABLENAME, item.get(LINKSETKEY_TABLENAME), i);
                this.setCtrlFields((String)item.get(LINKSETKEY_CTRLFLDIDS), i);
            }
        }
    }

    private Map<String, Object> getListSet() {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("itemId", this.getView().getFormShowParameter().getCustomParams().get("itemId"));
        para.put("metaType", this.getView().getFormShowParameter().getCustomParams().get("metaType"));
        para.put("propertyName", this.getView().getFormShowParameter().getCustomParams().get("propertyName"));
        ArrayList items = new ArrayList();
        int rowIndex = this.getModel().getEntryRowCount(KEY_ENTITYLK);
        for (int i = 0; i < rowIndex; ++i) {
            String parentEntityId = (String)this.getModel().getValue(KEY_PARENT_ENTITYID, i);
            String linkEntityKey = (String)this.getModel().getValue(KEY_LINK_ENTITY_KEY, i);
            String tableName = (String)this.getModel().getValue(KEY_TABLENAME, i);
            String ctrlFieldIds = (String)this.getModel().getValue(KEY_CTRLFIELD, i);
            if (StringUtils.isBlank((CharSequence)parentEntityId)) continue;
            HashMap<String, String> item = new HashMap<String, String>();
            item.put(LINKSETKEY_PARENT_ENTITYID, parentEntityId);
            item.put(LINKSETKEY_LINK_ENTITYKEY, linkEntityKey);
            item.put(LINKSETKEY_TABLENAME, tableName);
            item.put(LINKSETKEY_CTRLFLDIDS, ctrlFieldIds);
            items.add(item);
        }
        String trackerTable = (String)this.getModel().getValue(KEY_TRACKER_TABLE);
        String wbSnapTable = (String)this.getModel().getValue(KEY_WBSNAP_TABLE);
        HashMap<String, Object> linkSet = new HashMap<String, Object>();
        linkSet.put(LINKSETKEY_TRACKER_TABLE, trackerTable);
        linkSet.put(LINKSETKEY_WBSNAP_TABLE, wbSnapTable);
        linkSet.put(LINKSETKEY_PLUGINS, this.getPlugs(KEY_PLUGIN));
        linkSet.put(LINKSETKEY_ITEMS, items);
        para.put(VALUE, linkSet);
        para.put("alias", trackerTable);
        return para;
    }

    private void fillTrackTable() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        if (entityMetadata == null) {
            return;
        }
        String trackerTable = "";
        String wbsnapTable = "";
        String mainTable = entityMetadata.getRootEntity().getTableName();
        if (StringUtils.isBlank((CharSequence)mainTable)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)trackerTable) && StringUtils.isNotBlank((CharSequence)mainTable)) {
            trackerTable = mainTable + "_cttc";
        }
        if (StringUtils.isBlank((CharSequence)wbsnapTable) && StringUtils.isNotBlank((CharSequence)mainTable)) {
            wbsnapTable = mainTable + "_ctwb";
        }
        this.getModel().setValue(KEY_TRACKER_TABLE, (Object)trackerTable);
        this.getModel().setValue(KEY_WBSNAP_TABLE, (Object)wbsnapTable);
    }

    private void fillEntityCombo() {
        List<ComboItem> comboItems = this.buildEntityItems();
        ComboEdit entryEditor = (ComboEdit)this.getView().getControl(KEY_PARENT_ENTITYID);
        entryEditor.setComboItems(comboItems);
    }

    private List<ComboItem> buildEntityItems() {
        String currLCId = Lang.get().toString();
        EntityMetadata entityMetadata = this.getEntityMetadata();
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        comboItems.add(blankItem);
        if (entityMetadata != null) {
            for (EntityItem entityItem : entityMetadata.getItems()) {
                ComboItem comboItem;
                if (entityItem instanceof MainEntity) {
                    comboItem = new ComboItem();
                    comboItem.setValue("billhead");
                    comboItem.setCaption(new LocaleString(currLCId, ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"LinkSetEdit_0", (String)"bos-botp-formplugin", (Object[])new Object[0])));
                    comboItems.add(comboItem);
                    continue;
                }
                if (!(entityItem instanceof Entity)) continue;
                comboItem = new ComboItem();
                comboItem.setValue(entityItem.getId());
                comboItem.setCaption(new LocaleString(currLCId, entityItem.getName().toString()));
                comboItems.add(comboItem);
            }
        }
        return comboItems;
    }

    private void showCtrlFieldList() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTITYLK);
        String parentEntityId = (String)this.getModel().getValue(KEY_PARENT_ENTITYID, rowIndex);
        if (StringUtils.isBlank((CharSequence)parentEntityId)) {
            return;
        }
        Entity<?, ?> parentEntity = this.getParentEntity(parentEntityId);
        if (parentEntity == null) {
            return;
        }
        EntityMetadata entityMetadata = this.getEntityMetadata();
        TreeNode rootNode = new TreeNode();
        rootNode.setChildren(new ArrayList());
        rootNode.setId("0");
        rootNode.setText(parentEntity.getName().toString());
        rootNode.setIsOpened(true);
        for (EntityItem entityItem : entityMetadata.getItems()) {
            boolean isMyField = false;
            if (parentEntityId.equalsIgnoreCase("billhead") && StringUtils.isBlank((CharSequence)entityItem.getParentId())) {
                isMyField = true;
            } else if (parentEntity.getId().equalsIgnoreCase(entityItem.getParentId())) {
                isMyField = true;
            }
            if (!isMyField || !(entityItem instanceof DecimalField) || entityItem instanceof BigIntField || entityItem instanceof IntegerField) continue;
            TreeNode node = new TreeNode();
            node.setId(entityItem.getId());
            node.setText(entityItem.getName().toString());
            node.setParentid("0");
            rootNode.addChild(node);
        }
        String ctrlFieldIds = (String)this.getModel().getValue(KEY_CTRLFIELD, rowIndex);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)rootNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("ismulti", "true");
        showParameter.getCustomParams().put("nodeids", ctrlFieldIds);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_CTRLFIELD_DESC));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void setCtrlFields(String selectedFieldIds, int rowIndex) {
        if (selectedFieldIds == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)selectedFieldIds)) {
            this.getModel().setValue(KEY_CTRLFIELD, (Object)"", rowIndex);
            this.getModel().setValue(KEY_CTRLFIELD_DESC, (Object)"", rowIndex);
            return;
        }
        this.getModel().setValue(KEY_CTRLFIELD, (Object)selectedFieldIds, rowIndex);
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String[] arr = StringUtils.split((String)selectedFieldIds, (String)",");
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String fieldId : arr) {
            EntityItem fieldItem = entityMetadata.getItemById(fieldId);
            if (fieldItem == null) continue;
            fieldNames.add(fieldItem.getName().toString());
        }
        this.getModel().setValue(KEY_CTRLFIELD_DESC, (Object)StringUtils.join((Object[])fieldNames.toArray(), (String)","), rowIndex);
    }

    private void showPlugForm(String key) {
        List<Map<String, Object>> plugins = this.getPlugs(key);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ide_plugins");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put(VALUE, plugins);
        PropertyEditHelper editHelper = new PropertyEditHelper();
        String modelType = editHelper.getModelType(this.getView());
        String scriptTypeFilter = StringUtils.equals((CharSequence)key, (CharSequence)KEY_PLUGIN) ? "writebackplugin" : "";
        String bizAppId = editHelper.getBizAppId(this.getView());
        EntityMetadata entityMetadata = EntityMetadataUtil.getEntityMetadata((List)editHelper.getEntityMeta(this.getView()));
        showParameter.getCustomParams().put("modelType", modelType);
        showParameter.getCustomParams().put("scriptfiltertype", scriptTypeFilter);
        showParameter.getCustomParams().put("bizappid", bizAppId);
        showParameter.getCustomParams().put("formId", entityMetadata.getRootEntity().getKey());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void setPlugs(String key, List<Map<String, Object>> plugins) {
        String cacheKey;
        String string = cacheKey = StringUtils.equals((CharSequence)key, (CharSequence)KEY_PLUGIN) ? LINKSETKEY_PLUGINS : LINKSETKEY_CONVRULE_PLUGINS;
        if (plugins == null || plugins.size() == 0) {
            this.getPageCache().put(cacheKey, "");
            this.getModel().setValue(key, (Object)"");
        } else {
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(plugins));
            ArrayList<String> plugNames = new ArrayList<String>();
            for (Map<String, Object> plugin : plugins) {
                String className = (String)plugin.get("ClassName");
                if (!StringUtils.isNotBlank((CharSequence)className)) continue;
                plugNames.add(className);
            }
            this.getModel().setValue(key, (Object)StringUtils.join((Object[])plugNames.toArray(), (String)";"));
        }
    }

    private List<Map<String, Object>> getPlugs(String key) {
        String cacheKey = StringUtils.equals((CharSequence)key, (CharSequence)KEY_PLUGIN) ? LINKSETKEY_PLUGINS : LINKSETKEY_CONVRULE_PLUGINS;
        String jsonStr = this.getPageCache().get(cacheKey);
        if (StringUtils.isBlank((CharSequence)jsonStr) || StringUtils.isBlank((Object)this.getModel().getValue(KEY_PLUGIN))) {
            return new ArrayList<Map<String, Object>>();
        }
        List plugIns = SerializationUtils.fromJsonStringToList((String)jsonStr, Map.class);
        return plugIns;
    }
}

