/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.ctbotp;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtLoadFuncTypesEventArgs;
import kd.bos.entity.ctbotp.runtime.CtConvertFuncLoader;
import kd.bos.entity.function.FunctionType;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.metadata.ctbotp.CtConvertRuleMetadata;
import kd.bos.metadata.ctbotp.CtRuleTreeNode;
import kd.bos.service.ctbotp.utils.CtTenantPathUtils;

public class CtRuleCacheHelper {
    private static final String BOS_CTBOTP_PLUGIN = "bos-ctbotp-formplugin";
    private static final String CACHEKEY_RULES = "Rules";
    private static final String CACHEKEY_SOURCE_BILL_TREENODE = "SourceBillTreeNode";

    public static void putRootRuleNode(AbstractFormPlugin plugin, CtRuleTreeNode rootNode) {
        String json = SerializationUtils.toJsonString((Object)rootNode);
        plugin.getPageCache().put(CACHEKEY_RULES, json);
    }

    public static CtRuleTreeNode getRootRuleNode(AbstractFormPlugin plugin) {
        String json = plugin.getPageCache().get(CACHEKEY_RULES);
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ece\u7f13\u5b58\u4e2d\u8bfb\u53d6\u8f6c\u6362\u89c4\u5219\u6811\u5931\u8d25\u3002", (String)"CtConvertRuleEdit_51", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        }
        CtRuleTreeNode rootNode = (CtRuleTreeNode)SerializationUtils.fromJsonString((String)json, CtRuleTreeNode.class);
        return rootNode;
    }

    public static CtConvertRuleMetadata getRule(AbstractFormPlugin plugin, String ruleId) {
        CtRuleTreeNode rootNode = CtRuleCacheHelper.getRootRuleNode(plugin);
        return CtRuleCacheHelper.getRule(rootNode, ruleId);
    }

    private static CtConvertRuleMetadata getRule(CtRuleTreeNode rootNode, String ruleId) {
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            return null;
        }
        CtRuleTreeNode currRuleNode = rootNode.searchRule(ruleId);
        if (currRuleNode == null) {
            String errMessage = MessageFormat.format(ResManager.loadKDString((String)"\u4ece\u7f13\u5b58\u4e2d\u8bfb\u53d6\u8f6c\u6362\u89c4\u5219[{0}]\u5931\u8d25\u3002", (String)"CtConvertRuleEdit_52", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]), ruleId);
            throw new KDBizException(errMessage);
        }
        CtConvertRuleMetadata ruleMetadata = currRuleNode.deserialize(rootNode);
        CtRuleCacheHelper.setTenantInfo(ruleMetadata.getRuleElement());
        return ruleMetadata;
    }

    public static CtRuleTreeNode addRule(AbstractFormPlugin plugin, CtConvertRuleMetadata ruleMetadata) {
        String currentIsv = ISVService.getISVInfo().getId();
        ruleMetadata.setIsv(currentIsv);
        CtRuleTreeNode rootNode = CtRuleCacheHelper.getRootRuleNode(plugin);
        CtConvertRuleMetadata parentRuleMeta = CtRuleCacheHelper.getRule(rootNode, ruleMetadata.getParentId());
        CtRuleTreeNode ruleNode = CtRuleTreeNode.buildRuleNode((CtConvertRuleMetadata)parentRuleMeta, (CtConvertRuleMetadata)ruleMetadata, (String)currentIsv);
        ruleNode.setNewed(true);
        if (StringUtils.isBlank((CharSequence)ruleMetadata.getParentId())) {
            rootNode.getChildren().put(ruleNode.getId(), ruleNode);
        } else {
            CtRuleTreeNode parentNode = rootNode.searchRule(ruleNode.getParentId());
            if (parentNode == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u628a\u89c4\u5219\u6dfb\u52a0\u5230\u89c4\u5219\u6811\u4e0a\u65f6\uff0c\u6ca1\u6709\u641c\u7d22\u5230\u7236\u7ea7\u89c4\u5219\uff0c\u6dfb\u52a0\u5931\u8d25\u3002", (String)"CtConvertRuleEdit_53", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
            }
            parentNode.getChildren().put(ruleNode.getId(), ruleNode);
        }
        CtRuleCacheHelper.putRootRuleNode(plugin, rootNode);
        return ruleNode;
    }

    public static void modifyRule(AbstractFormPlugin plugin, CtConvertRuleMetadata ruleMetadata) {
        CtRuleTreeNode rootNode = CtRuleCacheHelper.getRootRuleNode(plugin);
        CtRuleTreeNode ruleNode = rootNode.searchRule(ruleMetadata.getId());
        if (ruleNode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5728\u89c4\u5219\u6811\u4e0a\u6ca1\u6709\u627e\u5230\u5f53\u524d\u4fee\u6539\u7684\u89c4\u5219\uff0c\u66f4\u65b0\u89c4\u5219\u5931\u8d25\u3002", (String)"CtConvertRuleEdit_54", (String)BOS_CTBOTP_PLUGIN, (Object[])new Object[0]));
        }
        String currentIsv = ISVService.getISVInfo().getId();
        CtConvertRuleMetadata parentRuleMeta = CtRuleCacheHelper.getRule(rootNode, ruleMetadata.getParentId());
        CtRuleTreeNode newNode = CtRuleTreeNode.buildRuleNode((CtConvertRuleMetadata)parentRuleMeta, (CtConvertRuleMetadata)ruleMetadata, (String)currentIsv);
        ruleNode.setDesignJson(newNode.getDesignJson());
        ruleNode.setChanged(true);
        CtRuleCacheHelper.putRootRuleNode(plugin, rootNode);
    }

    public static CtRuleTreeNode deleteRule(AbstractFormPlugin plugin, String ruleId) {
        CtRuleTreeNode rootNode = CtRuleCacheHelper.getRootRuleNode(plugin);
        CtRuleTreeNode currNode = rootNode.searchRule(ruleId);
        if (currNode == null) {
            return null;
        }
        currNode.setDeleted(true);
        List allChildren = currNode.mergeAllChildren();
        for (CtRuleTreeNode node : allChildren) {
            node.setDeleted(true);
        }
        CtRuleCacheHelper.putRootRuleNode(plugin, rootNode);
        CtRuleTreeNode parentNode = rootNode.searchRule(currNode.getParentId());
        if (parentNode == null) {
            for (CtRuleTreeNode node : rootNode.getChildren().values()) {
                if (node.isDeleted()) continue;
                return node;
            }
            return null;
        }
        return parentNode;
    }

    public static String getSourceEntityNumber(IFormView view) {
        Map sourceMap = (Map)view.getFormShowParameter().getCustomParam("sourceInfo");
        return (String)sourceMap.get("SourceBill");
    }

    public static String getSourceBizAppId(IFormView view) {
        Map sourceMap = (Map)view.getFormShowParameter().getCustomParam("sourceInfo");
        return (String)sourceMap.get("SourceAppId");
    }

    public static String getSourceTenant(IFormView view) {
        return view.getPageCache().get("SourceTenant");
    }

    public static String getSourceDataCenter(IFormView view) {
        return view.getPageCache().get("SourceDataCenter");
    }

    public static String getTargetEntityNumber(IFormView view) {
        Map sourceMap = (Map)view.getFormShowParameter().getCustomParam("targetInfo");
        return (String)sourceMap.get("TargetBill");
    }

    public static String getTargetAppId(IFormView view) {
        Map sourceMap = (Map)view.getFormShowParameter().getCustomParam("targetInfo");
        return (String)sourceMap.get("TargetAppId");
    }

    public static String getTargetTenant(IFormView view) {
        return view.getPageCache().get("TargetTenant");
    }

    public static String getTargetDataCenter(IFormView view) {
        return view.getPageCache().get("TargetDataCenter");
    }

    public static String getSourceBillTreeNode(AbstractFormPlugin plugin) {
        String json = plugin.getPageCache().get(CACHEKEY_SOURCE_BILL_TREENODE);
        return json;
    }

    public static String putSourceBillTreeNode(AbstractFormPlugin plugin, String billNodeJson) {
        plugin.getPageCache().put(CACHEKEY_SOURCE_BILL_TREENODE, billNodeJson);
        return billNodeJson;
    }

    public static String getFuncsXML(AbstractFormPlugin plugin) {
        String funcsXML = plugin.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = FunctionTypes.getCommonFuncs();
            FunctionTypes cloudFunc = CtConvertFuncLoader.loadBizCloudFuncTypes();
            functionTypes.getFunctionGroups().addAll(cloudFunc.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(cloudFunc.getFunctionTypes());
            CtLoadFuncTypesEventArgs args = new CtLoadFuncTypesEventArgs(functionTypes);
            ArrayList<FunctionType> removefunctionTypeList = new ArrayList<FunctionType>();
            List functionTypeList = args.getFuncTypes().getFunctionTypes();
            for (FunctionType functionType : functionTypeList) {
                String groupId = functionType.getGroupId();
                if (!groupId.equals("Common") && !groupId.equals("MultiSelectBaseData") && !groupId.equals("BOTP") && !groupId.equals("BD")) continue;
                removefunctionTypeList.add(functionType);
            }
            functionTypeList.removeAll(removefunctionTypeList);
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)args.getFuncTypes());
            plugin.getPageCache().put("functiontypes", funcsXML);
        }
        return funcsXML;
    }

    public static void setTenantInfo(CtConvertRuleElement ruleElement) {
        DynamicObject tenantPath;
        if (StringUtils.isNotBlank((CharSequence)ruleElement.getTenantPath()) && (tenantPath = CtTenantPathUtils.getTenantPath((String)ruleElement.getTenantPath())) != null) {
            DynamicObject sourceTenant = (DynamicObject)tenantPath.get("sourcetenant");
            ruleElement.setSourceTenant(sourceTenant.getString("tenantid"));
            ruleElement.setSourceDataCenter(sourceTenant.getString("accountid"));
            ruleElement.setSourceAccountNumber(sourceTenant.getString("accountnumber"));
            DynamicObject targetTenant = (DynamicObject)tenantPath.get("targettenant");
            ruleElement.setTargetTenant(targetTenant.getString("tenantid"));
            ruleElement.setTargetDataCenter(targetTenant.getString("accountid"));
            ruleElement.setTargetAccountNumber(targetTenant.getString("accountnumber"));
        }
    }
}

