/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.designer.property.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtConvertBill;
import kd.bos.entity.ctbotp.CtDataCenter;
import kd.bos.entity.ctbotp.CtTenantData;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.runtime.CtConvertOpRule;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.AbstractOpParameterPlugin;
import kd.bos.metadata.entity.operation.CtPushParameter;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.util.CollectionUtils;

public class CtPushOpEditPlugin
extends AbstractOpParameterPlugin<CtPushParameter> {
    private static final String BOS_CTBOTP_FORMPLUGIN = "bos-ctbotp-formplugin";
    private static Log log = LogFactory.getLog(CtPushOpEditPlugin.class);
    private static final String KEY_TTENANTCODE = "ttenantcode";
    private static final String KEY_TACCOUNTID = "taccountid";
    private static final String KEY_HIDEPUSHFORM = "hidepushform";
    private static final String KEY_BILL = "targetbill";
    private static final String KEY_SYNCTYPE = "synctype";
    private static final String KEY_RULE = "rule";
    private static final String KEY_HASRIGHT = "hasright";
    private static final String KEY_MUSTSELECTRULE = "mustselectrule";
    private static final String BOTP_TENANTDATA = "ct_botp_tenantdata";
    private static final String ALL_RULE = "@all";
    private CtPushParameter ctPushParameter = new CtPushParameter();

    public boolean check(StringBuilder sbMsg) {
        boolean hidepushform = (Boolean)this.getModel().getValue(KEY_HIDEPUSHFORM);
        String targetBill = (String)this.getModel().getValue(KEY_BILL);
        String rule = (String)this.getModel().getValue(KEY_RULE);
        if (hidepushform && StringUtils.isBlank((CharSequence)targetBill)) {
            sbMsg.append(ResManager.loadKDString((String)"\u60a8\u52fe\u9009\u4e86\u201c\u8df3\u8fc7\u6570\u636e\u534f\u540c\u9009\u62e9\u53c2\u6570\u754c\u9762\u201d\u9009\u9879\uff0c\u5fc5\u987b\u8bbe\u7f6e\u597d\u4e0b\u63a8\u76ee\u6807\u5355\u636e\u3002", (String)"CtPushOpEditPlugin_0", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        if (hidepushform && StringUtils.isBlank((CharSequence)rule)) {
            sbMsg.append(ResManager.loadKDString((String)"\u60a8\u52fe\u9009\u4e86\u201c\u8df3\u8fc7\u6570\u636e\u534f\u540c\u9009\u62e9\u53c2\u6570\u754c\u9762\u201d\u9009\u9879\uff0c\u5fc5\u987b\u8bbe\u7f6e\u597d\u6570\u636e\u534f\u540c\u89c4\u5219\u3002", (String)"CtPushOpEditPlugin_2", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected CtPushParameter createNewOpParameter() {
        return new CtPushParameter();
    }

    protected IDataEntityType getDataEntityType() {
        return DataEntityType.getDataEntityType(CtPushParameter.class);
    }

    protected void showParameter(CtPushParameter v) {
        this.ctPushParameter = v;
        this.getModel().setValue(KEY_HIDEPUSHFORM, (Object)v.getHidePushForm());
        this.getModel().setValue(KEY_BILL, (Object)v.getTargetBill());
        this.getModel().setValue(KEY_RULE, (Object)v.getRuleId());
        this.getModel().setValue(KEY_TTENANTCODE, (Object)v.gettTenantCode());
        this.getModel().setValue(KEY_TACCOUNTID, (Object)v.gettAccountId());
        if (!StringUtils.isBlank((CharSequence)v.getSyncType())) {
            this.getModel().setValue(KEY_SYNCTYPE, (Object)v.getSyncType());
        }
        if (this.getModel().getProperty(KEY_HASRIGHT) != null) {
            this.getModel().setValue(KEY_HASRIGHT, (Object)v.isHasRight());
        }
        if (this.getModel().getProperty(KEY_MUSTSELECTRULE) != null) {
            this.getModel().setValue(KEY_MUSTSELECTRULE, (Object)v.isMustSelectRule());
        }
    }

    protected void returnParameter(CtPushParameter v) {
        v.setHidePushForm(((Boolean)this.getModel().getValue(KEY_HIDEPUSHFORM)).booleanValue());
        v.setTargetBill((String)this.getModel().getValue(KEY_BILL));
        v.setRuleId((String)this.getModel().getValue(KEY_RULE));
        v.settTenantCode((String)this.getModel().getValue(KEY_TTENANTCODE));
        v.settAccountId((String)this.getModel().getValue(KEY_TACCOUNTID));
        v.setSyncType((String)this.getModel().getValue(KEY_SYNCTYPE));
        if (this.getModel().getProperty(KEY_HASRIGHT) != null) {
            v.setHasRight(((Boolean)this.getModel().getValue(KEY_HASRIGHT)).booleanValue());
        }
        if (this.getModel().getProperty(KEY_MUSTSELECTRULE) != null) {
            v.setMustSelectRule(((Boolean)this.getModel().getValue(KEY_MUSTSELECTRULE)).booleanValue());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.fillTenantCombo();
        this.fillAccountCombo();
        this.fillBillCombo();
        this.fillRuleCombo();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)KEY_TTENANTCODE, (CharSequence)e.getProperty().getName())) {
            this.fillAccountCombo();
            this.fillBillCombo();
            this.fillRuleCombo();
        } else if (StringUtils.equals((CharSequence)KEY_TACCOUNTID, (CharSequence)e.getProperty().getName())) {
            this.fillBillCombo();
            this.fillRuleCombo();
        } else if (StringUtils.equals((CharSequence)KEY_BILL, (CharSequence)e.getProperty().getName())) {
            this.fillRuleCombo();
        } else if (StringUtils.equals((CharSequence)KEY_SYNCTYPE, (CharSequence)e.getProperty().getName())) {
            this.fillRuleCombo();
        }
    }

    private void fillTenantCombo() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String id = entityMetadata.getRootEntity().getId();
        String masterId = MetadataDao.getMasterId((String)id);
        String srcEntityNumber = MetadataDao.getNumberById((String)(StringUtils.isBlank((CharSequence)masterId) ? id : masterId));
        List<ComboItem> tenantItems = this.buildTenantItems(srcEntityNumber);
        if (CollectionUtils.isEmpty(tenantItems)) {
            return;
        }
        ComboEdit tenantEditor = (ComboEdit)this.getView().getControl(KEY_TTENANTCODE);
        tenantEditor.setComboItems(tenantItems);
    }

    private List<ComboItem> buildTenantItems(String entityNumber) {
        List tenantDatas = CtConvertMetaServiceHelper.loadTenantDatas((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)entityNumber);
        if (CollectionUtils.isEmpty((Collection)tenantDatas)) {
            return null;
        }
        this.getView().getPageCache().put(BOTP_TENANTDATA, SerializationUtils.toJsonString((Object)tenantDatas));
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        for (CtTenantData tenantData : tenantDatas) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(tenantData.getTenantNumber());
            billItem.setCaption(new LocaleString(Lang.defaultLang().toString(), tenantData.getTenantName()));
            billItems.add(billItem);
        }
        return billItems;
    }

    private void fillAccountCombo() {
        CtTenantData currTenant = this.getCurrCtTenant();
        if (currTenant == null) {
            this.cleanComboEdit(KEY_TACCOUNTID);
            return;
        }
        ArrayList<ComboItem> dataCenterItems = new ArrayList<ComboItem>(10);
        for (CtDataCenter dataCenter : currTenant.getDataCenter().values()) {
            ComboItem dataCenterItem = new ComboItem();
            dataCenterItem.setValue(dataCenter.getDataCenterNumber());
            dataCenterItem.setCaption(new LocaleString(dataCenter.getDataCenterName()));
            dataCenterItems.add(dataCenterItem);
        }
        if (dataCenterItems.isEmpty()) {
            this.cleanComboEdit(KEY_TACCOUNTID);
            return;
        }
        ComboEdit dataCenterEditor = (ComboEdit)this.getView().getControl(KEY_TACCOUNTID);
        dataCenterEditor.setComboItems(dataCenterItems);
        if (dataCenterItems.isEmpty()) {
            this.getModel().setValue(KEY_TACCOUNTID, (Object)"");
        }
        String tAccountId = this.ctPushParameter.gettAccountId();
        if (currTenant.getDataCenter().containsKey(tAccountId)) {
            this.getModel().setValue(KEY_TACCOUNTID, (Object)tAccountId);
        } else {
            this.getModel().setValue(KEY_TACCOUNTID, (Object)"");
        }
    }

    private CtTenantData getCurrCtTenant() {
        try {
            String teantData = this.getView().getPageCache().get(BOTP_TENANTDATA);
            if (StringUtils.isBlank((CharSequence)teantData)) {
                return null;
            }
            List tenantDatas = SerializationUtils.fromJsonStringToList((String)teantData, CtTenantData.class);
            Object tenant = this.getModel().getValue(KEY_TTENANTCODE);
            if (StringUtils.isBlank((Object)tenant)) {
                return null;
            }
            for (CtTenantData tenantData : tenantDatas) {
                if (!tenant.equals(tenantData.getTenantNumber())) continue;
                return tenantData;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u79df\u6237\u4fe1\u606f\u3002", (String)"CtPushOpEditPlugin_1", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
    }

    private void fillBillCombo() {
        CtTenantData currTenant = this.getCurrCtTenant();
        if (currTenant == null) {
            this.cleanComboEdit(KEY_BILL);
            return;
        }
        Object dataCenterNumber = this.getModel().getValue(KEY_TACCOUNTID);
        if (StringUtils.isBlank((Object)dataCenterNumber)) {
            this.cleanComboEdit(KEY_BILL);
            return;
        }
        CtDataCenter dataCenter = (CtDataCenter)currTenant.getDataCenter().get(dataCenterNumber);
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        billItems.add(blankItem);
        for (CtConvertBill bill : dataCenter.getBills().values()) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(bill.getEntityNumber());
            billItem.setCaption(new LocaleString(Lang.defaultLang().toString(), bill.getEntityName()));
            billItems.add(billItem);
        }
        if (billItems.isEmpty()) {
            this.cleanComboEdit(KEY_BILL);
            return;
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_BILL);
        billEditor.setComboItems(billItems);
        if (billItems.isEmpty()) {
            this.getModel().setValue(KEY_BILL, (Object)"");
        }
        String targetBill = this.ctPushParameter.getTargetBill();
        if (dataCenter.getBills().containsKey(targetBill)) {
            this.getModel().setValue(KEY_BILL, (Object)targetBill);
        } else {
            this.getModel().setValue(KEY_BILL, (Object)"");
        }
    }

    private void fillRuleCombo() {
        CtTenantData currTenant = this.getCurrCtTenant();
        Object dataCenterNumber = this.getModel().getValue(KEY_TACCOUNTID);
        if (StringUtils.isBlank((Object)dataCenterNumber)) {
            this.cleanComboEdit(KEY_RULE);
            return;
        }
        if (currTenant == null) {
            log.error("currTenant is null");
            return;
        }
        CtDataCenter dataCenter = (CtDataCenter)currTenant.getDataCenter().get(dataCenterNumber);
        Object billNumber = this.getModel().getValue(KEY_BILL);
        if (StringUtils.isBlank((Object)billNumber)) {
            this.cleanComboEdit(KEY_RULE);
            return;
        }
        CtConvertBill bill = (CtConvertBill)dataCenter.getBills().get(billNumber);
        ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>();
        Object syncType = this.getModel().getValue(KEY_SYNCTYPE);
        if (syncType == null) {
            syncType = SyncTypeEnum.FORWARD.getValue();
        }
        if (bill != null) {
            for (CtConvertOpRule rule : bill.getRules()) {
                if (!syncType.equals(rule.getSyncType())) continue;
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(rule.getRuleId());
                ruleItem.setCaption(new LocaleString(rule.getRuleName()));
                ruleItems.add(ruleItem);
            }
        }
        if (ruleItems.isEmpty()) {
            this.cleanComboEdit(KEY_RULE);
            return;
        }
        ComboEdit ruleEditor = (ComboEdit)this.getView().getControl(KEY_RULE);
        ruleEditor.setComboItems(ruleItems);
        if (ruleItems.isEmpty()) {
            this.getModel().setValue(KEY_RULE, (Object)"");
        }
    }

    private String getEntityNumber() {
        EntityMetadata entityMetadata = this.getEntityMetadata();
        String id = entityMetadata.getRootEntity().getId();
        String masterId = MetadataDao.getMasterId((String)id);
        String srcEntityNumber = MetadataDao.getNumberById((String)(StringUtils.isBlank((CharSequence)masterId) ? id : masterId));
        return srcEntityNumber;
    }

    private void cleanComboEdit(String key) {
        ArrayList items = new ArrayList();
        ComboEdit ruleEditor = (ComboEdit)this.getView().getControl(key);
        ruleEditor.setComboItems(items);
        this.getModel().setValue(key, (Object)"");
    }
}

