/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin.ctbotp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.hosting.SVNUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.plugin.ctbotp.CtRuleCompatibleImport;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.balance.DesignBalanceRuleMeta;
import kd.bos.metadata.balance.DesignBalanceRuleMetaL;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;
import kd.bos.metadata.ctbotp.CtMetadataDao;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.deploy.DeployFile;

public class CtBOTPFileUtil {
    private static final Log logger = LogFactory.getLog(CtBOTPFileUtil.class);
    private static final String SUBPATH_METADATA = "metadata";
    public static final String Type_ConvertRule = "ctcr";
    public static final String Type_WriteBackRule = "wb";
    public static final String Type_BalanceUpdateRule = "bur";
    private static final String KEY_ERROR = "error";
    private static final String BOS_CTBOTP_FORMPLUGIN = "bos-ctbotp-formplugin";
    private String ruleType;
    private MainEntityType targetMainEntityType;
    private MainEntityType sourceMainEntityType;

    public CtBOTPFileUtil(String ruleType) {
        this.ruleType = ruleType;
    }

    public FormShowParameter buildExportShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_exportpath");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public String exportRule(String exportPath, String[] ruleIds, JSONObject exportResult) {
        ArrayList<String> exportFiles = new ArrayList<String>();
        this.exportRulesFile(exportPath, ruleIds, exportFiles, exportResult);
        if (exportResult.get((Object)KEY_ERROR) != null) {
            return "";
        }
        this.zipFiles(ruleIds[0], exportPath);
        AppUtils.deleteFiles((String)exportPath);
        exportResult.put("success", (Object)ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"CtBOTPFileUtil_19", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
        File zipFile = new File(DevportalUtil.checkFilePath((String)(exportPath + File.separator + ruleIds[0] + ".zip")));
        if (zipFile.exists()) {
            return zipFile.getPath();
        }
        return "";
    }

    public FormShowParameter buildImportShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ctbotp_importfile");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    public boolean importRule(String zipFileName, JSONObject importResult) {
        String localPath = DevportalUtil.unZipSingleFile((String)zipFileName, (JSONObject)importResult);
        if (importResult.get((Object)KEY_ERROR) != null) {
            return false;
        }
        String xmlFileSuffix = "." + this.ruleType;
        String langFileSuffix = "." + this.ruleType + "x";
        String MetadataFilePath = localPath + File.separator + SUBPATH_METADATA;
        String checkMetadataFilePath = DevportalUtil.checkFilePath((String)MetadataFilePath);
        File MetadataFile = new File(checkMetadataFilePath);
        String[] MetadataFileList = MetadataFile.list();
        for (int i = 0; i < MetadataFileList.length; ++i) {
            String fullFileName;
            File file;
            String fileName = MetadataFileList[i];
            if (!fileName.endsWith(xmlFileSuffix) && !fileName.endsWith(langFileSuffix) || !(file = new File(fullFileName = checkMetadataFilePath + File.separator + fileName)).exists()) continue;
            Path filePath = Paths.get(DevportalUtil.checkFilePath((String)fullFileName), new String[0]);
            try (InputStream in = Files.newInputStream(filePath, new OpenOption[0]);){
                byte[] b = new byte[(int)file.length()];
                int count = 0;
                while ((count = in.read(b)) > 0) {
                    String content = new String(b, StandardCharsets.UTF_8);
                    MetadataDao.deployMetadata((String)content, null, null);
                }
                continue;
            }
            catch (IOException e) {
                importResult.put(KEY_ERROR, (Object)String.format(ResManager.loadKDString((String)"%s\u683c\u5f0f\u6587\u4ef6\u5bfc\u5165\u51fa\u9519\u3002", (String)"CtBOTPFileUtil_11", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]), this.ruleType));
            }
        }
        AppUtils.deleteFiles((String)localPath);
        importResult.put("success", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"CtBOTPFileUtil_10", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean uploadRule(String fileUrl, JSONObject importResult) {
        String xmlFileSuffix = "." + this.ruleType;
        String langFileSuffix = "." + this.ruleType + "x";
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content zipContent = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            zipContent = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        }
        catch (MalformedURLException exp) {
            importResult.put("ERROR", (Object)exp);
            return false;
        }
        int limitsiz = 0x500000;
        try {
            InputStream inStream = zipContent.getInputStream();
            Object object = null;
            try (ZipInputStream zipIn = new ZipInputStream(inStream);){
                ZipEntry zipEntry = null;
                while ((zipEntry = zipIn.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    String metaName = zipEntry.getName();
                    if (!metaName.startsWith(SUBPATH_METADATA) || !metaName.endsWith(this.ruleType) && !metaName.endsWith(this.ruleType + "x")) {
                        importResult.put("ERROR", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u4e0e\u5bfc\u51fa\u7684\u6587\u4ef6\u683c\u5f0f\u5fc5\u987b\u4fdd\u6301\u4e00\u81f4\u3002", (String)"CtBOTPFileUtil_12", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
                        boolean bl = false;
                        return bl;
                    }
                    int readLength = 0;
                    int len = 0;
                    byte[] buf = new byte[limitsiz];
                    if (!metaName.endsWith(xmlFileSuffix) && !metaName.endsWith(langFileSuffix)) continue;
                    while ((readLength = zipIn.read()) != -1) {
                        buf[len] = (byte)readLength;
                        ++len;
                    }
                    String xmlContent = new String(buf, 0, len, "UTF-8");
                    if (metaName.endsWith("cr")) {
                        CtRuleCompatibleImport ruleCompatibleImport = new CtRuleCompatibleImport(0);
                        ruleCompatibleImport.doCompatible(xmlContent, importResult);
                    }
                    MetadataDao.deployMetadata((String)xmlContent, null, null);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inStream != null) {
                    if (object != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inStream.close();
                    }
                }
            }
        }
        catch (Exception e) {
            importResult.put("ERROR", (Object)e);
            return false;
        }
        importResult.put("SUCCESS", (Object)ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"CtBOTPFileUtil_10", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
        return true;
    }

    public FormShowParameter buildCheckInShowParameter(String[] ruleIds, JSONObject buildResult) {
        if (ruleIds == null || ruleIds.length == 0) {
            buildResult.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"\u8bf7\u63d0\u4ea4\u9700\u8981\u7684\u89c4\u5219\u201cruleIds\u201d\u3002", (String)"CtBOTPFileUtil_1", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("bos_devportal_svn_login");
        showParameter.setCustomParam("type", (Object)this.ruleType);
        showParameter.setCustomParam("issave", (Object)Boolean.FALSE);
        Class<DesignConvertRuleMeta> designMetaClass = null;
        if (this.ruleType.equals(Type_ConvertRule)) {
            designMetaClass = DesignConvertRuleMeta.class;
        } else if (this.ruleType.equals(Type_WriteBackRule)) {
            designMetaClass = DesignWriteBackRuleMeta.class;
        } else if (this.ruleType.equals(Type_BalanceUpdateRule)) {
            designMetaClass = DesignBalanceRuleMeta.class;
        }
        if (designMetaClass == null) {
            buildResult.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"ruleType\u53ea\u80fd\u652f\u6301cr, wb, bur", (String)"CtBOTPFileUtil_2", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        Object[] designMetas = BusinessDataReader.load((Object[])ruleIds, (IDataEntityType)OrmUtils.getDataEntityType(designMetaClass));
        JSONArray idsArray = new JSONArray();
        HashSet<String> bizAppIds = new HashSet<String>();
        for (Object designMeta : designMetas) {
            String ruleId = ((DesignMeta)designMeta).getId();
            String bizAppId = ((DesignMeta)designMeta).getBizappId();
            idsArray.add((Object)ruleId);
            if (!StringUtils.isNotBlank((CharSequence)bizAppId) || bizAppIds.contains(bizAppId)) continue;
            bizAppIds.add(bizAppId);
        }
        if (idsArray.size() == 0) {
            buildResult.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u89c4\u5219\u3002", (String)"CtBOTPFileUtil_3", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        if (bizAppIds.size() == 0) {
            buildResult.put(KEY_ERROR, (Object)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u63d0\u4ea4\uff0c\u627e\u4e0d\u5230\u9700\u8981\u63d0\u4ea4\u7684%s\u8def\u5f84\uff0c\u539f\u56e0\u662f\u672a\u660e\u786e\u89c4\u5219\u6240\u5c5e\u7684\u5e94\u7528\u3002", (String)"CtBOTPFileUtil_4", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]), "svn"));
            return null;
        }
        if (bizAppIds.size() > 1) {
            buildResult.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"\u8bf7\u5206\u5f00\u63d0\u4ea4\uff0c\u6bcf\u6b21\u53ea\u80fd\u63d0\u4ea4\u5c5e\u4e8e\u4e00\u4e2a\u5e94\u7528\u7684\u89c4\u5219\u3002", (String)"CtBOTPFileUtil_5", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return null;
        }
        showParameter.setCustomParam("ruleids", (Object)idsArray.toJSONString());
        showParameter.setCustomParam("bizappid", bizAppIds.iterator().next());
        return showParameter;
    }

    public JSONObject chickInRule(JSONObject svnMsg, JSONArray idsArray, String bizAppId) {
        String property = System.getProperty("user.home");
        String filePath = property + File.separator + SUBPATH_METADATA;
        String localPath = svnMsg.getString("localpath");
        String checkLocalPath = DevportalUtil.checkFilePath((String)localPath);
        AppUtils.deleteFile((String)localPath);
        File file = new File(checkLocalPath);
        if (file.exists()) {
            AppUtils.deleteFile((String)localPath);
        }
        HashSet<String> ruleIds = new HashSet<String>();
        for (int i = 0; i < idsArray.size(); ++i) {
            String ruleId = idsArray.getString(i);
            if (!StringUtils.isNotBlank((CharSequence)ruleId) || ruleIds.contains(ruleId)) continue;
            ruleIds.add(ruleId);
        }
        if ((svnMsg = SVNUtil.checkOutFiles((JSONObject)svnMsg)).get((Object)KEY_ERROR) != null) {
            return svnMsg;
        }
        ArrayList<String> exportFiles = new ArrayList<String>();
        this.exportRulesFile(localPath, ruleIds.toArray(new String[ruleIds.size()]), exportFiles, svnMsg);
        if (svnMsg.get((Object)KEY_ERROR) != null) {
            return svnMsg;
        }
        if (exportFiles.size() > 0) {
            svnMsg = SVNUtil.commitToSVN(exportFiles, (JSONObject)svnMsg);
        } else {
            svnMsg.put(KEY_ERROR, (Object)ResManager.loadKDString((String)"\u7b7e\u5165\u6587\u4ef6\u4e3a\u7a7a", (String)"CtBOTPFileUtil_8", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
        }
        return svnMsg;
    }

    public void exportRulesFile(String exportPath, String[] ruleIds, List<String> exportFiles, JSONObject checkInMsg) {
        for (String ruleId : ruleIds) {
            this.exportRuleFile(exportPath, ruleId, exportFiles, checkInMsg);
        }
    }

    public void exportRuleFile(String exportPath, String ruleId, List<String> exportFiles, JSONObject checkInMsg) {
        List list = null;
        if (!this.ruleType.equals(Type_ConvertRule)) {
            return;
        }
        list = CtMetadataDao.getCtConvertRuleDeployFile((String)ruleId);
        for (DeployFile deployFile : list) {
            String fileContent;
            String fileName = deployFile.getFileName();
            String exportFile = this.saveMetaXmlFile(exportPath, fileName, fileContent = deployFile.getFileContent(), checkInMsg);
            if (!StringUtils.isNotBlank((CharSequence)exportFile)) continue;
            exportFiles.add(exportFile);
        }
    }

    public static List<DeployFile> getRuleFile(String ruleType, String ruleId) {
        List list = null;
        if (ruleType.endsWith(Type_ConvertRule)) {
            list = MetadataDao.getConvertRuleDeployFile((String)ruleId);
        } else if (ruleType.endsWith(Type_WriteBackRule)) {
            list = MetadataDao.getWriteBackRuleDeployFile((String)ruleId);
        } else if (ruleType.endsWith(Type_BalanceUpdateRule)) {
            IDataEntityType designMetaType = OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class);
            IDataEntityType designMetaType_Lang = OrmUtils.getDataEntityType(DesignBalanceRuleMetaL.class);
            list = MetadataDao.getCustMetadataDeployFile((String)ruleId, (IDataEntityType)designMetaType, (IDataEntityType)designMetaType_Lang, (String)Type_BalanceUpdateRule);
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    private String saveMetaXmlFile(String exportPath, String fileName, String fileContext, JSONObject checkInMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getMetaXmlPath(String exportPath, String filename) {
        String fullPath = String.format("%s/%s/%s", exportPath, SUBPATH_METADATA, filename);
        return fullPath;
    }

    private void zipFiles(String zipName, String zipPath) {
        JSONArray files = new JSONArray();
        String zipCheckPath = DevportalUtil.checkFilePath((String)zipPath);
        File file = new File(DevportalUtil.checkFilePath((String)zipCheckPath));
        if (file.exists()) {
            files.add((Object)zipCheckPath);
        }
        String zipFilePath = zipCheckPath + File.separator + zipName + ".zip";
        Path customZipPath = Paths.get(zipFilePath, new String[0]);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(customZipPath, new OpenOption[0]));){
            this.zipFile(files, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void zipFile(JSONArray files, ZipOutputStream out) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File(DevportalUtil.checkFilePath((String)((String)files.get(i))));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                if (listFiles != null) {
                    for (File tempFile : listFiles) {
                        try {
                            tempFiles.add((Object)tempFile.getCanonicalPath());
                        }
                        catch (IOException e) {
                            logger.error((Throwable)e);
                        }
                    }
                }
                this.zipFile(tempFiles, out);
                continue;
            }
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
            if (path == null) continue;
            Path zipPath = Paths.get(DevportalUtil.checkFilePath((String)path), new String[0]);
            int t = -1;
            if (path != null && path.contains(SUBPATH_METADATA)) {
                t = path.indexOf(SUBPATH_METADATA);
            }
            if (t == -1) continue;
            if ((path = path.substring(t, path.length())) != null && path.contains("\\")) {
                path = path.replace('\\', '/');
            }
            try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

