/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devportal.plugin.ctbotp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.designer.ctbotp.CtConvertRuleRightChecker;
import kd.bos.devportal.business.git.GitContext;
import kd.bos.devportal.business.git.GitOperateHandler;
import kd.bos.devportal.business.git.GitOperationUtils;
import kd.bos.devportal.business.hosting.GitOperationUtil;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.devportal.plugin.ctbotp.CtBOTPFileUtil;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.balance.DesignBalanceRuleMeta;
import kd.bos.metadata.botp.DesignConvertRuleMeta;
import kd.bos.metadata.botp.DesignWriteBackRuleMeta;

public class CtBOTPListFilePlugin
extends AbstractTreeListPlugin {
    private static final Log logger = LogFactory.getLog(CtBOTPListFilePlugin.class);
    private static final String BTNCHECKIN = "btncheckin";
    private static final String BTNGIT = "btngit";
    private static final String BTNGIT_COMMIT = "commit";
    private static final String BTNGIT_PUSH = "push";
    private static final String BTNGIT_REVERT = "revert";
    private static final String BTNGIT_PULL = "pull";
    private static final String BTNEXPORT = "btnexport";
    private static final String BTNIMPORT = "btnimport";
    private static final String BOS_DEVPORTAL_PLUGIN = "bos-ctbotp-formplugin";
    private static final String GITMSG = "gitmsg";
    private static final String COMMIT = "commit";
    private static final String SUCCESS = "success";
    private static final String GIT_COMMIT_NEW_CALLBACK = "gitCommitNewCallBack";
    private static final String GIT_COMMIT_PUSH_CONFIRM_BACK = "gitCommitAndPushConfirmBack";
    private static final String GIT_PULL_UPDATE_META_CALLBACK = "gitPullUpdateMetaCallBack";
    private static final String GIT_PULL_CONFLICT_CALLBACK = "gitPullConflictCallBack";
    private static final String GIT_PUSH_NEW_CALLBACK = "gitPushNewCallBack";
    private static final String GIT_RESTORE_CALL_BACK = "gitRestoreCallBack";

    public void initialize() {
        super.initialize();
        boolean isDevelopEnv = DevportalUtil.isDevelopEnv();
        boolean isGitManageType = DevportalUtil.isGitManageType();
        this.getView().setVisible(Boolean.valueOf(isDevelopEnv && isGitManageType), new String[]{BTNGIT});
        this.getView().setVisible(Boolean.valueOf(isDevelopEnv && !isGitManageType), new String[]{BTNCHECKIN});
    }

    public void afterBindData(EventObject e) {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.getClientLocalStorage(GITMSG);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map param = e.getParam();
        if (GITMSG.equals(e.getName())) {
            if (StringUtils.isNotBlank((Object)param)) {
                String gitSessionId = (String)param.get("actonResult");
                this.getPageCache().put("gitSessionId", gitSessionId);
            } else {
                this.getPageCache().put("gitSessionId", "");
            }
        }
    }

    private String[] getSelectedRuleIds() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() == 0) {
            return null;
        }
        String[] ruleIds = new String[rows.size()];
        for (int index = 0; index < rows.size(); ++index) {
            String ruleId;
            ruleIds[index] = ruleId = (String)rows.get(index).getPrimaryKeyValue();
        }
        return ruleIds;
    }

    protected CtBOTPFileUtil createFileUtil() {
        CtBOTPFileUtil fileUtil = new CtBOTPFileUtil("ctcr");
        return fileUtil;
    }

    protected String getBotpTypeForGit() {
        return "botp_cr";
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String barItemKey = evt.getItemKey();
        if (barItemKey.equalsIgnoreCase(BTNCHECKIN)) {
            this.doCheckIn();
        } else if (barItemKey.equalsIgnoreCase(BTNEXPORT)) {
            this.doExport();
        } else if (barItemKey.equalsIgnoreCase(BTNIMPORT)) {
            this.showImportForm();
        } else if (barItemKey.equalsIgnoreCase("commit")) {
            this.gitOperate(this.getBotpTypeForGit(), "commit");
        } else if (barItemKey.equalsIgnoreCase(BTNGIT_PUSH)) {
            this.gitOperate(this.getBotpTypeForGit(), BTNGIT_PUSH);
        } else if (barItemKey.equalsIgnoreCase(BTNGIT_REVERT)) {
            this.gitOperate(this.getBotpTypeForGit(), BTNGIT_REVERT);
        } else if (barItemKey.equalsIgnoreCase(BTNGIT_PULL)) {
            this.gitOperate(this.getBotpTypeForGit(), BTNGIT_PULL);
        }
    }

    private void gitOperate(String type, String operateKey) {
        Object[] ruleIds = this.getSelectedRuleIds();
        if (ruleIds == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7b7e\u5165\u7684\u89c4\u5219\u3002", (String)"CtBOTPListFilePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        Object[] designMetas = null;
        if (type.equals("botp_cr")) {
            designMetas = BusinessDataReader.load((Object[])ruleIds, (IDataEntityType)OrmUtils.getDataEntityType(DesignConvertRuleMeta.class));
        } else if (type.equals("botp_wb")) {
            designMetas = BusinessDataReader.load((Object[])ruleIds, (IDataEntityType)OrmUtils.getDataEntityType(DesignWriteBackRuleMeta.class));
        } else if (type.equals("botp_bur")) {
            designMetas = BusinessDataReader.load((Object[])ruleIds, (IDataEntityType)OrmUtils.getDataEntityType(DesignBalanceRuleMeta.class));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"ruleType\u53ea\u80fd\u652f\u6301cr, wb, bur", (String)"CtBOTPListFilePlugin_4", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        JSONArray idsArray = new JSONArray();
        HashSet<String> bizAppIds = new HashSet<String>();
        for (Object designMeta : designMetas) {
            String ruleId = ((DesignMeta)designMeta).getId();
            String bizAppId = ((DesignMeta)designMeta).getBizappId();
            idsArray.add((Object)ruleId);
            if (!StringUtils.isNotBlank((CharSequence)bizAppId) || bizAppIds.contains(bizAppId)) continue;
            bizAppIds.add(bizAppId);
        }
        if (idsArray.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u89c4\u5219\u3002", (String)"CtBOTPListFilePlugin_5", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if (bizAppIds.size() == 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u63d0\u4ea4\uff0c\u627e\u4e0d\u5230\u9700\u8981\u63d0\u4ea4\u7684%s\u8def\u5f84\uff0c\u539f\u56e0\u662f\u672a\u660e\u786e\u89c4\u5219\u6240\u5c5e\u7684\u5e94\u7528\u3002", (String)"CtBOTPListFilePlugin_6", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), "git"));
            return;
        }
        if (bizAppIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5206\u5f00\u63d0\u4ea4\uff0c\u6bcf\u6b21\u53ea\u80fd\u63d0\u4ea4\u5c5e\u4e8e\u4e00\u4e2a\u5e94\u7528\u7684\u89c4\u5219\u3002", (String)"CtBOTPListFilePlugin_7", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String id = (String)bizAppIds.iterator().next();
        String sessionId = RequestContext.get().getGlobalSessionId();
        String gitSessionId = this.getPageCache().get("gitSessionId");
        if (StringUtils.isNotBlank((CharSequence)gitSessionId)) {
            sessionId = gitSessionId;
        }
        this.getView().getPageCache().put("ruleIds", idsArray.toJSONString());
        GitOperationUtil.gitConfirmOperate((String)id, (String)type, (String)operateKey, (String)sessionId, (AbstractFormPlugin)this);
    }

    private void handleGitOperateConfirmCallBack() {
        JSONObject gitInfo = JSONObject.parseObject((String)this.getPageCache().get("gitinfo"));
        String id = gitInfo.getString("gitoperateid");
        String type = gitInfo.getString("gitoperatetype");
        String operateKey = gitInfo.getString("gitoperatekey");
        String sessionId = gitInfo.getString("gitoperatesessionid");
        this.getPageCache().remove("gitinfo");
        GitOperationUtil.beforeGitOperate((String)operateKey, (String)id, (String)type, (String)sessionId, (AbstractFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("gitOperateCallBack".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.handleGitOperateConfirmCallBack();
        } else if (GIT_COMMIT_PUSH_CONFIRM_BACK.equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.handleGitCommitAndPushConfirmBack();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (!e.getActionId().equalsIgnoreCase(BTNEXPORT)) {
            if (e.getActionId().equalsIgnoreCase(BTNIMPORT)) {
                this.doImport((String)e.getReturnData());
            } else if ("gitlogincallback".equals(e.getActionId()) && e.getReturnData() != null) {
                this.handleGitLoginCallback(e);
            } else if ("gitcommitcallback".equals(e.getActionId()) && e.getReturnData() != null) {
                this.handleGitCommitCallback(e);
            } else if (GIT_COMMIT_NEW_CALLBACK.equals(e.getActionId()) && e.getReturnData() != null) {
                this.handleGitCommitNewCallBack(e);
            } else if (GIT_PULL_UPDATE_META_CALLBACK.equals(e.getActionId()) && e.getReturnData() != null) {
                this.handleGitPullUpdateMetaCallBack(e);
            } else if (GIT_PULL_CONFLICT_CALLBACK.equals(e.getActionId()) && e.getReturnData() != null) {
                this.handleGitPullConflictCallBack(e);
            } else if (GIT_PUSH_NEW_CALLBACK.equals(e.getActionId()) && e.getReturnData() != null) {
                this.handleGitPushNewCallBack(e);
            } else if (GIT_RESTORE_CALL_BACK.equals(e.getActionId()) && e.getReturnData() != null) {
                this.handleGitRestoreCallBack(e);
            }
        }
    }

    private void handleGitCommitAndPushConfirmBack() {
        String gitContext = this.getPageCache().get("gitContext");
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        context.setOperateKey(BTNGIT_PUSH);
        GitOperateHandler handler = new GitOperateHandler();
        handler.handler(context, (AbstractFormPlugin)this);
    }

    private void handleGitRestoreCallBack(ClosedCallBackEvent e) {
        String msg = (String)e.getReturnData();
        if (SUCCESS.equals(msg)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5c06\u9009\u62e9\u5143\u6570\u636e\u4ece\u672c\u5730\u4ed3\u5e93\u8fd8\u539f\u81f3\u6570\u636e\u5e93\u3002", (String)"CtBOTPListFilePlugin_12", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void handleGitPushNewCallBack(ClosedCallBackEvent e) {
        Map res = (Map)e.getReturnData();
        String result = (String)res.get("result");
        if (SUCCESS.equals(result)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f\u3002", (String)"CtBOTPListFilePlugin_13", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63a8\u9001\u5931\u8d25\uff1a%s", (String)"CtBOTPListFilePlugin_14", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
        }
    }

    private void handleGitPullConflictCallBack(ClosedCallBackEvent e) {
        String res = (String)e.getReturnData();
        if (SUCCESS.equals(res)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5c06\u51b2\u7a81\u6587\u4ef6\u8fdb\u884c\u63d0\u4ea4\u3002", (String)"CtBOTPListFilePlugin_15", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        }
    }

    private void handleGitPullUpdateMetaCallBack(ClosedCallBackEvent e) {
        String gitContext = (String)e.getReturnData();
        GitContext context = (GitContext)SerializationUtils.fromJsonString((String)gitContext, GitContext.class);
        GitOperationUtils.updateMetadata((GitContext)context, (AbstractFormPlugin)this);
    }

    private void handleGitCommitNewCallBack(ClosedCallBackEvent e) {
        Map res = (Map)e.getReturnData();
        String gitType = (String)res.get("type");
        String result = (String)res.get("result");
        if ("nochange".equals(result) || "nochange_commitandpush".equals(result)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u6ca1\u6709\u53d8\u5316\uff0c\u65e0\u9700\u63d0\u4ea4\u3002", (String)"CtBOTPListFilePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        if ("commit".equals(gitType)) {
            if (SUCCESS.equals(result)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"CtBOTPListFilePlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"CtBOTPListFilePlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
            }
            return;
        }
        if (SUCCESS.equals(result)) {
            String context = (String)res.get("gitContext");
            this.getPageCache().put("gitContext", context);
            String info = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u6240\u6709\u6587\u4ef6\u5c06\u63a8\u9001\u81f3\u8fdc\u7a0b\u4ed3\u5e93\uff0c\u662f\u5426\u7ee7\u7eed\u63a8\u9001\uff1f", (String)"CtBOTPListFilePlugin_16", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]);
            this.getView().showConfirm(info, MessageBoxOptions.YesNo, new ConfirmCallBackListener(GIT_COMMIT_PUSH_CONFIRM_BACK));
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"CtBOTPListFilePlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
        }
    }

    private void handleGitLoginCallback(ClosedCallBackEvent event) {
        JSONObject sourceMsg = JSONObject.parseObject((String)((String)event.getReturnData()));
        String userName = sourceMsg.getString("username");
        String passWord = sourceMsg.getString("password");
        String sessionId = sourceMsg.getString(GITMSG);
        String gitUrl = sourceMsg.getString("giturl");
        String gitOperateKey = sourceMsg.getString("gitoperatekey");
        String gitOperateId = sourceMsg.getString("gitoperateid");
        String gitOperateType = sourceMsg.getString("gitoperatetype");
        String gitRepository = sourceMsg.getString("gitrepository");
        String gitBranch = sourceMsg.getString("gitbranch");
        String gitRootpath = sourceMsg.getString("gitrootpath");
        String bizAppId = sourceMsg.getString("bizappid");
        String personalGitRepository = sourceMsg.getString("personalgitrepository");
        GitOperationUtil.gitOperate((String)bizAppId, (String)gitUrl, (String)gitRepository, (String)gitBranch, (String)gitRootpath, (String)personalGitRepository, (String)userName, (String)passWord, (String)gitOperateKey, (String)gitOperateId, (String)gitOperateType, (AbstractFormPlugin)this);
        Boolean isChecked = sourceMsg.getBoolean("ischecked");
        if (isChecked.booleanValue()) {
            JSONObject saveGitMsg = new JSONObject();
            saveGitMsg.put("sessionid", (Object)sessionId);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("SAVE_GIT_SESSIONID", (Object)saveGitMsg);
        }
    }

    private void handleGitCommitCallback(ClosedCallBackEvent event) {
        JSONObject returnResult = JSONObject.parseObject((String)event.getReturnData().toString());
        String result = returnResult.getString("result");
        if ("nochange".equals(result) || "nochange_commitandpush".equals(result)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5185\u5bb9\u6ca1\u6709\u53d8\u5316\uff0c\u65e0\u9700\u63d0\u4ea4\u3002", (String)"CtBOTPListFilePlugin_8", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (SUCCESS.equals(result)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"CtBOTPListFilePlugin_9", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%s", (String)"CtBOTPListFilePlugin_10", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), result));
        }
    }

    private void doCheckIn() {
        String[] ruleIds = this.getSelectedRuleIds();
        if (ruleIds == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u7b7e\u5165\u7684\u89c4\u5219\u3002", (String)"CtBOTPListFilePlugin_0", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        CtBOTPFileUtil fileUtil = this.createFileUtil();
        JSONObject buildResult = new JSONObject();
        FormShowParameter showParameter = fileUtil.buildCheckInShowParameter(ruleIds, buildResult);
        Object errMessage = buildResult.get((Object)"error");
        if (StringUtils.isNotBlank((Object)errMessage)) {
            this.getView().showTipNotification((String)errMessage);
            return;
        }
        this.getView().showForm(showParameter);
    }

    private void doExport() {
        String[] ruleIds = this.getSelectedRuleIds();
        if (ruleIds == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u89c4\u5219\u3002", (String)"CtBOTPListFilePlugin_1", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
            return;
        }
        String property = DevportalUtil.checkFilePath((String)System.getProperty("user.home"));
        String tempPath = String.valueOf(DB.genGlobalLongId());
        String localPath = property + File.separator + "KINGDEEDOWNLOAD" + File.separator + tempPath;
        File file = new File(DevportalUtil.checkFilePath((String)localPath));
        if (!file.exists()) {
            file.mkdirs();
        }
        CtBOTPFileUtil fileUtil = this.createFileUtil();
        JSONObject exportResult = new JSONObject();
        String zipFileName = fileUtil.exportRule(localPath, ruleIds, exportResult);
        Object errMessage = exportResult.get((Object)"error");
        if (StringUtils.isNotBlank((Object)errMessage)) {
            this.getView().showTipNotification((String)errMessage);
            return;
        }
        Path zipPath = Paths.get(DevportalUtil.checkFilePath((String)zipFileName), new String[0]);
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(zipPath, new OpenOption[0]));){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ruleIds[0] + ".zip", (InputStream)in, 5000);
            this.getView().openUrl(urls);
        }
        catch (IOException e1) {
            logger.error(e1.getMessage());
        }
        AppUtils.deleteKd((File)file);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"CtBOTPListFilePlugin_11", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), Integer.valueOf(5000));
    }

    private void showImportForm() {
        if (!CtConvertRuleRightChecker.hasRight(this.getView().getFormShowParameter().getCheckRightAppId(), "4715a0df000000ac")) {
            return;
        }
        CtBOTPFileUtil fileUtil = this.createFileUtil();
        FormShowParameter showParameter = fileUtil.buildImportShowParameter();
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTNIMPORT);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void doImport(String importFile) {
        Object errMessage;
        if (StringUtils.isBlank((CharSequence)importFile)) {
            return;
        }
        String[] fieldUrls = StringUtils.split((String)importFile, (String)";");
        CtBOTPFileUtil fileUtil = this.createFileUtil();
        JSONObject importResult = new JSONObject();
        for (String fileUrl : fieldUrls) {
            fileUtil.uploadRule(fileUrl, importResult);
        }
        Object checkBaseDataWarnMsg = importResult.get((Object)"checkBaseDataWarnMsg");
        if (StringUtils.isNotBlank((Object)checkBaseDataWarnMsg)) {
            this.getView().showTipNotification(checkBaseDataWarnMsg.toString());
        }
        if ((errMessage = importResult.get((Object)"ERROR")) instanceof Throwable) {
            this.getView().showErrMessage(((Throwable)errMessage).getMessage(), ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"CtBOTPListFilePlugin_3", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]));
        } else if (StringUtils.isNotBlank((Object)errMessage)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25:%s", (String)"CtBOTPListFilePlugin_2", (String)BOS_DEVPORTAL_PLUGIN, (Object[])new Object[0]), errMessage));
        } else {
            Object success = importResult.get((Object)"SUCCESS");
            if (StringUtils.isNotBlank((Object)success)) {
                this.getView().showSuccessNotification((String)success);
            }
            ((IListView)this.getView()).refresh();
        }
    }
}

