/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.ctbotp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.ctbotp.sync.SSyncLogService;
import kd.bos.ctbotp.sync.TSyncLogService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.constants.SourceOperateEnum;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.runtime.AbstractCtConvertServiceArgs;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkDownNode;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.CtPush;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.service.ctbotp.service.CtBillLkServiceHelper;
import kd.bos.service.ctbotp.synclog.CtBotpQueryRstService;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.service.ctbotp.utils.CtBotpTenantUtils;
import kd.bos.servicehelper.CtConvertServiceHelper;
import kd.bos.servicehelper.CtSyncLogServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.CtCustomParamsUtil;
import org.apache.commons.collections.MapUtils;

public class CTBotpBillLinkListPlugin
extends AbstractListPlugin {
    private static final String FORMID = "ct_botp_bill";
    private static final String TRACKUP_SRCBILLIDS = "Track_Up_SrcBillIds";
    private static final String TRACKUP_SRCENTITYNUMBER = "Track_Up_SrcEntityNumber";
    private static final String TRACKUP_SRCTENANTCODES = "Track_Down_SrcTenantCodes";
    private static final String TRACKUP_SRCACCOUNTIDS = "Track_Down_SrcAccountIds";
    private static final String TRACKDOWN_TARBILLIDS = "Track_Down_TarBillIds";
    private static final String TRACKDOWN_TARENTITYNUMBER = "Track_Down_TarEntityNumber";
    private static final String TRACKDOWN_TARTENANTCODES = "Track_Down_TarTenantCodes";
    private static final String TRACKDOWN_TARACCOUNTIDS = "Track_Down_TarAccountIds";
    private static final String KEY_BAR_VIEW = "bar_view";
    private static final String BOS_CTBOTP_FORMPLUGIN = "bos-ctbotp-formplugin";
    private static final String KEY_TBILLNO_FIELDNAME = "tbillno";
    private static final String KEY_SBILLNO_FIELDNAME = "sbillno";
    private static final String KEY_BAR_TRY = "try";
    private static final String KEY_BAR_UPDATESTATUS = "updatestatus";

    private void showBill(String targetBillNumber, Long fid, String tenantCode, String accountId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("billId", (Object)fid);
        showParameter.setCustomParam("billNumber", (Object)targetBillNumber);
        showParameter.setCustomParam("tenantCode", (Object)tenantCode);
        showParameter.setCustomParam("accountId", (Object)accountId);
        this.getView().showForm(showParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (KEY_TBILLNO_FIELDNAME.equals(fieldName) && ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId().equals("bos_ctbotp_trackdown")) {
            args.setCancel(true);
            Long selectRowId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            SyncLog syncLog = SSyncLogService.create().getSSyncLogsById(selectRowId);
            if (!this.checkDownBillExists(syncLog)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"CTBotpBillLinkListPlugin_5", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
                return;
            }
            if (CtCustomParamsUtil.getCustomParamsParam((String)"KEY_CTBOTP_LOOK_USE_CUSFORM").booleanValue()) {
                String tTenantCode = syncLog.getTtenantCode();
                String accountId = syncLog.gettAccountId();
                String tEntityKey = syncLog.gettEntityKey();
                Long tbillId = syncLog.getTbillId();
                this.showBill(tEntityKey, tbillId, tTenantCode, accountId);
            } else {
                this.showBillDetailDown(args);
            }
        } else if (KEY_SBILLNO_FIELDNAME.equals(fieldName) && ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId().equals("bos_ctbotp_trackup")) {
            args.setCancel(true);
            Long selectRowId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            SyncLog syncLog = SSyncLogService.create().getSSyncLogsById(selectRowId);
            if (CtCustomParamsUtil.getCustomParamsParam((String)"KEY_CTBOTP_LOOK_USE_CUSFORM").booleanValue()) {
                String sTenantCode = syncLog.getStenantCode();
                String sAccountId = syncLog.getsAccountId();
                String sEntityKey = syncLog.getsEntityKey();
                Long sbillId = syncLog.getSbillId();
                this.showBill(sEntityKey, sbillId, sTenantCode, sAccountId);
            } else {
                this.showBillDetailUp(args);
            }
        }
    }

    private boolean checkDownBillExists(SyncLog syncLog) {
        Map longCtBFRowLinkDownNodeMap = CtBillLkServiceHelper.loadBillLinkDownNodes((String)syncLog.getStenantCode(), (String)syncLog.getsAccountId(), (String)syncLog.getsEntityKey(), (Long[])new Long[]{syncLog.getSbillId()}, (boolean)true);
        if (MapUtils.isEmpty((Map)longCtBFRowLinkDownNodeMap)) {
            return false;
        }
        CtBFRowLinkDownNode ctBFRowLinkDownNode = (CtBFRowLinkDownNode)longCtBFRowLinkDownNodeMap.get(syncLog.getSbillId());
        if (ctBFRowLinkDownNode.getTNodes().isEmpty()) {
            return false;
        }
        for (CtBFRowId ctBFRowId : ctBFRowLinkDownNode.getTNodes().keySet()) {
            if (!syncLog.getTbillId().equals(ctBFRowId.getBillId())) continue;
            return true;
        }
        return false;
    }

    private void showBillDetailDown(HyperLinkClickArgs args) {
        args.setCancel(true);
        Long selectRowId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        SyncLog syncLog = SSyncLogService.create().getSSyncLogsById(selectRowId);
        String tTenantCode = syncLog.getTtenantCode();
        String accountId = syncLog.gettAccountId();
        String tEntityKey = syncLog.gettEntityKey();
        Long tbillId = syncLog.getTbillId();
        DynamicObject tenant = CtBotpTenantUtils.getTenantInfoById((String)tTenantCode, (String)accountId);
        String url = CtBotpApiUtils.getUrl((DynamicObject)tenant);
        String fullUrl = this.buildUrl(url, tEntityKey, tbillId, accountId);
        this.getView().openUrl(fullUrl);
    }

    private void showBillDetailUp(HyperLinkClickArgs args) {
        args.setCancel(true);
        Long selectRowId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        SyncLog syncLog = TSyncLogService.create().getSSyncLogsById(selectRowId);
        String sTenantCode = syncLog.getStenantCode();
        String sAccountId = syncLog.getsAccountId();
        String sEntityKey = syncLog.getsEntityKey();
        Long sbillId = syncLog.getSbillId();
        DynamicObject tenant = CtBotpTenantUtils.getTenantInfoById((String)sTenantCode, (String)sAccountId);
        String url = CtBotpApiUtils.getUrl((DynamicObject)tenant);
        String fullUrl = this.buildUrl(url, sEntityKey, sbillId, sAccountId);
        this.getView().openUrl(fullUrl);
    }

    private String buildUrl(String url, String billFormId, Long billId, String accountId) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(url);
        urlBuilder.append("?formId=");
        urlBuilder.append("bos_ctbotp_lookuptracker");
        urlBuilder.append("&billFormId=");
        urlBuilder.append(billFormId);
        urlBuilder.append("&billId=");
        urlBuilder.append(billId);
        urlBuilder.append("&accountId=");
        urlBuilder.append(accountId);
        return urlBuilder.toString();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)KEY_BAR_VIEW)) {
            this.showDetails();
        } else if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)KEY_BAR_UPDATESTATUS)) {
            this.updateRst();
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.refresh();
        } else if (StringUtils.equals((CharSequence)evt.getItemKey(), (CharSequence)KEY_BAR_TRY)) {
            this.tryCtPush();
        }
    }

    private void updateRst() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection listSelectedRows = view.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u66f4\u65b0\u72b6\u6001\u7684\u8bb0\u5f55\u3002", (String)"CTBotpBillLinkListPlugin_6", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        List ids = Arrays.stream(listSelectedRows.getPrimaryKeyValues()).map(a -> Long.parseLong(String.valueOf(a))).collect(Collectors.toList());
        List syncLogs = CtSyncLogServiceHelper.getSSyncLogsByIds(ids);
        if (syncLogs.stream().anyMatch(a -> a.getStatus().equals(SyncStatusEnum.S.getStatus()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u72b6\u6001\u4e3a\u540c\u6b65\u6210\u529f\u7684\u8bb0\u5f55\u4e0d\u9700\u8981\u518d\u66f4\u65b0\u72b6\u6001\u3002", (String)"CTBotpBillLinkListPlugin_7", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        CtBotpQueryRstService.updateCtSSyncLogResult((List)syncLogs);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u72b6\u6001\u6210\u529f\u3002", (String)"CTBotpBillLinkListPlugin_12", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
    }

    private void tryCtPush() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection listSelectedRows = view.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)listSelectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8981\u91cd\u8bd5\u7684\u8bb0\u5f55\u3002", (String)"CTBotpBillLinkListPlugin_8", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        List ids = Arrays.stream(listSelectedRows.getPrimaryKeyValues()).map(a -> Long.parseLong(String.valueOf(a))).collect(Collectors.toList());
        List syncLogs = CtSyncLogServiceHelper.getSSyncLogsByIds(ids);
        if (CollectionUtils.isEmpty((Collection)syncLogs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"CTBotpBillLinkListPlugin_10", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        SyncLog syncLog = (SyncLog)syncLogs.get(0);
        if (syncLogs.stream().anyMatch(a -> !a.getRootJobId().equals(syncLog.getRootJobId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4efb\u52a1\u6807\u8bc6\u7684\u8bb0\u5f55\u8fdb\u884c\u91cd\u8bd5\u3002", (String)"CTBotpBillLinkListPlugin_9", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (syncLogs.stream().anyMatch(a -> !a.getStatus().equals(SyncStatusEnum.F.getStatus()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u540c\u6b65\u5931\u8d25\u7684\u8bb0\u5f55\u624d\u80fd\u91cd\u8bd5\u3002", (String)"CTBotpBillLinkListPlugin_11", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        this.doCtPush(syncLogs);
    }

    private void doCtPush(List<SyncLog> syncLogs) {
        SyncLog syncLog = syncLogs.get(0);
        ArrayList<ListSelectedRow> listSelectedRows = new ArrayList<ListSelectedRow>(16);
        for (SyncLog item : syncLogs) {
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue((Object)item.getSbillId());
            listSelectedRows.add(listSelectedRow);
        }
        CtPushArgs pushArgs = new CtPushArgs();
        pushArgs.setSourceEntityNumber(syncLog.getsEntityKey());
        pushArgs.setTargetEntityNumber(syncLog.gettEntityKey());
        pushArgs.settTenantCode(syncLog.getTtenantCode());
        pushArgs.settAccountId(syncLog.gettAccountId());
        pushArgs.setSyncType(syncLog.getSyncType());
        pushArgs.setSourceOperate(SourceOperateEnum.OTHER.getValue());
        pushArgs.setRuleId(syncLog.getRuleId());
        pushArgs.setSelectedRows(listSelectedRows);
        CtPush.addPushByBillOption((IFormView)this.getView(), (AbstractCtConvertServiceArgs)pushArgs);
        if (SyncTypeEnum.REVERSE.getValue().equals(syncLog.getSyncType())) {
            List ids = pushArgs.getSelectedRows().stream().map(a -> Long.parseLong(a.getPrimaryKeyValue().toString())).collect(Collectors.toList());
            CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
            ctLkUpQueryArgs.settTenantCode(RequestContext.get().getTenantCode());
            ctLkUpQueryArgs.settAccountId(RequestContext.get().getAccountId());
            ctLkUpQueryArgs.settEntityKey(pushArgs.getSourceEntityNumber());
            ctLkUpQueryArgs.settBillIds(ids);
            List ctBillLks = CtBillLinkService.getCtDirtBillLkUp((CtLkUpQueryArgs)ctLkUpQueryArgs);
            pushArgs.setCtBillLks(ctBillLks);
        }
        CtConvertOperationResult ctConvertOperationResult = CtConvertServiceHelper.ctPush((CtPushArgs)pushArgs);
        CtPush.showReport((IFormView)this.getView(), (AbstractCtConvertServiceArgs)pushArgs, (CtConvertOperationResult)ctConvertOperationResult);
    }

    private void showDetails() {
        IListView view = (IListView)this.getView();
        if (view.getCurrentSelectedRowInfo() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8f6c\u6362\u8bb0\u5f55\u3002", (String)"CTBotpBillLinkListPlugin_1", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (view.getSelectedRows().size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u52fe\u9009\u5355\u6761\u67e5\u770b\u3002", (String)"CTBotpBillLinkListPlugin_2", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        Long selectRowId = (Long)view.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        String type = (String)this.getView().getFormShowParameter().getCustomParam("bos_call_source_type");
        if ("ct_botp_track_down".equals(type)) {
            Map tarBillIds = (Map)this.getView().getFormShowParameter().getCustomParam(TRACKDOWN_TARBILLIDS);
            Map tarTenantCodes = (Map)this.getView().getFormShowParameter().getCustomParam(TRACKDOWN_TARTENANTCODES);
            Map tarAccountIds = (Map)this.getView().getFormShowParameter().getCustomParam(TRACKDOWN_TARACCOUNTIDS);
            String tarEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(TRACKDOWN_TARENTITYNUMBER);
            long tarBillId = Long.parseLong(tarBillIds.get(selectRowId) + "");
            String tarTenantCode = (String)tarTenantCodes.get(selectRowId);
            String tarAccountId = (String)tarAccountIds.get(selectRowId);
            if (tarBillId != 0L) {
                this.showBill(tarEntityNumber, tarBillId, tarTenantCode, tarAccountId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u8f6c\u6362\u5931\u8d25\uff0c\u672a\u751f\u6210\u76ee\u6807\u5355\u3002", (String)"CTBotpBillLinkListPlugin_3", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            }
        } else if ("ct_botp_track_up".equals(type)) {
            Map srcBillIds = (Map)this.getView().getFormShowParameter().getCustomParam(TRACKUP_SRCBILLIDS);
            Map srcTenantCodes = (Map)this.getView().getFormShowParameter().getCustomParam(TRACKUP_SRCTENANTCODES);
            Map srcAccountIds = (Map)this.getView().getFormShowParameter().getCustomParam(TRACKUP_SRCACCOUNTIDS);
            String srcEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(TRACKUP_SRCENTITYNUMBER);
            long srcBillId = Long.parseLong(srcBillIds.get(selectRowId) + "");
            String srcTenantCode = (String)srcTenantCodes.get(selectRowId);
            String srcAccountId = (String)srcAccountIds.get(selectRowId);
            if (srcBillId != 0L) {
                this.showBill(srcEntityNumber, srcBillId, srcTenantCode, srcAccountId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u6b65\u8f6c\u6362\u5931\u8d25\uff0c\u672a\u751f\u6210\u6e90\u5355\u3002", (String)"CTBotpBillLinkListPlugin_4", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
            }
        }
    }

    private void showTrackBill() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ct_botp_trackbill");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("createtime desc");
    }
}

