/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.ctbotp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.LookBillParams;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;
import kd.bos.entity.ctbotp.runtime.CtSourceBillReport;
import kd.bos.entity.ctbotp.runtime.CtSourceRowReport;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.ctbotp.CtPushStatus;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.service.ctbotp.utils.CtBotpTenantUtils;
import kd.bos.util.CollectionUtils;

public class CtConvertReportEdit
extends AbstractFormPlugin {
    private static final String KEY_REPORTENTRY = "report";
    private static final String KEY_SRCBILLNO = "srcbillno";
    private static final String KEY_PushStatus = "pushstatus";
    private static final String KEY_REPORTMESSAGE = "reportmessage";
    private static final String KEY_LBLREPORT = "lblreport";
    private static final String KEY_LOOKTARGETBILL = "looktargetbill";
    private static final String BOS_CTBOTP_FORMPLUGIN = "bos-ctbotp-formplugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_LOOKTARGETBILL});
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()) == null) {
            return;
        }
        CtConvertOperationResult convertResult = this.getCtConvertResult();
        this.fillReportEntry(convertResult);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getOpenStyle().getShowType() == ShowType.InContainer && this.getView().getControl("operatepanel") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"operatepanel"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (srcCtrl.getKey().equalsIgnoreCase(KEY_LOOKTARGETBILL)) {
            this.openTargetBills();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.releaseResult();
    }

    private void openTargetBills() {
        CtConvertOperationResult convertResult = this.getCtConvertResult();
        if (convertResult != null && CollectionUtils.isNotEmpty((Collection)convertResult.getTargetBillIds())) {
            this.showBillDetail(convertResult);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"CtConvertReportEdit_0", (String)BOS_CTBOTP_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    private void showBillDetail(CtConvertOperationResult ctConvertOperationResult) {
        Set ids = ctConvertOperationResult.getTargetBillIds();
        String tTenantCode = ctConvertOperationResult.getTargetTenantCode();
        String tAccountId = ctConvertOperationResult.getTargetAccountId();
        String tEntityKey = ctConvertOperationResult.getTargetEntityNumber();
        DynamicObject tenant = CtBotpTenantUtils.getTenantInfoById((String)tTenantCode, (String)tAccountId);
        String url = CtBotpApiUtils.getUrl((DynamicObject)tenant);
        String fullUrl = this.buildUrl(url, tEntityKey, ctConvertOperationResult.getTargetEntityNumber(), ids, tAccountId);
        this.getView().openUrl(fullUrl);
    }

    private String buildUrl(String url, String billFormId, String targetEntityNumber, Set<Long> ids, String accountId) {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(url);
        urlBuilder.append("?formId=");
        urlBuilder.append("bos_ctbotp_lookbill");
        urlBuilder.append("&billFormId=");
        urlBuilder.append(billFormId);
        urlBuilder.append("&accountId=");
        urlBuilder.append(accountId);
        urlBuilder.append("&customParams=");
        urlBuilder.append(SerializationUtils.toJsonString((Object)this.getLookBillParams(targetEntityNumber, ids)));
        return urlBuilder.toString();
    }

    private LookBillParams getLookBillParams(String targetEntityNumber, Set<Long> ids) {
        LookBillParams lookBillParams = new LookBillParams();
        lookBillParams.setIds(new ArrayList<Long>(ids));
        lookBillParams.setEntityKey(targetEntityNumber);
        return lookBillParams;
    }

    private void fillReportEntry(CtConvertOperationResult convertResult) {
        int rowCount = 0;
        for (CtSourceBillReport billReport : convertResult.getBillReports()) {
            ++rowCount;
            rowCount += billReport.getLinkEntityRowReports().size();
            for (Map.Entry otherEntity : billReport.getDependEntityRowReports().entrySet()) {
                rowCount += ((List)otherEntity.getValue()).size();
            }
        }
        int defRowCount = this.getModel().getEntryRowCount(KEY_REPORTENTRY);
        if (rowCount > defRowCount) {
            this.getModel().batchCreateNewEntryRow(KEY_REPORTENTRY, rowCount - defRowCount);
        } else {
            for (int i = defRowCount - 1; i >= rowCount; --i) {
                this.getModel().deleteEntryRow(KEY_REPORTENTRY, i);
            }
        }
        MainEntityType srcMainType = null;
        if (StringUtils.isNotBlank((CharSequence)convertResult.getSourceEntityNumber())) {
            srcMainType = EntityMetadataCache.getDataEntityType((String)convertResult.getSourceEntityNumber());
        }
        boolean pushSuccess = convertResult.isSuccess();
        int rowIndex = 0;
        int successBillCount = 0;
        int failBillCount = 0;
        for (CtSourceBillReport billReport : convertResult.getBillReports()) {
            this.getModel().setValue(KEY_SRCBILLNO, (Object)billReport.getRowInfo(), rowIndex);
            if (pushSuccess && billReport.isSuccess()) {
                this.getModel().setValue(KEY_PushStatus, (Object)String.valueOf(CtPushStatus.Success.getValue()), rowIndex);
            } else {
                this.getModel().setValue(KEY_PushStatus, (Object)String.valueOf(CtPushStatus.Fail.getValue()), rowIndex);
            }
            if (StringUtils.isNotBlank((CharSequence)convertResult.getMessage())) {
                this.getModel().setValue(KEY_REPORTMESSAGE, (Object)convertResult.getMessage(), rowIndex);
            } else {
                this.getModel().setValue(KEY_REPORTMESSAGE, (Object)billReport.getFailMessage(), rowIndex);
            }
            String billNo = StringUtils.isBlank((CharSequence)billReport.getBillNo()) ? String.valueOf(billReport.getBillId()) : billReport.getBillNo();
            for (CtSourceRowReport rowReport : billReport.getLinkEntityRowReports()) {
                this.getModel().setValue(KEY_SRCBILLNO, (Object)("    " + billNo), ++rowIndex);
                this.getModel().setValue(KEY_PushStatus, (Object)String.valueOf(CtPushStatus.Fail.getValue()), rowIndex);
                this.getModel().setValue(KEY_REPORTMESSAGE, (Object)rowReport.getFailMessage(), rowIndex);
            }
            if (billReport.isSuccess()) {
                ++successBillCount;
            } else {
                ++failBillCount;
            }
            ++rowIndex;
        }
        String tips = null;
        tips = convertResult.getReporter() != null && CollectionUtils.isEmpty((Collection)convertResult.getReporter().getSuccessIds()) ? String.format(ResManager.loadKDString((String)"\u9009\u62e9\u4e86 %1$s \u5f20\u5355\u636e\u4e0b\u63a8\uff0c\u5168\u90e8\u5931\u8d25%2$s\uff1b\u5171\u8017\u65f6 %3$s \u79d2", (String)"ConvertReportEdit_5", (String)"bos-botp-formplugin", (Object[])new Object[0]), convertResult.getReporter().getsBillCounts(), "", convertResult.getRunSecond()) : String.format(ResManager.loadKDString((String)"\u9009\u62e9\u4e86 %1$d \u5f20\u5355\u636e\u4e0b\u63a8\uff0c\u6210\u529f %2$s \u5f20\uff0c\u5931\u8d25 %3$s \u5f20\uff1b\u751f\u6210 %4$s \u5f20\u76ee\u6807\u5355\uff0c\u5171\u8017\u8d39 %5$s \u79d2", (String)"ConvertReportEdit_6", (String)"bos-botp-formplugin", (Object[])new Object[0]), convertResult.getReporter().getsBillCounts(), convertResult.getReporter().getSuccessIds().size(), failBillCount, convertResult.getReporter().getSuccessIds().size(), convertResult.getRunSecond());
        Label label = (Label)this.getView().getControl(KEY_LBLREPORT);
        label.setText(tips);
    }

    private void releaseResult() {
        String targetEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("cttargetentitynumber");
        String parentPageId = (String)this.getView().getFormShowParameter().getCustomParam("ctconvertresultpageid");
        String releaseResult = (String)this.getView().getFormShowParameter().getCustomParam("ctreleaseresult");
        if (StringUtils.isBlank((CharSequence)releaseResult) || StringUtils.isBlank((CharSequence)targetEntityNumber) || StringUtils.isBlank((CharSequence)parentPageId)) {
            return;
        }
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("CtConvertOperationResult");
        if (StringUtils.isNotBlank((CharSequence)convertResultJson)) {
            pageCache.remove("CtConvertOperationResult");
        }
    }

    private CtConvertOperationResult getCtConvertResult() {
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("ctconvertresultpageid");
        if (StringUtils.isBlank((CharSequence)pageId)) {
            return new CtConvertOperationResult();
        }
        IFormView parentView = this.getView().getViewNoPlugin(pageId);
        if (parentView == null) {
            return new CtConvertOperationResult();
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("CtConvertOperationResult");
        if (StringUtils.isBlank((CharSequence)convertResultJson)) {
            return new CtConvertOperationResult();
        }
        CtConvertOperationResult convertResult = (CtConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, CtConvertOperationResult.class);
        return convertResult;
    }
}

