/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.ctbotp;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.LookBillParams;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.util.CollectionUtils;

public class CtLookBillPlugin
extends AbstractFormPlugin {
    private static final String KEY_CONTENTPANEL = "contentpanel";

    public void initialize() {
        super.initialize();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showBill();
    }

    private void showBill() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LookBillParams lookBillParams = (LookBillParams)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)customParams), LookBillParams.class);
        if (CollectionUtils.isNotEmpty((Collection)lookBillParams.getIds())) {
            if (lookBillParams.getIds().size() == 1) {
                this.showOneBill(lookBillParams.getEntityKey(), (Long)lookBillParams.getIds().get(0));
            } else {
                this.showBillList(lookBillParams.getEntityKey(), lookBillParams.getIds());
            }
        }
    }

    protected void showOneBill(String entityNumber, Long billId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(KEY_CONTENTPANEL);
        formShowParameter.setFormId(entityNumber);
        formShowParameter.getCustomParams().put("InContainer", ShowType.InContainer);
        formShowParameter.setPkId((Object)billId);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    protected void showBillList(String entityNumber, List<Long> billIds) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String caption = entityType != null ? entityType.getDisplayName().getLocaleValue() : ResManager.loadKDString((String)"\u4e0b\u67e5\u5217\u8868", (String)"CtLookBillPlugin_1", (String)"bos-ctbotp-formplugin", (Object[])new Object[0]);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s(\u8de8\u79df\u6237)", (String)"LookUpTrackerEdit_3", (String)"bos-botp-formplugin", (Object[])new Object[0]), caption));
        listShowParameter.setBillFormId(entityNumber);
        for (Long billId : billIds) {
            listShowParameter.addLinkQueryPkId((Object)billId);
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

