/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.ctbotp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class CtLookUpTrackerEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TABBILLS = "tabbills";
    private Map<String, String> checkRightAppIds;

    private Map<String, String> getCheckRightAppIds() {
        if (this.checkRightAppIds == null) {
            String appIds = (String)this.getView().getFormShowParameter().getCustomParam("track_checkrightappids");
            this.checkRightAppIds = StringUtils.isBlank((CharSequence)appIds) ? new HashMap<String, String>() : (Map)SerializationUtils.fromJsonString((String)appIds, Map.class);
        }
        return this.checkRightAppIds;
    }

    private boolean isShowEditStatus() {
        boolean isEditStatus = false;
        String showStatusParam = (String)this.getView().getFormShowParameter().getCustomParam("botp_track_edit_status");
        if (StringUtils.isNotBlank((CharSequence)showStatusParam)) {
            isEditStatus = Boolean.parseBoolean(showStatusParam);
        }
        return isEditStatus;
    }

    private List<String> getCustPlugins() {
        String custPlugParam = (String)this.getView().getFormShowParameter().getCustomParam("botp_track_cust_plugin");
        if (StringUtils.isBlank((CharSequence)custPlugParam)) {
            return new ArrayList<String>(0);
        }
        String[] custPlugClassNames = StringUtils.split((String)custPlugParam, (String)",");
        ArrayList<String> list = new ArrayList<String>(custPlugClassNames.length);
        for (String className : custPlugClassNames) {
            if (!StringUtils.isNotBlank((CharSequence)className) || list.contains(className)) continue;
            list.add(className);
        }
        return list;
    }

    public void initialize() {
        super.initialize();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showBill();
    }

    private void showBill() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("billFormId");
        String billId = (String)this.getView().getFormShowParameter().getCustomParam("billId");
        if (StringUtils.isBlank((CharSequence)billId)) {
            return;
        }
        BillShowParameter showParameter = this.createBillShowParameter(billFormId, Long.parseLong(billId));
        if (showParameter != null) {
            this.getView().showForm((FormShowParameter)showParameter);
            return;
        }
    }

    protected BillShowParameter createBillShowParameter(String entityNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityNumber);
        showParameter.getCustomParams().put("isIgnoreLicense", true);
        showParameter.getCustomParams().put("bos_call_source_type", "botp_track");
        String appId = this.getCheckRightAppIds().get(entityNumber);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            showParameter.getCustomParams().put("checkRightAppId", appId);
        }
        showParameter.setPkId((Object)billId);
        boolean isEditStatus = this.isShowEditStatus();
        if (isEditStatus) {
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setShowTitle(false);
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            showParameter.setCaption(String.format(ResManager.loadKDString((String)"%1$s%2$s\u67e5\u770b", (String)"LookUpTrackerEdit_2", (String)"bos-botp-formplugin", (Object[])new Object[0]), mainType.getDisplayName().toString(), " - "));
        }
        showParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        showParameter.getOpenStyle().setTargetKey(KEY_TABBILLS);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, entityNumber);
        showParameter.setCloseCallBack(closeCallBack);
        List<String> custPlugins = this.getCustPlugins();
        if (!custPlugins.isEmpty()) {
            for (String custPlugin : custPlugins) {
                showParameter.addCustPlugin(custPlugin);
            }
        }
        showParameter.setHasRight(true);
        return showParameter;
    }
}

