/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.ctbotp;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.ctbotp.CtConvertDataMutex;
import kd.bos.form.plugin.ctbotp.CtConvertDataMutexs;
import kd.bos.servicehelper.CtConvertServiceHelper;

public class CtReleaseConvertDataMutexPlugin
extends AbstractBillPlugIn {
    private static final String CACHEKEY_CONVERTDATAMUTEX = "convertdatamutex";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CtConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult == null) {
            return;
        }
        CtReleaseConvertDataMutexPlugin.addConvertDataMutex(this.getView(), convertResult.getSourceEntityNumber(), convertResult.getDataMutexSrcBillIds());
    }

    public void pageRelease(EventObject e) {
        this.releaseDataMutex();
    }

    public static void addConvertDataMutex(IFormView view, String srcEntityNumber, Collection<String> srcBillIds) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        String str = pageCache.get(CACHEKEY_CONVERTDATAMUTEX);
        CtConvertDataMutexs dataMutexs = null;
        dataMutexs = StringUtils.isBlank((CharSequence)str) ? new CtConvertDataMutexs() : (CtConvertDataMutexs)SerializationUtils.fromJsonString((String)str, CtConvertDataMutexs.class);
        dataMutexs.addItem(srcEntityNumber, srcBillIds);
        str = SerializationUtils.toJsonString((Object)dataMutexs);
        pageCache.put(CACHEKEY_CONVERTDATAMUTEX, str);
    }

    private CtConvertOperationResult getConvertResult() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return null;
        }
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("CtConvertOperationResult");
        if (StringUtils.isBlank((CharSequence)convertResultJson)) {
            return null;
        }
        CtConvertOperationResult convertResult = (CtConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, CtConvertOperationResult.class);
        return convertResult;
    }

    private CtConvertDataMutexs getConvertDataMutexs() {
        String str = this.getPageCache().get(CACHEKEY_CONVERTDATAMUTEX);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return (CtConvertDataMutexs)SerializationUtils.fromJsonString((String)str, CtConvertDataMutexs.class);
        }
        return new CtConvertDataMutexs();
    }

    private boolean releaseDataMutex() {
        CtConvertDataMutexs convertDataMutexs = this.getConvertDataMutexs();
        if (convertDataMutexs.getItems().isEmpty()) {
            return true;
        }
        for (CtConvertDataMutex item : convertDataMutexs.getItems().values()) {
            HashSet<String> srcBillIds = new HashSet<String>(item.getSrcBillIds());
            CtConvertServiceHelper.releasePushMutex((String)item.getSrcEntityNumber(), srcBillIds);
        }
        return true;
    }
}

