/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.ctbotp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtWebApiLogListPlugin
extends AbstractListPlugin {
    private static final String APILOG_ENTITYNUMBER = "isc_apic_log";
    private static final String OPENAPI_ENTITYNUMBER = "openapi_customapi";
    private static final Log log = LogFactory.getLog(CtWebApiLogListPlugin.class);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List<Long> ids = this.loadOpenApiLogData();
        QFilter qFilter = new QFilter("type", "=", (Object)"isc_apic_webapi").and(new QFilter("api.id", "in", ids));
        e.getQFilters().add(qFilter);
    }

    private List<Long> loadOpenApiLogData() {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        String selectProp = "id,number,name";
        QFilter qFilter = new QFilter("group.id", "=", (Object)1959394011491863552L).and(new QFilter("group.number", "=", (Object)"KD_CTSY_X"));
        Map webApiDatas = BusinessDataServiceHelper.loadFromCache((String)OPENAPI_ENTITYNUMBER, (String)selectProp, (QFilter[])new QFilter[]{qFilter});
        HashSet<String> webApiNames = new HashSet<String>();
        for (Map.Entry webApiDataEntry : webApiDatas.entrySet()) {
            ids.add((Long)webApiDataEntry.getKey());
            Object name = ((DynamicObject)webApiDataEntry.getValue()).get("name");
            if (name == null) continue;
            webApiNames.add(name.toString());
        }
        log.info(String.join((CharSequence)"\uff1b", webApiNames));
        return ids;
    }
}

