/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.ctbotp.evt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtConvertBill;
import kd.bos.entity.ctbotp.CtDataCenter;
import kd.bos.entity.ctbotp.CtTenantData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.util.CollectionUtils;

public class CTEvtConfigPlugin
extends AbstractFormPlugin {
    private static final String BOS_CTBOTP_FORMPLUGIN = "bos-ctbotp-formplugin";
    private static Log log = LogFactory.getLog(CTEvtConfigPlugin.class);
    private static final String KEY_OK = "btnok";
    private static final String KEY_TENANT = "targettenant";
    private static final String KEY_CENTER = "targetdatacenter";
    private static final String KEY_BILL = "targetbill";
    private static final String KEY_RULE = "convertrule";
    private static final String KEY_TYPE = "syntype";
    private static final String BOTP_TENANTDATA = "ct_botp_tenantdata";
    private Map<String, String> config = new HashMap<String, String>();

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_OK});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String configStr = this.getView().getFormShowParameter().getCustomParam("config").toString();
        if (StringUtils.isNotBlank((CharSequence)configStr)) {
            this.config = (Map)JSONObject.parseObject((String)configStr, Map.class);
        }
        this.fillTenantCombo();
        this.fillAccountCombo();
        this.fillBillCombo();
        this.fillRuleCombo();
    }

    private void fillTenantCombo() {
        String entityNumber = this.getCustomParam("entityNumber");
        List<ComboItem> tenantItems = this.buildTenantItems(entityNumber);
        if (CollectionUtils.isEmpty(tenantItems)) {
            return;
        }
        ComboEdit tenantEditor = (ComboEdit)this.getView().getControl(KEY_TENANT);
        tenantEditor.setComboItems(tenantItems);
        String tenant = this.config.get(KEY_TENANT);
        if (StringUtils.isNotBlank((CharSequence)tenant)) {
            this.getModel().setValue(KEY_TENANT, (Object)tenant);
        } else {
            this.getModel().setValue(KEY_TENANT, (Object)tenantItems.get(0).getValue());
        }
    }

    private void fillAccountCombo() {
        Object dataCenter2;
        CtTenantData currTenant = this.getCurrCtTenant();
        if (currTenant == null) {
            this.cleanComboEdit(KEY_CENTER);
            return;
        }
        ArrayList<ComboItem> dataCenterItems = new ArrayList<ComboItem>(10);
        for (Object dataCenter2 : currTenant.getDataCenter().values()) {
            ComboItem dataCenterItem = new ComboItem();
            dataCenterItem.setValue(dataCenter2.getDataCenterNumber());
            dataCenterItem.setCaption(new LocaleString(dataCenter2.getDataCenterName()));
            dataCenterItems.add(dataCenterItem);
        }
        if (dataCenterItems.isEmpty()) {
            this.cleanComboEdit(KEY_CENTER);
            return;
        }
        ComboEdit dataCenterEditor = (ComboEdit)this.getView().getControl(KEY_CENTER);
        dataCenterEditor.setComboItems(dataCenterItems);
        dataCenter2 = this.config.get(KEY_CENTER);
        if (StringUtils.isNotBlank((CharSequence)dataCenter2)) {
            this.getModel().setValue(KEY_CENTER, dataCenter2);
        } else {
            this.getModel().setValue(KEY_CENTER, (Object)((ComboItem)dataCenterItems.get(0)).getValue());
        }
    }

    private void fillBillCombo() {
        Object bill2;
        CtTenantData currTenant = this.getCurrCtTenant();
        if (currTenant == null) {
            this.cleanComboEdit(KEY_BILL);
            return;
        }
        Object dataCenterNumber = this.getModel().getValue(KEY_CENTER);
        if (StringUtils.isBlank((Object)dataCenterNumber)) {
            this.cleanComboEdit(KEY_BILL);
            return;
        }
        CtDataCenter dataCenter = (CtDataCenter)currTenant.getDataCenter().get(dataCenterNumber);
        if (dataCenter == null) {
            return;
        }
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        for (Object bill2 : dataCenter.getBills().values()) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(bill2.getEntityNumber());
            billItem.setCaption(new LocaleString(Lang.defaultLang().toString(), bill2.getEntityName()));
            billItems.add(billItem);
        }
        if (billItems.isEmpty()) {
            this.cleanComboEdit(KEY_BILL);
            return;
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_BILL);
        billEditor.setComboItems(billItems);
        bill2 = this.config.get(KEY_BILL);
        if (StringUtils.isNotBlank((CharSequence)bill2)) {
            this.getModel().setValue(KEY_BILL, bill2);
        } else {
            this.getModel().setValue(KEY_BILL, (Object)((ComboItem)billItems.get(0)).getValue());
        }
    }

    private void fillRuleCombo() {
        Object rule2;
        String type = this.config.get(KEY_TYPE);
        if (StringUtils.isNotBlank((CharSequence)type)) {
            this.getModel().setValue(KEY_TYPE, (Object)type);
        }
        CtTenantData currTenant = this.getCurrCtTenant();
        Object dataCenterNumber = this.getModel().getValue(KEY_CENTER);
        if (StringUtils.isBlank((Object)dataCenterNumber)) {
            this.cleanComboEdit(KEY_RULE);
            return;
        }
        if (currTenant == null) {
            log.error("currTenant is null");
            return;
        }
        CtDataCenter dataCenter = (CtDataCenter)currTenant.getDataCenter().get(dataCenterNumber);
        Object billNumber = this.getModel().getValue(KEY_BILL);
        if (StringUtils.isBlank((Object)billNumber)) {
            this.cleanComboEdit(KEY_RULE);
            return;
        }
        CtConvertBill bill = (CtConvertBill)dataCenter.getBills().get(billNumber);
        ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>();
        String syncType = this.getModel().getValue(KEY_TYPE).toString();
        if (bill != null) {
            for (Object rule2 : bill.getRules()) {
                if (!syncType.equals(rule2.getSyncType())) continue;
                ComboItem ruleItem = new ComboItem();
                ruleItem.setValue(rule2.getRuleId());
                ruleItem.setCaption(new LocaleString(rule2.getRuleName()));
                ruleItems.add(ruleItem);
            }
        }
        if (ruleItems.isEmpty()) {
            this.cleanComboEdit(KEY_RULE);
            return;
        }
        ComboEdit ruleEditor = (ComboEdit)this.getView().getControl(KEY_RULE);
        ruleEditor.setComboItems(ruleItems);
        rule2 = this.config.get(KEY_RULE);
        if (StringUtils.isNotBlank((Object)bill)) {
            this.getModel().setValue(KEY_RULE, rule2);
        } else {
            this.getModel().setValue(KEY_RULE, (Object)((ComboItem)ruleItems.get(0)).getValue());
        }
    }

    private List<ComboItem> buildTenantItems(String entityNumber) {
        List tenantDatas = CtConvertMetaServiceHelper.loadTenantDatas((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (String)entityNumber);
        if (CollectionUtils.isEmpty((Collection)tenantDatas)) {
            return null;
        }
        this.getView().getPageCache().put(BOTP_TENANTDATA, SerializationUtils.toJsonString((Object)tenantDatas));
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(10);
        for (CtTenantData tenantData : tenantDatas) {
            ComboItem billItem = new ComboItem();
            billItem.setValue(tenantData.getTenantNumber());
            billItem.setCaption(new LocaleString(Lang.defaultLang().toString(), tenantData.getTenantName()));
            billItems.add(billItem);
        }
        return billItems;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equalsIgnoreCase(KEY_TENANT)) {
            this.fillAccountCombo();
            this.fillBillCombo();
            this.fillRuleCombo();
        } else if (key.equalsIgnoreCase(KEY_CENTER)) {
            this.fillBillCombo();
            this.fillRuleCombo();
        } else if (key.equalsIgnoreCase(KEY_BILL)) {
            this.fillRuleCombo();
        } else if (key.equalsIgnoreCase(KEY_TYPE)) {
            this.fillRuleCombo();
        }
    }

    private void cleanComboEdit(String key) {
        ArrayList items = new ArrayList();
        ComboEdit ruleEditor = (ComboEdit)this.getView().getControl(key);
        ruleEditor.setComboItems(items);
        this.getModel().setValue(key, (Object)"");
    }

    private String getCustomParam(String param) {
        return (String)this.getView().getFormShowParameter().getCustomParam(param);
    }

    private CtTenantData getCurrCtTenant() {
        try {
            List tenantDatas = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get(BOTP_TENANTDATA), CtTenantData.class);
            String tenant = this.getModel().getValue(KEY_TENANT).toString();
            for (CtTenantData tenantData : tenantDatas) {
                if (!tenant.equals(tenantData.getTenantNumber())) continue;
                return tenantData;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return null;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if (KEY_OK.equalsIgnoreCase(srcCtrl.getKey())) {
            JSONObject obj = new JSONObject();
            obj.put(KEY_TENANT, this.getModel().getValue(KEY_TENANT));
            obj.put(KEY_CENTER, this.getModel().getValue(KEY_CENTER));
            obj.put(KEY_BILL, this.getModel().getValue(KEY_BILL));
            obj.put(KEY_RULE, this.getModel().getValue(KEY_RULE));
            obj.put(KEY_TYPE, this.getModel().getValue(KEY_TYPE));
            this.getView().returnDataToParent((Object)obj);
            this.getView().close();
        }
    }
}

