/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.schedule;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ctbotp.synclog.CtBotpQueryRstService;
import kd.bos.servicehelper.CtSyncLogServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;

public class UpdateCtSSyncLogResultTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(UpdateCtSSyncLogResultTask.class);
    private static final int BATCH_COUNT = 1000;
    private static final int MAX_TOTALCOUNT = 100000;
    private static final int UPDATE_STATUS_COUNT_LIMIT = 3;

    public void execute(RequestContext rc, Map<String, Object> params) throws KDException {
        LOG.info("------ UpdateCtSSyncLogResultTask begin ------");
        int batchCount = Integer.parseInt(String.valueOf(params.getOrDefault("BATCH_COUNT", 1000)));
        int updateCountLimit = Integer.parseInt(String.valueOf(params.getOrDefault("UPDATE_STATUS_COUNT_LIMIT", 3)));
        int maxTotalCount = Integer.parseInt(String.valueOf(params.getOrDefault("MAX_TOTALCOUNT", 100000)));
        QFilter[] qFilters = new QFilter[]{new QFilter("status", "!=", (Object)SyncStatusEnum.S.getStatus()), new QFilter("updatestatuscount", "<", (Object)updateCountLimit), new QFilter("updatetime", "<=", (Object)DateUtils.addHours((Date)TimeServiceHelper.now(), (int)-3)).or(QFilter.isNull((String)"updatetime"))};
        int batchIndex = 0;
        for (int totalCount = 0; totalCount <= maxTotalCount; totalCount += batchCount) {
            Date startTime = TimeServiceHelper.now();
            List syncLogs = CtSyncLogServiceHelper.getSyncLogsByQFilters((QFilter[])qFilters, (int)batchCount);
            if (CollectionUtils.isEmpty((Collection)syncLogs)) break;
            int curBatchSize = syncLogs.size();
            CtBotpQueryRstService.updateCtSSyncLogResult((List)syncLogs);
            Date endTime = TimeServiceHelper.now();
            long ms = (endTime.getTime() - startTime.getTime()) / 1000L;
            LOG.info(String.format("curBatch UpdateCtSSyncLogResultTask end\uff0cbatchIndex\uff1a %1$s \uff0ccurBatchSize\uff1a %2$s \uff0ccost\uff1a %3$s s\u3002", ++batchIndex, curBatchSize, ms));
        }
        LOG.info("------ UpdateCtSSyncLogResultTask end ------");
    }
}

