/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.servicehelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.CtBusinessFlowDataService;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkDownRes;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkUpRes;
import kd.bos.entity.ctbotp.apiresponse.CtTableInfoRes;
import kd.bos.entity.ctbotp.runtime.CtBFRow;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkDownNode;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections.MapUtils;

@SdkPublic
public class CtBillTrackerServiceHelper {
    public static Map<Long, CtBFRowLinkUpNode> loadBillLinkUpNodes(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtSource) {
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        return service.loadBillLinkUpNodes(tTenantCode, tAccountId, entityNumber, billIds, onlyDirtSource);
    }

    public static List<CtBFRow> loadBillLinkUpRows(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        return service.loadBillLinkUpRows(tTenantCode, tAccountId, entityNumber, billIds, onlyDirtTarget);
    }

    public static CtBillLkUpRes loadBillLinkUp(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        CtBillLkUpRes ctBillLkUpRes = new CtBillLkUpRes();
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        List ctBFRows = service.loadBillLinkUpRows(tTenantCode, tAccountId, entityNumber, billIds, onlyDirtTarget);
        ctBillLkUpRes.setCtBFRowList(ctBFRows);
        ArrayList<CtTableInfoRes> ctTableInfoResList = new ArrayList<CtTableInfoRes>(16);
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        for (CtBFRow ctBFRow : ctBFRows) {
            if (MapUtils.isNotEmpty(nameMap)) break;
            if (!ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId()) || !ctBFRow.getId().getMainEntityKey().equals(entityNumber)) continue;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getId().getMainEntityKey());
            String name = mainEntityType.getDisplayName().getLocaleValue();
            nameMap.put(entityNumber, name);
            CtTableInfoRes ctTableInfoRes = new CtTableInfoRes();
            ctTableInfoRes.setTenantId(ctBFRow.getId().getTenantId());
            ctTableInfoRes.setAccountId(ctBFRow.getId().getAccountId());
            ctTableInfoRes.setMainEntityKey(ctBFRow.getId().getMainEntityKey());
            ctTableInfoRes.setName(name);
            ctTableInfoResList.add(ctTableInfoRes);
        }
        ctBillLkUpRes.setCtTableInfos(ctTableInfoResList);
        return ctBillLkUpRes;
    }

    public static Map<Long, CtBFRowLinkDownNode> loadBillLinkDownNodes(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        return service.loadBillLinkDownNodes(sTenantCode, sAccountId, entityNumber, billIds, onlyDirtTarget);
    }

    public static List<CtBFRow> loadBillLinkDownRows(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        return service.loadBillLinkDownRows(sTenantCode, sAccountId, entityNumber, billIds, onlyDirtTarget);
    }

    public static CtBillLkDownRes loadBillLinkDown(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        CtBillLkDownRes ctBillLkDownRes = new CtBillLkDownRes();
        CtBusinessFlowDataService service = new CtBusinessFlowDataService();
        List ctBFRows = service.loadBillLinkDownRows(sTenantCode, sAccountId, entityNumber, billIds, onlyDirtTarget);
        ctBillLkDownRes.setCtBFRowList(ctBFRows);
        ArrayList<CtTableInfoRes> ctTableInfoResList = new ArrayList<CtTableInfoRes>(16);
        HashMap<String, String> nameMap = new HashMap<String, String>(16);
        for (CtBFRow ctBFRow : ctBFRows) {
            if (MapUtils.isNotEmpty(nameMap)) break;
            if (!ctBFRow.getSId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getSId().getAccountId().equals(RequestContext.get().getAccountId()) || !ctBFRow.getSId().getMainEntityKey().equals(entityNumber)) continue;
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)ctBFRow.getId().getMainEntityKey());
            String name = mainEntityType.getDisplayName().getLocaleValue();
            nameMap.put(entityNumber, name);
            CtTableInfoRes ctTableInfoRes = new CtTableInfoRes();
            ctTableInfoRes.setTenantId(ctBFRow.getId().getTenantId());
            ctTableInfoRes.setAccountId(ctBFRow.getId().getAccountId());
            ctTableInfoRes.setMainEntityKey(ctBFRow.getId().getMainEntityKey());
            ctTableInfoRes.setName(name);
            ctTableInfoResList.add(ctTableInfoRes);
        }
        ctBillLkDownRes.setCtTableInfos(ctTableInfoResList);
        return ctBillLkDownRes;
    }
}

