/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.ctbotp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.ctbotp.CtConvertRuleMetadata;
import kd.bos.metadata.ctbotp.DesignCtConvertRuleMeta;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.metadata.ICtConvertRuleMetaDaoPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtConvertRuleMetaDaoPlugin
implements IMetadataDaoPlugIn,
ICtConvertRuleMetaDaoPlugin {
    private static IDataEntityType designMetaType;
    private static String KEY_BOS_CTBOTP_TENANTPATH;
    private static String KEY_NUMBER;
    private static final String KEY_SOURCE_TENANT = "sourcetenant";
    private static final String KEY_TARGET_TENANT = "targettenant";
    private static final String KEY_TENANTID = "tenantid";
    private static final String KEY_ACCOUNTID = "accountid";
    private static final String KEY_ACCOUNTNUMBER = "accountnumber";

    private static synchronized IDataEntityType getDesignMetaType() {
        if (designMetaType == null) {
            designMetaType = OrmUtils.getDataEntityType(DesignCtConvertRuleMeta.class);
        }
        return designMetaType;
    }

    public HashSet<String> loadDisableExtend(HashSet<String> extObjectIds) {
        HashSet<String> disableIds = new HashSet<String>();
        if (extObjectIds.size() == 0) {
            return disableIds;
        }
        String ids = StringUtils.join((Object[])extObjectIds.toArray(), (String)"','");
        String sql = String.format("SELECT FId FROM %s_S WHERE FEnabled <> '1' and FId IN ('%s') ", CtConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias(), ids);
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> list = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    list.add(id);
                }
                return list;
            }
        };
        List list = (List)DB.query((DBRoute)DBRoute.base, (String)sql, null, (ResultSetHandler)action);
        disableIds.addAll(list);
        return disableIds;
    }

    public void save(AbstractMetadata[] metadatas) {
        super.save(metadatas);
        for (AbstractMetadata metadata : metadatas) {
            CtConvertRuleMetadata convertRuleMetadata = (CtConvertRuleMetadata)metadata;
            this.saveStatus(convertRuleMetadata);
            CtConvertRuleMetaDaoPlugin.saveTenantInfo(convertRuleMetadata);
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("CtConvertRule", new DistributeCacheHAPolicy(true, true));
        HashSet<String> removeRuleIds = new HashSet<String>(16);
        for (AbstractMetadata metadata : metadatas) {
            if (!(metadata instanceof CtConvertRuleMetadata)) continue;
            CtConvertRuleMetadata ruleMetadata = (CtConvertRuleMetadata)metadata;
            removeRuleIds.add(ruleMetadata.getId());
            if (!ruleMetadata.getDevType().equals("2")) continue;
            removeRuleIds.add(ruleMetadata.getMasterId());
        }
        if (!CollectionUtils.isEmpty(removeRuleIds)) {
            cache.remove(removeRuleIds.toArray(new String[0]));
        }
    }

    public void afterReadMeta(AbstractMetadata meta) {
        this.loadStatus((CtConvertRuleMetadata)meta);
        this.loadTenantPath((CtConvertRuleMetadata)meta);
        this.loadTenantInfo((CtConvertRuleMetadata)meta);
    }

    private void saveStatus(CtConvertRuleMetadata meta) {
        String sqlExists = String.format("select FID from %s_S where FId = ? ", CtConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
        Object[] paramsExists = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId())};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        boolean exists = (Boolean)DB.query((DBRoute)DBRoute.base, (String)sqlExists, (Object[])paramsExists, (ResultSetHandler)action);
        String sql = null;
        Object[] params = null;
        if (exists) {
            sql = String.format("update %s_S set FEnabled = ? where FId = ? ", CtConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
            params = new SqlParameter[]{new SqlParameter(":FEnabled", 1, (Object)(meta.getRuleElement().isEnabled() ? "1" : "0")), new SqlParameter(":FId", 12, (Object)meta.getId())};
        } else {
            sql = String.format("insert into %s_S (FID, FEnabled, FSourceTenant, FSourceDatacenter, FSourceAccountNumber, FTargetTenant, FTargetDatacenter, FTargetAccountNumber, FTenantPath) values (?, ?, ?, ?, ?, ?, ?, ?, ?)", CtConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
            params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId()), new SqlParameter(":FEnabled", 1, (Object)(meta.getRuleElement().isEnabled() ? "1" : "0")), new SqlParameter(":FSourceTenant", 1, (Object)meta.getRuleElement().getSourceTenant()), new SqlParameter(":FSourceDatacenter", 1, (Object)meta.getRuleElement().getSourceDataCenter()), new SqlParameter(":FSourceAccountNumber", 1, (Object)meta.getRuleElement().getSourceAccountNumber()), new SqlParameter(":FTargetTenant", 1, (Object)meta.getRuleElement().getTargetTenant()), new SqlParameter(":FTargetDatacenter", 1, (Object)meta.getRuleElement().getTargetDataCenter()), new SqlParameter(":FTargetAccountNumber", 1, (Object)meta.getRuleElement().getTargetAccountNumber()), new SqlParameter(":FTenantPath", 1, (Object)meta.getRuleElement().getTenantPath())};
        }
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
    }

    public static void saveTenantInfo(CtConvertRuleMetadata meta) {
        String sqlExists = String.format("select FID from %s_S where FId = ? ", CtConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
        Object[] paramsExists = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId())};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return true;
                }
                return false;
            }
        };
        boolean exists = (Boolean)DB.query((DBRoute)DBRoute.base, (String)sqlExists, (Object[])paramsExists, (ResultSetHandler)action);
        String sql = null;
        Object[] params = null;
        if (exists) {
            sql = String.format("update %s_S set FTenantPath = ? where FId = ? ", CtConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
            params = new SqlParameter[]{new SqlParameter(":FTenantPath", 1, (Object)meta.getRuleElement().getTenantPath()), new SqlParameter(":FId", 12, (Object)meta.getId())};
        } else {
            sql = String.format("insert into %s_S (FID, FTenantPath) values (?, ?)", CtConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
            params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId()), new SqlParameter(":FTenantPath", 1, (Object)meta.getRuleElement().getTenantPath())};
        }
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
    }

    private boolean loadStatus(final CtConvertRuleMetadata meta) {
        String sql = String.format("select FEnabled from %s_S where FId = ? ", CtConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId())};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    String enable = rs.getString(1);
                    meta.getRuleElement().setEnabled(StringUtils.equals((CharSequence)enable, (CharSequence)"1"));
                    return true;
                }
                meta.getRuleElement().setEnabled(true);
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private boolean loadTenantPath(final CtConvertRuleMetadata meta) {
        String sql = String.format("select FTenantPath from %s_S where FId = ? ", CtConvertRuleMetaDaoPlugin.getDesignMetaType().getAlias());
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId())};
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    String tenantPath = rs.getString(1);
                    meta.getRuleElement().setTenantPath(tenantPath);
                    return true;
                }
                return false;
            }
        };
        return (Boolean)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private void loadTenantInfo(CtConvertRuleMetadata meta) {
        String tenantPathNumber = meta.getRuleElement().getTenantPath();
        DynamicObject tenantPath = this.getTenantPath(tenantPathNumber);
        if (tenantPath != null) {
            DynamicObject targetTenant;
            DynamicObject sourceTenant = (DynamicObject)tenantPath.get(KEY_SOURCE_TENANT);
            if (sourceTenant != null) {
                meta.getRuleElement().setSourceTenant(sourceTenant.getString(KEY_TENANTID));
                meta.getRuleElement().setSourceDataCenter(sourceTenant.getString(KEY_ACCOUNTID));
                meta.getRuleElement().setSourceAccountNumber(sourceTenant.getString(KEY_ACCOUNTNUMBER));
            }
            if ((targetTenant = (DynamicObject)tenantPath.get(KEY_TARGET_TENANT)) != null) {
                meta.getRuleElement().setTargetTenant(targetTenant.getString(KEY_TENANTID));
                meta.getRuleElement().setTargetDataCenter(targetTenant.getString(KEY_ACCOUNTID));
                meta.getRuleElement().setTargetAccountNumber(targetTenant.getString(KEY_ACCOUNTNUMBER));
            }
        }
    }

    private DynamicObject getTenantPath(String tenantPathNumber) {
        if (StringUtils.isBlank((CharSequence)tenantPathNumber)) {
            return null;
        }
        QFilter[] filter = new QFilter[]{new QFilter(KEY_NUMBER, "=", (Object)tenantPathNumber)};
        DynamicObject tenantPath = BusinessDataServiceHelper.loadSingleFromCache((String)KEY_BOS_CTBOTP_TENANTPATH, (QFilter[])filter);
        return tenantPath;
    }

    static {
        KEY_BOS_CTBOTP_TENANTPATH = "bos_ctbotp_tenantpath";
        KEY_NUMBER = "number";
    }
}

