/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.ctbotp;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ctbotp.CtConvertPath;
import kd.bos.entity.ctbotp.CtConvertRuleCache;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.runtime.CtConvertRuleElementSerializer;
import kd.bos.isv.ISVService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.ctbotp.CtConvertRuleMetadata;
import kd.bos.metadata.ctbotp.CtConvertRuleReader;
import kd.bos.metadata.ctbotp.CtConvertRuleTemplate;
import kd.bos.metadata.ctbotp.CtConvertRuleVer;
import kd.bos.metadata.ctbotp.DesignCtConvertRuleMeta;
import kd.bos.metadata.dao.MetadataWriter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataLogService;

public class CtConvertRuleWriter {
    private static final String BOS_BOTP_MEATADATA = "bos-botp-metadata";
    private static final String SUCCESS_STR = "success";
    private static final String MESSAGE_STR = "message";

    public static Map<String, Object> save(Map<String, Object> metaMap) {
        CtConvertRuleTemplate template = new CtConvertRuleTemplate();
        CtConvertRuleMetadata ruleMetadata = template.deserializeFromMap(metaMap, null);
        return CtConvertRuleWriter.save(ruleMetadata);
    }

    public static Map<String, Object> save(CtConvertRuleMetadata ruleMetadata) {
        ruleMetadata.setBizappId(ruleMetadata.getRuleElement().getsBizAppId());
        MetadataWriter writer = new MetadataWriter("CtConvertRuleModel");
        CtConvertRuleWriter.updateVersion(ruleMetadata);
        Map result = writer.save(new AbstractMetadata[]{ruleMetadata});
        CtConvertRuleWriter.clearCache();
        return result;
    }

    public static Map<String, Object> syncRuleSave(CtConvertRuleMetadata ruleMetadata) {
        ruleMetadata.setBizappId(ruleMetadata.getRuleElement().getsBizAppId());
        MetadataWriter writer = new MetadataWriter("CtConvertRuleModel");
        ruleMetadata.setModifyDate(new Date());
        Map result = writer.save(new AbstractMetadata[]{ruleMetadata});
        CtConvertRuleWriter.clearCache();
        return result;
    }

    public static void saveDefaultStatus(CtConvertRuleMetadata meta) {
        if (StringUtils.isNotBlank((CharSequence)meta.getDevType()) && meta.getDevType().equals("2")) {
            return;
        }
        CtConvertRuleWriter.clearCache();
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("Update T__CT_BOTP_ConvertRule_S Set FIsDefault = ? ");
        sBuilder.append("WHERE FId = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)meta.getId())};
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)DBRoute.base, (String)sBuilder.toString(), (Object[])params);
        }
    }

    private static void writeDeleteMetaDataLog(String[] ruleIds, Map<String, CtConvertRuleMetadata> rulesMap) {
        MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        for (String ruleId : ruleIds) {
            long logId = DB.genGlobalLongId();
            if (rulesMap.get(ruleId) == null) continue;
            String metaNumber = rulesMap.get(ruleId).getRuleElement().getSourceEntityNumber() + "-" + rulesMap.get(ruleId).getRuleElement().getTargetEntityNumber();
            CtConvertRuleTemplate template = new CtConvertRuleTemplate();
            String string = template.buildDiffXml(rulesMap.get(ruleId), null, false);
        }
    }

    public static Map<String, Object> delete(String[] ruleIds) {
        CtConvertRuleReader reader = new CtConvertRuleReader();
        List<CtConvertRuleMetadata> rules = reader.batchLoadMeta(ruleIds, false);
        Map<String, CtConvertRuleMetadata> rulesMap = rules.stream().collect(Collectors.toMap(CtConvertRuleMetadata::getId, item -> item));
        IDataEntityType dType = OrmUtils.getDataEntityType(DesignCtConvertRuleMeta.class);
        BusinessDataWriter.delete((IDataEntityType)dType, (Object[])ruleIds);
        CtConvertRuleWriter.deleteRuleStatus(ruleIds);
        CtConvertRuleWriter.deleteRuleVersions(ruleIds);
        CtConvertRuleWriter.clearCache();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(SUCCESS_STR, true);
        result.put(MESSAGE_STR, ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"ConvertRuleWriter_0", (String)BOS_BOTP_MEATADATA, (Object[])new Object[0]));
        CtConvertRuleWriter.writeDeleteMetaDataLog(ruleIds, rulesMap);
        return result;
    }

    private static void deleteRuleStatus(String[] ruleIds) {
        if (ruleIds.length == 0) {
            return;
        }
        String sql = "DELETE FROM T_CTBOTP_ConvertRule_S WHERE FID IN (%s)";
        ArrayList<String> list = new ArrayList<String>(10);
        Object[] params = new SqlParameter[ruleIds.length];
        for (int i = 0; i < ruleIds.length; ++i) {
            list.add("?");
            params[i] = new SqlParameter(":FId" + String.valueOf(i), 12, (Object)ruleIds[i]);
        }
        sql = String.format(sql, StringUtils.join((Object[])list.toArray(), (String)","));
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
    }

    private static void deleteRuleVersions(String[] ruleIds) {
        if (ruleIds.length == 0) {
            return;
        }
        String sql = "DELETE FROM T_CTBOTP_ConvertRuleVer WHERE FRuleId IN (%s)";
        ArrayList<String> list = new ArrayList<String>(10);
        Object[] params = new SqlParameter[ruleIds.length];
        for (int i = 0; i < ruleIds.length; ++i) {
            list.add("?");
            params[i] = new SqlParameter(":FId" + String.valueOf(i), 12, (Object)ruleIds[i]);
        }
        sql = String.format(sql, StringUtils.join((Object[])list.toArray(), (String)","));
        DB.execute((DBRoute)DBRoute.base, (String)sql, (Object[])params);
    }

    public static Map<String, Object> delete(CtConvertPath path, boolean existSourceEntity, boolean existTargetEntity) {
        CtConvertRuleReader reader = new CtConvertRuleReader();
        List<CtConvertRuleMetadata> rules = reader.loadMetas(path.getSourceTenant(), path.getSourceAccountId(), path.getSourceEntityNumber(), path.getTargetTenant(), path.getTargetAccountId(), path.getTargetEntityNumber());
        ArrayList<String> ruleIds = new ArrayList<String>(16);
        String currentIsv = ISVService.getISVInfo().getId();
        boolean isKingdee = StringUtils.equals((CharSequence)currentIsv, (CharSequence)"kingdee");
        for (CtConvertRuleMetadata ruleMetadata : rules) {
            boolean isExtRule = StringUtils.equals((CharSequence)"2", (CharSequence)ruleMetadata.getDevType());
            if (!isExtRule && ruleMetadata.getRuleElement().isEnabled() && existSourceEntity && existTargetEntity) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCESS_STR, false);
                result.put(MESSAGE_STR, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a\u6709\u542f\u7528\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u8def\u7ebf\u3002\u8bf7\u5148\u505c\u7528\u89c4\u5219\u540e\u518d\u5220\u9664", (String)"ConvertRuleWriter_2", (String)BOS_BOTP_MEATADATA, (Object[])new Object[0]));
                return result;
            }
            if (!(StringUtils.equalsIgnoreCase((CharSequence)currentIsv, (CharSequence)ruleMetadata.getIsv()) || isKingdee || StringUtils.isBlank((CharSequence)ruleMetadata.getIsv()))) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put(SUCCESS_STR, false);
                result.put(MESSAGE_STR, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a\u8def\u7ebf\u4e2d\u5305\u542b\u6709\u975e\u672c\u5f00\u53d1\u5546\u5f00\u53d1\u7684\u89c4\u5219\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u8def\u7ebf", (String)"ConvertRuleWriter_3", (String)BOS_BOTP_MEATADATA, (Object[])new Object[0]));
                return result;
            }
            if (isExtRule) continue;
            ruleIds.add(ruleMetadata.getId());
        }
        if (!ruleIds.isEmpty()) {
            return CtConvertRuleWriter.delete(ruleIds.toArray(new String[ruleIds.size()]));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(SUCCESS_STR, false);
        result.put(MESSAGE_STR, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a\u6e90\u5355\u4e0e\u76ee\u6807\u5355\u4e4b\u95f4\uff0c\u6ca1\u6709\u8f6c\u6362\u89c4\u5219", (String)"ConvertRuleWriter_1", (String)BOS_BOTP_MEATADATA, (Object[])new Object[0]));
        return result;
    }

    public static void clearCache(String[] ruleIds) {
        CtConvertRuleWriter.clearCache();
    }

    private static void setBizappId(final CtConvertRuleMetadata ruleMetadata) {
        if (StringUtils.isBlank((CharSequence)ruleMetadata.getBizappId())) {
            String sql = "SELECT FNumber, FSubsysId, FBizAppId FROM t_meta_entitydesign WHERE FNumber = ?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FNumber", 12, (Object)ruleMetadata.getRuleElement().getSourceEntityNumber())};
            ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws Exception {
                    if (rs.next()) {
                        int subSysId = rs.getInt("FSubsysId");
                        String bizAppId = rs.getString("FBizAppId");
                        ruleMetadata.setSubSysId(subSysId);
                        ruleMetadata.setBizappId(bizAppId);
                    }
                    return null;
                }
            };
            DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, (ResultSetHandler)action);
        }
    }

    private static void updateVersion(CtConvertRuleMetadata ruleMetadata) {
        long version = DB.genGlobalLongId();
        if (ruleMetadata.getDevType().equals("2")) {
            CtConvertRuleReader reader = new CtConvertRuleReader();
            CtConvertRuleMetadata parent = reader.loadMeta(ruleMetadata.getParentId(), false);
            ruleMetadata.getRuleElement().setCurrentVerId(parent.getRuleElement().getCurrentVerId());
            ruleMetadata.getRuleElement().setExtVerId(version);
        } else {
            ruleMetadata.getRuleElement().setCurrentVerId(version);
            CtConvertRuleWriter.updateInheritRuleVer(ruleMetadata.getId());
        }
    }

    public static void updateInheritRuleVer(String parentRuleId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT FID ");
        sBuilder.append("FROM T_CTBOTP_ConvertRule ");
        sBuilder.append("WHERE FParentId = ? and FType <> ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FParentId", 12, (Object)parentRuleId), new SqlParameter(":FType", 1, (Object)"2")};
        ResultSetHandler<List<String>> action = new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> ids = new ArrayList<String>(10);
                while (rs.next()) {
                    String id = rs.getString("FID");
                    ids.add(id);
                }
                return ids;
            }
        };
        List ruleIds = (List)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (ruleIds.isEmpty()) {
            return;
        }
        CtConvertRuleReader reader = new CtConvertRuleReader();
        for (String ruleId : ruleIds) {
            CtConvertRuleMetadata ruleMeta = reader.loadMeta(ruleId, false);
            CtConvertRuleWriter.save(ruleMeta);
        }
    }

    public static Long saveRuleVer(String ruleId) {
        CtConvertRuleReader reader = new CtConvertRuleReader();
        CtConvertRuleMetadata ruleMetadata = reader.loadMeta(ruleId, true);
        CtConvertRuleElement ruleElement = ruleMetadata.getRuleElement();
        long oriVersion = ruleElement.getCurrentVerId();
        long extVersion = ruleElement.getExtVerId();
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT Fid ");
        sBuilder.append("FROM T_CTBOTP_ConvertRuleVer ");
        sBuilder.append("WHERE FRuleId = ? ");
        sBuilder.append("and FOriVersion = ? ");
        sBuilder.append("and FExtVersion = ? ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FRuleId", 12, (Object)ruleId), new SqlParameter(":FOriVersion", -5, (Object)oriVersion), new SqlParameter(":FExtVersion", -5, (Object)extVersion)};
        ResultSetHandler<Long> action = new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long id = 0L;
                if (rs.next()) {
                    id = rs.getLong("Fid");
                }
                return id;
            }
        };
        long verId = (Long)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        if (verId == 0L) {
            CtConvertRuleVer ver = new CtConvertRuleVer();
            ver.setFid(DB.genGlobalLongId());
            ver.setRuleId(ruleId);
            ver.setOriVersion(oriVersion);
            ver.setExtVersion(extVersion);
            ver.setCreateDate(new Date());
            ver.setModifyDate(new Date());
            ver.setModifier(RequestContext.get().getCurrUserId());
            String json = CtConvertRuleElementSerializer.serializeToString((CtConvertRuleElement)ruleElement, null);
            ver.setData(json);
            IDataEntityType dType = OrmUtils.getDataEntityType(CtConvertRuleVer.class);
            BusinessDataWriter.save((IDataEntityType)dType, (Object[])new Object[]{ver});
        }
        return verId;
    }

    private static void clearCache() {
        CtConvertRuleCache.clearAllConvertRuleCache();
    }
}

