/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.ctbotp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.isv.ISVService;
import kd.bos.metadata.ctbotp.CtConvertRuleMetadata;
import kd.bos.metadata.ctbotp.CtConvertRuleTemplate;
import kd.bos.metadata.ctbotp.DesignCtConvertRuleMeta;
import kd.bos.metadata.dao.MetadataSerializer;
import kd.bos.metadata.lang.LangWriter;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;

@ApiModel
public class CtRuleTreeNode
implements Serializable {
    private static final String BOS_DESIGNER_PLUGIN = "bos-botp-formplugin";
    private static final long serialVersionUID = -83360075095010596L;
    @ApiParam(value="\u89c4\u5219\u552f\u4e00\u6807\u8bc6")
    private @ApiParam(value="\u89c4\u5219\u552f\u4e00\u6807\u8bc6") String id;
    @ApiParam(value="\u540d\u79f0")
    private @ApiParam(value="\u540d\u79f0") String name;
    @ApiParam(value="\u7236ID")
    private @ApiParam(value="\u7236ID") String parentId;
    @ApiParam(value="\u7c7b\u578b")
    private @ApiParam(value="\u7c7b\u578b") String devType;
    @ApiParam(value="\u8bbe\u8ba1\u65f6\u5b57\u7b26\u4e32")
    private @ApiParam(value="\u8bbe\u8ba1\u65f6\u5b57\u7b26\u4e32") String designJson;
    @ApiParam(value="\u5f00\u542f\u72b6\u6001")
    private @ApiParam(value="\u5f00\u542f\u72b6\u6001") boolean enabled;
    @ApiParam(value="\u662f\u5426\u80fd\u4fee\u6539")
    private @ApiParam(value="\u662f\u5426\u80fd\u4fee\u6539") boolean canModify;
    @ApiParam(value="\u65b0\u5efa")
    private @ApiParam(value="\u65b0\u5efa") boolean newed;
    @ApiParam(value="\u4fee\u6539")
    private @ApiParam(value="\u4fee\u6539") boolean changed;
    @ApiParam(value="\u5220\u9664")
    private @ApiParam(value="\u5220\u9664") boolean deleted;
    @ApiParam(value="\u591a\u8bed\u8a00\u8bcd\u6761")
    private @ApiParam(value="\u591a\u8bed\u8a00\u8bcd\u6761") List<Map<String, Map<String, Object>>> localeItems = new ArrayList<Map<String, Map<String, Object>>>();
    @ApiParam(value="\u8bcd\u6761\u4e2d\u542b\u6709\u7684\u8bed\u79cd")
    private @ApiParam(value="\u8bcd\u6761\u4e2d\u542b\u6709\u7684\u8bed\u79cd") Set<String> localeIds = new HashSet<String>();
    private Map<String, CtRuleTreeNode> children = new HashMap<String, CtRuleTreeNode>();

    @Deprecated
    public CtRuleTreeNode() {
    }

    public CtRuleTreeNode(String id, String name, String parentId, String devType, String designJson) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
        this.devType = devType;
        this.designJson = designJson;
        this.newed = false;
        this.changed = false;
        this.deleted = false;
        this.children = new HashMap<String, CtRuleTreeNode>();
    }

    public List<Map<String, Map<String, Object>>> getLocaleItems() {
        return this.localeItems;
    }

    public void setLocaleItems(List<Map<String, Map<String, Object>>> localeItems) {
        this.localeItems = localeItems;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getDevType() {
        return this.devType;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }

    public String getDesignJson() {
        return this.designJson;
    }

    public void setDesignJson(String xml) {
        this.designJson = xml;
    }

    public Map<String, CtRuleTreeNode> getChildren() {
        return this.children;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Set<String> getLocaleIds() {
        return this.localeIds;
    }

    public void setLocaleIds(Set<String> localeIds) {
        this.localeIds = localeIds;
    }

    public boolean isCanModify() {
        return this.canModify;
    }

    public void setCanModify(boolean canModify) {
        this.canModify = canModify;
    }

    public boolean isNewed() {
        return this.newed;
    }

    public void setNewed(boolean newed) {
        this.newed = newed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public static CtRuleTreeNode BuildRuleTree(List<CtConvertRuleMetadata> ruleMetadatas) {
        CtRuleTreeNode rootNode = new CtRuleTreeNode("0", ResManager.loadKDString((String)"\u5168\u90e8\u89c4\u5219", (String)"ConvertRuleEdit_48", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]), "", "0", "");
        String currentIsv = ISVService.getISVInfo().getId();
        HashMap<String, CtConvertRuleMetadata> ruleMap = new HashMap<String, CtConvertRuleMetadata>(16);
        for (CtConvertRuleMetadata ruleMetadata : ruleMetadatas) {
            ruleMap.put(ruleMetadata.getId(), ruleMetadata);
        }
        HashMap<String, CtRuleTreeNode> nodes = new HashMap<String, CtRuleTreeNode>(16);
        for (CtConvertRuleMetadata ruleMetadata : ruleMetadatas) {
            CtConvertRuleMetadata parentRuleMeta = null;
            if (StringUtils.isNotBlank((CharSequence)ruleMetadata.getParentId())) {
                parentRuleMeta = (CtConvertRuleMetadata)((Object)ruleMap.get(ruleMetadata.getParentId()));
            }
            CtRuleTreeNode node = CtRuleTreeNode.buildRuleNode(parentRuleMeta, ruleMetadata, currentIsv);
            nodes.put(ruleMetadata.getId(), node);
        }
        for (CtRuleTreeNode node : nodes.values()) {
            if (StringUtils.isBlank((CharSequence)node.getParentId())) {
                rootNode.children.put(node.getId(), node);
                continue;
            }
            CtRuleTreeNode parentNode = (CtRuleTreeNode)nodes.get(node.getParentId());
            if (parentNode == null) continue;
            parentNode.getChildren().put(node.getId(), node);
        }
        return rootNode;
    }

    public static CtRuleTreeNode buildRuleNode(CtConvertRuleMetadata parentRuleMeta, CtConvertRuleMetadata ruleMetadata, String currentIsv) {
        CtConvertRuleTemplate template = new CtConvertRuleTemplate();
        boolean isKingdee = StringUtils.equals((CharSequence)currentIsv, (CharSequence)"kingdee");
        if (isKingdee && StringUtils.isBlank((CharSequence)ruleMetadata.getIsv())) {
            ruleMetadata.setIsv(currentIsv);
        }
        String xml = template.buildDiffXml(ruleMetadata, parentRuleMeta, false);
        DesignCtConvertRuleMeta designMeta = (DesignCtConvertRuleMeta)ruleMetadata.convertToDesignMeta(xml);
        String designJson = SerializationUtils.toJsonString((Object)((Object)designMeta));
        CtRuleTreeNode node = new CtRuleTreeNode(ruleMetadata.getId(), ruleMetadata.getName().toString(), ruleMetadata.getParentId(), ruleMetadata.getDevType(), designJson);
        node.setEnabled(ruleMetadata.getRuleElement().isEnabled());
        List<Map<String, ILocaleValue<?>>> localeItems = ruleMetadata.getLocaleItems();
        HashSet<String> localeIds = new HashSet<String>(10);
        ArrayList<Map<String, Map<String, Object>>> list = new ArrayList<Map<String, Map<String, Object>>>(10);
        for (Map<String, ILocaleValue<?>> localeMap : localeItems) {
            HashMap<String, Map> v = new HashMap<String, Map>(16);
            for (Map.Entry<String, ILocaleValue<?>> data : localeMap.entrySet()) {
                localeIds.addAll(data.getValue().keySet());
                Map map = (Map)data.getValue();
                v.put(data.getKey(), map);
            }
            list.add(v);
        }
        node.setLocaleItems(list);
        node.setLocaleIds(localeIds);
        node.setCanModify(StringUtils.equals((CharSequence)ruleMetadata.getIsv(), (CharSequence)currentIsv));
        return node;
    }

    public TreeNode buildTreeNodes() {
        TreeNode currNode = new TreeNode();
        currNode.setId(this.id);
        currNode.setText(this.buildTreeNodeName());
        currNode.setIsOpened(true);
        currNode.setChildren(new ArrayList());
        for (CtRuleTreeNode child : this.children.values()) {
            TreeNode childNode = child.buildTreeNodes();
            currNode.addChild(childNode);
        }
        return currNode;
    }

    public TreeNode buildTreeNode() {
        TreeNode currNode = new TreeNode();
        currNode.setId(this.id);
        currNode.setText(this.buildTreeNodeName());
        currNode.setParentid(this.getParentId());
        currNode.setChildren(new ArrayList());
        currNode.setIsOpened(true);
        return currNode;
    }

    public CtConvertRuleMetadata deserialize(CtRuleTreeNode rootNode) {
        CtRuleTreeNode parentRuleNode;
        if (StringUtils.isBlank((CharSequence)this.designJson)) {
            return null;
        }
        DesignCtConvertRuleMeta designMeta = (DesignCtConvertRuleMeta)((Object)SerializationUtils.fromJsonString((String)this.designJson, DesignCtConvertRuleMeta.class));
        String xml = designMeta.getDataXml();
        CtConvertRuleMetadata parentRuleMeta = null;
        if (StringUtils.isNotBlank((CharSequence)this.getParentId()) && (parentRuleNode = rootNode.searchRule(this.getParentId())) != null) {
            parentRuleMeta = parentRuleNode.deserialize(rootNode);
        }
        CtConvertRuleTemplate template = new CtConvertRuleTemplate();
        CtConvertRuleMetadata ruleMetadata = template.getMetadata(xml, parentRuleMeta);
        String modelType = ruleMetadata.getModelType();
        MetadataSerializer serializer = new MetadataSerializer(modelType);
        String curLocaleId = RequestContext.get().getLang().name();
        List<Map<String, Map<String, Object>>> localeItems = this.localeItems;
        Set<String> localIds = this.localeIds;
        LangWriter writer = new LangWriter(serializer.getBinder(), (Object)ruleMetadata, localeItems);
        localIds.remove(null);
        localIds.remove(curLocaleId);
        writer.setLoaceValue(new ArrayList<String>(localIds));
        ruleMetadata.convertFromDesignMeta(designMeta);
        return ruleMetadata;
    }

    public List<CtRuleTreeNode> mergeAllChildren() {
        ArrayList<CtRuleTreeNode> allList = new ArrayList<CtRuleTreeNode>();
        for (CtRuleTreeNode rule : this.children.values()) {
            allList.add(rule);
            allList.addAll(rule.mergeAllChildren());
        }
        return allList;
    }

    public CtRuleTreeNode searchRule(String ruleId) {
        if (this.id.equalsIgnoreCase(ruleId)) {
            return this;
        }
        List<CtRuleTreeNode> allChildren = this.mergeAllChildren();
        for (CtRuleTreeNode rule : allChildren) {
            if (!rule.getId().equals(ruleId)) continue;
            return rule;
        }
        return null;
    }

    private String buildTreeNodeName() {
        String status = "";
        status = this.isEnabled() ? ResManager.loadKDString((String)"\u5df2\u542f\u7528", (String)"ConvertRuleEdit_49", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u505c\u7528", (String)"ConvertRuleEdit_50", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]);
        String dev = "";
        dev = StringUtils.equals((CharSequence)this.getDevType(), (CharSequence)"2") ? ResManager.loadKDString((String)"\u6269\u5c55", (String)"ConvertRuleEdit_55", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]) : (StringUtils.equals((CharSequence)this.getDevType(), (CharSequence)"1") ? ResManager.loadKDString((String)"\u7ee7\u627f", (String)"ConvertRuleEdit_56", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u539f\u59cb", (String)"ConvertRuleEdit_57", (String)BOS_DESIGNER_PLUGIN, (Object[])new Object[0]));
        return String.format("%s(%s,%s)", this.getName(), dev, status);
    }
}

