/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.ctbotp;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.botp.BOTPServiceFactory;
import kd.bos.service.botp.metadata.IConvertRuleReaderProxy;
import kd.bos.service.botp.metadata.IConvertRuleWriterProxy;
import kd.bos.service.metadata.MetadataLogService;

@DataEntityTypeAttribute(tableName="T_CTBOTP_ConvertRule", dbRouteKey="sys")
public class DesignCtConvertRuleMeta
extends DesignMeta {
    private static Log log = LogFactory.getLog(DesignCtConvertRuleMeta.class);
    private static final long serialVersionUID = 7694422362445119122L;
    private String sourceEntityNumber;
    private String sourceEntityName;
    private String sourceTenant;
    private String sourceDataCenter;
    private String sourceAccountNumber;
    private String targetEntityNumber;
    private String targetEntityName;
    private String targetTenant;
    private String targetDataCenter;
    private String targetAccountNumber;
    private String tenantPath;
    private Date createDate = new Date();
    private Long modifierId;
    private Date modifyDate;
    private String sysStatus;
    private boolean enabled = Boolean.TRUE;
    private Long currentVerId;
    private String syncType;
    private String sBizAppId;
    private String sBizAppName;
    private String tBizAppId;
    private String tBizAppName;

    @SimplePropertyAttribute(isDbIgnore=true)
    public String getNumber() {
        return super.getNumber();
    }

    @SimplePropertyAttribute(isDbIgnore=true)
    public Integer getSubSysId() {
        return super.getSubSysId();
    }

    @SimplePropertyAttribute(alias="FSourceEntityNumber", dbType=12)
    public String getSourceEntityNumber() {
        return this.sourceEntityNumber;
    }

    public void setSourceEntityNumber(String sourceEntityNumber) {
        this.sourceEntityNumber = sourceEntityNumber;
    }

    @SimplePropertyAttribute(alias="FSourceTenant", dbType=12)
    public String getSourceTenant() {
        return this.sourceTenant;
    }

    public void setSourceTenant(String sourceTenant) {
        this.sourceTenant = sourceTenant;
    }

    @SimplePropertyAttribute(alias="FSourceDataCenter", dbType=12)
    public String getSourceDataCenter() {
        return this.sourceDataCenter;
    }

    public void setSourceDataCenter(String sourceDataCenter) {
        this.sourceDataCenter = sourceDataCenter;
    }

    @SimplePropertyAttribute(alias="FTargetEntityNumber", dbType=12)
    public String getTargetEntityNumber() {
        return this.targetEntityNumber;
    }

    public void setTargetEntityNumber(String targetEntityNumber) {
        this.targetEntityNumber = targetEntityNumber;
    }

    @SimplePropertyAttribute(alias="FTargetTenant", dbType=12)
    public String getTargetTenant() {
        return this.targetTenant;
    }

    public void setTargetTenant(String targetTenant) {
        this.targetTenant = targetTenant;
    }

    @SimplePropertyAttribute(alias="FTargetDataCenter", dbType=12)
    public String getTargetDataCenter() {
        return this.targetDataCenter;
    }

    public void setTargetDataCenter(String targetDataCenter) {
        this.targetDataCenter = targetDataCenter;
    }

    @SimplePropertyAttribute(alias="FCreateDate", dbType=91)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @SimplePropertyAttribute(alias="FModifierId", dbType=-5)
    public Long getModifierId() {
        return this.modifierId;
    }

    public void setModifierId(Long modifierId) {
        this.modifierId = modifierId;
    }

    @SimplePropertyAttribute(alias="FModifyDate", dbType=91)
    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    @SimplePropertyAttribute(alias="FSysStatus", dbType=12)
    public String getSysStatus() {
        return this.sysStatus;
    }

    public void setSysStatus(String sysStatus) {
        this.sysStatus = sysStatus;
    }

    @SimplePropertyAttribute(alias="FEnabled", dbType=16)
    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SimplePropertyAttribute(alias="FCurrentVerId", dbType=-5)
    public Long getCurrentVerId() {
        return this.currentVerId;
    }

    @SimplePropertyAttribute(alias="FSyncType", dbType=12)
    public String getSyncType() {
        return this.syncType;
    }

    public void setSyncType(String syncType) {
        this.syncType = syncType;
    }

    @SimplePropertyAttribute(alias="FSBizAppId", dbType=12)
    public String getsBizAppId() {
        return this.sBizAppId;
    }

    public void setsBizAppId(String sBizAppId) {
        this.sBizAppId = sBizAppId;
    }

    @SimplePropertyAttribute(alias="FTBizAppId", dbType=12)
    public String gettBizAppId() {
        return this.tBizAppId;
    }

    public void settBizAppId(String tBizAppId) {
        this.tBizAppId = tBizAppId;
    }

    public void setCurrentVerId(Long currentVerId) {
        this.currentVerId = currentVerId;
    }

    @SimplePropertyAttribute(alias="fsourceentityname", dbType=12)
    public String getSourceEntityName() {
        return this.sourceEntityName;
    }

    public void setSourceEntityName(String sourceEntityName) {
        this.sourceEntityName = sourceEntityName;
    }

    @SimplePropertyAttribute(alias="fsourceaccountnumber", dbType=12)
    public String getSourceAccountNumber() {
        return this.sourceAccountNumber;
    }

    public void setSourceAccountNumber(String sourceAccountNumber) {
        this.sourceAccountNumber = sourceAccountNumber;
    }

    @SimplePropertyAttribute(alias="ftargetentityname", dbType=12)
    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public void setTargetEntityName(String targetEntityName) {
        this.targetEntityName = targetEntityName;
    }

    @SimplePropertyAttribute(alias="ftargetaccountnumber", dbType=12)
    public String getTargetAccountNumber() {
        return this.targetAccountNumber;
    }

    public void setTargetAccountNumber(String targetAccountNumber) {
        this.targetAccountNumber = targetAccountNumber;
    }

    @SimplePropertyAttribute(alias="FTenantPath", dbType=12)
    public String getTenantPath() {
        return this.tenantPath;
    }

    public void setTenantPath(String tenantPath) {
        this.tenantPath = tenantPath;
    }

    @SimplePropertyAttribute(alias="fsbizappname", dbType=12)
    public String getsBizAppName() {
        return this.sBizAppName;
    }

    public void setsBizAppName(String sBizAppName) {
        this.sBizAppName = sBizAppName;
    }

    @SimplePropertyAttribute(alias="ftbizappname", dbType=12)
    public String gettBizAppName() {
        return this.tBizAppName;
    }

    public void settBizAppName(String tBizAppName) {
        this.tBizAppName = tBizAppName;
    }

    public void deployMetadata() {
        super.deployMetadata();
        this.setModifierId(Long.valueOf(RequestContext.get().getUserId()));
        this.setModifyDate(new Date());
        try (TXHandle h = TX.notSupported();){
            this.writeMetadataLog(this.getId(), this.getSourceEntityNumber(), this.getTargetEntityNumber(), this.getDataXml(), this.getBizappId());
        }
        catch (Exception var14) {
            log.error("\u5bfc\u5165\u8f6c\u6362\u89c4\u5219\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38", (Throwable)var14);
        }
        IConvertRuleWriterProxy convertRuleWriter = (IConvertRuleWriterProxy)BOTPServiceFactory.getSingletonService(IConvertRuleWriterProxy.class);
        convertRuleWriter.clearCache(new String[]{this.getId()});
    }

    private void writeMetadataLog(String ruleId, String sourceEntityNumber, String targetEntityNumber, String xmlData, String bizappId) {
        IConvertRuleReaderProxy reader;
        String sourceXmlData;
        String metaNumber = sourceEntityNumber + "-" + targetEntityNumber;
        String remark = ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219", (String)"DesignConvertRuleMeta_0", (String)"bos-metadata", (Object[])new Object[0]);
        MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        if (CollectionUtils.isEmpty((Collection)logService.queryMetaIds(Collections.singletonList(ruleId))) && (sourceXmlData = (reader = (IConvertRuleReaderProxy)BOTPServiceFactory.getSingletonService(IConvertRuleReaderProxy.class)).buildXml(ruleId, false, false)) != null) {
            long logId = DB.genGlobalLongId();
            logService.addBotpMetaLog(ruleId, metaNumber, sourceXmlData, (int)MetaLogType.BotpInit.getValue(), logId, bizappId, remark);
        }
        long logId = DB.genGlobalLongId();
        logService.addBotpMetaLog(ruleId, metaNumber, xmlData, (int)MetaLogType.BotpImport.getValue(), logId, bizappId, remark);
    }
}

