/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.metadata;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ctbotp.CtConvertRuleCache;
import kd.bos.metadata.ctbotp.CtConvertRuleReader;
import kd.bos.metadata.ctbotp.CtConvertRuleVer;

public class CtBOTPMetadataReader {
    public static String loadCtConvertRule(String ruleId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT TOP 1 FID,FData_tag ");
        sBuilder.append("FROM T_CTBOTP_ConvertRuleVer ");
        sBuilder.append("WHERE FRuleId = ? ");
        sBuilder.append("ORDER BY FID DESC ");
        Object[] params = new SqlParameter[]{new SqlParameter(":FRuleId", 12, (Object)ruleId)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                String data = "";
                if (rs.next()) {
                    data = rs.getString("FData_tag");
                }
                return data;
            }
        };
        String ruleString = (String)DB.query((DBRoute)DBRoute.base, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
        return ruleString;
    }

    public static CtConvertRuleVer loadCtConvertRuleByVerId(String ruleId, String verId, String extVerId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FRuleId", 12, (Object)ruleId), new SqlParameter(":FOriVersion", -5, (Object)Long.valueOf(verId)), new SqlParameter(":FExtVersion", -5, (Object)(StringUtils.isNotBlank((CharSequence)extVerId) ? Long.parseLong(extVerId) : 0L))};
        ResultSetHandler<CtConvertRuleVer> action = new ResultSetHandler<CtConvertRuleVer>(){

            public CtConvertRuleVer handle(ResultSet rs) throws Exception {
                CtConvertRuleVer ruleVer = new CtConvertRuleVer();
                if (rs.next()) {
                    String data = rs.getString("FData_tag");
                    Long fid = rs.getLong("FID");
                    ruleVer.setData(data);
                    ruleVer.setFid(fid);
                }
                return ruleVer;
            }
        };
        String sql = "SELECT TOP 1 FID,FData_tag FROM T_CTBOTP_ConvertRuleVer WHERE FRuleId = ?  AND  FOriVersion = ?  AND  FExtVersion = ? ";
        return (CtConvertRuleVer)DB.query((DBRoute)DBRoute.base, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    public static List<String> loadCtConvertRules(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber) {
        CtConvertRuleReader reader = new CtConvertRuleReader();
        List<String> ruleIds = reader.loadRuleIds(sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber, true);
        ArrayList<String> ruleStrings = new ArrayList<String>(10);
        for (String ruleId : ruleIds) {
            String ruleString = CtBOTPMetadataReader.loadCtConvertRule(ruleId);
            ruleStrings.add(ruleString);
        }
        return ruleStrings;
    }

    public static List<String> loadCtConvertRuleIds(String sourceTenant, String sourceDataCenter, String sourceEntityNumber, String targetTenant, String targetDataCenter, String targetEntityNumber) {
        CtConvertRuleReader reader = new CtConvertRuleReader();
        return reader.loadRuleIds(sourceTenant, sourceDataCenter, sourceEntityNumber, targetTenant, targetDataCenter, targetEntityNumber, true);
    }

    public static void clearAllCtConvertRuleCache() {
        CtConvertRuleCache.clearAllConvertRuleCache();
    }
}

