/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.ConvertRuleElementDcBinder;
import kd.bos.entity.botp.ConvertRuleKeyPair;
import kd.bos.entity.botp.ConvertRuleLocalCache;
import kd.bos.entity.botp.ConvertRuleRedisCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.collections.CollectionUtils;

@SdkPublic
public class ConvertRuleCache {
    private static final Log log = LogFactory.getLog(ConvertRuleCache.class);

    public static List<ConvertRuleElement> loadRules(String[] ids) {
        long ts = System.currentTimeMillis();
        ArrayList<ConvertRuleElement> ruleElements = new ArrayList<ConvertRuleElement>(10);
        Map<String, ConvertRuleElement> rules = ConvertRuleLocalCache.getConvertRules(ids);
        List<String> convertRuleVersions = ConvertRuleRedisCache.getConvertRuleVersions(ids);
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            ConvertRuleElement rule = rules.get(ids[i]);
            if (rule != null) {
                if (StringUtils.isBlank((CharSequence)rule.getCacheVersion()) || !StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)convertRuleVersions.get(i)) || Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                    ruleElements.add(ConvertRuleCache.getRedisCacheRule(id));
                    continue;
                }
                ruleElements.add(rule);
                continue;
            }
            ruleElements.add(ConvertRuleCache.getRedisCacheRule(id));
        }
        return ruleElements;
    }

    private static ConvertRuleElement getRedisCacheRule(String id) {
        String cacheVersion = null;
        String ruleXml = ConvertRuleRedisCache.getConvertRule(id);
        if (ruleXml != null) {
            cacheVersion = ConvertRuleRedisCache.getConvertRuleVersion(id);
            if (StringUtils.isBlank((CharSequence)cacheVersion)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                cacheVersion = sdf.format(new Date());
                ConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
            }
        } else {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleXml = service.loadConvertRule(id);
            if (StringUtils.isBlank((CharSequence)ruleXml)) {
                ruleXml = "";
            }
            ConvertRuleRedisCache.putConvertRule(id, ruleXml);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            ConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            DcJsonSerializer serializer = ConvertRuleCache.getSerializer();
            ConvertRuleElement rule = ConvertRuleCache.deserializeFromString(serializer, ruleXml);
            if (rule != null) {
                rule.setCacheVersion(cacheVersion);
                rule.setCheckVersionTimeMillis(System.currentTimeMillis());
            }
            ConvertRuleLocalCache.putConvertRule(id, rule);
            return rule;
        }
        return null;
    }

    public static ConvertRuleElement loadRule(String id) {
        long ts = System.currentTimeMillis();
        ConvertRuleElement rule = ConvertRuleLocalCache.getConvertRule(id);
        if (rule != null) {
            if (StringUtils.isBlank((CharSequence)rule.getCacheVersion())) {
                rule = null;
            } else if (!StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)ConvertRuleRedisCache.getConvertRuleVersion(id))) {
                rule = null;
            } else if (Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                rule = null;
            }
        }
        if (rule != null) {
            return rule;
        }
        String cacheVersion = null;
        String ruleXml = ConvertRuleRedisCache.getConvertRule(id);
        if (ruleXml != null) {
            cacheVersion = ConvertRuleRedisCache.getConvertRuleVersion(id);
            if (StringUtils.isBlank((CharSequence)cacheVersion)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                cacheVersion = sdf.format(new Date());
                ConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
            }
        } else {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleXml = service.loadConvertRule(id);
            if (StringUtils.isBlank((CharSequence)ruleXml)) {
                ruleXml = "";
            }
            ConvertRuleRedisCache.putConvertRule(id, ruleXml);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            ConvertRuleRedisCache.putConvertRuleVersion(id, cacheVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            DcJsonSerializer serializer = ConvertRuleCache.getSerializer();
            rule = ConvertRuleCache.deserializeFromString(serializer, ruleXml);
            if (rule == null) {
                return null;
            }
            rule.setCacheVersion(cacheVersion);
            rule.setCheckVersionTimeMillis(System.currentTimeMillis());
            ConvertRuleLocalCache.putConvertRule(id, rule);
            return rule;
        }
        return null;
    }

    public static List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber) {
        List ruleIds = null;
        String cacheRuleIds = ConvertRuleRedisCache.getConvertRuleIds(sourceEntityNumber, targetEntityNumber);
        if (cacheRuleIds != null) {
            ruleIds = (List)SerializationUtils.fromJsonString((String)cacheRuleIds, List.class);
        } else {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleIds = service.loadConvertRuleIds(sourceEntityNumber, targetEntityNumber);
            cacheRuleIds = SerializationUtils.toJsonString((Object)ruleIds);
            ConvertRuleRedisCache.putConvertRuleIds(sourceEntityNumber, targetEntityNumber, cacheRuleIds);
        }
        ArrayList<ConvertRuleElement> rules = new ArrayList<ConvertRuleElement>();
        for (String ruleId : ruleIds) {
            ConvertRuleElement rule = ConvertRuleCache.loadRule(ruleId);
            if (rule == null) continue;
            rules.add(rule);
        }
        return rules;
    }

    public static Map<ConvertRuleKeyPair, List<ConvertRuleElement>> batchLoadRules(List<ConvertRuleKeyPair> keys) {
        if (keys == null || keys.isEmpty()) {
            return new HashMap<ConvertRuleKeyPair, List<ConvertRuleElement>>(0);
        }
        List ruleIds = null;
        HashMap<ConvertRuleKeyPair, List<ConvertRuleElement>> convertRuleElementMap = new HashMap<ConvertRuleKeyPair, List<ConvertRuleElement>>(16);
        ArrayList<String> keyList = new ArrayList<String>(10);
        LinkedHashMap<ConvertRuleKeyPair, String> keyPair = new LinkedHashMap<ConvertRuleKeyPair, String>(16);
        for (ConvertRuleKeyPair convertRuleKeyPair : keys) {
            String key = String.format("%s_to_%s", convertRuleKeyPair.getSourceEntityNumber(), convertRuleKeyPair.getTargetEntityNumber());
            keyList.add(key);
            keyPair.put(convertRuleKeyPair, key);
        }
        List<String> cacheRuleIdss = ConvertRuleRedisCache.batchGetConvertRuleIds(keyList.toArray(new String[0]));
        HashMap<String, String> batchCacheRules = new HashMap<String, String>(16);
        int i = 0;
        for (Map.Entry entry : keyPair.entrySet()) {
            String cacheRuleIds = null;
            if (cacheRuleIdss != null && cacheRuleIdss.size() > i) {
                cacheRuleIds = cacheRuleIdss.get(i);
            }
            if (StringUtils.isNotBlank(cacheRuleIds)) {
                ruleIds = (List)SerializationUtils.fromJsonString(cacheRuleIds, List.class);
            } else {
                MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
                ruleIds = service.loadConvertRuleIds(((ConvertRuleKeyPair)entry.getKey()).getSourceEntityNumber(), ((ConvertRuleKeyPair)entry.getKey()).getTargetEntityNumber());
                cacheRuleIds = SerializationUtils.toJsonString((Object)ruleIds);
                batchCacheRules.put((String)entry.getValue(), cacheRuleIds);
            }
            ++i;
            if (CollectionUtils.isEmpty((Collection)ruleIds)) continue;
            convertRuleElementMap.put((ConvertRuleKeyPair)entry.getKey(), ConvertRuleCache.loadRules(ruleIds.toArray(new String[0])));
        }
        if (!batchCacheRules.isEmpty()) {
            ConvertRuleRedisCache.batchPutConvertRuleIds(batchCacheRules);
        }
        return convertRuleElementMap;
    }

    public static synchronized void clearAllConvertRuleCache() {
        ConvertRuleLocalCache.clearAllConvertRuleCache();
        ConvertRuleRedisCache.clearAllConvertRuleCache();
        log.info("clearAllConvertRuleCache");
    }

    public static void clearConvertRuleCache(String ruleId) {
        ConvertRuleRedisCache.clearConvertRuleCache(ruleId);
    }

    public static String loadDebugRule(String id, String cacheType) {
        if (StringUtils.isBlank((CharSequence)cacheType) || StringUtils.equals((CharSequence)cacheType, (CharSequence)"local")) {
            ConvertRuleElement rule = ConvertRuleLocalCache.getConvertRule(id);
            if (rule == null) {
                return "null";
            }
            return SerializationUtils.toJsonString((Object)rule);
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"redis")) {
            String xml = ConvertRuleRedisCache.getConvertRule(id);
            if (StringUtils.isBlank((CharSequence)xml)) {
                return "null";
            }
            return xml;
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"db")) {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            String xml = service.loadConvertRule(id);
            if (StringUtils.isBlank((CharSequence)xml)) {
                return "null";
            }
            return xml;
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"clear")) {
            ConvertRuleCache.clearAllConvertRuleCache();
            return "clear all rule cache success";
        }
        return "null";
    }

    private static DcJsonSerializer getSerializer() {
        ConvertRuleElementDcBinder binder = new ConvertRuleElementDcBinder();
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)binder);
        serializer.setIsLocaleValueFull(true);
        return serializer;
    }

    private static ConvertRuleElement deserializeFromString(DcJsonSerializer serializer, String ruleString) {
        if (StringUtils.isBlank((CharSequence)ruleString)) {
            return null;
        }
        serializer.setIsLocaleValueFull(true);
        ConvertRuleElement ruleElement = (ConvertRuleElement)serializer.deserializeFromString(ruleString, null);
        if (ruleElement.getName() == null) {
            serializer.setIsLocaleValueFull(false);
            ruleElement = (ConvertRuleElement)serializer.deserializeFromString(ruleString, null);
        }
        return ruleElement;
    }
}

