/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.AttachmentPanelMapPolicy;
import kd.bos.entity.botp.BillTypeMapPolicy;
import kd.bos.entity.botp.BizRulePolicy;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.ConvertRuleLocalCache;
import kd.bos.entity.botp.ConvertRuleRedisCache;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.entity.botp.FilterPolicy;
import kd.bos.entity.botp.GroupByPolicy;
import kd.bos.entity.botp.LinkEntityPolicy;
import kd.bos.entity.botp.LinkRecordType;
import kd.bos.entity.botp.OptionPolicy;
import kd.bos.entity.botp.PlugInPolicy;

public interface ConvertRuleElementBuilder {
    public static final String BOS_ENTITY_CORE = "bos-botp-core";
    public static final ThreadLocal<Set<String>> ruleIdThreadLocal = new ThreadLocal();

    public static void putConvertRule(String ruleId, ConvertRuleElement rule) {
        ConvertRuleLocalCache.putConvertRule(ruleId, rule);
        ConvertRuleRedisCache.putConvertRuleVersion(ruleId, rule.getCacheVersion());
        Set<String> ruleIds = ruleIdThreadLocal.get();
        if (ruleIds == null) {
            ruleIds = new HashSet<String>();
        }
        ruleIds.add(ruleId);
    }

    public static void removeConvertRule(String ruleId) {
        ConvertRuleLocalCache.removeConverRule(ruleId);
        ConvertRuleRedisCache.clearConvertRuleCache(ruleId);
    }

    public static void removeAll() {
        Set<String> ruleIds = ruleIdThreadLocal.get();
        for (String ruleId : ruleIds) {
            ConvertRuleLocalCache.removeConverRule(ruleId);
            ConvertRuleRedisCache.clearConvertRuleCache(ruleId);
        }
    }

    public static ConvertRuleElementBuilder builder(String ruleId, String sourceEntityNumber, String targetEntityNumber) {
        return new ConvertRuleElementBuilderImpl(ruleId, sourceEntityNumber, targetEntityNumber);
    }

    public ConvertRuleElementBuilder runCondition(CRCondition var1);

    public ConvertRuleElementBuilder linkEntityPolicy(LinkEntityPolicy var1);

    public ConvertRuleElementBuilder fieldMapPolicy(FieldMapPolicy var1);

    public ConvertRuleElementBuilder filterPolicy(FilterPolicy var1);

    public ConvertRuleElementBuilder groupByPolicy(GroupByPolicy var1);

    public ConvertRuleElementBuilder plugInPolicy(PlugInPolicy var1);

    public ConvertRuleElementBuilder bizRulePolicy(BizRulePolicy var1);

    public ConvertRuleElementBuilder billTypeMapPolicy(BillTypeMapPolicy var1);

    public ConvertRuleElementBuilder attachmentPanelMapPolicy(AttachmentPanelMapPolicy var1);

    public ConvertRuleElementBuilder optionPolicy(OptionPolicy var1);

    public ConvertRuleElement build();

    public static class ConvertRuleElementBuilderImpl
    implements ConvertRuleElementBuilder {
        private String id;
        private LocaleString name;
        private String sourceEntityNumber;
        private String targetEntityNumber;
        private boolean enabled;
        private boolean defRule;
        private boolean visibled;
        private boolean visibledCtrl;
        private boolean drawVisibled;
        private boolean autoSave;
        private transient long checkVersionTimeMillis;
        private String cacheVersion;
        private CRCondition runCondition;
        private LinkEntityPolicy linkEntityPolicy;
        private FieldMapPolicy fieldMapPolicy;
        private FilterPolicy filterPolicy;
        private GroupByPolicy groupByPolicy;
        private PlugInPolicy plugInPolicy;
        private BizRulePolicy bizRulePolicy;
        private BillTypeMapPolicy billTypeMapPolicy;
        private AttachmentPanelMapPolicy attachmentPanelMapPolicy;
        private OptionPolicy optionPolicy;

        public ConvertRuleElementBuilderImpl(String ruleId, String sourceEntityNumber, String targetEntityNumber) {
            this.id = ruleId;
            this.name = new LocaleString(ResManager.loadKDString((String)"\u6d4b\u8bd5", (String)"ConvertRuleElementBuilder_0", (String)ConvertRuleElementBuilder.BOS_ENTITY_CORE, (Object[])new Object[0]));
            this.sourceEntityNumber = sourceEntityNumber;
            this.targetEntityNumber = targetEntityNumber;
            this.visibled = true;
            this.visibledCtrl = false;
            this.drawVisibled = true;
            this.enabled = true;
            this.defRule = true;
            this.autoSave = false;
            this.runCondition = new CRCondition();
            this.initLinkEntityPolicy();
            this.fieldMapPolicy = new FieldMapPolicy();
            this.filterPolicy = new FilterPolicy();
            this.groupByPolicy = new GroupByPolicy();
            this.plugInPolicy = new PlugInPolicy();
            this.bizRulePolicy = new BizRulePolicy();
            this.billTypeMapPolicy = new BillTypeMapPolicy();
            this.attachmentPanelMapPolicy = new AttachmentPanelMapPolicy();
            this.optionPolicy = new OptionPolicy();
            this.checkVersionTimeMillis = System.currentTimeMillis();
            this.cacheVersion = "2023-03-02 01:22:20";
        }

        private void initLinkEntityPolicy() {
            this.linkEntityPolicy = new LinkEntityPolicy();
            this.linkEntityPolicy.setSourceEntryKey(this.sourceEntityNumber);
            this.linkEntityPolicy.setTargetEntryKey(this.targetEntityNumber);
            this.linkEntityPolicy.setLinkRecordType(LinkRecordType.Link);
        }

        @Override
        public ConvertRuleElementBuilder runCondition(CRCondition runCondition) {
            this.runCondition = runCondition;
            return this;
        }

        @Override
        public ConvertRuleElementBuilder linkEntityPolicy(LinkEntityPolicy linkEntityPolicy) {
            this.linkEntityPolicy = linkEntityPolicy;
            return this;
        }

        @Override
        public ConvertRuleElementBuilder fieldMapPolicy(FieldMapPolicy fieldMapPolicy) {
            this.fieldMapPolicy = fieldMapPolicy;
            return this;
        }

        @Override
        public ConvertRuleElementBuilder filterPolicy(FilterPolicy filterPolicy) {
            this.filterPolicy = filterPolicy;
            return this;
        }

        @Override
        public ConvertRuleElementBuilder groupByPolicy(GroupByPolicy groupByPolicy) {
            this.groupByPolicy = groupByPolicy;
            return this;
        }

        @Override
        public ConvertRuleElementBuilder plugInPolicy(PlugInPolicy plugInPolicy) {
            this.plugInPolicy = plugInPolicy;
            return this;
        }

        @Override
        public ConvertRuleElementBuilder bizRulePolicy(BizRulePolicy bizRulePolicy) {
            this.bizRulePolicy = bizRulePolicy;
            return this;
        }

        @Override
        public ConvertRuleElementBuilder billTypeMapPolicy(BillTypeMapPolicy billTypeMapPolicy) {
            this.billTypeMapPolicy = billTypeMapPolicy;
            return this;
        }

        @Override
        public ConvertRuleElementBuilder attachmentPanelMapPolicy(AttachmentPanelMapPolicy attachmentPanelMapPolicy) {
            this.attachmentPanelMapPolicy = attachmentPanelMapPolicy;
            return this;
        }

        @Override
        public ConvertRuleElementBuilder optionPolicy(OptionPolicy optionPolicy) {
            this.optionPolicy = optionPolicy;
            return this;
        }

        @Override
        public ConvertRuleElement build() {
            ConvertRuleElement convertRuleElement = new ConvertRuleElement();
            convertRuleElement.setId(this.id);
            convertRuleElement.setName(this.name);
            convertRuleElement.setSourceEntityNumber(this.sourceEntityNumber);
            convertRuleElement.setTargetEntityNumber(this.targetEntityNumber);
            convertRuleElement.setVisibled(this.visibled);
            convertRuleElement.setVisibledCtrl(this.visibledCtrl);
            convertRuleElement.setDrawVisibled(this.drawVisibled);
            convertRuleElement.setEnabled(this.enabled);
            convertRuleElement.setDefRule(this.defRule);
            convertRuleElement.setAutoSave(this.autoSave);
            convertRuleElement.setRunCondition(this.runCondition);
            convertRuleElement.setLinkEntityPolicy(this.linkEntityPolicy);
            convertRuleElement.setFieldMapPolicy(this.fieldMapPolicy);
            convertRuleElement.setFilterPolicy(this.filterPolicy);
            convertRuleElement.setGroupByPolicy(this.groupByPolicy);
            convertRuleElement.setPlugInPolicy(this.plugInPolicy);
            convertRuleElement.setBizRulePolicy(this.bizRulePolicy);
            convertRuleElement.setBillTypeMapPolicy(this.billTypeMapPolicy);
            convertRuleElement.setAttachmentPanelMapPolicy(this.attachmentPanelMapPolicy);
            convertRuleElement.setOptionPolicy(this.optionPolicy);
            convertRuleElement.setCacheVersion(this.cacheVersion);
            convertRuleElement.setCheckVersionTimeMillis(this.checkVersionTimeMillis);
            return convertRuleElement;
        }
    }
}

