/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

class ConvertRuleRedisCache {
    private static final String CR_DISTRIBUTE = "ConvertRule";
    private static final String Type_ConvertRule = "ConvertRule";
    private static final String Type_ConvertRuleVersion = "ConvertRuleVersion";
    private static final String Type_ConvertRuleList = "ConvertRuleList";

    ConvertRuleRedisCache() {
    }

    private static DistributeSessionlessCache getDistributeCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ConvertRule", new DistributeCacheHAPolicy(true, true));
    }

    public static void clearAllConvertRuleCache() {
        DistributeSessionlessCache cache = ConvertRuleRedisCache.getDistributeCache();
        cache.remove(ConvertRuleRedisCache.buildCacheType("ConvertRule"));
        cache.remove(ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleVersion));
        cache.remove(ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleList));
    }

    public static void clearConvertRuleCache(String ruleId) {
        DistributeSessionlessCache cache = ConvertRuleRedisCache.getDistributeCache();
        cache.remove(ConvertRuleRedisCache.buildCacheType("ConvertRule"), ruleId);
        cache.remove(ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleVersion), ruleId);
        cache.remove(ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleList), ruleId);
    }

    public static String getConvertRuleVersion(String ruleId) {
        String type = ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleVersion);
        return (String)ConvertRuleRedisCache.getDistributeCache().get(type, ruleId);
    }

    public static List<String> getConvertRuleVersions(String[] ruleIds) {
        String type = ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleVersion);
        return ConvertRuleRedisCache.getDistributeCache().get(type, ruleIds);
    }

    public static void putConvertRuleVersion(String ruleId, String version) {
        String type = ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleVersion);
        ConvertRuleRedisCache.getDistributeCache().put(type, ruleId, (Object)version);
    }

    public static String getConvertRule(String ruleId) {
        String type = ConvertRuleRedisCache.buildCacheType("ConvertRule");
        return (String)ConvertRuleRedisCache.getDistributeCache().get(type, ruleId);
    }

    public static void putConvertRule(String ruleId, String ruleStr) {
        String type = ConvertRuleRedisCache.buildCacheType("ConvertRule");
        ConvertRuleRedisCache.getDistributeCache().put(type, ruleId, (Object)ruleStr);
    }

    public static String getConvertRuleIds(String sourceEntityNumber, String targetEntityNumber) {
        String type = ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleList);
        String key = String.format("%s_to_%s", sourceEntityNumber, targetEntityNumber);
        return (String)ConvertRuleRedisCache.getDistributeCache().get(type, key);
    }

    public static List<String> batchGetConvertRuleIds(String[] keys) {
        String type = ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleList);
        return ConvertRuleRedisCache.getDistributeCache().get(type, keys);
    }

    public static void putConvertRuleIds(String sourceEntityNumber, String targetEntityNumber, String ruleIds) {
        String type = ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleList);
        String key = String.format("%s_to_%s", sourceEntityNumber, targetEntityNumber);
        ConvertRuleRedisCache.getDistributeCache().put(type, key, (Object)ruleIds);
    }

    public static void batchPutConvertRuleIds(Map<String, String> ruleIdss) {
        String type = ConvertRuleRedisCache.buildCacheType(Type_ConvertRuleList);
        ConvertRuleRedisCache.getDistributeCache().put(type, ruleIdss);
    }

    private static String buildCacheType(String type) {
        String accountId = CacheKeyUtil.getAcctId();
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return String.format("%s_%s_%s", accountId, appGroup, type);
        }
        return String.format("%s_%s", accountId, type);
    }
}

