/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByConditions;
import kd.bos.entity.botp.FieldConvertType;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldSumType;

public interface FieldMapItemBuilder {
    public static FieldMapItemBuilder buidler(String targetFieldKey, String sourceFieldKey) {
        return new FieldMapItemBuilderImpl(targetFieldKey, sourceFieldKey);
    }

    public FieldMapItemBuilder targetFieldKey(String var1);

    public FieldMapItemBuilder sourceFieldKey(String var1);

    public FieldMapItemBuilder fieldConvertType(FieldConvertType var1);

    public FieldMapItemBuilder fieldSumType(FieldSumType var1);

    public FieldMapItemBuilder formula(CRFormula var1);

    public FieldMapItemBuilder valByConditions(CRValByConditions var1);

    public FieldMapItemBuilder constant(CRFormula var1);

    public FieldMapItemBuilder drawFilter(boolean var1);

    public FieldMapItemBuilder drawAgainFilter(boolean var1);

    public FieldMapItemBuilder breakForNoDistribute(boolean var1);

    public FieldMapItemBuilder onlyTakeApprovedData(boolean var1);

    public FieldMapItemBuilder onlyTakeUsedData(boolean var1);

    public FieldMapItem build();

    public static class FieldMapItemBuilderImpl
    implements FieldMapItemBuilder {
        private String targetFieldKey;
        private String sourceFieldKey;
        private FieldConvertType fieldConvertType;
        private FieldSumType fieldSumType;
        private CRFormula formula;
        private CRValByConditions valByConditions;
        private CRFormula constant;
        private boolean drawFilter;
        private boolean drawAgainFilter;
        private boolean breakForNoDistribute;
        private boolean onlyTakeApprovedData;
        private boolean onlyTakeUsedData;

        public FieldMapItemBuilderImpl(String targetFieldKey, String sourceFieldKey) {
            this.targetFieldKey = targetFieldKey;
            this.sourceFieldKey = sourceFieldKey;
            this.fieldConvertType = FieldConvertType.SourceField;
            this.fieldSumType = FieldSumType.First;
            this.formula = new CRFormula();
            this.valByConditions = new CRValByConditions();
            this.constant = new CRFormula();
        }

        @Override
        public FieldMapItemBuilder targetFieldKey(String targetFieldKey) {
            this.targetFieldKey = targetFieldKey;
            return this;
        }

        @Override
        public FieldMapItemBuilder sourceFieldKey(String sourceFieldKey) {
            this.sourceFieldKey = sourceFieldKey;
            return this;
        }

        @Override
        public FieldMapItemBuilder fieldConvertType(FieldConvertType fieldConvertType) {
            this.fieldConvertType = fieldConvertType;
            return this;
        }

        @Override
        public FieldMapItemBuilder fieldSumType(FieldSumType fieldSumType) {
            this.fieldSumType = fieldSumType;
            return this;
        }

        @Override
        public FieldMapItemBuilder formula(CRFormula formula) {
            this.formula = formula;
            return this;
        }

        @Override
        public FieldMapItemBuilder valByConditions(CRValByConditions valByConditions) {
            this.valByConditions = valByConditions;
            return this;
        }

        @Override
        public FieldMapItemBuilder constant(CRFormula constant) {
            this.constant = constant;
            return this;
        }

        @Override
        public FieldMapItemBuilder drawFilter(boolean drawFilter) {
            this.drawFilter = drawFilter;
            return this;
        }

        @Override
        public FieldMapItemBuilder drawAgainFilter(boolean drawAgainFilter) {
            this.drawAgainFilter = drawAgainFilter;
            return this;
        }

        @Override
        public FieldMapItemBuilder breakForNoDistribute(boolean breakForNoDistribute) {
            this.breakForNoDistribute = breakForNoDistribute;
            return this;
        }

        @Override
        public FieldMapItemBuilder onlyTakeApprovedData(boolean onlyTakeApprovedData) {
            this.onlyTakeApprovedData = onlyTakeApprovedData;
            return this;
        }

        @Override
        public FieldMapItemBuilder onlyTakeUsedData(boolean onlyTakeUsedData) {
            this.onlyTakeUsedData = onlyTakeUsedData;
            return this;
        }

        @Override
        public FieldMapItem build() {
            FieldMapItem fieldMapItem = new FieldMapItem();
            fieldMapItem.setTargetFieldKey(this.targetFieldKey);
            fieldMapItem.setSourceFieldKey(this.sourceFieldKey);
            fieldMapItem.setFieldConvertType(this.fieldConvertType);
            fieldMapItem.setFieldSumType(this.fieldSumType);
            fieldMapItem.setFormula(this.formula);
            fieldMapItem.setValByConditions(this.valByConditions);
            fieldMapItem.setConstant(this.constant);
            fieldMapItem.setDrawFilter(this.drawFilter);
            fieldMapItem.setDrawAgainFilter(this.drawAgainFilter);
            fieldMapItem.setBreakForNoDistribute(this.breakForNoDistribute);
            fieldMapItem.setOnlyTakeApprovedData(this.onlyTakeApprovedData);
            fieldMapItem.setOnlyTakeUsedData(this.onlyTakeUsedData);
            return fieldMapItem;
        }
    }
}

