/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.WriteBackRuleElement;
import kd.bos.entity.botp.WriteBackRuleElementSerializer;
import kd.bos.entity.botp.WriteBackRuleLocalCache;
import kd.bos.entity.botp.WriteBackRuleRedisCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import org.apache.commons.collections.CollectionUtils;

public class WriteBackRuleCache {
    private static final Log log = LogFactory.getLog(WriteBackRuleCache.class);

    public static synchronized void clearAllRuleCache() {
        WriteBackRuleLocalCache.clearAllRuleCache();
        WriteBackRuleRedisCache.clearAllRuleCache();
        log.info("clearAllRuleCache");
    }

    public static List<WriteBackRuleElement> batchLoadRule(List<String> ruleIds) {
        if (CollectionUtils.isEmpty(ruleIds)) {
            return new ArrayList<WriteBackRuleElement>();
        }
        List<String> cacheVersions = WriteBackRuleRedisCache.batchGetCacheVersion(ruleIds.toArray(new String[ruleIds.size()]));
        ArrayList<WriteBackRuleElement> writeBackRuleElements = new ArrayList<WriteBackRuleElement>(ruleIds.size());
        for (int i = 0; i < ruleIds.size(); ++i) {
            long ts = System.currentTimeMillis();
            String ruleId = ruleIds.get(i);
            WriteBackRuleElement rule = WriteBackRuleLocalCache.getRule(ruleId);
            if (rule != null) {
                if (StringUtils.isBlank((CharSequence)rule.getCacheVersion())) {
                    rule = null;
                } else if (!StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)cacheVersions.get(i))) {
                    rule = null;
                } else if (Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                    rule = null;
                }
            }
            if (rule != null) {
                writeBackRuleElements.add(rule);
                continue;
            }
            String cacheVersion = null;
            String ruleXml = WriteBackRuleRedisCache.getRule(ruleId);
            if (ruleXml != null) {
                cacheVersion = cacheVersions.get(i);
                if (StringUtils.isBlank((CharSequence)cacheVersion)) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                    cacheVersion = sdf.format(new Date());
                    WriteBackRuleRedisCache.putCacheVersion(ruleId, cacheVersion);
                }
            } else {
                MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
                ruleXml = service.loadWriteBackRule(ruleId);
                if (StringUtils.isBlank((CharSequence)ruleXml)) {
                    ruleXml = "";
                }
                WriteBackRuleRedisCache.putRule(ruleId, ruleXml);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                cacheVersion = sdf.format(new Date());
                WriteBackRuleRedisCache.putCacheVersion(ruleId, cacheVersion);
            }
            if (!StringUtils.isNotBlank((CharSequence)ruleXml)) continue;
            rule = WriteBackRuleElementSerializer.deserializeFromString(ruleXml, null);
            rule.setCacheVersion(cacheVersion);
            rule.setCheckVersionTimeMillis(System.currentTimeMillis());
            WriteBackRuleLocalCache.putRule(ruleId, rule);
            writeBackRuleElements.add(rule);
        }
        return writeBackRuleElements;
    }

    public static WriteBackRuleElement loadRule(String ruleId) {
        long ts = System.currentTimeMillis();
        WriteBackRuleElement rule = WriteBackRuleLocalCache.getRule(ruleId);
        if (rule != null) {
            if (StringUtils.isBlank((CharSequence)rule.getCacheVersion())) {
                rule = null;
            } else if (!StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)WriteBackRuleRedisCache.getCacheVersion(ruleId))) {
                rule = null;
            } else if (Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                rule = null;
            }
        }
        if (rule != null) {
            return rule;
        }
        String cacheVersion = null;
        String ruleXml = WriteBackRuleRedisCache.getRule(ruleId);
        if (ruleXml != null) {
            cacheVersion = WriteBackRuleRedisCache.getCacheVersion(ruleId);
            if (StringUtils.isBlank((CharSequence)cacheVersion)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
                cacheVersion = sdf.format(new Date());
                WriteBackRuleRedisCache.putCacheVersion(ruleId, cacheVersion);
            }
        } else {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleXml = service.loadWriteBackRule(ruleId);
            if (StringUtils.isBlank((CharSequence)ruleXml)) {
                ruleXml = "";
            }
            WriteBackRuleRedisCache.putRule(ruleId, ruleXml);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            WriteBackRuleRedisCache.putCacheVersion(ruleId, cacheVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            rule = WriteBackRuleElementSerializer.deserializeFromString(ruleXml, null);
            rule.setCacheVersion(cacheVersion);
            rule.setCheckVersionTimeMillis(System.currentTimeMillis());
            WriteBackRuleLocalCache.putRule(ruleId, rule);
            return rule;
        }
        return null;
    }

    public static List<WriteBackRuleElement> loadRules(String targetEntityNumber) {
        List ruleIds = null;
        String cacheRuleIds = WriteBackRuleRedisCache.getRuleIds(targetEntityNumber);
        if (cacheRuleIds == null) {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleIds = service.loadWriteBackRuleIds(targetEntityNumber);
            WriteBackRuleRedisCache.putRuleIds(targetEntityNumber, SerializationUtils.toJsonString((Object)ruleIds));
        } else {
            ruleIds = (List)SerializationUtils.fromJsonString((String)cacheRuleIds, List.class);
        }
        return WriteBackRuleCache.batchLoadRule(ruleIds);
    }

    public static Long loadRuleVerId(String ruleId, long oriVersion, long extVersion) {
        return WriteBackRuleLocalCache.loadRuleVerId(ruleId, oriVersion, extVersion);
    }

    public static void cacheRuleVerId(String ruleId, long oriVersion, long extVersion, long verId) {
        WriteBackRuleLocalCache.putRuleVerId(ruleId, oriVersion, extVersion, verId);
    }

    public static WriteBackRuleElement loadRuleVer(long verId) {
        String cacheVersion;
        long ts = System.currentTimeMillis();
        WriteBackRuleElement rule = WriteBackRuleLocalCache.getRuleVer(verId);
        if (rule != null) {
            if (StringUtils.isBlank((CharSequence)rule.getCacheVersion())) {
                rule = null;
            } else if (!StringUtils.equals((CharSequence)rule.getCacheVersion(), (CharSequence)WriteBackRuleRedisCache.getCacheVersion(String.valueOf(verId)))) {
                rule = null;
            } else if (Long.compare(ts - rule.getCheckVersionTimeMillis(), 600000L) > 0) {
                rule = null;
            }
        }
        if (rule != null) {
            return rule;
        }
        String ruleXml = WriteBackRuleRedisCache.getRuleVer(verId);
        if (ruleXml == null) {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            ruleXml = service.loadWriteBackRuleVersion(verId);
            if (StringUtils.isBlank((CharSequence)ruleXml)) {
                ruleXml = "";
            }
            WriteBackRuleRedisCache.putRuleVer(verId, ruleXml);
        }
        if (StringUtils.isBlank((CharSequence)(cacheVersion = WriteBackRuleRedisCache.getCacheVersion(String.valueOf(verId))))) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            cacheVersion = sdf.format(new Date());
            WriteBackRuleRedisCache.putCacheVersion(String.valueOf(verId), cacheVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)ruleXml)) {
            rule = WriteBackRuleElementSerializer.deserializeFromString(ruleXml, null);
            rule.setCacheVersion(cacheVersion);
            rule.setCheckVersionTimeMillis(ts);
            WriteBackRuleLocalCache.putRuleVer(verId, rule);
        }
        return rule;
    }

    public static String loadDebugRule(String id, String cacheType) {
        if (StringUtils.isBlank((CharSequence)cacheType) || StringUtils.equals((CharSequence)cacheType, (CharSequence)"local")) {
            WriteBackRuleElement rule = WriteBackRuleLocalCache.getRule(id);
            if (rule == null) {
                return "null";
            }
            return SerializationUtils.toJsonString((Object)rule);
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"redis")) {
            String xml = WriteBackRuleRedisCache.getRule(id);
            if (StringUtils.isBlank((CharSequence)xml)) {
                return "null";
            }
            return xml;
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"db")) {
            MetadataService service = (MetadataService)ServiceFactory.getService(MetadataService.class);
            String xml = service.loadWriteBackRule(id);
            if (StringUtils.isBlank((CharSequence)xml)) {
                return "null";
            }
            return xml;
        }
        if (StringUtils.equals((CharSequence)cacheType, (CharSequence)"clear")) {
            WriteBackRuleCache.clearAllRuleCache();
            return "clear all rule cache success";
        }
        return null;
    }
}

