/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp;

import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;

class WriteBackRuleRedisCache {
    private static final String WR_DISTRIBUTE = "WriteBackRule";
    private static final String Type_WriteBackRule = "WriteBackRule";
    private static final String Type_CacheVersion = "WriteBackRuleCacheVersion";
    private static final String Type_WriteBackRuleList = "WriteBackRuleList";

    WriteBackRuleRedisCache() {
    }

    private static DistributeSessionlessCache getDistributeCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("WriteBackRule", new DistributeCacheHAPolicy(true, true));
    }

    private static String buildCacheType(String type) {
        String accountId = CacheKeyUtil.getAcctId();
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        if (StringUtils.isNotBlank((CharSequence)appGroup) && !"defaultGroup".equals(appGroup)) {
            return String.format("%s_%s_%s", accountId, appGroup, type);
        }
        return String.format("%s_%s", accountId, type);
    }

    public static void clearAllRuleCache() {
        DistributeSessionlessCache cache = WriteBackRuleRedisCache.getDistributeCache();
        cache.remove(WriteBackRuleRedisCache.buildCacheType("WriteBackRule"));
        cache.remove(WriteBackRuleRedisCache.buildCacheType(Type_CacheVersion));
        cache.remove(WriteBackRuleRedisCache.buildCacheType(Type_WriteBackRuleList));
    }

    public static String getRule(String ruleId) {
        String type = WriteBackRuleRedisCache.buildCacheType("WriteBackRule");
        return (String)WriteBackRuleRedisCache.getDistributeCache().get(type, ruleId);
    }

    public static void putRule(String ruleId, String ruleString) {
        String type = WriteBackRuleRedisCache.buildCacheType("WriteBackRule");
        WriteBackRuleRedisCache.getDistributeCache().put(type, ruleId, (Object)ruleString);
    }

    public static String getRuleIds(String targetEntityNumber) {
        String type = WriteBackRuleRedisCache.buildCacheType(Type_WriteBackRuleList);
        return (String)WriteBackRuleRedisCache.getDistributeCache().get(type, targetEntityNumber);
    }

    public static void putRuleIds(String targetEntityNumber, String ruleIds) {
        String type = WriteBackRuleRedisCache.buildCacheType(Type_WriteBackRuleList);
        WriteBackRuleRedisCache.getDistributeCache().put(type, targetEntityNumber, (Object)ruleIds);
    }

    public static String getRuleVer(long verId) {
        String type = WriteBackRuleRedisCache.buildCacheType("WriteBackRule");
        String strVerId = String.valueOf(verId);
        return (String)WriteBackRuleRedisCache.getDistributeCache().get(type, strVerId);
    }

    public static void putRuleVer(long verId, String ruleString) {
        String type = WriteBackRuleRedisCache.buildCacheType("WriteBackRule");
        String strVerId = String.valueOf(verId);
        WriteBackRuleRedisCache.getDistributeCache().put(type, strVerId, (Object)ruleString);
    }

    public static String getCacheVersion(String ruleId) {
        String type = WriteBackRuleRedisCache.buildCacheType(Type_CacheVersion);
        return (String)WriteBackRuleRedisCache.getDistributeCache().get(type, ruleId);
    }

    public static List<String> batchGetCacheVersion(String[] ruleIds) {
        String type = WriteBackRuleRedisCache.buildCacheType(Type_CacheVersion);
        return WriteBackRuleRedisCache.getDistributeCache().get(type, ruleIds);
    }

    public static void putCacheVersion(String ruleId, String cacheVersion) {
        String type = WriteBackRuleRedisCache.buildCacheType(Type_CacheVersion);
        WriteBackRuleRedisCache.getDistributeCache().put(type, ruleId, (Object)cacheVersion);
    }
}

