/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.runtime;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.CRExpressionLocalCache;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.function.BatchFuncRunParam;

public class CRExpressionContext
implements ExpressionContext {
    private BillEntityType srcMainType;
    private BillEntityType tgtMainType;
    private AbstractConvertServiceArgs convertServiceArgs;
    private ConvertRuleElement rule;
    private OperateOption option;
    private DynamicObject activeRow;
    private Map<String, DynamicProperty> fldProperties;
    private CRExpressionLocalCache localCache;
    private Map<BatchFuncRunParam, Object> batchCallResult;
    private int batchResultMaxCount = 10000;

    public CRExpressionContext(BillEntityType srcMainType, BillEntityType tgtMainType, ConvertRuleElement rule) {
        this.srcMainType = srcMainType;
        this.tgtMainType = tgtMainType;
        this.rule = rule;
        this.localCache = new CRExpressionLocalCache();
    }

    public BillEntityType getSrcMainType() {
        return this.srcMainType;
    }

    public BillEntityType getTgtMainType() {
        return this.tgtMainType;
    }

    public AbstractConvertServiceArgs getConvertServiceArgs() {
        return this.convertServiceArgs;
    }

    public void setConvertServiceArgs(AbstractConvertServiceArgs convertServiceArgs) {
        this.convertServiceArgs = convertServiceArgs;
    }

    public ConvertRuleElement getRule() {
        return this.rule;
    }

    public DynamicObject getActiveRow() {
        return this.activeRow;
    }

    public void setActiveRow(DynamicObject activeRow) {
        this.activeRow = activeRow;
    }

    public Map<String, DynamicProperty> getFldProperties() {
        return this.fldProperties;
    }

    public void setFldProperties(Map<String, DynamicProperty> fldProperties) {
        this.fldProperties = fldProperties;
    }

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public CRExpressionLocalCache getLocalCache() {
        return this.localCache;
    }

    public void setLocalCache(CRExpressionLocalCache localCache) {
        this.localCache = localCache;
    }

    public Boolean tryGetValue(String var, OutValue<Object> value) {
        DynamicProperty prop = this.getFldProperties().get(var);
        if (prop == null) {
            return false;
        }
        Object varValue = prop.getValueFast((Object)this.activeRow);
        value.set(varValue);
        return true;
    }

    public Boolean tryGetValue(String var, OutValue<Object> value, Function<DynamicObject, Optional<Object>> getValueFunctionForBasedataVersion) {
        Boolean b = this.tryGetValue(var, value);
        if (b.booleanValue()) {
            Optional<Object> apply = getValueFunctionForBasedataVersion.apply(this.activeRow);
            value.set(apply.orElse(value.get()));
        }
        return b;
    }

    public boolean tryGetBatchRunResult(BatchFuncRunParam funcParams, OutValue<Object> value) {
        if (this.batchCallResult == null) {
            return false;
        }
        if (!this.batchCallResult.containsKey(funcParams)) {
            return false;
        }
        value.set(this.batchCallResult.get(funcParams));
        return true;
    }

    public void setBatchRunResult(Map<BatchFuncRunParam, Object> batchRunResult) {
        this.batchCallResult = batchRunResult;
    }

    public void setBatchResultMaxCount(int maxCount) {
        this.batchResultMaxCount = maxCount;
    }

    public int getBatchResultMaxCount() {
        return this.batchResultMaxCount;
    }
}

