/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.runtime;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kd.bos.consts.BOSExtPackage;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.function.FunctionTypes;

public class ConvertFuncLoader {
    private static final String FUNC_PATH = "/botp/cv/";
    private static final String FUNC_END_SUFFIX = ".func";
    private static final Map<String, FunctionTypes> BIZ_CLOUD_FUNCTION_CACHE = new HashMap<String, FunctionTypes>();
    private static final Map<String, FunctionTypes> CUSTOM_FUNCTION_CACHE = new HashMap<String, FunctionTypes>();

    public static synchronized FunctionTypes loadBizCloudFuncTypes() {
        FunctionTypes functionTypes = new FunctionTypes();
        for (String cloudNumber : BOSExtPackage.getExtPackageNumbers()) {
            FunctionTypes appFunctionTypes = ConvertFuncLoader.loadFunctionBy(cloudNumber, BIZ_CLOUD_FUNCTION_CACHE);
            if (appFunctionTypes == null) continue;
            functionTypes.getFunctionGroups().addAll(appFunctionTypes.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(appFunctionTypes.getFunctionTypes());
        }
        return functionTypes;
    }

    public static synchronized FunctionTypes loadBizFuncTypes(String[] appNumbers) {
        FunctionTypes functionTypes = new FunctionTypes();
        if (null == appNumbers) {
            return functionTypes;
        }
        for (String appNumber : appNumbers) {
            FunctionTypes appFunctionTypes;
            if (StringUtils.isBlank((CharSequence)appNumber) || (appFunctionTypes = ConvertFuncLoader.loadFunctionBy(appNumber, CUSTOM_FUNCTION_CACHE)) == null) continue;
            functionTypes.getFunctionGroups().addAll(appFunctionTypes.getFunctionGroups());
            functionTypes.getFunctionTypes().addAll(appFunctionTypes.getFunctionTypes());
        }
        return functionTypes;
    }

    private static FunctionTypes loadFunctionBy(String number, Map<String, FunctionTypes> cacheMap) {
        FunctionTypes functionTypes = cacheMap.get(number);
        if (null != functionTypes) {
            return functionTypes;
        }
        String file = FUNC_PATH + number.toLowerCase() + FUNC_END_SUFFIX;
        URL url = FunctionTypes.class.getResource(file);
        functionTypes = FunctionTypes.get((URL)url, (boolean)false);
        cacheMap.put(number, functionTypes);
        return functionTypes;
    }
}

