/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.botp.runtime;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.BillUseRule;
import kd.bos.entity.botp.runtime.AttachmentItemInfo;
import kd.bos.entity.botp.runtime.ConvertReport;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IDataProvider;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@KSObject
@SdkPublic
public class ConvertOperationResult {
    private static final Log log = LogFactory.getLog(ConvertOperationResult.class);
    private String sourceEntityNumber;
    private String targetEntityNumber;
    private String targetBillFormId;
    private String targetMobFormId;
    private boolean success;
    private String message;
    private List<ConvertReport> reports = new ArrayList<ConvertReport>();
    private List<SourceBillReport> billReports = new ArrayList<SourceBillReport>();
    private List<String> cachePageIds = new ArrayList<String>();
    private Map<String, String> cacheTargetObjStr = new HashMap<String, String>();
    private Map<String, String> cacheTargetBillno = new HashMap<String, String>();
    private Set<String> dataMutexSrcBillIds = new HashSet<String>();
    private Set<Object> targetBillIds = new HashSet<Object>();
    private Set<Object> pksWhichNotFullCacheTargetObj = new HashSet<Object>();
    private Date startTime;
    private Date finishedTime;
    private Set<String> headFields = new HashSet<String>();
    private Map<Object, Map<String, List<AttachmentItemInfo>>> billAttachmentPanelInfos = new HashMap<Object, Map<String, List<AttachmentItemInfo>>>();
    private Map<Long, List<BillUseRule>> billUseRuleMap = new HashMap<Long, List<BillUseRule>>();

    public Map<Long, List<BillUseRule>> getBillUseRuleMap() {
        return this.billUseRuleMap;
    }

    public void setBillUseRuleMap(Map<Long, List<BillUseRule>> billUseRuleMap) {
        this.billUseRuleMap = billUseRuleMap;
    }

    public Map<Object, Map<String, List<AttachmentItemInfo>>> getBillAttachmentPanelInfos() {
        return this.billAttachmentPanelInfos;
    }

    public void setBillAttachmentPanelInfos(Map<Object, Map<String, List<AttachmentItemInfo>>> billAttachmentPanelInfos) {
        this.billAttachmentPanelInfos = billAttachmentPanelInfos;
    }

    public ConvertOperationResult createSimpleConvertOperationResult() {
        ConvertOperationResult simpleConvertResult = new ConvertOperationResult();
        simpleConvertResult.sourceEntityNumber = this.getSourceEntityNumber();
        simpleConvertResult.targetEntityNumber = this.getTargetEntityNumber();
        simpleConvertResult.targetBillFormId = this.getTargetBillFormId();
        simpleConvertResult.targetMobFormId = this.getTargetMobFormId();
        simpleConvertResult.success = this.isSuccess();
        simpleConvertResult.message = this.getMessage();
        simpleConvertResult.cachePageIds = this.getCachePageIds();
        simpleConvertResult.dataMutexSrcBillIds = this.getDataMutexSrcBillIds();
        simpleConvertResult.targetBillIds = this.getTargetBillIds();
        simpleConvertResult.pksWhichNotFullCacheTargetObj = this.getPksWhichNotFullCacheTargetObj();
        simpleConvertResult.startTime = this.getStartTime();
        simpleConvertResult.finishedTime = this.getFinishedTime();
        simpleConvertResult.headFields = this.getHeadFields();
        simpleConvertResult.billAttachmentPanelInfos = this.getBillAttachmentPanelInfos();
        simpleConvertResult.cacheTargetBillno = this.getCacheTargetBillno();
        return simpleConvertResult;
    }

    @KSMethod
    public String getSourceEntityNumber() {
        return this.sourceEntityNumber;
    }

    public void setSourceEntityNumber(String sourceEntityNumber) {
        this.sourceEntityNumber = sourceEntityNumber;
    }

    @KSMethod
    public String getTargetEntityNumber() {
        return this.targetEntityNumber;
    }

    public void setTargetEntityNumber(String targetEntityNumber) {
        this.targetEntityNumber = targetEntityNumber;
    }

    @KSMethod
    public String getTargetBillFormId() {
        return this.targetBillFormId;
    }

    public void setTargetBillFormId(String targetBillFormId) {
        this.targetBillFormId = targetBillFormId;
    }

    @KSMethod
    public String getTargetMobFormId() {
        return this.targetMobFormId;
    }

    public void setTargetMobFormId(String targetMobFormId) {
        this.targetMobFormId = targetMobFormId;
    }

    @KSMethod
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @KSMethod
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @SdkInternal
    @KSMethod
    @Deprecated
    public List<ConvertReport> getReports() {
        return this.reports;
    }

    @SdkInternal
    public void setReports(List<ConvertReport> reports) {
        this.reports = reports;
    }

    @KSMethod
    public List<SourceBillReport> getBillReports() {
        return this.billReports;
    }

    @KSMethod
    public List<String> getCachePageIds() {
        return this.cachePageIds;
    }

    public void setCachePageIds(List<String> cachePageIds) {
        this.cachePageIds = cachePageIds;
    }

    @KSMethod
    public Map<String, String> getCacheTargetObjStr() {
        return this.cacheTargetObjStr;
    }

    public void setCacheTargetObjStr(Map<String, String> cacheTargetObjStr) {
        this.cacheTargetObjStr = cacheTargetObjStr;
    }

    public Map<String, String> getCacheTargetBillno() {
        return this.cacheTargetBillno;
    }

    public void setCacheTargetBillno(Map<String, String> cacheTargetBillno) {
        this.cacheTargetBillno = cacheTargetBillno;
    }

    public Set<String> getDataMutexSrcBillIds() {
        return this.dataMutexSrcBillIds;
    }

    public Set<Object> getTargetBillIds() {
        return this.targetBillIds;
    }

    public Set<String> getHeadFields() {
        return this.headFields;
    }

    public void setHeadFields(Set<String> headFields) {
        this.headFields = headFields;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishedTime() {
        return this.finishedTime;
    }

    public void setFinishedTime(Date finishedTime) {
        this.finishedTime = finishedTime;
    }

    public long getRunSecond() {
        if (this.startTime == null || this.finishedTime == null) {
            return 0L;
        }
        return (this.finishedTime.getTime() - this.startTime.getTime()) / 1000L;
    }

    public Set<Object> getPksWhichNotFullCacheTargetObj() {
        return this.pksWhichNotFullCacheTargetObj;
    }

    public void setPksWhichNotFullCacheTargetObj(Set<Object> pksWhichNotFullCacheTargetObj) {
        this.pksWhichNotFullCacheTargetObj = pksWhichNotFullCacheTargetObj;
    }

    public void addTargetDataObjects(IRefrencedataProvider refDataProvider, MainEntityType mainType, List<DynamicObject> dataEntities) {
        DataEntitySerializerOption option = this.buildSerializerOption();
        for (DynamicObject dataEntity : dataEntities) {
            String billNoKey;
            for (IDataEntityProperty prop : dataEntity.getDataEntityType().getProperties()) {
                this.headFields.add(prop.getName());
            }
            dataEntity.getDataEntityState().setPushChanged(true);
            String pageId = UUID.randomUUID().toString();
            String str = DataEntitySerializer.serializerToString((Object)dataEntity, (DataEntitySerializerOption)option);
            this.cachePageIds.add(pageId);
            this.cacheTargetObjStr.put(pageId, str);
            if (!(mainType instanceof BillEntityType) || StringUtils.isBlank((CharSequence)(billNoKey = ((BillEntityType)mainType).getBillNo()))) continue;
            Object billNoObj = dataEntity.get(billNoKey);
            this.cacheTargetBillno.put(pageId, billNoObj != null ? billNoObj.toString() : "");
        }
    }

    public List<String> cacheAutoSavedDataObjects(IRefrencedataProvider refDataProvider, MainEntityType mainType, List<DynamicObject> dataEntities) {
        DataEntitySerializerOption option = this.buildSerializerOption();
        ArrayList<String> pageIds = new ArrayList<String>();
        for (DynamicObject dataEntity : dataEntities) {
            if (!this.targetBillIds.contains(dataEntity.getPkValue())) continue;
            String pageId = UUID.randomUUID().toString();
            dataEntity.getDataEntityState().setPushChanged(true);
            String str = DataEntitySerializer.serializerToString((Object)dataEntity, (DataEntitySerializerOption)option);
            this.cachePageIds.add(pageId);
            this.cacheTargetObjStr.put(pageId, str);
            pageIds.add(pageId);
        }
        return pageIds;
    }

    public void updateTargetDataObject(String pageId, DynamicObject dataEntity) {
        this.updateTargetDataObject(pageId, dataEntity, true);
    }

    public void updateTargetDataObject(String pageId, DynamicObject dataEntity, boolean isFullEntityType) {
        DataEntitySerializerOption option = this.buildSerializerOption();
        dataEntity.getDataEntityState().setPushChanged(true);
        String str = DataEntitySerializer.serializerToString((Object)dataEntity, (DataEntitySerializerOption)option);
        this.cacheTargetObjStr.put(pageId, str);
    }

    @KSMethod
    public DynamicObject loadTargetDataObject(IRefrencedataProvider refDataProvider, MainEntityType mainType, String pageId) {
        return this.loadTargetDataObject(refDataProvider, mainType, pageId, true);
    }

    public DynamicObject loadTargetDataObject(IRefrencedataProvider refDataProvider, MainEntityType mainType, String pageId, boolean loadReference) {
        if (!this.cacheTargetObjStr.containsKey(pageId)) {
            return null;
        }
        String str = this.cacheTargetObjStr.get(pageId);
        return this.deSerializerObj(refDataProvider, (IDataEntityType)mainType, str, loadReference);
    }

    @KSMethod
    public DynamicObject loadAutoSavedDataObjects(IDataProvider refDataProvider, MainEntityType mainType, Object pkId) {
        if (!this.targetBillIds.contains(pkId)) {
            return null;
        }
        return refDataProvider.loadReferenceData((DynamicObjectType)mainType, pkId);
    }

    @KSMethod
    public List<DynamicObject> loadTargetDataObjects(IRefrencedataProvider refDataProvider, MainEntityType mainType) {
        return this.loadTargetDataObjects(refDataProvider, mainType, true);
    }

    @KSMethod
    public List<DynamicObject> loadTargetDataObjects(IRefrencedataProvider refDataProvider, MainEntityType mainType, boolean releaseCach) {
        if (this.cachePageIds.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> dataEntities = new ArrayList<DynamicObject>(this.cachePageIds.size() + this.targetBillIds.size());
        for (String pageId : this.cachePageIds) {
            String str = this.cacheTargetObjStr.get(pageId);
            DynamicObject dataEntity = this.deSerializerObj(refDataProvider, (IDataEntityType)mainType, str, true);
            dataEntities.add(dataEntity);
        }
        if (releaseCach) {
            this.release(refDataProvider, mainType);
        }
        return dataEntities;
    }

    private DataEntitySerializerOption buildSerializerOption() {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeDataEntityState(true);
        option.setIncludeComplexProperty(false);
        option.setIncludeCollectionProperty(true);
        option.setIncludeType(false);
        return option;
    }

    private DynamicObject deSerializerObj(IRefrencedataProvider refDataProvider, IDataEntityType mainType, String str, boolean loadReference) {
        DynamicObject dataEntity = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)str, (IDataEntityType)mainType);
        this.checkDataEntityState(mainType, dataEntity);
        if (loadReference) {
            refDataProvider.fillReferenceData(new Object[]{dataEntity}, mainType);
        }
        return dataEntity;
    }

    public String loadTargetLayoutFormId() {
        if (StringUtils.isNotBlank((CharSequence)this.targetBillFormId)) {
            return this.targetBillFormId;
        }
        if (this.cachePageIds.isEmpty()) {
            return this.targetEntityNumber;
        }
        BillEntityType targetMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.targetEntityNumber);
        if (StringUtils.isNotBlank((CharSequence)targetMainType.getBillType())) {
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dType) {
                }
            };
            String objJson = this.cacheTargetObjStr.get(this.cachePageIds.get(0));
            if (StringUtils.isBlank((CharSequence)objJson)) {
                return this.targetEntityNumber;
            }
            DynamicObject dataEntity = this.deSerializerObj(refDataProvider, (IDataEntityType)targetMainType, objJson, true);
            Long billTypeId = dataEntity.getLong(targetMainType.getBillType() + "_id");
            if (billTypeId != null && Long.compare(0L, billTypeId) != 0) {
                String billFormId;
                ORM orm = ORM.create();
                QFilter[] filter = new QFilter[]{new QFilter("id", "=", (Object)billTypeId)};
                String layoutId = null;
                try (DataSet ds = orm.queryDataSet("ConvertOperationResult.getBillType", "bos_billtype", "id, number, billformid, layoutsolution", filter);){
                    if (ds.hasNext()) {
                        Row row = ds.next();
                        layoutId = row.getString("layoutsolution");
                    }
                }
                if (StringUtils.isNotBlank(layoutId) && !StringUtils.equalsIgnoreCase((CharSequence)"null", (CharSequence)layoutId) && StringUtils.isNotBlank((CharSequence)(billFormId = this.loadFormNumber(this.targetEntityNumber, layoutId)))) {
                    return billFormId;
                }
            }
        }
        return this.targetEntityNumber;
    }

    private String loadFormNumber(String entityNumber, String layoutId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("SELECT t0.FId, t0.FNumber ");
        sBuilder.append("FROM T_META_FORMDESIGN t0 LEFT JOIN T_META_ENTITYDESIGN t1 on (t0.FEntityId = t1.FId)");
        sBuilder.append("WHERE t0.FId = ? AND t1.FNumber = ?");
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)layoutId), new SqlParameter(":FNumber", 12, (Object)entityNumber)};
        ResultSetHandler<String> action = new ResultSetHandler<String>(){

            public String handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    String formNumber = rs.getString("FNumber");
                    return formNumber;
                }
                return null;
            }
        };
        return (String)DB.query((DBRoute)DBRoute.meta, (String)sBuilder.toString(), (Object[])params, (ResultSetHandler)action);
    }

    @KSMethod
    public void release(IRefrencedataProvider refDataProvider, MainEntityType mainType) {
    }

    private void checkDataEntityState(IDataEntityType mainType, DynamicObject dataEntity) {
        if (dataEntity.getDataEntityState() == null || !dataEntity.getDataEntityState().isPushChanged()) {
            HashSet<String> delFields = new HashSet<String>();
            HashSet<String> addFields = new HashSet<String>();
            for (IDataEntityProperty prop : mainType.getProperties()) {
                if (this.headFields.contains(prop.getName())) continue;
                addFields.add(prop.getName());
            }
            for (String key : this.headFields) {
                if (mainType.getProperties().containsKey((Object)key)) continue;
                delFields.add(key);
            }
            String throwExecption = System.getProperty("dirtyFlag_Empty_ThrowExecption");
            if (throwExecption != null && StringUtils.equals((CharSequence)"false", (CharSequence)throwExecption.toString())) {
                log.info("data entity state is lost");
                return;
            }
            if (delFields.isEmpty() && addFields.isEmpty()) {
                throw new KDException(new ErrorCode("ConvertOperationResult.checkDataEntityState.1", "data entity state is lost"), new Object[0]);
            }
            if (delFields.isEmpty()) {
                throw new KDException(new ErrorCode("ConvertOperationResult.checkDataEntityState.2", "data entity state is lost, beacuse add fields: %s"), new Object[]{StringUtils.join((Object[])addFields.toArray(), (String)",")});
            }
            if (addFields.isEmpty()) {
                throw new KDException(new ErrorCode("ConvertOperationResult.checkDataEntityState.3", "data entity state is lost, beacuse remove fields: %s"), new Object[]{StringUtils.join((Object[])delFields.toArray(), (String)",")});
            }
            throw new KDException(new ErrorCode("ConvertOperationResult.checkDataEntityState.4", "data entity state is lost, beacuse add fields: %s; remove fields: %s"), new Object[]{StringUtils.join((Object[])addFields.toArray(), (String)","), StringUtils.join((Object[])delFields.toArray(), (String)",")});
        }
    }

    public EntityType getSimpleEntityType(MainEntityType mainType) {
        ArrayList<String> simpleProperties = new ArrayList<String>(2);
        simpleProperties.add(mainType.getPrimaryKey().getName());
        if (mainType instanceof BillEntityType && StringUtils.isNotBlank((CharSequence)((BillEntityType)mainType).getBillNo())) {
            simpleProperties.add(((BillEntityType)mainType).getBillNo());
        }
        return mainType.getSubEntityType(simpleProperties);
    }
}

