/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.CtConvertDataService;
import kd.bos.ctbotp.CtEntryTrackReader;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.runtime.CtBFRow;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

final class CtBillTrackReader {
    private static final String FORM_BOTP_BILLTRACKER = "botp_billtracker";
    private static final String KEY_S_TABLEID = "stableid";
    private static final String KEY_S_BILLID = "sbillid";
    private static final String KEYS_TTABLEID_TBILLID = "ttableid, tbillid";
    private static final String KEYS_STABLEID_SBILLID_TTABLEID_TBILLID = "stableid, sbillid, ttableid, tbillid";
    private static final String ALGO_KEY_READ_DOWN_BILL_BFROWIDS = "kd.bos.botp.BillTrackReader.readDownBillBFRowIds";
    private static final String ALGO_KEY_READ_DOWN_BILL_BFROWS = "kd.bos.botp.BillTrackReader.readDownBillBFRows";
    private CtEntryTrackReader entryTrackReader;

    CtBillTrackReader() {
    }

    public CtEntryTrackReader getEntryTrackReader() {
        if (this.entryTrackReader == null) {
            this.entryTrackReader = new CtEntryTrackReader();
        }
        return this.entryTrackReader;
    }

    public void setEntryTrackReader(CtEntryTrackReader entryTrackReader) {
        this.entryTrackReader = entryTrackReader;
    }

    protected List<CtBFRowId> readDownBillBFRowIds(Long srcMainTableId, Long[] srcBillIds) {
        if (srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<CtBFRowId>();
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(KEY_S_TABLEID, "=", (Object)srcMainTableId));
        qFilters.add(new QFilter(KEY_S_BILLID, "in", (Object)srcBillIds));
        ArrayList<CtBFRowId> rowIds = new ArrayList<CtBFRowId>(srcBillIds.length);
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_DOWN_BILL_BFROWIDS, FORM_BOTP_BILLTRACKER, KEYS_TTABLEID_TBILLID, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long tTableId = row.getLong(0);
                Long tBillId = row.getLong(1);
                CtBFRowId rowId = new CtBFRowId(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), tTableId, tBillId, tTableId, tBillId);
                rowIds.add(rowId);
            }
        }
        return rowIds;
    }

    protected List<CtBFRow> readDownBillBFRows(String sTenantCode, String sAccountId, Long srcMainTableId, Long[] srcBillIds) {
        if (srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<CtBFRow>();
        }
        CtConvertDataService reader = new CtConvertDataService();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(KEY_S_TABLEID, "=", (Object)srcMainTableId));
        qFilters.add(new QFilter(KEY_S_BILLID, "in", (Object)srcBillIds));
        ArrayList<CtBFRow> rows = new ArrayList<CtBFRow>(srcBillIds.length);
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_DOWN_BILL_BFROWS, FORM_BOTP_BILLTRACKER, KEYS_STABLEID_SBILLID_TTABLEID_TBILLID, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long sTableId = row.getLong(0);
                Long sBillId = row.getLong(1);
                Long tTableId = row.getLong(2);
                Long tBillId = row.getLong(3);
                CtBFRowId sRowId = new CtBFRowId(sTenantCode, sAccountId, sTableId, sBillId, sTableId, sBillId);
                TableDefine sTableDefine = reader.loadTableDefine(sTableId);
                sRowId.setMainEntityKey(sTableDefine.getEntityNumber());
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)sTableDefine.getEntityNumber()).getDisplayName().getLocaleValue());
                CtBFRowId rowId = new CtBFRowId(sTenantCode, sAccountId, tTableId, tBillId, tTableId, tBillId);
                TableDefine tTableDefine = reader.loadTableDefine(tTableId);
                rowId.setMainEntityKey(tTableDefine.getEntityNumber());
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)tTableDefine.getEntityNumber()).getDisplayName().getLocaleValue());
                CtBFRow bfRow = new CtBFRow();
                bfRow.setSId(sRowId);
                bfRow.setId(rowId);
                rows.add(bfRow);
            }
        }
        return rows;
    }

    protected List<CtBFRow> readDownEntryBFRows(Long srcMainTableId, Long srcTableId, Long[] srcBillIds, Set<Long> srcEntryIds, boolean searchEntry) {
        List<CtBFRowId> targetBillRowIds = this.readDownBillBFRowIds(srcMainTableId, srcBillIds);
        HashMap tgtBillIds = new HashMap();
        for (CtBFRowId rowId : targetBillRowIds) {
            Long tMainTableId = rowId.getMainTableId();
            Long tBillId = rowId.getBillId();
            this.getEntryTrackReader().addToMap(tgtBillIds, tMainTableId, tBillId);
        }
        ArrayList<CtBFRow> allEntryRows = new ArrayList<CtBFRow>();
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            Long tMainTableId = (Long)entry.getKey();
            Long[] tBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
            List<CtBFRow> bfRows = this.getEntryTrackReader().readUpEntryBFRows(tMainTableId, tBillIds);
            for (CtBFRow bfRow : bfRows) {
                if (searchEntry && Long.compare(bfRow.getId().getMainTableId(), bfRow.getId().getTableId()) == 0 || Long.compare(srcTableId, bfRow.getSId().getTableId()) != 0 || !srcEntryIds.contains(bfRow.getSId().getEntryId())) continue;
                allEntryRows.add(bfRow);
            }
        }
        return allEntryRows;
    }

    protected List<CtBFRow> readFullDownBillBFRows(String sTenantCode, String sAccountId, Long srcMainTableId, Long[] srcBillIds) {
        List<CtBFRow> rows = this.readDownBillBFRows(sTenantCode, sAccountId, srcMainTableId, srcBillIds);
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(rows);
        int count = 0;
        while (!rows.isEmpty() && count < 100) {
            Long tMainTableId;
            ++count;
            HashMap targetBillIds = new HashMap(2);
            for (CtBFRow ctBFRow : rows) {
                tMainTableId = ctBFRow.getId().getMainTableId();
                Long tBillId = ctBFRow.getId().getBillId();
                this.getEntryTrackReader().addToMap(targetBillIds, tMainTableId, tBillId);
            }
            rows.clear();
            for (Map.Entry entry : targetBillIds.entrySet()) {
                tMainTableId = (Long)entry.getKey();
                Long[] tBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
                rows.addAll(this.readDownBillBFRows(sTenantCode, sAccountId, tMainTableId, tBillIds));
            }
            allRows.addAll(rows);
        }
        return allRows;
    }

    protected List<CtBFRow> readFullDownEntryBFRows(Long srcMainTableId, Long[] srcBillIds, boolean onlyDirtLink) {
        List<CtBFRowId> targetBillRowIds = this.readDownBillBFRowIds(srcMainTableId, srcBillIds);
        HashMap allTgtBillIds = new HashMap();
        HashMap tgtBillIds = new HashMap();
        for (CtBFRowId rowId : targetBillRowIds) {
            Iterator tMainTableId = rowId.getMainTableId();
            Long l = rowId.getBillId();
            if (!this.getEntryTrackReader().addToMap(allTgtBillIds, tMainTableId, l)) continue;
            this.getEntryTrackReader().addToMap(tgtBillIds, tMainTableId, l);
        }
        if (!onlyDirtLink) {
            int count = 0;
            while (tgtBillIds.size() > 0 && count < 100) {
                ++count;
                ArrayList<CtBFRowId> allBillRowIds = new ArrayList<CtBFRowId>();
                for (Map.Entry entry : tgtBillIds.entrySet()) {
                    Long sMainTableId = (Long)entry.getKey();
                    Long[] sBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
                    List<CtBFRowId> billRowIds = this.readDownBillBFRowIds(sMainTableId, sBillIds);
                    allBillRowIds.addAll(billRowIds);
                }
                tgtBillIds.clear();
                for (CtBFRowId ctBFRowId : allBillRowIds) {
                    Long tMainTableId = ctBFRowId.getMainTableId();
                    Long tBillId = ctBFRowId.getBillId();
                    if (!this.getEntryTrackReader().addToMap(allTgtBillIds, tMainTableId, tBillId)) continue;
                    this.getEntryTrackReader().addToMap(tgtBillIds, tMainTableId, tBillId);
                }
            }
        }
        ArrayList<CtBFRow> allEntryRows = new ArrayList<CtBFRow>();
        for (Map.Entry entry : allTgtBillIds.entrySet()) {
            Long l = (Long)entry.getKey();
            Long[] tBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
            List<CtBFRow> entryRows = this.getEntryTrackReader().readUpEntryBFRows(l, tBillIds);
            allEntryRows.addAll(entryRows);
        }
        return allEntryRows;
    }

    protected List<CtBFRow> readFullDownEntryBFRows(Long srcMainTableId, Long srcEntryTableId, Long[] srcBillIds, Set<Long> srcEntryIds, boolean onlyDirtLink, boolean searchEntry) {
        ArrayList<CtBFRow> allEntryRows = new ArrayList<CtBFRow>();
        List<CtBFRow> targetBFRows = this.readDownEntryBFRows(srcMainTableId, srcEntryTableId, srcBillIds, srcEntryIds, searchEntry);
        allEntryRows.addAll(targetBFRows);
        if (onlyDirtLink) {
            return allEntryRows;
        }
        HashMap allTargetRowIds = new HashMap();
        HashMap targetRowIds = new HashMap();
        for (CtBFRow bfRow : targetBFRows) {
            Long tTableId = bfRow.getId().getTableId();
            if (!this.getEntryTrackReader().addToMap(allTargetRowIds, tTableId, bfRow.getId())) continue;
            this.getEntryTrackReader().addToMap(targetRowIds, tTableId, bfRow.getId());
        }
        int count = 0;
        while (targetRowIds.size() > 0 && count < 100) {
            Long tTableId;
            ++count;
            ArrayList<CtBFRow> list = new ArrayList<CtBFRow>();
            for (Map.Entry entry : targetRowIds.entrySet()) {
                tTableId = (Long)entry.getKey();
                Long tMainTableId = ((CtBFRowId)((Set)entry.getValue()).iterator().next()).getMainTableId();
                HashSet<Long> tBillIds = new HashSet<Long>(((Set)entry.getValue()).size());
                HashSet<Long> tEntryIds = new HashSet<Long>(((Set)entry.getValue()).size());
                for (CtBFRowId rowId : (Set)entry.getValue()) {
                    tBillIds.add(rowId.getBillId());
                    tEntryIds.add(rowId.getEntryId());
                }
                targetBFRows = this.readDownEntryBFRows(tMainTableId, tTableId, tBillIds.toArray(new Long[0]), tEntryIds, searchEntry);
                allEntryRows.addAll(targetBFRows);
                list.addAll(targetBFRows);
            }
            targetRowIds.clear();
            for (CtBFRow bfRow : list) {
                tTableId = bfRow.getId().getTableId();
                if (!this.getEntryTrackReader().addToMap(allTargetRowIds, tTableId, bfRow.getId())) continue;
                this.getEntryTrackReader().addToMap(targetRowIds, tTableId, bfRow.getId());
            }
        }
        return allEntryRows;
    }
}

