/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.ctbotp.table.CtUniqueTable;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.link.CtBotpUnique;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CtBotpUniqueService {
    private static final Log LOG = LogFactory.getLog(CtBotpUniqueService.class);
    private static Map<String, MainEntityType> CTBOTP_UNIQUEKEY_TYPES = new ConcurrentHashMap<String, MainEntityType>();
    private static final String FORMID_CTBOTP_UNIQUE = "bos_ctbotp_unique";
    private static final String KEY_ID = "id";
    private static final String KEY_STENANTCODE = "stenantcode";
    private static final String KEY_SACCOUNTID = "saccountid";
    private static final String KEY_SENTITYKEY = "sentitykey";
    private static final String KEY_SBILLID = "sbillid";
    private static final String KEY_TENTITYKEY = "tentitykey";
    private static final String KEY_TBILLID = "tbillid";
    private static final String KEY_CREATETIME = "createtime";

    private static synchronized MainEntityType getCtBotpUniqueType(String dbRouteKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FORMID_CTBOTP_UNIQUE);
        MainEntityType cacheType = CTBOTP_UNIQUEKEY_TYPES.get(dbRouteKey);
        if (cacheType != null && !StringUtils.equals((CharSequence)mainType.getVersion(), (CharSequence)cacheType.getVersion())) {
            cacheType = null;
        }
        if (cacheType == null) {
            try {
                cacheType = (MainEntityType)mainType.clone();
            }
            catch (CloneNotSupportedException exp) {
                throw new KDException((Throwable)exp, new ErrorCode("CtBotpUniqueService.getCtBotpUniqueType", exp.getMessage()), new Object[0]);
            }
            cacheType.setDBRouteKey(dbRouteKey);
            CTBOTP_UNIQUEKEY_TYPES.put(dbRouteKey, cacheType);
        }
        return cacheType;
    }

    public static void addCtBotpUniques(String dbRouteKey, CtBotpUnique[] ctBotpUniques, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)dbRouteKey) || ctBotpUniques == null || ctBotpUniques.length == 0) {
            return;
        }
        if (option == null) {
            option = OperateOption.create();
        }
        MainEntityType mainType = CtBotpUniqueService.getCtBotpUniqueType(dbRouteKey);
        Object[] objs = new DynamicObject[ctBotpUniques.length];
        for (int i = 0; i < objs.length; ++i) {
            CtBotpUnique ctBotpUnique = ctBotpUniques[i];
            if (ctBotpUnique == null) continue;
            DynamicObject obj = CtBotpUniqueService.buildCtBotpUniqueObject(mainType, ctBotpUnique);
            objs[i] = obj;
        }
        CtUniqueTable.createTable(new DBRoute(dbRouteKey));
        BusinessDataWriter.save((IDataEntityType)mainType, (Object[])objs, (OperateOption)option);
    }

    public static void delete(String dbRouteKey, Long[] tBillIds, String tEntityKey) {
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        if (!CtUniqueTable.existTable(dbRoute).booleanValue()) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete t_ctbotp_unique where ", new Object[0]);
        sqlBuilder.appendIn("ftbillid", (Object[])tBillIds);
        sqlBuilder.append(" and ftentitykey = ?", new Object[0]);
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(1);
        params.add(new SqlParameter("ftentitykey", 12, (Object)tEntityKey));
        sqlBuilder.append(" ", params.toArray(new Object[0]));
        DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
    }

    private static DynamicObject buildCtBotpUniqueObject(MainEntityType mainType, CtBotpUnique ctBotpUnique) {
        DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
        obj.set(KEY_ID, (Object)ctBotpUnique.getId());
        obj.set(KEY_STENANTCODE, (Object)ctBotpUnique.getsTenantCode());
        obj.set(KEY_SACCOUNTID, (Object)ctBotpUnique.getsAccountId());
        obj.set(KEY_SENTITYKEY, (Object)ctBotpUnique.getsEntityKey());
        obj.set(KEY_SBILLID, (Object)ctBotpUnique.getsBillId());
        obj.set(KEY_TENTITYKEY, (Object)ctBotpUnique.gettEntityKey());
        obj.set(KEY_TBILLID, (Object)ctBotpUnique.gettBillId());
        obj.set(KEY_CREATETIME, (Object)new Date());
        return obj;
    }

    private static CtBotpUnique buildCtBotpUnique(DynamicObject obj) {
        CtBotpUnique ctBotpUnique = new CtBotpUnique();
        ctBotpUnique.setId((Long)obj.getPkValue());
        ctBotpUnique.setsTenantCode(obj.getString(KEY_STENANTCODE));
        ctBotpUnique.setsAccountId(obj.getString(KEY_SACCOUNTID));
        ctBotpUnique.setsEntityKey(obj.getString(KEY_SENTITYKEY));
        ctBotpUnique.setsBillId(Long.valueOf(obj.getLong(KEY_SBILLID)));
        ctBotpUnique.settEntityKey(obj.getString(KEY_TENTITYKEY));
        ctBotpUnique.settBillId(Long.valueOf(obj.getLong(KEY_TBILLID)));
        return ctBotpUnique;
    }
}

