/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.CtBillTrackReader;
import kd.bos.ctbotp.CtConvertDataService;
import kd.bos.ctbotp.CtEntryTrackReader;
import kd.bos.ctbotp.CtLinkTreeBuilder;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.runtime.CtBFRow;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkDownNode;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.entity.ctbotp.runtime.CtBFTable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtBusinessFlowDataService {
    private static final String BOOLEAN_TRUE = String.valueOf(true);
    private static final String BOOLEAN_FALSE = String.valueOf(false);
    public CtBillTrackReader billTrackReader;
    public CtEntryTrackReader entryTrackReader;
    public CtLinkTreeBuilder linkTreeBuilder;

    public CtBillTrackReader getBillTrackReader() {
        if (this.billTrackReader == null) {
            this.billTrackReader = new CtBillTrackReader();
        }
        return this.billTrackReader;
    }

    public CtEntryTrackReader getEntryTrackReader() {
        if (this.entryTrackReader == null) {
            this.entryTrackReader = new CtEntryTrackReader();
        }
        return this.entryTrackReader;
    }

    public CtLinkTreeBuilder getLinkTreeBuilder() {
        if (this.linkTreeBuilder == null) {
            this.linkTreeBuilder = new CtLinkTreeBuilder();
        }
        return this.linkTreeBuilder;
    }

    @Deprecated
    public List<CtBFRowLinkUpNode> loadLinkUpNodes(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new ArrayList<CtBFRowLinkUpNode>();
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(entityNumber, entryKey, entryIds, false);
        ArrayList<CtBFRowId> srcBFRowIds = new ArrayList<CtBFRowId>(16);
        for (CtBFRow row : myEntryBFRows) {
            srcBFRowIds.add(row.getSId());
        }
        List<CtBFRow> allEntryBFRows = this.loadSourceRowIds(srcBFRowIds);
        return this.getLinkTreeBuilder().buildLinkUpNodes(allEntryBFRows, myEntryBFRows);
    }

    @Deprecated
    public List<CtBFRowLinkUpNode> loadDirtLinkUpNodes(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new ArrayList<CtBFRowLinkUpNode>();
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(entityNumber, entryKey, entryIds, false);
        return this.getLinkTreeBuilder().buildDirtLinkUpNodes(myEntryBFRows);
    }

    public List<CtBFRowLinkUpNode> loadLinkUpNodes(String targetEntityNumber, Long[] targetBillIds, OperateOption option) {
        boolean isBillLink;
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetBillIds == null || targetBillIds.length == 0) {
            return new ArrayList<CtBFRowLinkUpNode>(0);
        }
        boolean isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean bl = isBillLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_bill_link", BOOLEAN_FALSE));
        if (isBillLink) {
            Map<Long, CtBFRowLinkUpNode> billLinkUpNodes = this.loadBillLinkUpNodes("", "", targetEntityNumber, targetBillIds, isDirtLink);
            return new ArrayList<CtBFRowLinkUpNode>(billLinkUpNodes.values());
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetBillIds);
        if (isDirtLink) {
            return this.getLinkTreeBuilder().buildDirtLinkUpNodes(myEntryBFRows);
        }
        ArrayList<CtBFRowId> srcBFRowIds = new ArrayList<CtBFRowId>(16);
        for (CtBFRow row : myEntryBFRows) {
            srcBFRowIds.add(row.getSId());
        }
        List<CtBFRow> allEntryBFRows = this.loadSourceRowIds(srcBFRowIds);
        return this.getLinkTreeBuilder().buildLinkUpNodes(allEntryBFRows, myEntryBFRows);
    }

    public List<CtBFRowLinkUpNode> loadLinkUpNodes(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds, OperateOption option) {
        boolean searchEntry;
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<CtBFRowLinkUpNode>(0);
        }
        boolean isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean bl = searchEntry = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_search_entry", BOOLEAN_FALSE));
        if (isDirtLink) {
            List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, searchEntry);
            return this.getLinkTreeBuilder().buildDirtLinkUpNodes(myEntryBFRows);
        }
        List<CtBFRow> allEntryBFRows = this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, searchEntry);
        TableDefine tableDefine = this.getEntryTrackReader().loadTableDefine(targetEntityNumber, targetEntryKey);
        return this.getLinkTreeBuilder().buildLinkUpNodes(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), allEntryBFRows, tableDefine.getTableId(), targetEntryIds);
    }

    public Map<Long, CtBFRowLinkUpNode> loadBillLinkUpNodes(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtSource) {
        List<CtBFRow> allRows = this.loadBillLinkUp(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityNumber, billIds, onlyDirtSource);
        return this.getLinkTreeBuilder().buildBillLinkUpNodes(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityNumber, billIds, allRows);
    }

    public List<CtBFRow> loadBillLinkUpRows(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        ArrayList<Long> billIdList = new ArrayList<Long>(Arrays.asList(billIds));
        CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
        ctLkUpQueryArgs.settTenantCode(tTenantCode);
        ctLkUpQueryArgs.settAccountId(tAccountId);
        ctLkUpQueryArgs.settEntityKey(entityNumber);
        ctLkUpQueryArgs.settBillIds(billIdList);
        List<CtBillLk> ctBillLks = CtBillLinkService.getCtDirtBillLkUp(ctLkUpQueryArgs);
        HashMap<String, List<Long>> billIdMap = new HashMap<String, List<Long>>(16);
        billIdMap.put(entityNumber, billIdList);
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>(10);
        for (CtBillLk ctBillLk : ctBillLks) {
            List<Long> ids;
            if (!billIdMap.containsKey(ctBillLk.getsEntityKey())) {
                ids = new ArrayList<Long>(16);
                ids.add(ctBillLk.getSBillId());
                billIdMap.put(ctBillLk.getsEntityKey(), ids);
            } else {
                ids = (List)billIdMap.get(ctBillLk.getsEntityKey());
                if (!ids.contains(ctBillLk.getSBillId())) {
                    ids.add(ctBillLk.getSBillId());
                    billIdMap.put(ctBillLk.getsEntityKey(), ids);
                }
            }
            CtBFRowId sRowId = new CtBFRowId(tTenantCode, tAccountId, ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (sRowId.getTenantId().equals(RequestContext.get().getTenantId()) && sRowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRowId rowId = new CtBFRowId(tTenantCode, tAccountId, ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (rowId.getTenantId().equals(RequestContext.get().getTenantId()) && rowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBotpBFRows.add(bfRow);
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        for (Map.Entry entry : billIdMap.entrySet()) {
            String entityKey = (String)entry.getKey();
            List ids = (List)entry.getValue();
            List<CtBFRow> rows = this.loadBillLinkUp(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityKey, ids.toArray(new Long[0]), onlyDirtTarget);
            if (!CollectionUtils.isNotEmpty(rows)) continue;
            allRows.addAll(rows);
        }
        return allRows;
    }

    private Map<CtBFTable, List<Long>> doCtUpBillLk(Map<CtBFTable, List<Long>> ctBFTableListMap, List<CtBFRow> ctBotpBFRows) {
        ArrayList<CtBillLk> billLks = new ArrayList<CtBillLk>();
        if (MapUtils.isNotEmpty(ctBFTableListMap)) {
            for (Map.Entry<CtBFTable, List<Long>> entry : ctBFTableListMap.entrySet()) {
                CtBFTable ctBFTable = entry.getKey();
                CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
                ctLkUpQueryArgs.settTenantCode(ctBFTable.getTenantId());
                ctLkUpQueryArgs.settAccountId(ctBFTable.getAccountId());
                ctLkUpQueryArgs.settEntityKey(ctBFTable.getMainEntityKey());
                ctLkUpQueryArgs.settBillIds(entry.getValue());
                List<CtBillLk> ctBillLks = CtBillLinkService.getCtDirtBillLkUp(ctLkUpQueryArgs);
                if (!CollectionUtils.isNotEmpty(ctBillLks)) continue;
                billLks.addAll(ctBillLks);
            }
        }
        HashMap<CtBFTable, List<Long>> tableIds = new HashMap<CtBFTable, List<Long>>();
        for (CtBillLk ctBillLk : billLks) {
            CtBFTable ctBFTable = new CtBFTable(ctBillLk.getsTenantCode(), ctBillLk.getsAccountId(), ctBillLk.getsEntityKey());
            if (tableIds.containsKey(ctBFTable)) {
                ((List)tableIds.get(ctBFTable)).add(ctBillLk.getSBillId());
            } else {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                ids.add(ctBillLk.getSBillId());
                tableIds.put(ctBFTable, ids);
            }
            CtBFRowId sRowId = new CtBFRowId(ctBillLk.getsTenantCode(), ctBillLk.getsAccountId(), ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (ctBillLk.getsTenantCode().equals(RequestContext.get().getTenantId()) && ctBillLk.getsAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            sRowId.setSyncModel(ctBillLk.getsSyncModel());
            CtBFRowId rowId = new CtBFRowId(ctBillLk.gettTenantCode(), ctBillLk.gettAccountId(), ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (ctBillLk.gettTenantCode().equals(RequestContext.get().getTenantId()) && ctBillLk.gettAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            rowId.setSyncModel(ctBillLk.gettSyncModel());
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBotpBFRows.add(bfRow);
        }
        if (MapUtils.isNotEmpty(tableIds)) {
            this.doCtUpBillLk(tableIds, ctBotpBFRows);
        }
        return tableIds;
    }

    private List<CtBFRow> getCtUpBillLkDirt(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds) {
        ArrayList<CtBFRow> ctBFRows = new ArrayList<CtBFRow>(10);
        ArrayList<CtBillLk> billLks = new ArrayList<CtBillLk>(10);
        CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
        ctLkUpQueryArgs.settTenantCode(tTenantCode);
        ctLkUpQueryArgs.settAccountId(tAccountId);
        ctLkUpQueryArgs.settEntityKey(entityNumber);
        ctLkUpQueryArgs.settBillIds(Arrays.asList(billIds));
        List<CtBillLk> ctBillLks = CtBillLinkService.getCtDirtBillLkUp(ctLkUpQueryArgs);
        if (CollectionUtils.isNotEmpty(ctBillLks)) {
            billLks.addAll(ctBillLks);
        }
        for (CtBillLk ctBillLk : billLks) {
            CtBFRowId sRowId = new CtBFRowId(ctBillLk.getsTenantCode(), ctBillLk.getsAccountId(), ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (ctBillLk.getsTenantCode().equals(RequestContext.get().getTenantId()) && ctBillLk.getsAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            sRowId.setSyncModel(ctBillLk.getsSyncModel());
            CtBFRowId rowId = new CtBFRowId(ctBillLk.gettTenantCode(), ctBillLk.gettAccountId(), ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (ctBillLk.gettTenantCode().equals(RequestContext.get().getTenantId()) && ctBillLk.gettAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            rowId.setSyncModel(ctBillLk.gettSyncModel());
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBFRows.add(bfRow);
        }
        return ctBFRows;
    }

    public List<CtBFRow> loadCtBillLinkUpRows(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        ArrayList<Long> billIdList = new ArrayList<Long>(Arrays.asList(billIds));
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>();
        CtBFTable ctBFTable = new CtBFTable(tTenantCode, tAccountId, entityNumber);
        HashMap<CtBFTable, List<Long>> tableIds = new HashMap<CtBFTable, List<Long>>();
        tableIds.put(ctBFTable, billIdList);
        while (tableIds.size() > 0) {
            this.doCtUpBillLk(tableIds, ctBotpBFRows);
            Map<String, List<Long>> billIdMap = this.getUpBillIdMap(tTenantCode, tAccountId, entityNumber, allRows, billIdList, ctBotpBFRows);
            tableIds.clear();
            for (Map.Entry<String, List<Long>> entry : billIdMap.entrySet()) {
                String entityKey = entry.getKey();
                List<Long> ids = entry.getValue();
                List<CtBFRow> rows = this.loadBillLinkUp(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityKey, ids.toArray(new Long[0]), onlyDirtTarget);
                if (CollectionUtils.isNotEmpty(rows)) {
                    allRows.addAll(rows);
                }
                for (CtBFRow ctBFRow : rows) {
                    CtBFRowId sId = ctBFRow.getSId();
                    billIdList.clear();
                    billIdList.add(sId.getBillId());
                    tTenantCode = sId.getTenantId();
                    tAccountId = sId.getAccountId();
                    entityNumber = sId.getMainEntityKey();
                    tableIds.put(new CtBFTable(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityNumber), billIdList);
                }
            }
            ctBotpBFRows.clear();
        }
        return allRows;
    }

    public List<CtBFRow> loadCtBillLinkUpDirt(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds) {
        List<CtBFRow> rows;
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        List<CtBFRow> ctBFRows = this.getCtUpBillLkDirt(tTenantCode, tAccountId, entityNumber, billIds);
        if (CollectionUtils.isNotEmpty(ctBFRows)) {
            allRows.addAll(ctBFRows);
        }
        if (CollectionUtils.isNotEmpty(rows = this.loadBillLinkUp(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityNumber, billIds, true))) {
            allRows.addAll(rows);
        }
        return allRows;
    }

    private Map<String, List<Long>> getUpBillIdMap(String tTenantCode, String tAccountId, String entityNumber, List<CtBFRow> allRows, List<Long> billIdList, List<CtBFRow> ctBotpBFRows) {
        HashMap<String, List<Long>> billIdMap = new HashMap<String, List<Long>>();
        if (tTenantCode.equals(RequestContext.get().getTenantId()) && tAccountId.equals(RequestContext.get().getAccountId())) {
            billIdMap.put(entityNumber, billIdList);
        }
        for (CtBFRow ctBFRow : ctBotpBFRows) {
            if (ctBFRow.getSId().getTenantId().equals(RequestContext.get().getTenantId()) && ctBFRow.getSId().getAccountId().equals(RequestContext.get().getAccountId())) {
                billIdMap.putIfAbsent(ctBFRow.getSId().getMainEntityKey(), new ArrayList());
                List ids = (List)billIdMap.get(ctBFRow.getSId().getMainEntityKey());
                ids.add(ctBFRow.getSId().getBillId());
            }
            if (!ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            billIdMap.putIfAbsent(ctBFRow.getId().getMainEntityKey(), new ArrayList());
            List tIds = (List)billIdMap.get(ctBFRow.getId().getMainEntityKey());
            tIds.add(ctBFRow.getId().getBillId());
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        return billIdMap;
    }

    @Deprecated
    public List<CtBFRowLinkDownNode> loadLinkDownNodes(String srcEntityNumber, String srcEntryKey, Long[] srcEntryIds) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<CtBFRowLinkDownNode>();
        }
        List<Object> allEntryBFRows = new ArrayList(0);
        if (StringUtils.isBlank((CharSequence)srcEntryKey)) {
            allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcEntryIds, null);
        } else {
            HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(srcEntityNumber, srcEntryKey, srcEntryIds);
            allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcEntryKey, myBillIds.toArray(new Long[0]), srcEntryIds, null);
        }
        return this.getLinkTreeBuilder().buildLinkDownNodes(srcEntityNumber, srcEntryKey, srcEntryIds, allEntryBFRows);
    }

    @Deprecated
    public List<CtBFRowLinkDownNode> loadDirtLinkDownNodes(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new ArrayList<CtBFRowLinkDownNode>();
        }
        List<Object> allEntryBFRows = new ArrayList(0);
        if (StringUtils.isBlank((CharSequence)entryKey)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("botp_track_only_dirt_link", BOOLEAN_TRUE);
            allEntryBFRows = this.loadTargetRowIds(entityNumber, entryIds, option);
        } else {
            HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(entityNumber, entryKey, entryIds);
            OperateOption option = OperateOption.create();
            option.setVariableValue("botp_track_only_dirt_link", BOOLEAN_TRUE);
            allEntryBFRows = this.loadTargetRowIds(entityNumber, entryKey, myBillIds.toArray(new Long[0]), entryIds, option);
        }
        return this.getLinkTreeBuilder().buildLinkDownNodes(entityNumber, entryKey, entryIds, allEntryBFRows);
    }

    public List<CtBFRowLinkDownNode> loadLinkDownNodes(String srcEntityNumber, Long[] srcBillIds, OperateOption option) {
        boolean onlyBillLink;
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<CtBFRowLinkDownNode>(0);
        }
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean bl = onlyBillLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_bill_link", BOOLEAN_FALSE));
        if (onlyBillLink) {
            Map<Long, CtBFRowLinkDownNode> map = this.loadBillLinkDownNodes("", "", srcEntityNumber, srcBillIds, onlyDirtLink);
            return new ArrayList<CtBFRowLinkDownNode>(map.values());
        }
        List<CtBFRow> allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcBillIds, option);
        return this.getLinkTreeBuilder().buildLinkDownNodes(srcEntityNumber, "", srcBillIds, allEntryBFRows);
    }

    public List<CtBFRowLinkDownNode> loadLinkDownNodes(String srcEntityNumber, String srcEntryKey, Long[] srcBillIds, Long[] srcEntryIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<CtBFRowLinkDownNode>(0);
        }
        List<CtBFRow> allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcEntryKey, srcBillIds, srcEntryIds, option);
        return this.getLinkTreeBuilder().buildLinkDownNodes(srcEntityNumber, srcEntryKey, srcEntryIds, allEntryBFRows);
    }

    public List<CtBFRow> loadBillLinkDownRows(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        ArrayList<Long> billIdList = new ArrayList<Long>(Arrays.asList(billIds));
        CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
        ctLkDownQueryArgs.setsTenantCode(sTenantCode);
        ctLkDownQueryArgs.setsAccountId(sAccountId);
        ctLkDownQueryArgs.setsEntityKey(entityNumber);
        ctLkDownQueryArgs.setsBillIds(billIdList);
        List<CtBillLk> ctBillLks = CtBillLinkService.getCtDirtBillLkDown(ctLkDownQueryArgs);
        List tIds = ctBillLks.stream().map(a -> a.getTBillId()).collect(Collectors.toList());
        HashMap<String, List<Object>> billIdMap = new HashMap<String, List<Object>>(16);
        billIdMap.put(entityNumber, tIds);
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>(10);
        for (CtBillLk ctBillLk : ctBillLks) {
            List<Long> ids;
            if (!billIdMap.containsKey(ctBillLk.gettEntityKey())) {
                ids = new ArrayList<Long>(16);
                ids.add(ctBillLk.getSBillId());
                billIdMap.put(ctBillLk.getsEntityKey(), ids);
            } else {
                ids = (List)billIdMap.get(ctBillLk.getsEntityKey());
                if (!ids.contains(ctBillLk.getSBillId())) {
                    ids.add(ctBillLk.getSBillId());
                    billIdMap.put(ctBillLk.getsEntityKey(), ids);
                }
            }
            CtBFRowId sRowId = new CtBFRowId(sTenantCode, sAccountId, ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (sRowId.getTenantId().equals(RequestContext.get().getTenantId()) && sRowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRowId rowId = new CtBFRowId(sTenantCode, sAccountId, ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (rowId.getTenantId().equals(RequestContext.get().getTenantId()) && rowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBotpBFRows.add(bfRow);
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        for (Map.Entry entry : billIdMap.entrySet()) {
            String entityKey = (String)entry.getKey();
            List ids = (List)entry.getValue();
            List<CtBFRow> rows = this.loadBillLinkDown(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityKey, ids.toArray(new Long[0]), onlyDirtTarget);
            if (!CollectionUtils.isNotEmpty(rows)) continue;
            allRows.addAll(rows);
        }
        return allRows;
    }

    public List<CtBFRow> getTenantDirtBillLkDown(String sTenantId, String sAccountId, String sEntityKey, List<Long> billIds) {
        ArrayList<CtBFRow> ctBFRows = new ArrayList<CtBFRow>(16);
        ArrayList<CtBillLk> billLks = new ArrayList<CtBillLk>();
        CtLkDownQueryArgs args = new CtLkDownQueryArgs();
        args.setsTenantCode(sTenantId);
        args.setsAccountId(sAccountId);
        args.setsEntityKey(sEntityKey);
        args.setsBillIds(billIds);
        List<CtBillLk> ctDirtBillLkDown = CtBillLinkService.getCtDirtBillLkDown(args);
        if (CollectionUtils.isNotEmpty(ctDirtBillLkDown)) {
            billLks.addAll(ctDirtBillLkDown);
        }
        for (CtBillLk ctBillLk : billLks) {
            CtBFRowId sRowId = new CtBFRowId(ctBillLk.getsTenantCode(), ctBillLk.getsAccountId(), ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (sRowId.getTenantId().equals(RequestContext.get().getTenantId()) && sRowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRowId rowId = new CtBFRowId(ctBillLk.gettTenantCode(), ctBillLk.gettAccountId(), ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (rowId.getTenantId().equals(RequestContext.get().getTenantId()) && rowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBFRows.add(bfRow);
        }
        return ctBFRows;
    }

    private Map<CtBFTable, List<Long>> doCtBillLk(Map<CtBFTable, List<Long>> ctBFTableListMap, List<CtBFRow> ctBotpBFRows) {
        ArrayList<CtBillLk> billLks = new ArrayList<CtBillLk>();
        if (MapUtils.isNotEmpty(ctBFTableListMap)) {
            for (Map.Entry<CtBFTable, List<Long>> entry : ctBFTableListMap.entrySet()) {
                CtBFTable ctBFTable = entry.getKey();
                CtLkDownQueryArgs args = new CtLkDownQueryArgs();
                args.setsTenantCode(ctBFTable.getTenantId());
                args.setsAccountId(ctBFTable.getAccountId());
                args.setsEntityKey(ctBFTable.getMainEntityKey());
                args.setsBillIds(entry.getValue());
                List<CtBillLk> ctDirtBillLkDown = CtBillLinkService.getCtDirtLkForCurrTenant(args);
                if (!CollectionUtils.isNotEmpty(ctDirtBillLkDown)) continue;
                billLks.addAll(ctDirtBillLkDown);
            }
        }
        HashMap<CtBFTable, List<Long>> tableIds = new HashMap<CtBFTable, List<Long>>();
        for (CtBillLk ctBillLk : billLks) {
            CtBFTable ctBFTable = new CtBFTable(ctBillLk.gettTenantCode(), ctBillLk.gettAccountId(), ctBillLk.gettEntityKey());
            if (tableIds.containsKey(ctBFTable)) {
                ((List)tableIds.get(ctBFTable)).add(ctBillLk.getTBillId());
            } else {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                ids.add(ctBillLk.getTBillId());
                tableIds.put(ctBFTable, ids);
            }
            CtBFRowId sRowId = new CtBFRowId(ctBillLk.getsTenantCode(), ctBillLk.getsAccountId(), ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (sRowId.getTenantId().equals(RequestContext.get().getTenantId()) && sRowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            sRowId.setSyncModel(ctBillLk.getsSyncModel());
            CtBFRowId rowId = new CtBFRowId(ctBillLk.gettTenantCode(), ctBillLk.gettAccountId(), ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (rowId.getTenantId().equals(RequestContext.get().getTenantId()) && rowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            rowId.setSyncModel(ctBillLk.gettSyncModel());
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBotpBFRows.add(bfRow);
        }
        if (MapUtils.isNotEmpty(tableIds)) {
            this.doCtBillLk(tableIds, ctBotpBFRows);
        }
        return tableIds;
    }

    public List<CtBFRow> loadCtBillLinkDownRows(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        ArrayList<Long> billIdList = new ArrayList<Long>(Arrays.asList(billIds));
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>();
        CtBFTable ctBFTable = new CtBFTable(sTenantCode, sAccountId, entityNumber);
        HashMap<CtBFTable, List<Long>> tableIds = new HashMap<CtBFTable, List<Long>>();
        tableIds.put(ctBFTable, billIdList);
        while (tableIds.size() > 0) {
            this.doCtBillLk(tableIds, ctBotpBFRows);
            Map<String, List<Long>> currTenantBillIdMap = this.getDownBillIdMap(sTenantCode, sAccountId, entityNumber, allRows, billIdList, ctBotpBFRows);
            tableIds.clear();
            for (Map.Entry<String, List<Long>> entry : currTenantBillIdMap.entrySet()) {
                String entityKey = entry.getKey();
                List<Long> ids = entry.getValue();
                List<CtBFRow> rows = this.loadBillLinkDown(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityKey, ids.toArray(new Long[0]), onlyDirtTarget);
                if (CollectionUtils.isNotEmpty(rows)) {
                    allRows.addAll(rows);
                }
                for (CtBFRow ctBFRow : rows) {
                    CtBFRowId id = ctBFRow.getId();
                    billIdList.clear();
                    billIdList.add(id.getBillId());
                    sTenantCode = id.getTenantId();
                    sAccountId = id.getAccountId();
                    entityNumber = id.getMainEntityKey();
                    tableIds.put(new CtBFTable(sTenantCode, sAccountId, entityNumber), billIdList);
                }
            }
            ctBotpBFRows.clear();
        }
        return allRows;
    }

    public List<CtBFRow> loadCtBillLinkDownDirt(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        ArrayList<Long> billIdList = new ArrayList<Long>(Arrays.asList(billIds));
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>();
        CtBFTable ctBFTable = new CtBFTable(sTenantCode, sAccountId, entityNumber);
        HashMap<CtBFTable, List<Long>> tableIds = new HashMap<CtBFTable, List<Long>>();
        tableIds.put(ctBFTable, billIdList);
        while (tableIds.size() > 0) {
            this.doCtBillLk(tableIds, ctBotpBFRows);
            Map<String, List<Long>> currTenantBillIdMap = this.getDownBillIdMap(sTenantCode, sAccountId, entityNumber, allRows, billIdList, ctBotpBFRows);
            tableIds.clear();
            for (Map.Entry<String, List<Long>> entry : currTenantBillIdMap.entrySet()) {
                String entityKey = entry.getKey();
                List<Long> ids = entry.getValue();
                List<CtBFRow> rows = this.loadBillLinkDown(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityKey, ids.toArray(new Long[0]), onlyDirtTarget);
                if (CollectionUtils.isNotEmpty(rows)) {
                    allRows.addAll(rows);
                }
                for (CtBFRow ctBFRow : rows) {
                    CtBFRowId id = ctBFRow.getId();
                    billIdList.clear();
                    billIdList.add(id.getBillId());
                    sTenantCode = id.getTenantId();
                    sAccountId = id.getAccountId();
                    entityNumber = id.getMainEntityKey();
                    tableIds.put(new CtBFTable(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityNumber), billIdList);
                }
            }
            ctBotpBFRows.clear();
        }
        return allRows;
    }

    private Map<String, List<Long>> getDownBillIdMap(String sTenantCode, String sAccountId, String entityNumber, List<CtBFRow> allRows, List<Long> billIdList, List<CtBFRow> ctBotpBFRows) {
        HashMap<String, List<Long>> currTenantBillIdMap = new HashMap<String, List<Long>>();
        if (sTenantCode.equals(RequestContext.get().getTenantId()) && sAccountId.equals(RequestContext.get().getAccountId())) {
            currTenantBillIdMap.putIfAbsent(entityNumber, new ArrayList());
            List ids = (List)currTenantBillIdMap.get(entityNumber);
            ids.addAll(billIdList);
        }
        for (CtBFRow ctBFRow : ctBotpBFRows) {
            if (ctBFRow.getSId().getTenantId().equals(RequestContext.get().getTenantId()) && ctBFRow.getSId().getAccountId().equals(RequestContext.get().getAccountId())) {
                currTenantBillIdMap.putIfAbsent(ctBFRow.getSId().getMainEntityKey(), new ArrayList());
                List ids = (List)currTenantBillIdMap.get(ctBFRow.getSId().getMainEntityKey());
                ids.add(ctBFRow.getSId().getBillId());
            }
            if (!ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            currTenantBillIdMap.putIfAbsent(ctBFRow.getId().getMainEntityKey(), new ArrayList());
            List tIds = (List)currTenantBillIdMap.get(ctBFRow.getId().getMainEntityKey());
            tIds.add(ctBFRow.getId().getBillId());
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        return currTenantBillIdMap;
    }

    public Map<Long, CtBFRowLinkDownNode> loadBillLinkDownNodes(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
        ctLkDownQueryArgs.setsTenantCode(sTenantCode);
        ctLkDownQueryArgs.setsAccountId(sAccountId);
        ctLkDownQueryArgs.setsEntityKey(entityNumber);
        ctLkDownQueryArgs.setsBillIds(Arrays.asList(billIds));
        List<CtBillLk> ctBillLks = CtBillLinkService.getCtDirtBillLkDown(ctLkDownQueryArgs);
        HashMap billIdMap = new HashMap(16);
        billIdMap.put(entityNumber, Arrays.asList(billIds));
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>(10);
        HashMap<String, Long> tableIdMap = new HashMap<String, Long>(16);
        CtConvertDataService reader = new CtConvertDataService();
        for (CtBillLk ctBillLk : ctBillLks) {
            List<Long> ids;
            if (tableIdMap.containsKey(ctBillLk.getsEntityKey())) {
                TableDefine sTableDefine = reader.loadTableDefine(ctBillLk.getsEntityKey(), ctBillLk.getsEntityKey());
                tableIdMap.put(ctBillLk.getsEntityKey(), sTableDefine.getTableId());
            }
            if (!tableIdMap.containsKey(ctBillLk.gettEntityKey())) {
                TableDefine tTableDefine = reader.loadTableDefine(ctBillLk.gettEntityKey(), ctBillLk.gettEntityKey());
                tableIdMap.put(ctBillLk.gettEntityKey(), tTableDefine.getTableId());
            }
            if (!billIdMap.containsKey(ctBillLk.getsEntityKey())) {
                ids = new ArrayList<Long>(16);
                ids.add(ctBillLk.getSBillId());
                billIdMap.put(ctBillLk.getsEntityKey(), ids);
            } else {
                ids = (List)billIdMap.get(ctBillLk.getsEntityKey());
                ids.add(ctBillLk.getSBillId());
                billIdMap.put(ctBillLk.getsEntityKey(), ids);
            }
            CtBFRowId sRowId = new CtBFRowId(sTenantCode, sAccountId, (Long)tableIdMap.get(ctBillLk.getsEntityKey()), ctBillLk.getSBillId(), (Long)tableIdMap.get(ctBillLk.getsEntityKey()), ctBillLk.getSBillId());
            CtBFRowId rowId = new CtBFRowId(sTenantCode, sAccountId, (Long)tableIdMap.get(ctBillLk.gettEntityKey()), ctBillLk.getTBillId(), (Long)tableIdMap.get(ctBillLk.gettEntityKey()), ctBillLk.getTBillId());
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBotpBFRows.add(bfRow);
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        for (Map.Entry entry : billIdMap.entrySet()) {
            String entityKey = (String)entry.getKey();
            List ids = (List)entry.getValue();
            List<CtBFRow> rows = this.loadBillLinkDown(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), entityKey, ids.toArray(new Long[0]), onlyDirtTarget);
            if (!CollectionUtils.isNotEmpty(rows)) continue;
            allRows.addAll(rows);
        }
        HashMap<Long, List<Long>> ctBfRowMap = new HashMap<Long, List<Long>>();
        for (CtBFRow ctBFRow : allRows) {
            List<Long> idList;
            if (ctBfRowMap.containsKey(ctBFRow.getId().getMainTableId())) {
                idList = (List)ctBfRowMap.get(ctBFRow.getId().getMainTableId());
                idList.add(ctBFRow.getId().getBillId());
                ctBfRowMap.put(ctBFRow.getId().getMainTableId(), idList);
            } else {
                idList = new ArrayList<Long>();
                idList.add(ctBFRow.getId().getBillId());
                ctBfRowMap.put(ctBFRow.getId().getMainTableId(), idList);
            }
            if (ctBfRowMap.containsKey(ctBFRow.getSId().getMainTableId())) {
                idList = (List)ctBfRowMap.get(ctBFRow.getSId().getMainTableId());
                idList.add(ctBFRow.getSId().getBillId());
                ctBfRowMap.put(ctBFRow.getSId().getMainTableId(), idList);
                continue;
            }
            idList = new ArrayList();
            idList.add(ctBFRow.getSId().getBillId());
            ctBfRowMap.put(ctBFRow.getSId().getMainTableId(), idList);
        }
        return this.getLinkTreeBuilder().buildBillLinkDownNodes("", "", entityNumber, billIds, allRows);
    }

    @Deprecated
    public List<CtBFRow> loadSourceRowIds(String targetEntityNumber, String targetEntryKey, Long[] targetEntryIds) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetEntryIds, false);
        ArrayList<CtBFRowId> srcBFRowIds = new ArrayList<CtBFRowId>(16);
        for (CtBFRow row : myEntryBFRows) {
            srcBFRowIds.add(row.getSId());
        }
        List<CtBFRow> srcEntryBFRows = this.loadSourceRowIds(srcBFRowIds);
        ArrayList<CtBFRow> allEntryBFRows = new ArrayList<CtBFRow>();
        allEntryBFRows.addAll(myEntryBFRows);
        allEntryBFRows.addAll(srcEntryBFRows);
        return allEntryBFRows;
    }

    public List<CtBFRow> loadSourceRowIds(String targetEntityNumber, Long[] targetBillIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetBillIds == null || targetBillIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        return this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetBillIds, onlyDirtLink);
    }

    public List<CtBFRow> loadSourceRowIds(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds, OperateOption option) {
        boolean isDirtLink;
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        boolean bl = isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        if (isDirtLink) {
            List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, false);
            return myEntryBFRows;
        }
        List<CtBFRow> allEntryBFRows = this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, false);
        return allEntryBFRows;
    }

    public List<CtBFRow> loadSourceRowIds(List<CtBFRowId> entryRowIds) {
        HashMap allSrcBillIds = new HashMap(entryRowIds.size());
        HashMap srcBillIds = new HashMap(entryRowIds.size());
        for (CtBFRowId entryRowId : entryRowIds) {
            if (!this.getEntryTrackReader().addToMap(allSrcBillIds, entryRowId.getMainTableId(), entryRowId.getBillId())) continue;
            this.getEntryTrackReader().addToMap(srcBillIds, entryRowId.getMainTableId(), entryRowId.getBillId());
        }
        ArrayList<CtBFRow> allEntryBFRows = new ArrayList<CtBFRow>(entryRowIds.size());
        ArrayList<CtBFRow> entryBFRows = new ArrayList<CtBFRow>(entryRowIds.size());
        int count = 0;
        while (srcBillIds.size() > 0 && count < 100) {
            ++count;
            entryBFRows.clear();
            for (Map.Entry entry : srcBillIds.entrySet()) {
                Long targetMainTableId = (Long)entry.getKey();
                Set tergetBillIds = (Set)entry.getValue();
                entryBFRows.addAll(this.getEntryTrackReader().readUpEntryBFRows(targetMainTableId, tergetBillIds.toArray(new Long[0])));
            }
            srcBillIds.clear();
            for (CtBFRow bfRow : entryBFRows) {
                if (!this.getEntryTrackReader().addToMap(allSrcBillIds, bfRow.getSId().getMainTableId(), bfRow.getSId().getBillId())) continue;
                this.getEntryTrackReader().addToMap(srcBillIds, bfRow.getSId().getMainTableId(), bfRow.getSId().getBillId());
            }
            allEntryBFRows.addAll(entryBFRows);
        }
        return allEntryBFRows;
    }

    @Deprecated
    public List<CtBFRow> loadTargetRowIds(String srcEntityNumber, String srcEntryKey, Long[] srcEntryIds) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<CtBFRow>();
        }
        if (StringUtils.isBlank((CharSequence)srcEntryKey)) {
            return this.loadTargetRowIds(srcEntityNumber, srcEntryIds, null);
        }
        HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(srcEntityNumber, srcEntryKey, srcEntryIds);
        return this.loadTargetRowIds(srcEntityNumber, srcEntryKey, myBillIds.toArray(new Long[0]), srcEntryIds, null);
    }

    public List<CtBFRow> loadTargetRowIds(String srcEntityNumber, Long[] srcBillIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<CtBFRow>();
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        return this.getBillTrackReader().readFullDownEntryBFRows(myMainTableId, srcBillIds, onlyDirtLink);
    }

    public List<CtBFRow> loadTargetRowIds(String srcEntityNumber, String srcEntryKey, Long[] srcBillIds, Long[] srcEntryIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<CtBFRow>();
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        TableDefine entryTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntryKey);
        Long myEntryTableId = entryTableDefine.getTableId();
        HashSet<Long> myEntryIds = new HashSet<Long>(srcEntryIds.length);
        for (Long entryId : srcEntryIds) {
            myEntryIds.add(entryId);
        }
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean searchEntry = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_search_entry", BOOLEAN_FALSE));
        return this.getBillTrackReader().readFullDownEntryBFRows(myMainTableId, myEntryTableId, srcBillIds, myEntryIds, onlyDirtLink, searchEntry);
    }

    public List<CtBFRow> loadBillLinkUp(String tTenantId, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtSource) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        if (onlyDirtSource) {
            Set<CtBFRow> myRows = this.getEntryTrackReader().readUpBillBFRows(tTenantId, tAccountId, entityNumber, billIds);
            return new ArrayList<CtBFRow>(myRows);
        }
        Set<CtBFRow> allRows = this.getEntryTrackReader().readFullUpBillBFRows(tTenantId, tAccountId, entityNumber, billIds);
        return new ArrayList<CtBFRow>(allRows);
    }

    public List<CtBFRow> loadBillLinkDown(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long mainTableId = mainTableDefine.getTableId();
        if (onlyDirtTarget) {
            return this.getBillTrackReader().readDownBillBFRows(sTenantCode, sAccountId, mainTableId, billIds);
        }
        return this.getBillTrackReader().readFullDownBillBFRows(sTenantCode, sAccountId, mainTableId, billIds);
    }

    public Map<String, HashSet<Long>> findLinkBills(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<String, HashSet<Long>>();
        }
        Map<String, HashSet<Long>> sourceBills = this.findSourceBills(entityNumber, billIds);
        Map<String, HashSet<Long>> targetBills = this.findTargetBills(entityNumber, billIds);
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        linkBills.putAll(sourceBills);
        linkBills.putAll(targetBills);
        return linkBills;
    }

    public Map<String, HashSet<Long>> findSourceBills(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<String, HashSet<Long>>();
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        HashSet<Long> myBillIds = new HashSet<Long>();
        for (Long billId : billIds) {
            myBillIds.add(billId);
        }
        if (myBillIds.size() == 0) {
            return new LinkedHashMap<String, HashSet<Long>>();
        }
        LinkedHashMap allLinkBills = new LinkedHashMap();
        HashMap<Long, HashSet<Long>> srcBillIds = new HashMap<Long, HashSet<Long>>();
        srcBillIds.put(myMainTableId, myBillIds);
        int count = 0;
        HashSet<CtBFRow> allBillLinkRows = new HashSet<CtBFRow>();
        while (srcBillIds.size() > 0 && count < 100) {
            ++count;
            allBillLinkRows.clear();
            for (Map.Entry entry : srcBillIds.entrySet()) {
                Long targetMainTableId = (Long)entry.getKey();
                Long[] targetBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
                Set<CtBFRow> billLinkRows = this.getEntryTrackReader().readUpBillBFRows("", "", targetMainTableId, targetBillIds);
                allBillLinkRows.addAll(billLinkRows);
            }
            srcBillIds.clear();
            for (CtBFRow billLinkRow : allBillLinkRows) {
                Long sMainTableId = billLinkRow.getSId().getMainTableId();
                Long sBillId = billLinkRow.getSId().getBillId();
                if (!this.getEntryTrackReader().addToMap(allLinkBills, sMainTableId, sBillId)) continue;
                this.getEntryTrackReader().addToMap(srcBillIds, sMainTableId, sBillId);
            }
        }
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        for (Map.Entry item : allLinkBills.entrySet()) {
            Long sMainTableId = (Long)item.getKey();
            TableDefine tableDefine = reader.loadTableDefine(sMainTableId);
            if (tableDefine == null) continue;
            HashSet sBillIds = new HashSet((Collection)item.getValue());
            linkBills.put(tableDefine.getEntityNumber(), sBillIds);
        }
        return linkBills;
    }

    public Map<String, HashSet<Long>> findTargetBills(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<String, HashSet<Long>>();
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        HashSet<Long> myBillIds = new HashSet<Long>(16);
        for (Long billId : billIds) {
            myBillIds.add(billId);
        }
        if (myBillIds.size() == 0) {
            return new LinkedHashMap<String, HashSet<Long>>();
        }
        LinkedHashMap allLinkBills = new LinkedHashMap();
        HashMap<Long, HashSet<Long>> tgtBillIds = new HashMap<Long, HashSet<Long>>();
        tgtBillIds.put(myMainTableId, myBillIds);
        int count = 0;
        while (tgtBillIds.size() > 0 && count < 100) {
            ++count;
            ArrayList<CtBFRowId> allBillRowIds = new ArrayList<CtBFRowId>();
            for (Map.Entry entry : tgtBillIds.entrySet()) {
                Long sMainTableId = (Long)entry.getKey();
                Long[] sBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
                List<CtBFRowId> billRowIds = this.getBillTrackReader().readDownBillBFRowIds(sMainTableId, sBillIds);
                allBillRowIds.addAll(billRowIds);
            }
            tgtBillIds.clear();
            for (CtBFRowId billRowId : allBillRowIds) {
                if (!this.getEntryTrackReader().addToMap(allLinkBills, billRowId.getTableId(), billRowId.getBillId())) continue;
                this.getEntryTrackReader().addToMap(tgtBillIds, billRowId.getTableId(), billRowId.getBillId());
            }
        }
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        for (Map.Entry item : allLinkBills.entrySet()) {
            HashSet<Long> existBillIds;
            Long mainTableId = (Long)item.getKey();
            TableDefine tableDefine = reader.loadTableDefine(mainTableId);
            if (tableDefine == null || (existBillIds = this.getEntryTrackReader().readExistsBillIds(tableDefine.getEntityNumber(), ((Set)item.getValue()).toArray(new Long[0]))).isEmpty()) continue;
            linkBills.put(tableDefine.getEntityNumber(), existBillIds);
        }
        return linkBills;
    }

    public Map<Long, List<CtBFRow>> findDirtTargetBills(String srcEntityNumber, Long[] srcBillIds) {
        Long tMainTableId;
        HashMap<Long, List<CtBFRow>> result = new HashMap<Long, List<CtBFRow>>(srcBillIds.length);
        HashSet<Long> myBillIds = new HashSet<Long>(10);
        for (Long billId : srcBillIds) {
            myBillIds.add(billId);
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        List<CtBFRowId> targetBillRowIds = this.getBillTrackReader().readDownBillBFRowIds(myMainTableId, srcBillIds);
        if (targetBillRowIds.isEmpty()) {
            return result;
        }
        HashMap tgtBillIds = new HashMap();
        for (CtBFRowId ctBFRowId : targetBillRowIds) {
            tMainTableId = ctBFRowId.getMainTableId();
            Long tBillId = ctBFRowId.getBillId();
            this.getEntryTrackReader().addToMap(tgtBillIds, tMainTableId, tBillId);
        }
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            tMainTableId = (Long)entry.getKey();
            Long[] tBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
            Set<CtBFRow> linkRows = this.getEntryTrackReader().readUpBillBFRows("", "", tMainTableId, tBillIds);
            for (CtBFRow linkRow : linkRows) {
                Long srcBillId = linkRow.getSId().getBillId();
                if (Long.compare(myMainTableId, linkRow.getSId().getMainTableId()) != 0 || !myBillIds.contains(srcBillId)) continue;
                if (!result.containsKey(srcBillId)) {
                    result.put(srcBillId, new ArrayList());
                }
                ((List)result.get(srcBillId)).add(linkRow);
            }
        }
        return result;
    }

    public Map<Long, List<CtBFRow>> findDirtSourceBills(String targetEntityNumber, Long[] targetBillIds) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetBillIds == null || targetBillIds.length == 0) {
            return new HashMap<Long, List<CtBFRow>>(0);
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetBillIds);
        HashMap<Long, List<CtBFRow>> result = new HashMap<Long, List<CtBFRow>>(targetBillIds.length);
        for (CtBFRow myRow : myEntryBFRows) {
            List bfRows = result.computeIfAbsent(myRow.getId().getBillId(), s -> new ArrayList());
            bfRows.add(myRow);
        }
        return result;
    }

    public boolean isPush(String srcEntityNumber, Long srcBillId) {
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        List<CtBFRowId> targetBillRowIds = this.getBillTrackReader().readDownBillBFRowIds(myMainTableId, new Long[]{srcBillId});
        if (targetBillRowIds.isEmpty()) {
            return false;
        }
        HashMap tgtBillIds = new HashMap();
        for (CtBFRowId ctBFRowId : targetBillRowIds) {
            this.getEntryTrackReader().addToMap(tgtBillIds, ctBFRowId.getMainTableId(), ctBFRowId.getBillId());
        }
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            Long targetMainTableId = (Long)entry.getKey();
            Long[] targetBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
            Set<CtBFRow> bfRows = this.getEntryTrackReader().readUpBillBFRows("", "", targetMainTableId, targetBillIds);
            if (bfRows.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isPush(String srcEntityNumber, String srcEntryKey, Long srcEntryId) {
        boolean isEntry = StringUtils.isNotBlank((CharSequence)srcEntryKey);
        if (isEntry) {
            HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(srcEntityNumber, srcEntryKey, new Long[]{srcEntryId});
            if (myBillIds.isEmpty()) {
                return false;
            }
            return this.isPush(srcEntityNumber, srcEntryKey, myBillIds.iterator().next(), srcEntryId);
        }
        return this.isPush(srcEntityNumber, srcEntryId);
    }

    public boolean isPush(String srcEntityNumber, String srcEntryKey, Long srcBillId, Long srcEntryId) {
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        List<CtBFRowId> targetBillRowIds = this.getBillTrackReader().readDownBillBFRowIds(myMainTableId, new Long[]{srcBillId});
        if (targetBillRowIds.isEmpty()) {
            return false;
        }
        TableDefine tableDefine = reader.loadTableDefine(srcEntityNumber, srcEntryKey);
        Long myEntryTableId = tableDefine.getTableId();
        HashMap tgtBillIds = new HashMap();
        for (CtBFRowId ctBFRowId : targetBillRowIds) {
            this.getEntryTrackReader().addToMap(tgtBillIds, ctBFRowId.getMainTableId(), ctBFRowId.getBillId());
        }
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            Long targetMainTableId = (Long)entry.getKey();
            Long[] targetBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
            Long searchTableId = myEntryTableId;
            Long searchId = srcEntryId;
            boolean existEntryTracker = this.getEntryTrackReader().isExistsEntryTracker(searchTableId, searchId, true, targetMainTableId, targetBillIds);
            if (!existEntryTracker) continue;
            return true;
        }
        return false;
    }
}

