/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ctbotp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.CtBillTrackReader;
import kd.bos.ctbotp.CtConvertDataService;
import kd.bos.ctbotp.CtEntryTrackReader;
import kd.bos.ctbotp.CtLinkTreeBuilder;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtEntryLkDownQueryArgs;
import kd.bos.entity.ctbotp.link.CtEntryLkUpQueryArgs;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.runtime.CtBFEntryTable;
import kd.bos.entity.ctbotp.runtime.CtBFRow;
import kd.bos.entity.ctbotp.runtime.CtBFRowId;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkDownNode;
import kd.bos.entity.ctbotp.runtime.CtBFRowLinkUpNode;
import kd.bos.entity.ctbotp.runtime.CtBillEntryInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtBusinessFlowEntryDataService {
    private static final String BOOLEAN_TRUE = String.valueOf(true);
    private static final String BOOLEAN_FALSE = String.valueOf(false);
    public CtBillTrackReader billTrackReader;
    public CtEntryTrackReader entryTrackReader;
    public CtLinkTreeBuilder linkTreeBuilder;

    public CtBillTrackReader getBillTrackReader() {
        if (this.billTrackReader == null) {
            this.billTrackReader = new CtBillTrackReader();
        }
        return this.billTrackReader;
    }

    public CtEntryTrackReader getEntryTrackReader() {
        if (this.entryTrackReader == null) {
            this.entryTrackReader = new CtEntryTrackReader();
        }
        return this.entryTrackReader;
    }

    public CtLinkTreeBuilder getLinkTreeBuilder() {
        if (this.linkTreeBuilder == null) {
            this.linkTreeBuilder = new CtLinkTreeBuilder();
        }
        return this.linkTreeBuilder;
    }

    @Deprecated
    public List<CtBFRowLinkUpNode> loadLinkUpNodes(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new ArrayList<CtBFRowLinkUpNode>();
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(entityNumber, entryKey, entryIds, false);
        ArrayList<CtBFRowId> srcBFRowIds = new ArrayList<CtBFRowId>(16);
        for (CtBFRow row : myEntryBFRows) {
            srcBFRowIds.add(row.getSId());
        }
        List<CtBFRow> allEntryBFRows = this.loadSourceRowIds(srcBFRowIds);
        return this.getLinkTreeBuilder().buildLinkUpNodes(allEntryBFRows, myEntryBFRows);
    }

    @Deprecated
    public List<CtBFRowLinkUpNode> loadDirtLinkUpNodes(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new ArrayList<CtBFRowLinkUpNode>();
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(entityNumber, entryKey, entryIds, false);
        return this.getLinkTreeBuilder().buildDirtLinkUpNodes(myEntryBFRows);
    }

    public List<CtBFRowLinkUpNode> loadLinkUpNodes(String targetEntityNumber, Long[] targetBillIds, OperateOption option) {
        boolean isBillLink;
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetBillIds == null || targetBillIds.length == 0) {
            return new ArrayList<CtBFRowLinkUpNode>(0);
        }
        boolean isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean bl = isBillLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_bill_link", BOOLEAN_FALSE));
        if (isBillLink) {
            Map<Long, CtBFRowLinkUpNode> billLinkUpNodes = this.loadBillLinkUpNodes("", "", targetEntityNumber, targetBillIds, isDirtLink);
            return new ArrayList<CtBFRowLinkUpNode>(billLinkUpNodes.values());
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetBillIds);
        if (isDirtLink) {
            return this.getLinkTreeBuilder().buildDirtLinkUpNodes(myEntryBFRows);
        }
        ArrayList<CtBFRowId> srcBFRowIds = new ArrayList<CtBFRowId>(16);
        for (CtBFRow row : myEntryBFRows) {
            srcBFRowIds.add(row.getSId());
        }
        List<CtBFRow> allEntryBFRows = this.loadSourceRowIds(srcBFRowIds);
        return this.getLinkTreeBuilder().buildLinkUpNodes(allEntryBFRows, myEntryBFRows);
    }

    public List<CtBFRowLinkUpNode> loadLinkUpNodes(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds, OperateOption option) {
        boolean searchEntry;
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<CtBFRowLinkUpNode>(0);
        }
        boolean isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean bl = searchEntry = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_search_entry", BOOLEAN_FALSE));
        if (isDirtLink) {
            List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, searchEntry);
            return this.getLinkTreeBuilder().buildDirtLinkUpNodes(myEntryBFRows);
        }
        List<CtBFRow> allEntryBFRows = this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, searchEntry);
        TableDefine tableDefine = this.getEntryTrackReader().loadTableDefine(targetEntityNumber, targetEntryKey);
        return this.getLinkTreeBuilder().buildLinkUpNodes(RequestContext.get().getTenantId(), RequestContext.get().getAccountId(), allEntryBFRows, tableDefine.getTableId(), targetEntryIds);
    }

    public List<CtBFRow> loadLinkRowUpNodes(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        boolean isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean searchEntry = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_search_entry", BOOLEAN_FALSE));
        List<Object> myEntryBFRows = new ArrayList(16);
        myEntryBFRows = isDirtLink ? this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, searchEntry) : this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, searchEntry);
        this.setTableInfo(myEntryBFRows);
        return myEntryBFRows;
    }

    public Map<Long, CtBFRowLinkUpNode> loadBillLinkUpNodes(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtSource) {
        List<CtBFRow> allRows = this.loadBillLinkUp(tTenantCode, tAccountId, entityNumber, billIds, onlyDirtSource);
        return this.getLinkTreeBuilder().buildBillLinkUpNodes(tTenantCode, tAccountId, entityNumber, billIds, allRows);
    }

    public List<CtBFRow> loadBillLinkUpRows(String tTenantCode, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        ArrayList<Long> billIdList = new ArrayList<Long>(Arrays.asList(billIds));
        CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
        ctLkUpQueryArgs.settTenantCode(tTenantCode);
        ctLkUpQueryArgs.settAccountId(tAccountId);
        ctLkUpQueryArgs.settEntityKey(entityNumber);
        ctLkUpQueryArgs.settBillIds(billIdList);
        List<CtBillLk> ctBillLks = CtBillLinkService.getCtDirtBillLkUp(ctLkUpQueryArgs);
        HashMap<String, List<Long>> billIdMap = new HashMap<String, List<Long>>(16);
        billIdMap.put(entityNumber, billIdList);
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>(10);
        for (CtBillLk ctBillLk : ctBillLks) {
            List<Long> ids;
            if (!billIdMap.containsKey(ctBillLk.getsEntityKey())) {
                ids = new ArrayList<Long>(16);
                ids.add(ctBillLk.getSBillId());
                billIdMap.put(ctBillLk.getsEntityKey(), ids);
            } else {
                ids = (List)billIdMap.get(ctBillLk.getsEntityKey());
                if (!ids.contains(ctBillLk.getSBillId())) {
                    ids.add(ctBillLk.getSBillId());
                    billIdMap.put(ctBillLk.getsEntityKey(), ids);
                }
            }
            CtBFRowId sRowId = new CtBFRowId(tTenantCode, tAccountId, ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (sRowId.getTenantId().equals(RequestContext.get().getTenantId()) && sRowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRowId rowId = new CtBFRowId(tTenantCode, tAccountId, ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (rowId.getTenantId().equals(RequestContext.get().getTenantId()) && rowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBotpBFRows.add(bfRow);
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        for (Map.Entry entry : billIdMap.entrySet()) {
            List ids;
            String entityKey = (String)entry.getKey();
            List<CtBFRow> rows = this.loadBillLinkUp(tTenantCode, tAccountId, entityKey, (ids = (List)entry.getValue()).toArray(new Long[0]), onlyDirtTarget);
            if (!CollectionUtils.isNotEmpty(rows)) continue;
            allRows.addAll(rows);
        }
        return allRows;
    }

    private Map<CtBFEntryTable, CtBillEntryInfo> doCtUpEntryLk(Map<CtBFEntryTable, CtBillEntryInfo> ctBillEntryInfoMap, List<CtBFRow> ctBotpBFRows) {
        ArrayList<CtBFRow> ctBFRows = new ArrayList<CtBFRow>();
        if (MapUtils.isNotEmpty(ctBillEntryInfoMap)) {
            for (Map.Entry<CtBFEntryTable, CtBillEntryInfo> entry : ctBillEntryInfoMap.entrySet()) {
                CtBFEntryTable ctBFTable = entry.getKey();
                CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
                ctLkUpQueryArgs.settTenantCode(ctBFTable.getTenantId());
                ctLkUpQueryArgs.settAccountId(ctBFTable.getAccountId());
                ctLkUpQueryArgs.settEntityKey(ctBFTable.getMainEntityKey());
                ctLkUpQueryArgs.settBillIds(entry.getValue().getBillIds());
                List<CtBFRow> ctBFs = CtBillLinkService.getCtDirtRowBillLkUp(ctLkUpQueryArgs);
                if (!CollectionUtils.isNotEmpty(ctBFs)) continue;
                for (CtBFRow ctBFRow : ctBFs) {
                    if (!ctBFRow.getId().getEntityKey().equals(entry.getKey().getEntryKey()) || !entry.getValue().getEntryIds().contains(ctBFRow.getId().getEntryId())) continue;
                    ctBFRows.add(ctBFRow);
                }
            }
        }
        HashMap<CtBFEntryTable, CtBillEntryInfo> tableIds = new HashMap<CtBFEntryTable, CtBillEntryInfo>();
        for (CtBFRow ctBFRow : ctBFRows) {
            CtBillEntryInfo ctBillEntryInfo;
            CtBFEntryTable ctBFTable = new CtBFEntryTable(ctBFRow.getSId().getTenantId(), ctBFRow.getSId().getAccountId(), ctBFRow.getSId().getMainEntityKey(), ctBFRow.getSId().getEntityKey());
            if (tableIds.containsKey(ctBFTable)) {
                ctBillEntryInfo = (CtBillEntryInfo)tableIds.get(ctBFTable);
                ctBillEntryInfo.getBillIds().add(ctBFRow.getSId().getBillId());
                ctBillEntryInfo.getEntryIds().add(ctBFRow.getSId().getEntryId());
            } else {
                ctBillEntryInfo = new CtBillEntryInfo();
                ctBillEntryInfo.getBillIds().add(ctBFRow.getSId().getBillId());
                ctBillEntryInfo.getEntryIds().add(ctBFRow.getSId().getEntryId());
                tableIds.put(ctBFTable, ctBillEntryInfo);
            }
            ctBotpBFRows.add(ctBFRow);
        }
        if (MapUtils.isNotEmpty(tableIds)) {
            this.doCtUpEntryLk(tableIds, ctBotpBFRows);
        }
        return tableIds;
    }

    private List<CtBFRow> getCtUpEntryLkDirt(CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs) {
        ArrayList<CtBFRow> ctBFRows = new ArrayList<CtBFRow>(10);
        CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
        ctLkUpQueryArgs.settTenantCode(ctEntryLkUpQueryArgs.gettTenantCode());
        ctLkUpQueryArgs.settAccountId(ctEntryLkUpQueryArgs.gettAccountId());
        ctLkUpQueryArgs.settEntityKey(ctEntryLkUpQueryArgs.gettMainEntityKey());
        ctLkUpQueryArgs.settBillIds(ctEntryLkUpQueryArgs.gettBillIds());
        List<CtBFRow> ctBFRowList = CtBillLinkService.getCtDirtRowBillLkUp(ctLkUpQueryArgs);
        if (CollectionUtils.isNotEmpty(ctBFRowList)) {
            for (CtBFRow ctBFRow : ctBFRowList) {
                if (!ctBFRow.getId().getEntityKey().equals(ctEntryLkUpQueryArgs.gettEntryKey()) || !ctEntryLkUpQueryArgs.gettEntryIds().contains(ctBFRow.getId().getEntryId())) continue;
                ctBFRows.add(ctBFRow);
            }
        }
        return ctBFRows;
    }

    public List<CtBFRow> loadCtEntryLinkUpRows(CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>();
        CtBFEntryTable ctBFEntryTable = new CtBFEntryTable(ctEntryLkUpQueryArgs.gettTenantCode(), ctEntryLkUpQueryArgs.gettAccountId(), ctEntryLkUpQueryArgs.gettMainEntityKey(), ctEntryLkUpQueryArgs.gettEntryKey());
        CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkUpQueryArgs.gettMainEntityKey(), ctEntryLkUpQueryArgs.gettEntryKey(), ctEntryLkUpQueryArgs.gettBillIds(), ctEntryLkUpQueryArgs.gettEntryIds());
        HashMap<CtBFEntryTable, CtBillEntryInfo> tableIds = new HashMap<CtBFEntryTable, CtBillEntryInfo>();
        tableIds.put(ctBFEntryTable, ctBillEntryInfo);
        Map<String, Map<String, CtBillEntryInfo>> ctBillEntryMap = this.getUpBillIdMap(ctEntryLkUpQueryArgs);
        int i = 0;
        while (tableIds.size() > 0) {
            this.doCtUpEntryLk(tableIds, ctBotpBFRows);
            Map<String, Map<String, CtBillEntryInfo>> billIdMap = this.getUpBillIdMap(allRows, ctBotpBFRows);
            if (i == 0) {
                billIdMap.putAll(ctBillEntryMap);
            }
            tableIds.clear();
            for (Map.Entry<String, Map<String, CtBillEntryInfo>> entry : billIdMap.entrySet()) {
                String mainEntityKey = entry.getKey();
                Map<String, CtBillEntryInfo> ctBillEntryInfoMap = entry.getValue();
                for (Map.Entry<String, CtBillEntryInfo> ctBillEntryInfoEntry : ctBillEntryInfoMap.entrySet()) {
                    CtBillEntryInfo ctBill;
                    String entryKey = ctBillEntryInfoEntry.getKey();
                    List<CtBFRow> rows = this.loadLinkRowUpNodes(mainEntityKey, entryKey, (ctBill = ctBillEntryInfoEntry.getValue()).getBillIds().toArray(new Long[0]), ctBill.getEntryIds().toArray(new Long[0]), null);
                    if (CollectionUtils.isNotEmpty(rows)) {
                        allRows.addAll(rows);
                    }
                    for (CtBFRow ctBFRow : rows) {
                        CtBillEntryInfo ctBillInfo;
                        CtBFRowId sid = ctBFRow.getSId();
                        CtBFEntryTable ctBFEntryTab = new CtBFEntryTable(sid.getTenantId(), sid.getAccountId(), sid.getMainEntityKey(), sid.getEntityKey());
                        if (tableIds.containsKey(ctBFEntryTab)) {
                            ctBillInfo = (CtBillEntryInfo)tableIds.get(ctBFEntryTab);
                            ctBillInfo.getBillIds().add(sid.getBillId());
                            ctBillInfo.getEntryIds().add(sid.getEntryId());
                            continue;
                        }
                        ctBillInfo = new CtBillEntryInfo();
                        ctBillInfo.setMainEntityKey(sid.getMainEntityKey());
                        ctBillInfo.setEntryKey(sid.getEntityKey());
                        ctBillInfo.getBillIds().add(sid.getBillId());
                        ctBillInfo.getEntryIds().add(sid.getEntryId());
                        tableIds.put(ctBFEntryTab, ctBillInfo);
                    }
                }
            }
            ctBotpBFRows.clear();
            ++i;
        }
        return allRows;
    }

    public List<CtBFRow> loadCtEntryLinkUpDirt(CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        List<CtBFRow> ctBFRows = this.getCtUpEntryLkDirt(ctEntryLkUpQueryArgs);
        if (CollectionUtils.isNotEmpty(ctBFRows)) {
            allRows.addAll(ctBFRows);
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("botp_track_only_dirt_link", BOOLEAN_TRUE);
        List<CtBFRow> rows = this.loadLinkRowUpNodes(ctEntryLkUpQueryArgs.gettMainEntityKey(), ctEntryLkUpQueryArgs.gettEntryKey(), ctEntryLkUpQueryArgs.gettBillIds().toArray(new Long[0]), ctEntryLkUpQueryArgs.gettEntryIds().toArray(new Long[0]), operateOption);
        if (CollectionUtils.isNotEmpty(rows)) {
            allRows.addAll(rows);
        }
        return allRows;
    }

    private Map<String, Map<String, CtBillEntryInfo>> getUpBillIdMap(CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs) {
        HashMap<String, Map<String, CtBillEntryInfo>> currTenantBillIdMap = new HashMap<String, Map<String, CtBillEntryInfo>>();
        if (ctEntryLkUpQueryArgs.gettTenantCode().equals(RequestContext.get().getTenantId()) && ctEntryLkUpQueryArgs.gettAccountId().equals(RequestContext.get().getAccountId())) {
            this.collectUpcurrTenantBill(currTenantBillIdMap, ctEntryLkUpQueryArgs);
        }
        return currTenantBillIdMap;
    }

    private Map<String, Map<String, CtBillEntryInfo>> getUpBillIdMap(List<CtBFRow> allRows, List<CtBFRow> ctBotpBFRows) {
        HashMap<String, Map<String, CtBillEntryInfo>> currTenantBillIdMap = new HashMap<String, Map<String, CtBillEntryInfo>>();
        for (CtBFRow ctBFRow : ctBotpBFRows) {
            if (ctBFRow.getSId().getTenantId().equals(RequestContext.get().getTenantId()) && ctBFRow.getSId().getAccountId().equals(RequestContext.get().getAccountId())) {
                this.collectTenantBill(currTenantBillIdMap, ctBFRow.getSId());
            }
            if (!ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            this.collectTenantBill(currTenantBillIdMap, ctBFRow.getId());
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        return currTenantBillIdMap;
    }

    @Deprecated
    public List<CtBFRowLinkDownNode> loadLinkDownNodes(String srcEntityNumber, String srcEntryKey, Long[] srcEntryIds) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<CtBFRowLinkDownNode>();
        }
        List<Object> allEntryBFRows = new ArrayList(0);
        if (StringUtils.isBlank((CharSequence)srcEntryKey)) {
            allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcEntryIds, null);
        } else {
            HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(srcEntityNumber, srcEntryKey, srcEntryIds);
            allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcEntryKey, myBillIds.toArray(new Long[0]), srcEntryIds, null);
        }
        return this.getLinkTreeBuilder().buildLinkDownNodes(srcEntityNumber, srcEntryKey, srcEntryIds, allEntryBFRows);
    }

    @Deprecated
    public List<CtBFRowLinkDownNode> loadDirtLinkDownNodes(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new ArrayList<CtBFRowLinkDownNode>();
        }
        List<Object> allEntryBFRows = new ArrayList(0);
        if (StringUtils.isBlank((CharSequence)entryKey)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("botp_track_only_dirt_link", BOOLEAN_TRUE);
            allEntryBFRows = this.loadTargetRowIds(entityNumber, entryIds, option);
        } else {
            HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(entityNumber, entryKey, entryIds);
            OperateOption option = OperateOption.create();
            option.setVariableValue("botp_track_only_dirt_link", BOOLEAN_TRUE);
            allEntryBFRows = this.loadTargetRowIds(entityNumber, entryKey, myBillIds.toArray(new Long[0]), entryIds, option);
        }
        return this.getLinkTreeBuilder().buildLinkDownNodes(entityNumber, entryKey, entryIds, allEntryBFRows);
    }

    public List<CtBFRowLinkDownNode> loadLinkDownNodes(String srcEntityNumber, Long[] srcBillIds, OperateOption option) {
        boolean onlyBillLink;
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<CtBFRowLinkDownNode>(0);
        }
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean bl = onlyBillLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_bill_link", BOOLEAN_FALSE));
        if (onlyBillLink) {
            Map<Long, CtBFRowLinkDownNode> map = this.loadBillLinkDownNodes("", "", srcEntityNumber, srcBillIds, onlyDirtLink);
            return new ArrayList<CtBFRowLinkDownNode>(map.values());
        }
        List<CtBFRow> allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcBillIds, option);
        return this.getLinkTreeBuilder().buildLinkDownNodes(srcEntityNumber, "", srcBillIds, allEntryBFRows);
    }

    public List<CtBFRowLinkDownNode> loadLinkDownNodes(String srcEntityNumber, String srcEntryKey, Long[] srcBillIds, Long[] srcEntryIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<CtBFRowLinkDownNode>(0);
        }
        List<CtBFRow> allEntryBFRows = this.loadTargetRowIds(srcEntityNumber, srcEntryKey, srcBillIds, srcEntryIds, option);
        return this.getLinkTreeBuilder().buildLinkDownNodes(srcEntityNumber, srcEntryKey, srcEntryIds, allEntryBFRows);
    }

    public List<CtBFRow> loadBillLinkDownRows(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        ArrayList<Long> billIdList = new ArrayList<Long>(Arrays.asList(billIds));
        CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
        ctLkDownQueryArgs.setsTenantCode(sTenantCode);
        ctLkDownQueryArgs.setsAccountId(sAccountId);
        ctLkDownQueryArgs.setsEntityKey(entityNumber);
        ctLkDownQueryArgs.setsBillIds(billIdList);
        List<CtBillLk> ctBillLks = CtBillLinkService.getCtDirtBillLkDown(ctLkDownQueryArgs);
        List tIds = ctBillLks.stream().map(a -> a.getTBillId()).collect(Collectors.toList());
        HashMap<String, List<Object>> billIdMap = new HashMap<String, List<Object>>(16);
        billIdMap.put(entityNumber, tIds);
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>(10);
        for (CtBillLk ctBillLk : ctBillLks) {
            List<Long> ids;
            if (!billIdMap.containsKey(ctBillLk.gettEntityKey())) {
                ids = new ArrayList<Long>(16);
                ids.add(ctBillLk.getSBillId());
                billIdMap.put(ctBillLk.getsEntityKey(), ids);
            } else {
                ids = (List)billIdMap.get(ctBillLk.getsEntityKey());
                if (!ids.contains(ctBillLk.getSBillId())) {
                    ids.add(ctBillLk.getSBillId());
                    billIdMap.put(ctBillLk.getsEntityKey(), ids);
                }
            }
            CtBFRowId sRowId = new CtBFRowId(sTenantCode, sAccountId, ctBillLk.getSTableId(), ctBillLk.getSBillId(), ctBillLk.getSTableId(), ctBillLk.getSBillId());
            sRowId.setMainEntityKey(ctBillLk.getsEntityKey());
            if (sRowId.getTenantId().equals(RequestContext.get().getTenantId()) && sRowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                sRowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.getsEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRowId rowId = new CtBFRowId(sTenantCode, sAccountId, ctBillLk.getTTableId(), ctBillLk.getTBillId(), ctBillLk.getTTableId(), ctBillLk.getTBillId());
            rowId.setMainEntityKey(ctBillLk.gettEntityKey());
            if (rowId.getTenantId().equals(RequestContext.get().getTenantId()) && rowId.getAccountId().equals(RequestContext.get().getAccountId())) {
                rowId.setMainEntityName(EntityMetadataCache.getDataEntityType((String)ctBillLk.gettEntityKey()).getDisplayName().getLocaleValue());
            }
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBotpBFRows.add(bfRow);
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        for (Map.Entry entry : billIdMap.entrySet()) {
            List ids;
            String entityKey = (String)entry.getKey();
            List<CtBFRow> rows = this.loadBillLinkDown(sTenantCode, sAccountId, entityKey, (ids = (List)entry.getValue()).toArray(new Long[0]), onlyDirtTarget);
            if (!CollectionUtils.isNotEmpty(rows)) continue;
            allRows.addAll(rows);
        }
        return allRows;
    }

    public List<CtBFRow> getTenantDirtEntryLkDown(CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs) {
        ArrayList<CtBFRow> ctBFRows = new ArrayList<CtBFRow>(16);
        CtLkDownQueryArgs args = new CtLkDownQueryArgs();
        args.setsTenantCode(ctEntryLkDownQueryArgs.getsTenantCode());
        args.setsAccountId(ctEntryLkDownQueryArgs.getsAccountId());
        args.setsEntityKey(ctEntryLkDownQueryArgs.getsMainEntityKey());
        args.setsBillIds(ctEntryLkDownQueryArgs.getsBillIds());
        List<CtBFRow> ctBFRowList = CtBillLinkService.getCtDirtLkRowForCurrTenant(args);
        if (CollectionUtils.isNotEmpty(ctBFRowList)) {
            for (CtBFRow ctBFRow : ctBFRowList) {
                if (!ctBFRow.getSId().getEntityKey().equals(ctEntryLkDownQueryArgs.getsEntryKey()) || !ctEntryLkDownQueryArgs.getsEntryIds().contains(ctBFRow.getSId().getEntryId())) continue;
                ctBFRows.add(ctBFRow);
            }
        }
        return ctBFRows;
    }

    private Map<CtBFEntryTable, CtBillEntryInfo> doCtBillLk(Map<CtBFEntryTable, CtBillEntryInfo> ctBillEntryInfoMap, List<CtBFRow> ctBotpBFRows) {
        ArrayList<CtBFRow> ctBFRows = new ArrayList<CtBFRow>();
        if (MapUtils.isNotEmpty(ctBillEntryInfoMap)) {
            for (Map.Entry<CtBFEntryTable, CtBillEntryInfo> entry : ctBillEntryInfoMap.entrySet()) {
                CtBFEntryTable ctBFTable = entry.getKey();
                CtLkDownQueryArgs args = new CtLkDownQueryArgs();
                args.setsTenantCode(ctBFTable.getTenantId());
                args.setsAccountId(ctBFTable.getAccountId());
                args.setsEntityKey(ctBFTable.getMainEntityKey());
                args.setsBillIds(entry.getValue().getBillIds());
                List<CtBFRow> ctDirtBillLkDown = CtBillLinkService.getCtDirtLkRowForCurrTenant(args);
                if (!CollectionUtils.isNotEmpty(ctDirtBillLkDown)) continue;
                for (CtBFRow ctBFRow : ctDirtBillLkDown) {
                    if (!ctBFRow.getSId().getEntityKey().equals(entry.getKey().getEntryKey()) || !entry.getValue().getEntryIds().contains(ctBFRow.getSId().getEntryId())) continue;
                    ctBFRows.add(ctBFRow);
                }
            }
        }
        HashMap<CtBFEntryTable, CtBillEntryInfo> tableIds = new HashMap<CtBFEntryTable, CtBillEntryInfo>();
        for (CtBFRow ctBFRow : ctBFRows) {
            CtBillEntryInfo ctBillEntryInfo;
            CtBFEntryTable ctBFTable = new CtBFEntryTable(ctBFRow.getId().getTenantId(), ctBFRow.getId().getAccountId(), ctBFRow.getId().getMainEntityKey(), ctBFRow.getId().getEntityKey());
            if (tableIds.containsKey(ctBFTable)) {
                ctBillEntryInfo = (CtBillEntryInfo)tableIds.get(ctBFTable);
                ctBillEntryInfo.getBillIds().add(ctBFRow.getId().getBillId());
                ctBillEntryInfo.getEntryIds().add(ctBFRow.getId().getEntryId());
            } else {
                ctBillEntryInfo = new CtBillEntryInfo();
                ctBillEntryInfo.getBillIds().add(ctBFRow.getId().getBillId());
                ctBillEntryInfo.getEntryIds().add(ctBFRow.getId().getEntryId());
                tableIds.put(ctBFTable, ctBillEntryInfo);
            }
            ctBotpBFRows.add(ctBFRow);
        }
        if (MapUtils.isNotEmpty(tableIds)) {
            this.doCtBillLk(tableIds, ctBotpBFRows);
        }
        return tableIds;
    }

    public List<CtBFRow> loadCtEntryLinkDownRows(CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>();
        CtBFEntryTable ctBFEntryTable = new CtBFEntryTable(ctEntryLkDownQueryArgs.getsTenantCode(), ctEntryLkDownQueryArgs.getsAccountId(), ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsEntryKey());
        CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsEntryKey(), ctEntryLkDownQueryArgs.getsBillIds(), ctEntryLkDownQueryArgs.getsEntryIds());
        HashMap<CtBFEntryTable, CtBillEntryInfo> tableIds = new HashMap<CtBFEntryTable, CtBillEntryInfo>();
        tableIds.put(ctBFEntryTable, ctBillEntryInfo);
        Map<String, Map<String, CtBillEntryInfo>> ctBillEntryMap = this.getDownBillIdMap(ctEntryLkDownQueryArgs);
        int i = 0;
        while (tableIds.size() > 0) {
            this.doCtBillLk(tableIds, ctBotpBFRows);
            Map<String, Map<String, CtBillEntryInfo>> currTenantBillIdMap = this.getDownBillIdMap(allRows, ctBotpBFRows);
            if (i == 0) {
                currTenantBillIdMap.putAll(ctBillEntryMap);
            }
            tableIds.clear();
            for (Map.Entry<String, Map<String, CtBillEntryInfo>> entry : currTenantBillIdMap.entrySet()) {
                String mainEntityKey = entry.getKey();
                Map<String, CtBillEntryInfo> ctBillEntryInfoMap = entry.getValue();
                for (Map.Entry<String, CtBillEntryInfo> ctBillEntryInfoEntry : ctBillEntryInfoMap.entrySet()) {
                    CtBillEntryInfo ctBill;
                    String entryKey = ctBillEntryInfoEntry.getKey();
                    List<CtBFRow> rows = this.loadTargetRowIds(mainEntityKey, entryKey, (ctBill = ctBillEntryInfoEntry.getValue()).getBillIds().toArray(new Long[0]), ctBill.getEntryIds().toArray(new Long[0]), null);
                    if (CollectionUtils.isNotEmpty(rows)) {
                        allRows.addAll(rows);
                    }
                    for (CtBFRow ctBFRow : rows) {
                        CtBillEntryInfo ctBillInfo;
                        CtBFRowId id = ctBFRow.getId();
                        CtBFEntryTable ctBFEntryTab = new CtBFEntryTable(id.getTenantId(), id.getAccountId(), id.getMainEntityKey(), id.getEntityKey());
                        if (tableIds.containsKey(ctBFEntryTab)) {
                            ctBillInfo = (CtBillEntryInfo)tableIds.get(ctBFEntryTab);
                            ctBillInfo.getBillIds().add(id.getBillId());
                            ctBillInfo.getEntryIds().add(id.getEntryId());
                            continue;
                        }
                        ctBillInfo = new CtBillEntryInfo();
                        ctBillInfo.setMainEntityKey(id.getMainEntityKey());
                        ctBillInfo.getBillIds().add(id.getBillId());
                        ctBillInfo.getEntryIds().add(id.getEntryId());
                        tableIds.put(ctBFEntryTab, ctBillInfo);
                    }
                }
            }
            ctBotpBFRows.clear();
            ++i;
        }
        return allRows;
    }

    private Map<String, Map<String, CtBillEntryInfo>> getDownBillIdMap(List<CtBFRow> allRows, List<CtBFRow> ctBotpBFRows) {
        HashMap<String, Map<String, CtBillEntryInfo>> currTenantBillIdMap = new HashMap<String, Map<String, CtBillEntryInfo>>();
        for (CtBFRow ctBFRow : ctBotpBFRows) {
            if (ctBFRow.getSId().getTenantId().equals(RequestContext.get().getTenantId()) && ctBFRow.getSId().getAccountId().equals(RequestContext.get().getAccountId())) {
                this.collectTenantBill(currTenantBillIdMap, ctBFRow.getSId());
            }
            if (!ctBFRow.getId().getTenantId().equals(RequestContext.get().getTenantId()) || !ctBFRow.getId().getAccountId().equals(RequestContext.get().getAccountId())) continue;
            this.collectTenantBill(currTenantBillIdMap, ctBFRow.getId());
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        return currTenantBillIdMap;
    }

    private Map<String, Map<String, CtBillEntryInfo>> getDownBillIdMap(CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs) {
        HashMap<String, Map<String, CtBillEntryInfo>> currTenantBillIdMap = new HashMap<String, Map<String, CtBillEntryInfo>>();
        if (ctEntryLkDownQueryArgs.getsTenantCode().equals(RequestContext.get().getTenantId()) && ctEntryLkDownQueryArgs.getsAccountId().equals(RequestContext.get().getAccountId())) {
            this.collectcurrTenantBill(currTenantBillIdMap, ctEntryLkDownQueryArgs);
        }
        return currTenantBillIdMap;
    }

    private void collectcurrTenantBill(Map<String, Map<String, CtBillEntryInfo>> currTenantBillIdMap, CtEntryLkDownQueryArgs ctEntryLkDownQueryArgs) {
        if (currTenantBillIdMap.containsKey(ctEntryLkDownQueryArgs.getsMainEntityKey())) {
            Map<String, CtBillEntryInfo> ctBillEntryInfoMap = currTenantBillIdMap.get(ctEntryLkDownQueryArgs.getsMainEntityKey());
            if (ctBillEntryInfoMap.containsKey(ctEntryLkDownQueryArgs.getsEntryKey())) {
                CtBillEntryInfo ctBillEntryInfo = ctBillEntryInfoMap.get(ctEntryLkDownQueryArgs.getsEntryKey());
                ctBillEntryInfo.getBillIds().addAll(ctEntryLkDownQueryArgs.getsBillIds());
                ctBillEntryInfo.getEntryIds().addAll(ctEntryLkDownQueryArgs.getsEntryIds());
            } else {
                CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsEntryKey(), ctEntryLkDownQueryArgs.getsBillIds(), ctEntryLkDownQueryArgs.getsEntryIds());
                ctBillEntryInfoMap.put(ctEntryLkDownQueryArgs.getsEntryKey(), ctBillEntryInfo);
            }
        } else {
            CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkDownQueryArgs.getsMainEntityKey(), ctEntryLkDownQueryArgs.getsEntryKey(), ctEntryLkDownQueryArgs.getsBillIds(), ctEntryLkDownQueryArgs.getsEntryIds());
            HashMap<String, CtBillEntryInfo> ctBillEntryInfoMap = new HashMap<String, CtBillEntryInfo>();
            ctBillEntryInfoMap.put(ctEntryLkDownQueryArgs.getsEntryKey(), ctBillEntryInfo);
            currTenantBillIdMap.putIfAbsent(ctEntryLkDownQueryArgs.getsMainEntityKey(), ctBillEntryInfoMap);
        }
    }

    private void collectUpcurrTenantBill(Map<String, Map<String, CtBillEntryInfo>> currTenantBillIdMap, CtEntryLkUpQueryArgs ctEntryLkUpQueryArgs) {
        if (currTenantBillIdMap.containsKey(ctEntryLkUpQueryArgs.gettMainEntityKey())) {
            Map<String, CtBillEntryInfo> ctBillEntryInfoMap = currTenantBillIdMap.get(ctEntryLkUpQueryArgs.gettMainEntityKey());
            if (ctBillEntryInfoMap.containsKey(ctEntryLkUpQueryArgs.gettMainEntityKey())) {
                CtBillEntryInfo ctBillEntryInfo = ctBillEntryInfoMap.get(ctEntryLkUpQueryArgs.gettEntryKey());
                ctBillEntryInfo.getBillIds().addAll(ctEntryLkUpQueryArgs.gettBillIds());
                ctBillEntryInfo.getEntryIds().addAll(ctEntryLkUpQueryArgs.gettEntryIds());
            } else {
                CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkUpQueryArgs.gettMainEntityKey(), ctEntryLkUpQueryArgs.gettEntryKey(), ctEntryLkUpQueryArgs.gettBillIds(), ctEntryLkUpQueryArgs.gettEntryIds());
                ctBillEntryInfoMap.put(ctEntryLkUpQueryArgs.gettEntryKey(), ctBillEntryInfo);
            }
        } else {
            CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo(ctEntryLkUpQueryArgs.gettMainEntityKey(), ctEntryLkUpQueryArgs.gettEntryKey(), ctEntryLkUpQueryArgs.gettBillIds(), ctEntryLkUpQueryArgs.gettEntryIds());
            HashMap<String, CtBillEntryInfo> ctBillEntryInfoMap = new HashMap<String, CtBillEntryInfo>();
            ctBillEntryInfoMap.put(ctEntryLkUpQueryArgs.gettEntryKey(), ctBillEntryInfo);
            currTenantBillIdMap.putIfAbsent(ctEntryLkUpQueryArgs.gettMainEntityKey(), ctBillEntryInfoMap);
        }
    }

    private void collectTenantBill(Map<String, Map<String, CtBillEntryInfo>> currTenantBillIdMap, CtBFRowId ctBFRowId) {
        if (currTenantBillIdMap.containsKey(ctBFRowId.getMainEntityKey())) {
            Map<String, CtBillEntryInfo> ctBillEntryInfoMap = currTenantBillIdMap.get(ctBFRowId.getMainEntityKey());
            if (ctBillEntryInfoMap.containsKey(ctBFRowId.getEntityKey())) {
                CtBillEntryInfo ctBillEntryInfo = ctBillEntryInfoMap.get(ctBFRowId.getEntityKey());
                ctBillEntryInfo.getBillIds().add(ctBFRowId.getBillId());
                ctBillEntryInfo.getEntryIds().add(ctBFRowId.getEntryId());
            } else {
                CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo();
                ctBillEntryInfo.setMainEntityKey(ctBFRowId.getMainEntityKey());
                ctBillEntryInfo.setEntryKey(ctBFRowId.getEntityKey());
                ctBillEntryInfo.getBillIds().add(ctBFRowId.getBillId());
                ctBillEntryInfo.getEntryIds().add(ctBFRowId.getEntryId());
                ctBillEntryInfoMap.put(ctBFRowId.getEntityKey(), ctBillEntryInfo);
            }
        } else {
            CtBillEntryInfo ctBillEntryInfo = new CtBillEntryInfo();
            ctBillEntryInfo.setMainEntityKey(ctBFRowId.getMainEntityKey());
            ctBillEntryInfo.setEntryKey(ctBFRowId.getEntityKey());
            ctBillEntryInfo.getBillIds().add(ctBFRowId.getBillId());
            ctBillEntryInfo.getEntryIds().add(ctBFRowId.getEntryId());
            HashMap<String, CtBillEntryInfo> ctBillEntryInfoMap = new HashMap<String, CtBillEntryInfo>();
            ctBillEntryInfoMap.put(ctBFRowId.getEntityKey(), ctBillEntryInfo);
            currTenantBillIdMap.putIfAbsent(ctBFRowId.getMainEntityKey(), ctBillEntryInfoMap);
        }
    }

    public Map<Long, CtBFRowLinkDownNode> loadBillLinkDownNodes(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        ArrayList<CtBFRow> allRows = new ArrayList<CtBFRow>(16);
        CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
        ctLkDownQueryArgs.setsTenantCode(sTenantCode);
        ctLkDownQueryArgs.setsAccountId(sAccountId);
        ctLkDownQueryArgs.setsEntityKey(entityNumber);
        ctLkDownQueryArgs.setsBillIds(Arrays.asList(billIds));
        List<CtBillLk> ctBillLks = CtBillLinkService.getCtDirtBillLkDown(ctLkDownQueryArgs);
        HashMap billIdMap = new HashMap(16);
        billIdMap.put(entityNumber, Arrays.asList(billIds));
        ArrayList<CtBFRow> ctBotpBFRows = new ArrayList<CtBFRow>(10);
        HashMap<String, Long> tableIdMap = new HashMap<String, Long>(16);
        CtConvertDataService reader = new CtConvertDataService();
        for (CtBillLk ctBillLk : ctBillLks) {
            List<Long> ids;
            if (tableIdMap.containsKey(ctBillLk.getsEntityKey())) {
                TableDefine sTableDefine = reader.loadTableDefine(ctBillLk.getsEntityKey(), ctBillLk.getsEntityKey());
                tableIdMap.put(ctBillLk.getsEntityKey(), sTableDefine.getTableId());
            }
            if (!tableIdMap.containsKey(ctBillLk.gettEntityKey())) {
                TableDefine tTableDefine = reader.loadTableDefine(ctBillLk.gettEntityKey(), ctBillLk.gettEntityKey());
                tableIdMap.put(ctBillLk.gettEntityKey(), tTableDefine.getTableId());
            }
            if (!billIdMap.containsKey(ctBillLk.getsEntityKey())) {
                ids = new ArrayList<Long>(16);
                ids.add(ctBillLk.getSBillId());
                billIdMap.put(ctBillLk.getsEntityKey(), ids);
            } else {
                ids = (List)billIdMap.get(ctBillLk.getsEntityKey());
                ids.add(ctBillLk.getSBillId());
                billIdMap.put(ctBillLk.getsEntityKey(), ids);
            }
            CtBFRowId sRowId = new CtBFRowId(sTenantCode, sAccountId, (Long)tableIdMap.get(ctBillLk.getsEntityKey()), ctBillLk.getSBillId(), (Long)tableIdMap.get(ctBillLk.getsEntityKey()), ctBillLk.getSBillId());
            CtBFRowId rowId = new CtBFRowId(sTenantCode, sAccountId, (Long)tableIdMap.get(ctBillLk.gettEntityKey()), ctBillLk.getTBillId(), (Long)tableIdMap.get(ctBillLk.gettEntityKey()), ctBillLk.getTBillId());
            CtBFRow bfRow = new CtBFRow();
            bfRow.setSId(sRowId);
            bfRow.setId(rowId);
            ctBotpBFRows.add(bfRow);
        }
        if (CollectionUtils.isNotEmpty(ctBotpBFRows)) {
            allRows.addAll(ctBotpBFRows);
        }
        for (Map.Entry entry : billIdMap.entrySet()) {
            List ids;
            String entityKey = (String)entry.getKey();
            List<CtBFRow> rows = this.loadBillLinkDown(sTenantCode, sAccountId, entityKey, (ids = (List)entry.getValue()).toArray(new Long[0]), onlyDirtTarget);
            if (!CollectionUtils.isNotEmpty(rows)) continue;
            allRows.addAll(rows);
        }
        HashMap<Long, List<Long>> ctBfRowMap = new HashMap<Long, List<Long>>();
        for (CtBFRow ctBFRow : allRows) {
            List<Long> idList;
            if (ctBfRowMap.containsKey(ctBFRow.getId().getMainTableId())) {
                idList = (List)ctBfRowMap.get(ctBFRow.getId().getMainTableId());
                idList.add(ctBFRow.getId().getBillId());
                ctBfRowMap.put(ctBFRow.getId().getMainTableId(), idList);
            } else {
                idList = new ArrayList<Long>();
                idList.add(ctBFRow.getId().getBillId());
                ctBfRowMap.put(ctBFRow.getId().getMainTableId(), idList);
            }
            if (ctBfRowMap.containsKey(ctBFRow.getSId().getMainTableId())) {
                idList = (List)ctBfRowMap.get(ctBFRow.getSId().getMainTableId());
                idList.add(ctBFRow.getSId().getBillId());
                ctBfRowMap.put(ctBFRow.getSId().getMainTableId(), idList);
                continue;
            }
            idList = new ArrayList();
            idList.add(ctBFRow.getSId().getBillId());
            ctBfRowMap.put(ctBFRow.getSId().getMainTableId(), idList);
        }
        return this.getLinkTreeBuilder().buildBillLinkDownNodes("", "", entityNumber, billIds, allRows);
    }

    @Deprecated
    public List<CtBFRow> loadSourceRowIds(String targetEntityNumber, String targetEntryKey, Long[] targetEntryIds) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetEntryIds, false);
        ArrayList<CtBFRowId> srcBFRowIds = new ArrayList<CtBFRowId>(16);
        for (CtBFRow row : myEntryBFRows) {
            srcBFRowIds.add(row.getSId());
        }
        List<CtBFRow> srcEntryBFRows = this.loadSourceRowIds(srcBFRowIds);
        ArrayList<CtBFRow> allEntryBFRows = new ArrayList<CtBFRow>();
        allEntryBFRows.addAll(myEntryBFRows);
        allEntryBFRows.addAll(srcEntryBFRows);
        return allEntryBFRows;
    }

    public List<CtBFRow> loadSourceRowIds(String targetEntityNumber, Long[] targetBillIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetBillIds == null || targetBillIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        return this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetBillIds, onlyDirtLink);
    }

    public List<CtBFRow> loadSourceRowIds(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds, OperateOption option) {
        boolean isDirtLink;
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        boolean bl = isDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        if (isDirtLink) {
            List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, false);
            return myEntryBFRows;
        }
        List<CtBFRow> allEntryBFRows = this.getEntryTrackReader().readFullUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, false);
        return allEntryBFRows;
    }

    public List<CtBFRow> loadSourceRowIds(List<CtBFRowId> entryRowIds) {
        HashMap allSrcBillIds = new HashMap(entryRowIds.size());
        HashMap srcBillIds = new HashMap(entryRowIds.size());
        for (CtBFRowId entryRowId : entryRowIds) {
            if (!this.getEntryTrackReader().addToMap(allSrcBillIds, entryRowId.getMainTableId(), entryRowId.getBillId())) continue;
            this.getEntryTrackReader().addToMap(srcBillIds, entryRowId.getMainTableId(), entryRowId.getBillId());
        }
        ArrayList<CtBFRow> allEntryBFRows = new ArrayList<CtBFRow>(entryRowIds.size());
        ArrayList<CtBFRow> entryBFRows = new ArrayList<CtBFRow>(entryRowIds.size());
        int count = 0;
        while (srcBillIds.size() > 0 && count < 100) {
            ++count;
            entryBFRows.clear();
            for (Map.Entry entry : srcBillIds.entrySet()) {
                Long targetMainTableId = (Long)entry.getKey();
                Set tergetBillIds = (Set)entry.getValue();
                entryBFRows.addAll(this.getEntryTrackReader().readUpEntryBFRows(targetMainTableId, tergetBillIds.toArray(new Long[0])));
            }
            srcBillIds.clear();
            for (CtBFRow bfRow : entryBFRows) {
                if (!this.getEntryTrackReader().addToMap(allSrcBillIds, bfRow.getSId().getMainTableId(), bfRow.getSId().getBillId())) continue;
                this.getEntryTrackReader().addToMap(srcBillIds, bfRow.getSId().getMainTableId(), bfRow.getSId().getBillId());
            }
            allEntryBFRows.addAll(entryBFRows);
        }
        return allEntryBFRows;
    }

    @Deprecated
    public List<CtBFRow> loadTargetRowIds(String srcEntityNumber, String srcEntryKey, Long[] srcEntryIds) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<CtBFRow>();
        }
        if (StringUtils.isBlank((CharSequence)srcEntryKey)) {
            return this.loadTargetRowIds(srcEntityNumber, srcEntryIds, null);
        }
        HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(srcEntityNumber, srcEntryKey, srcEntryIds);
        return this.loadTargetRowIds(srcEntityNumber, srcEntryKey, myBillIds.toArray(new Long[0]), srcEntryIds, null);
    }

    public List<CtBFRow> loadTargetRowIds(String srcEntityNumber, Long[] srcBillIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<CtBFRow>();
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        return this.getBillTrackReader().readFullDownEntryBFRows(myMainTableId, srcBillIds, onlyDirtLink);
    }

    public List<CtBFRow> loadTargetRowIds(String srcEntityNumber, String srcEntryKey, Long[] srcBillIds, Long[] srcEntryIds, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)srcEntityNumber) || srcEntryIds == null || srcEntryIds.length == 0) {
            return new ArrayList<CtBFRow>();
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        TableDefine entryTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntryKey);
        Long myEntryTableId = entryTableDefine.getTableId();
        HashSet<Long> myEntryIds = new HashSet<Long>(srcEntryIds.length);
        for (Long entryId : srcEntryIds) {
            myEntryIds.add(entryId);
        }
        boolean onlyDirtLink = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_only_dirt_link", BOOLEAN_FALSE));
        boolean searchEntry = option != null && StringUtils.equals((CharSequence)BOOLEAN_TRUE, (CharSequence)option.getVariableValue("botp_track_search_entry", BOOLEAN_FALSE));
        List<CtBFRow> ctBFRows = this.getBillTrackReader().readFullDownEntryBFRows(myMainTableId, myEntryTableId, srcBillIds, myEntryIds, onlyDirtLink, searchEntry);
        this.setTableInfo(ctBFRows);
        return ctBFRows;
    }

    private List<CtBFRow> setTableInfo(List<CtBFRow> ctBFRows) {
        CtConvertDataService reader = new CtConvertDataService();
        HashMap<Long, TableDefine> tableMap = new HashMap<Long, TableDefine>();
        for (CtBFRow ctBFRow : ctBFRows) {
            Long tTableId = ctBFRow.getId().getTableId();
            Long sTableId = ctBFRow.getSId().getTableId();
            TableDefine tTableDefine = null;
            if (tableMap.containsKey(tTableId)) {
                tTableDefine = (TableDefine)tableMap.get(tTableId);
            } else {
                tTableDefine = reader.loadTableDefine(tTableId);
                tableMap.put(tTableId, tTableDefine);
            }
            ctBFRow.getId().setMainEntityKey(tTableDefine.getEntityNumber());
            ctBFRow.getId().setEntityKey(tTableDefine.getEntityKey());
            TableDefine sTableDefine = null;
            if (tableMap.containsKey(sTableId)) {
                sTableDefine = (TableDefine)tableMap.get(sTableId);
            } else {
                sTableDefine = reader.loadTableDefine(sTableId);
                tableMap.put(sTableId, sTableDefine);
            }
            ctBFRow.getSId().setMainEntityKey(sTableDefine.getEntityNumber());
            ctBFRow.getSId().setEntityKey(sTableDefine.getEntityKey());
        }
        return ctBFRows;
    }

    public List<CtBFRow> loadBillLinkUp(String tTenantId, String tAccountId, String entityNumber, Long[] billIds, boolean onlyDirtSource) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        if (onlyDirtSource) {
            Set<CtBFRow> myRows = this.getEntryTrackReader().readUpBillBFRows(tTenantId, tAccountId, entityNumber, billIds);
            return new ArrayList<CtBFRow>(myRows);
        }
        Set<CtBFRow> allRows = this.getEntryTrackReader().readFullUpBillBFRows(tTenantId, tAccountId, entityNumber, billIds);
        return new ArrayList<CtBFRow>(allRows);
    }

    public List<CtBFRow> loadBillLinkDown(String sTenantCode, String sAccountId, String entityNumber, Long[] billIds, boolean onlyDirtTarget) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new ArrayList<CtBFRow>(0);
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long mainTableId = mainTableDefine.getTableId();
        if (onlyDirtTarget) {
            return this.getBillTrackReader().readDownBillBFRows(sTenantCode, sAccountId, mainTableId, billIds);
        }
        return this.getBillTrackReader().readFullDownBillBFRows(sTenantCode, sAccountId, mainTableId, billIds);
    }

    public Map<String, HashSet<Long>> findLinkBills(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<String, HashSet<Long>>();
        }
        Map<String, HashSet<Long>> sourceBills = this.findSourceBills(entityNumber, billIds);
        Map<String, HashSet<Long>> targetBills = this.findTargetBills(entityNumber, billIds);
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        linkBills.putAll(sourceBills);
        linkBills.putAll(targetBills);
        return linkBills;
    }

    public Map<String, HashSet<Long>> findSourceBills(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<String, HashSet<Long>>();
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        HashSet<Long> myBillIds = new HashSet<Long>();
        for (Long billId : billIds) {
            myBillIds.add(billId);
        }
        if (myBillIds.size() == 0) {
            return new LinkedHashMap<String, HashSet<Long>>();
        }
        LinkedHashMap allLinkBills = new LinkedHashMap();
        HashMap<Long, HashSet<Long>> srcBillIds = new HashMap<Long, HashSet<Long>>();
        srcBillIds.put(myMainTableId, myBillIds);
        int count = 0;
        HashSet<CtBFRow> allBillLinkRows = new HashSet<CtBFRow>();
        while (srcBillIds.size() > 0 && count < 100) {
            ++count;
            allBillLinkRows.clear();
            for (Map.Entry entry : srcBillIds.entrySet()) {
                Long targetMainTableId = (Long)entry.getKey();
                Long[] targetBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
                Set<CtBFRow> billLinkRows = this.getEntryTrackReader().readUpBillBFRows("", "", targetMainTableId, targetBillIds);
                allBillLinkRows.addAll(billLinkRows);
            }
            srcBillIds.clear();
            for (CtBFRow billLinkRow : allBillLinkRows) {
                Long sMainTableId = billLinkRow.getSId().getMainTableId();
                Long sBillId = billLinkRow.getSId().getBillId();
                if (!this.getEntryTrackReader().addToMap(allLinkBills, sMainTableId, sBillId)) continue;
                this.getEntryTrackReader().addToMap(srcBillIds, sMainTableId, sBillId);
            }
        }
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        for (Map.Entry item : allLinkBills.entrySet()) {
            Long sMainTableId = (Long)item.getKey();
            TableDefine tableDefine = reader.loadTableDefine(sMainTableId);
            if (tableDefine == null) continue;
            HashSet sBillIds = new HashSet((Collection)item.getValue());
            linkBills.put(tableDefine.getEntityNumber(), sBillIds);
        }
        return linkBills;
    }

    public Map<String, HashSet<Long>> findTargetBills(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || billIds == null || billIds.length == 0) {
            return new HashMap<String, HashSet<Long>>();
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        HashSet<Long> myBillIds = new HashSet<Long>(16);
        for (Long billId : billIds) {
            myBillIds.add(billId);
        }
        if (myBillIds.size() == 0) {
            return new LinkedHashMap<String, HashSet<Long>>();
        }
        LinkedHashMap allLinkBills = new LinkedHashMap();
        HashMap<Long, HashSet<Long>> tgtBillIds = new HashMap<Long, HashSet<Long>>();
        tgtBillIds.put(myMainTableId, myBillIds);
        int count = 0;
        while (tgtBillIds.size() > 0 && count < 100) {
            ++count;
            ArrayList<CtBFRowId> allBillRowIds = new ArrayList<CtBFRowId>();
            for (Map.Entry entry : tgtBillIds.entrySet()) {
                Long sMainTableId = (Long)entry.getKey();
                Long[] sBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
                List<CtBFRowId> billRowIds = this.getBillTrackReader().readDownBillBFRowIds(sMainTableId, sBillIds);
                allBillRowIds.addAll(billRowIds);
            }
            tgtBillIds.clear();
            for (CtBFRowId billRowId : allBillRowIds) {
                if (!this.getEntryTrackReader().addToMap(allLinkBills, billRowId.getTableId(), billRowId.getBillId())) continue;
                this.getEntryTrackReader().addToMap(tgtBillIds, billRowId.getTableId(), billRowId.getBillId());
            }
        }
        LinkedHashMap<String, HashSet<Long>> linkBills = new LinkedHashMap<String, HashSet<Long>>();
        for (Map.Entry item : allLinkBills.entrySet()) {
            HashSet<Long> existBillIds;
            Long mainTableId = (Long)item.getKey();
            TableDefine tableDefine = reader.loadTableDefine(mainTableId);
            if (tableDefine == null || (existBillIds = this.getEntryTrackReader().readExistsBillIds(tableDefine.getEntityNumber(), ((Set)item.getValue()).toArray(new Long[0]))).isEmpty()) continue;
            linkBills.put(tableDefine.getEntityNumber(), existBillIds);
        }
        return linkBills;
    }

    public Map<Long, List<CtBFRow>> findDirtTargetBills(String srcEntityNumber, Long[] srcBillIds) {
        Long tMainTableId;
        HashMap<Long, List<CtBFRow>> result = new HashMap<Long, List<CtBFRow>>(srcBillIds.length);
        HashSet<Long> myBillIds = new HashSet<Long>(10);
        for (Long billId : srcBillIds) {
            myBillIds.add(billId);
        }
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        List<CtBFRowId> targetBillRowIds = this.getBillTrackReader().readDownBillBFRowIds(myMainTableId, srcBillIds);
        if (targetBillRowIds.isEmpty()) {
            return result;
        }
        HashMap tgtBillIds = new HashMap();
        for (CtBFRowId ctBFRowId : targetBillRowIds) {
            tMainTableId = ctBFRowId.getMainTableId();
            Long tBillId = ctBFRowId.getBillId();
            this.getEntryTrackReader().addToMap(tgtBillIds, tMainTableId, tBillId);
        }
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            tMainTableId = (Long)entry.getKey();
            Long[] tBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
            Set<CtBFRow> linkRows = this.getEntryTrackReader().readUpBillBFRows("", "", tMainTableId, tBillIds);
            for (CtBFRow linkRow : linkRows) {
                Long srcBillId = linkRow.getSId().getBillId();
                if (Long.compare(myMainTableId, linkRow.getSId().getMainTableId()) != 0 || !myBillIds.contains(srcBillId)) continue;
                if (!result.containsKey(srcBillId)) {
                    result.put(srcBillId, new ArrayList());
                }
                ((List)result.get(srcBillId)).add(linkRow);
            }
        }
        return result;
    }

    public Map<Long, List<CtBFRow>> findDirtSourceBills(String targetEntityNumber, Long[] targetBillIds) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetBillIds == null || targetBillIds.length == 0) {
            return new HashMap<Long, List<CtBFRow>>(0);
        }
        List<CtBFRow> myEntryBFRows = this.getEntryTrackReader().readUpEntryBFRows(targetEntityNumber, targetBillIds);
        HashMap<Long, List<CtBFRow>> result = new HashMap<Long, List<CtBFRow>>(targetBillIds.length);
        for (CtBFRow myRow : myEntryBFRows) {
            List bfRows = result.computeIfAbsent(myRow.getId().getBillId(), s -> new ArrayList());
            bfRows.add(myRow);
        }
        return result;
    }

    public boolean isPush(String srcEntityNumber, Long srcBillId) {
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        List<CtBFRowId> targetBillRowIds = this.getBillTrackReader().readDownBillBFRowIds(myMainTableId, new Long[]{srcBillId});
        if (targetBillRowIds.isEmpty()) {
            return false;
        }
        HashMap tgtBillIds = new HashMap();
        for (CtBFRowId ctBFRowId : targetBillRowIds) {
            this.getEntryTrackReader().addToMap(tgtBillIds, ctBFRowId.getMainTableId(), ctBFRowId.getBillId());
        }
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            Long targetMainTableId = (Long)entry.getKey();
            Long[] targetBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
            Set<CtBFRow> bfRows = this.getEntryTrackReader().readUpBillBFRows("", "", targetMainTableId, targetBillIds);
            if (bfRows.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isPush(String srcEntityNumber, String srcEntryKey, Long srcEntryId) {
        boolean isEntry = StringUtils.isNotBlank((CharSequence)srcEntryKey);
        if (isEntry) {
            HashSet<Long> myBillIds = this.getEntryTrackReader().readBillIds(srcEntityNumber, srcEntryKey, new Long[]{srcEntryId});
            if (myBillIds.isEmpty()) {
                return false;
            }
            return this.isPush(srcEntityNumber, srcEntryKey, myBillIds.iterator().next(), srcEntryId);
        }
        return this.isPush(srcEntityNumber, srcEntryId);
    }

    public boolean isPush(String srcEntityNumber, String srcEntryKey, Long srcBillId, Long srcEntryId) {
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(srcEntityNumber, srcEntityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        List<CtBFRowId> targetBillRowIds = this.getBillTrackReader().readDownBillBFRowIds(myMainTableId, new Long[]{srcBillId});
        if (targetBillRowIds.isEmpty()) {
            return false;
        }
        TableDefine tableDefine = reader.loadTableDefine(srcEntityNumber, srcEntryKey);
        Long myEntryTableId = tableDefine.getTableId();
        HashMap tgtBillIds = new HashMap();
        for (CtBFRowId ctBFRowId : targetBillRowIds) {
            this.getEntryTrackReader().addToMap(tgtBillIds, ctBFRowId.getMainTableId(), ctBFRowId.getBillId());
        }
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            Long targetMainTableId = (Long)entry.getKey();
            Long[] targetBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
            Long searchTableId = myEntryTableId;
            Long searchId = srcEntryId;
            boolean existEntryTracker = this.getEntryTrackReader().isExistsEntryTracker(searchTableId, searchId, true, targetMainTableId, targetBillIds);
            if (!existEntryTracker) continue;
            return true;
        }
        return false;
    }
}

